import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Bengali Bangla (`bn`).
class FluentLocalizationsBn extends FluentLocalizations {
  FluentLocalizationsBn([String locale = 'bn']) : super(locale);

  @override
  String get backButtonTooltip => 'পিছনে';

  @override
  String get closeButtonLabel => 'বন্ধ করুন';

  @override
  String get searchLabel => 'খুঁজুন';

  @override
  String get closeNavigationTooltip => 'নেভিগেশন বন্ধ করুন';

  @override
  String get openNavigationTooltip => 'নেভিগেশন খুলুন';

  @override
  String get clickToSearch => 'খুঁজে পেতে ক্লিক করুন';

  @override
  String get modalBarrierDismissLabel => 'বরখাস্ত করুন';

  @override
  String get minimizeWindowTooltip => 'ছোট করুন';

  @override
  String get restoreWindowTooltip => 'ফিরে আনুন';

  @override
  String get closeWindowTooltip => 'বন্ধ করুন';

  @override
  String get dialogLabel => 'ডায়লগ';

  @override
  String get cutActionLabel => 'কাট';

  @override
  String get copyActionLabel => 'কপি';

  @override
  String get pasteActionLabel => 'পেস্ট';

  @override
  String get selectAllActionLabel => 'সব সিলেক্ট করুন';

  @override
  String get newTabLabel => 'নতুন ট্যাব যোগ করুন';

  @override
  String get closeTabLabelSuffix => 'ট্যাব বন্ধ করুন';

  @override
  String get scrollTabBackwardLabel => 'ট্যাব তালিকার পিছনে স্ক্রোল করুন';

  @override
  String get scrollTabForwardLabel => 'ট্যাব তালিকার সামনে স্ক্রোল করুন';

  @override
  String get noResultsFoundLabel => 'কোন ফলাফল পাওয়া যায়নি';

  @override
  String get copyActionTooltip => 'সিলেক্টেড কন্টেন্ট ক্লিপবোর্ড এ কপি করুন';

  @override
  String get cutActionTooltip =>
      'সিলেক্টেড কন্টেন্ট এখান থেকে রিমুভ করে ক্লিপবোর্ড এ কপি করুন';

  @override
  String get pasteActionTooltip => 'ক্লিপবোর্ড এর কন্টেন্ট এখানে পেস্ট করুন';

  @override
  String get selectAllActionTooltip => 'সব সিলেক্ট করুন';

  @override
  String get hour => 'ঘন্টা';

  @override
  String get minute => 'মিনিট';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'মাস';

  @override
  String get day => 'দিন';

  @override
  String get year => 'বছর';

  @override
  String get redLabel => 'লাল';

  @override
  String get greenLabel => 'সবুজ';

  @override
  String get blueLabel => 'নীল';

  @override
  String get opacityLabel => 'স্বচ্ছতা';

  @override
  String get hueLabel => 'রং';

  @override
  String get saturationLabel => 'সম্পৃক্ততা';

  @override
  String get valueLabel => 'মান';

  @override
  String get moreText => 'আরও';

  @override
  String get lessText => 'কম';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'মান $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% অস্বচ্ছতা';
  }

  @override
  String get colorBlack => 'কালো';

  @override
  String get colorNavy => 'গাঢ় নীল';

  @override
  String get colorDarkBlue => 'গাঢ় নীল';

  @override
  String get colorMediumBlue => 'নীল';

  @override
  String get colorBlue => 'নীল';

  @override
  String get colorDarkGreen => 'গাঢ় সবুজ';

  @override
  String get colorGreen => 'গাঢ় সবুজ';

  @override
  String get colorTeal => 'গাঢ় তুঁতে';

  @override
  String get colorDarkCyan => 'গাঢ় তুঁতে';

  @override
  String get colorDeepSkyBlue => 'নীলকান্ত';

  @override
  String get colorDarkTurquoise => 'এ্যাকুয়া';

  @override
  String get colorMediumSpringGreen => 'সবুজ';

  @override
  String get colorLime => 'সবুজ';

  @override
  String get colorSpringGreen => 'সবুজ';

  @override
  String get colorCyan => 'এ্যাকুয়া';

  @override
  String get colorMidnightBlue => 'গাঢ় নীল';

  @override
  String get colorDodgerBlue => 'নীল';

  @override
  String get colorLightSeaGreen => 'নীলচে সবুজ';

  @override
  String get colorForestGreen => 'গাঢ় সবুজ';

  @override
  String get colorSeaGreen => 'গাঢ় সবুজ';

  @override
  String get colorDarkSlateGray => 'গাঢ় তুঁতে';

  @override
  String get colorLimeGreen => 'সবুজ';

  @override
  String get colorMediumSeaGreen => 'সবুজ';

  @override
  String get colorTurquoise => 'নীলচে সবুজ';

  @override
  String get colorRoyalBlue => 'নীল';

  @override
  String get colorSteelBlue => 'নীল-ধূসর';

  @override
  String get colorDarkSlateBlue => 'বেগুনি';

  @override
  String get colorMediumTurquoise => 'নীলচে সবুজ';

  @override
  String get colorIndigo => 'গাঢ় বেগুনি লাল';

  @override
  String get colorDarkOliveGreen => 'গাঢ় সবুজ';

  @override
  String get colorCadetBlue => 'নীলচে সবুজ';

  @override
  String get colorCornflowerBlue => 'নীল';

  @override
  String get colorMediumAquamarine => 'সবুজ';

  @override
  String get colorDimGray => 'ধূসর';

  @override
  String get colorSlateBlue => 'বেগুনি নীলবর্ণ';

  @override
  String get colorOliveDrab => 'গাঢ় সবুজ';

  @override
  String get colorSlateGray => 'নীল-ধূসর';

  @override
  String get colorLightSlateGray => 'নীল-ধূসর';

  @override
  String get colorMediumSlateBlue => 'হালকা নীল';

  @override
  String get colorLawnGreen => 'সবুজ';

  @override
  String get colorChartreuse => 'সবুজ';

  @override
  String get colorAquamarine => 'উজ্জ্বল সবুজ';

  @override
  String get colorMaroon => 'গাঢ় লাল';

  @override
  String get colorPurple => 'গাঢ় বেগুনি লাল';

  @override
  String get colorOlive => 'গাঢ় হলুদ';

  @override
  String get colorGray => 'ধূসর';

  @override
  String get colorSkyBlue => 'হালকা নীলকান্ত';

  @override
  String get colorLightSkyBlue => 'হালকা নীল';

  @override
  String get colorBlueViolet => 'বেগুনি';

  @override
  String get colorDarkRed => 'গাঢ় লাল';

  @override
  String get colorDarkMagenta => 'গাঢ় বেগুনি লাল';

  @override
  String get colorSaddleBrown => 'বাদামী';

  @override
  String get colorDarkSeaGreen => 'সবুজ';

  @override
  String get colorLightGreen => 'উজ্জ্বল সবুজ';

  @override
  String get colorMediumPurple => 'ল্যাভেন্ডার';

  @override
  String get colorDarkViolet => 'বেগুনি';

  @override
  String get colorPaleGreen => 'উজ্জ্বল সবুজ';

  @override
  String get colorDarkOrchid => 'বেগুনি';

  @override
  String get colorYellowGreen => 'সবুজ';

  @override
  String get colorSienna => 'তামাটে রঙ';

  @override
  String get colorBrown => 'লাল';

  @override
  String get colorDarkGray => 'ধূসর';

  @override
  String get colorLightBlue => 'আকাশী নীল';

  @override
  String get colorGreenYellow => 'সবুজ';

  @override
  String get colorPaleTurquoise => 'এ্যাকুয়া';

  @override
  String get colorLightSteelBlue => 'আইস ব্লু';

  @override
  String get colorPowderBlue => 'আকাশী নীল';

  @override
  String get colorFirebrick => 'লাল';

  @override
  String get colorDarkGoldenrod => 'গাঢ় হলুদ';

  @override
  String get colorMediumOrchid => 'বেগুনি';

  @override
  String get colorRosyBrown => 'কোরাল';

  @override
  String get colorDarkKhaki => 'তামাটে রঙ';

  @override
  String get colorSilver => 'হালকা ধূসর';

  @override
  String get colorMediumVioletRed => 'গোলাপী';

  @override
  String get colorIndianRed => 'লাল';

  @override
  String get colorPeru => 'তামাটে রঙ';

  @override
  String get colorChocolate => 'কমলা';

  @override
  String get colorTan => 'তামাটে রঙ';

  @override
  String get colorLightGray => 'হালকা ধূসর';

  @override
  String get colorThistle => 'ল্যাভেন্ডার';

  @override
  String get colorOrchid => 'ল্যাভেন্ডার';

  @override
  String get colorGoldenrod => 'সোনালী';

  @override
  String get colorPaleVioletRed => 'গোলাপী';

  @override
  String get colorCrimson => 'লাল';

  @override
  String get colorGainsboro => 'হালকা ধূসর';

  @override
  String get colorPlum => 'গোলাপী';

  @override
  String get colorBurlyWood => 'তামাটে রঙ';

  @override
  String get colorLightCyan => 'আকাশী নীল';

  @override
  String get colorLavender => 'হালকা নীল';

  @override
  String get colorDarkSalmon => 'গোলাপী';

  @override
  String get colorViolet => 'ল্যাভেন্ডার';

  @override
  String get colorPaleGoldenrod => 'হালকা হলুদ';

  @override
  String get colorLightCoral => 'গোলাপী';

  @override
  String get colorKhaki => 'হালকা হলুদ';

  @override
  String get colorAliceBlue => 'সাদা';

  @override
  String get colorHoneydew => 'সাদা';

  @override
  String get colorAzure => 'সাদা';

  @override
  String get colorSandyBrown => 'হালকা কমলা';

  @override
  String get colorWheat => 'হালকা হলুদ';

  @override
  String get colorBeige => 'হালকা হলুদ';

  @override
  String get colorWhiteSmoke => 'সাদা';

  @override
  String get colorMintCream => 'সাদা';

  @override
  String get colorGhostWhite => 'সাদা';

  @override
  String get colorSalmon => 'গোলাপী';

  @override
  String get colorAntiqueWhite => 'হালকা কমলা';

  @override
  String get colorLinen => 'হালকা কমলা';

  @override
  String get colorLightGoldenrodYellow => 'হালকা হলুদ';

  @override
  String get colorOldLace => 'সাদা';

  @override
  String get colorRed => 'লাল';

  @override
  String get colorMagenta => 'বেগুনি';

  @override
  String get colorDeepPink => 'গোলাপী';

  @override
  String get colorOrangeRed => 'লাল';

  @override
  String get colorTomato => 'লাল';

  @override
  String get colorHotPink => 'গোলাপী';

  @override
  String get colorCoral => 'লাল';

  @override
  String get colorDarkOrange => 'কমলা';

  @override
  String get colorLightSalmon => 'গোলাপী';

  @override
  String get colorOrange => 'সোনালী';

  @override
  String get colorLightPink => 'গোলাপী';

  @override
  String get colorPink => 'গোলাপী';

  @override
  String get colorGold => 'সোনালী';

  @override
  String get colorPeachPuff => 'হালকা কমলা';

  @override
  String get colorNavajoWhite => 'হালকা কমলা';

  @override
  String get colorMoccasin => 'হালকা কমলা';

  @override
  String get colorBisque => 'হালকা কমলা';

  @override
  String get colorMistyRose => 'গোলাপী';

  @override
  String get colorBlanchedAlmond => 'হালকা কমলা';

  @override
  String get colorPapayaWhip => 'হালকা কমলা';

  @override
  String get colorLavenderBlush => 'সাদা';

  @override
  String get colorSeaShell => 'সাদা';

  @override
  String get colorCornsilk => 'হালকা হলুদ';

  @override
  String get colorLemonChiffon => 'হালকা হলুদ';

  @override
  String get colorFloralWhite => 'সাদা';

  @override
  String get colorSnow => 'সাদা';

  @override
  String get colorYellow => 'হলুদ';

  @override
  String get colorLightYellow => 'হালকা হলুদ';

  @override
  String get colorIvory => 'সাদা';

  @override
  String get colorWhite => 'সাদা';
}
