import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Arabic (`ar`).
class FluentLocalizationsAr extends FluentLocalizations {
  FluentLocalizationsAr([String locale = 'ar']) : super(locale);

  @override
  String get backButtonTooltip => 'رجوع';

  @override
  String get closeButtonLabel => 'إغلاق';

  @override
  String get searchLabel => 'بحث';

  @override
  String get closeNavigationTooltip => 'إغلاق الواجهة';

  @override
  String get openNavigationTooltip => 'فتح الواجهة';

  @override
  String get clickToSearch => 'انقر للبحث';

  @override
  String get modalBarrierDismissLabel => 'استبعاد';

  @override
  String get minimizeWindowTooltip => 'تصغير';

  @override
  String get restoreWindowTooltip => 'إسترجاع';

  @override
  String get closeWindowTooltip => 'إغلاق';

  @override
  String get dialogLabel => 'مربع حوار';

  @override
  String get cutActionLabel => 'قص';

  @override
  String get copyActionLabel => 'نسخ';

  @override
  String get pasteActionLabel => 'لصق';

  @override
  String get selectAllActionLabel => 'تحديد الكل';

  @override
  String get newTabLabel => 'إضافة علامة تبويب جديدة';

  @override
  String get closeTabLabelSuffix => 'إغلاق علامة التبويب';

  @override
  String get scrollTabBackwardLabel => 'تمرير قائمة علامة التبويب للخلف';

  @override
  String get scrollTabForwardLabel => 'تمرير قائمة علامة التبويب إلى الأمام';

  @override
  String get noResultsFoundLabel => 'لم يتم العثور على نتائج';

  @override
  String get copyActionTooltip => 'انسخ المحتوى المحدد إلى الحافظة';

  @override
  String get cutActionTooltip => 'قم بإزالة المحتوى المحدد وضعه في الحافظة';

  @override
  String get pasteActionTooltip => 'إدراج محتويات الحافظة إلى الموقع الحالي';

  @override
  String get selectAllActionTooltip => 'تحديد المحتوى بالكامل';

  @override
  String get hour => 'ساعة';

  @override
  String get minute => 'دقيقة';

  @override
  String get am => 'ص';

  @override
  String get pm => 'م';

  @override
  String get month => 'شهر';

  @override
  String get day => 'يوم';

  @override
  String get year => 'سنة';

  @override
  String get redLabel => 'أحمر';

  @override
  String get greenLabel => 'أخضر';

  @override
  String get blueLabel => 'أزرق';

  @override
  String get opacityLabel => 'معدل العتامة';

  @override
  String get hueLabel => 'التدرج';

  @override
  String get saturationLabel => 'التشبع';

  @override
  String get valueLabel => 'القيمة';

  @override
  String get moreText => 'المزيد';

  @override
  String get lessText => 'أقل';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return '($colorName) $value القيمة';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '%$value معدل العتامة';
  }

  @override
  String get colorBlack => 'أسود';

  @override
  String get colorNavy => 'أزرق داكن';

  @override
  String get colorDarkBlue => 'أزرق داكن';

  @override
  String get colorMediumBlue => 'أزرق';

  @override
  String get colorBlue => 'أزرق';

  @override
  String get colorDarkGreen => 'أخضر داكن';

  @override
  String get colorGreen => 'أخضر داكن';

  @override
  String get colorTeal => 'أزرق مخضر داكن';

  @override
  String get colorDarkCyan => 'أزرق مخضر داكن';

  @override
  String get colorDeepSkyBlue => 'فيروزي';

  @override
  String get colorDarkTurquoise => 'أزرق مائي';

  @override
  String get colorMediumSpringGreen => 'أخضر';

  @override
  String get colorLime => 'أخضر';

  @override
  String get colorSpringGreen => 'أخضر';

  @override
  String get colorCyan => 'أزرق مائي';

  @override
  String get colorMidnightBlue => 'أزرق داكن';

  @override
  String get colorDodgerBlue => 'أزرق';

  @override
  String get colorLightSeaGreen => 'أزرق مخضر';

  @override
  String get colorForestGreen => 'أخضر داكن';

  @override
  String get colorSeaGreen => 'أخضر داكن';

  @override
  String get colorDarkSlateGray => 'أزرق مخضر داكن';

  @override
  String get colorLimeGreen => 'أخضر';

  @override
  String get colorMediumSeaGreen => 'أخضر';

  @override
  String get colorTurquoise => 'أزرق مخضر';

  @override
  String get colorRoyalBlue => 'أزرق';

  @override
  String get colorSteelBlue => 'أزرق-رمادي';

  @override
  String get colorDarkSlateBlue => 'أرجواني';

  @override
  String get colorMediumTurquoise => 'أزرق مخضر';

  @override
  String get colorIndigo => 'أرجواني داكن';

  @override
  String get colorDarkOliveGreen => 'أخضر داكن';

  @override
  String get colorCadetBlue => 'أزرق مخضر';

  @override
  String get colorCornflowerBlue => 'أزرق';

  @override
  String get colorMediumAquamarine => 'أخضر';

  @override
  String get colorDimGray => 'رمادي';

  @override
  String get colorSlateBlue => 'نيلي';

  @override
  String get colorOliveDrab => 'أخضر داكن';

  @override
  String get colorSlateGray => 'أزرق-رمادي';

  @override
  String get colorLightSlateGray => 'أزرق-رمادي';

  @override
  String get colorMediumSlateBlue => 'أزرق فاتح';

  @override
  String get colorLawnGreen => 'أخضر';

  @override
  String get colorChartreuse => 'أخضر';

  @override
  String get colorAquamarine => 'أخضر فاتح';

  @override
  String get colorMaroon => 'أحمر داكن';

  @override
  String get colorPurple => 'أرجواني داكن';

  @override
  String get colorOlive => 'أصفر داكن';

  @override
  String get colorGray => 'رمادي';

  @override
  String get colorSkyBlue => 'تركوازي فاتح';

  @override
  String get colorLightSkyBlue => 'أزرق فاتح';

  @override
  String get colorBlueViolet => 'أرجواني';

  @override
  String get colorDarkRed => 'أحمر داكن';

  @override
  String get colorDarkMagenta => 'أرجواني داكن';

  @override
  String get colorSaddleBrown => 'بني';

  @override
  String get colorDarkSeaGreen => 'أخضر';

  @override
  String get colorLightGreen => 'أخضر فاتح';

  @override
  String get colorMediumPurple => 'أرجواني شاحب';

  @override
  String get colorDarkViolet => 'أرجواني';

  @override
  String get colorPaleGreen => 'أخضر فاتح';

  @override
  String get colorDarkOrchid => 'أرجواني';

  @override
  String get colorYellowGreen => 'أخضر';

  @override
  String get colorSienna => 'خمري';

  @override
  String get colorBrown => 'أحمر';

  @override
  String get colorDarkGray => 'رمادي';

  @override
  String get colorLightBlue => 'أزرق سماوي';

  @override
  String get colorGreenYellow => 'أخضر';

  @override
  String get colorPaleTurquoise => 'أزرق مائي';

  @override
  String get colorLightSteelBlue => 'أزرق ثلجي';

  @override
  String get colorPowderBlue => 'أزرق سماوي';

  @override
  String get colorFirebrick => 'أحمر';

  @override
  String get colorDarkGoldenrod => 'أصفر داكن';

  @override
  String get colorMediumOrchid => 'أرجواني';

  @override
  String get colorRosyBrown => 'مرجاني';

  @override
  String get colorDarkKhaki => 'خمري';

  @override
  String get colorSilver => 'رمادي فاتح';

  @override
  String get colorMediumVioletRed => 'قرنفلي';

  @override
  String get colorIndianRed => 'أحمر';

  @override
  String get colorPeru => 'خمري';

  @override
  String get colorChocolate => 'برتقالي';

  @override
  String get colorTan => 'خمري';

  @override
  String get colorLightGray => 'رمادي فاتح';

  @override
  String get colorThistle => 'أرجواني شاحب';

  @override
  String get colorOrchid => 'أرجواني شاحب';

  @override
  String get colorGoldenrod => 'ذهبي';

  @override
  String get colorPaleVioletRed => 'وردي';

  @override
  String get colorCrimson => 'أحمر';

  @override
  String get colorGainsboro => 'رمادي فاتح';

  @override
  String get colorPlum => 'قرنفلي';

  @override
  String get colorBurlyWood => 'خمري';

  @override
  String get colorLightCyan => 'أزرق سماوي';

  @override
  String get colorLavender => 'أزرق فاتح';

  @override
  String get colorDarkSalmon => 'وردي';

  @override
  String get colorViolet => 'أرجواني شاحب';

  @override
  String get colorPaleGoldenrod => 'أصفر فاتح';

  @override
  String get colorLightCoral => 'وردي';

  @override
  String get colorKhaki => 'أصفر فاتح';

  @override
  String get colorAliceBlue => 'أبيض';

  @override
  String get colorHoneydew => 'أبيض';

  @override
  String get colorAzure => 'أبيض';

  @override
  String get colorSandyBrown => 'برتقالي فاتح';

  @override
  String get colorWheat => 'أصفر فاتح';

  @override
  String get colorBeige => 'أصفر فاتح';

  @override
  String get colorWhiteSmoke => 'أبيض';

  @override
  String get colorMintCream => 'أبيض';

  @override
  String get colorGhostWhite => 'أبيض';

  @override
  String get colorSalmon => 'وردي';

  @override
  String get colorAntiqueWhite => 'برتقالي فاتح';

  @override
  String get colorLinen => 'برتقالي فاتح';

  @override
  String get colorLightGoldenrodYellow => 'أصفر فاتح';

  @override
  String get colorOldLace => 'أبيض';

  @override
  String get colorRed => 'أحمر';

  @override
  String get colorMagenta => 'أرجواني';

  @override
  String get colorDeepPink => 'قرنفلي';

  @override
  String get colorOrangeRed => 'أحمر';

  @override
  String get colorTomato => 'أحمر';

  @override
  String get colorHotPink => 'قرنفلي';

  @override
  String get colorCoral => 'أحمر';

  @override
  String get colorDarkOrange => 'برتقالي';

  @override
  String get colorLightSalmon => 'وردي';

  @override
  String get colorOrange => 'ذهبي';

  @override
  String get colorLightPink => 'وردي';

  @override
  String get colorPink => 'وردي';

  @override
  String get colorGold => 'ذهبي';

  @override
  String get colorPeachPuff => 'برتقالي فاتح';

  @override
  String get colorNavajoWhite => 'برتقالي فاتح';

  @override
  String get colorMoccasin => 'برتقالي فاتح';

  @override
  String get colorBisque => 'برتقالي فاتح';

  @override
  String get colorMistyRose => 'وردي';

  @override
  String get colorBlanchedAlmond => 'برتقالي فاتح';

  @override
  String get colorPapayaWhip => 'برتقالي فاتح';

  @override
  String get colorLavenderBlush => 'أبيض';

  @override
  String get colorSeaShell => 'أبيض';

  @override
  String get colorCornsilk => 'أصفر فاتح';

  @override
  String get colorLemonChiffon => 'أصفر فاتح';

  @override
  String get colorFloralWhite => 'أبيض';

  @override
  String get colorSnow => 'أبيض';

  @override
  String get colorYellow => 'أصفر';

  @override
  String get colorLightYellow => 'أصفر فاتح';

  @override
  String get colorIvory => 'أبيض';

  @override
  String get colorWhite => 'أبيض';
}
