
# Reactackle
[![npm version](https://badge.fury.io/js/reactackle.svg)](https://www.npmjs.org/package/reactackle)
[![Build Status](https://travis-ci.org/bcrumbs/reactackle.svg?branch=master)](https://travis-ci.org/bcrumbs/reactackle)
[![Coverage Status](https://coveralls.io/repos/github/bcrumbs/reactackle/badge.svg?branch=master)](https://coveralls.io/github/bcrumbs/reactackle?branch=master)

**An open-source components library built with [React](https://facebook.github.io/react/) and [Styled Components](https://www.styled-components.com).**

Reactackle is a family of components that make it easy to design beautiful websites and apps. It's still young but we are going to constantly add new components.

## Getting started

**Using NPM:**
```
npm install reactackle --save
```

**Using Yarn:**
```
yarn add reactackle
```

**Or you can install components independently:**
```
npm install reactackle-button --save
```

## Docs
* [Getting Started](http://reactackle-docs.braincrumbs.io)

#### Component Demos
* [App](http://reactackle-docs.braincrumbs.io/#/app/demo)
* [Auto Position](http://reactackle-docs.braincrumbs.io/#/auto-position/demo)
* [Button](http://reactackle-docs.braincrumbs.io/#/button/demo)
* [Card](http://reactackle-docs.braincrumbs.io/#/card/demo)
* [Checkbox](http://reactackle-docs.braincrumbs.io/#/checkbox/demo)
* [Dialog](http://reactackle-docs.braincrumbs.io/#/dialog/demo)
* [Form](http://reactackle-docs.braincrumbs.io/#/form/demo)
* [Grid / Column](http://reactackle-docs.braincrumbs.io/#/grid-column/demo)
* [Grid / Row](http://reactackle-docs.braincrumbs.io/#/grid-row/demo)
* [Header](http://reactackle-docs.braincrumbs.io/#/header/demo)
* [Icon](http://reactackle-docs.braincrumbs.io/#/icon/demo)
* [Input Autocomplete](http://reactackle-docs.braincrumbs.io/#/input-autocomplete/demo)
* [Radio Group](http://reactackle-docs.braincrumbs.io/#/radio/demo)
* [Select Box](http://reactackle-docs.braincrumbs.io/#/select-box/demo)
* [Sidebar](http://reactackle-docs.braincrumbs.io/#/sidebar/demo)
* [Tabs](http://reactackle-docs.braincrumbs.io/#/tabs/demo)
* [Text Field](http://reactackle-docs.braincrumbs.io/#/text-field/demo)
* [Toggle Button](http://reactackle-docs.braincrumbs.io/#/toggle-button/demo)
* [Tooltip](http://reactackle-docs.braincrumbs.io/#/tooltip/demo)
* [Tooltip Icon](http://reactackle-docs.braincrumbs.io/#/tooltip-icon/demo)

## Browser Support
At present we aim to support the last two versions of the following browsers: Chrome, Edge, Firefox, Safari, Opera.

## Contributing
Contributions are welcome!

Also we're opened to any proposals. Feel free to submit an issue or just [write us a few words](mailto:hello@braincrumbs.io).

## Stay in touch
* [Twitter](https://twitter.com/@reactackle)
* [Slack](https://reactackle.slack.com)

## License
[MIT License](/LICENSE.md)

