import {
  bmodule,
  fontSizeSmall,
  fontSizeBody,
  fontSizeBody2,
  fontSizeTitle,
  fontSizeHeadline,
  fontSizeDisplay1,
  fontSizeDisplay2,
  fontSizeDisplay3,
  fontSizeDisplay4,
  bodyFontColor,
  fontColorMedium,
  fontWeightLight,
  fontWeightNormal,
  fontWeightSemibold,
} from 'reactackle-core';

export default {
  default: {
    fontSize: 'inherit',
    lineHeight: 'inherit',
    color: 'currentColor',
    textTransform: 'inherit',
    fontWeight: 'inherit',
    letterSpacing: 'inherit',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(1),
  },

  caption: {
    fontSize: fontSizeSmall,
    lineHeight: 1.25,
    color: fontColorMedium,
    textTransform: 'none',
    fontWeight: fontWeightNormal,
    letterSpacing: 'initial',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(0.5),
  },

  body: {
    fontSize: fontSizeBody,
    lineHeight: 1.6,
    color: bodyFontColor,
    textTransform: 'none',
    fontWeight: fontWeightNormal,
    letterSpacing: 'initial',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(1),
  },

  bodyStrong: {
    fontSize: fontSizeBody,
    lineHeight: 1.6,
    color: bodyFontColor,
    textTransform: 'none',
    fontWeight: fontWeightSemibold,
    letterSpacing: 'initial',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(1),
  },

  subheading: {
    fontSize: fontSizeBody2,
    lineHeight: 1.6,
    color: bodyFontColor,
    textTransform: 'none',
    fontWeight: fontWeightNormal,
    letterSpacing: 'initial',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(1),
  },

  title: {
    fontSize: fontSizeTitle,
    lineHeight: 1.6,
    color: bodyFontColor,
    textTransform: 'none',
    fontWeight: fontWeightSemibold,
    letterSpacing: 'initial',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(1),
  },

  headline: {
    fontSize: fontSizeHeadline,
    lineHeight: 1.6,
    color: bodyFontColor,
    textTransform: 'none',
    fontWeight: fontWeightNormal,
    letterSpacing: 'initial',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(1),
  },

  display1: {
    fontSize: fontSizeDisplay1,
    lineHeight: 1.6,
    color: bodyFontColor,
    textTransform: 'none',
    fontWeight: fontWeightNormal,
    letterSpacing: 'initial',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(1),
  },

  display2: {
    fontSize: fontSizeDisplay2,
    lineHeight: 1.6,
    color: bodyFontColor,
    textTransform: 'none',
    fontWeight: fontWeightNormal,
    letterSpacing: 'initial',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(1),
  },

  display3: {
    fontSize: fontSizeDisplay3,
    lineHeight: 1.3,
    color: bodyFontColor,
    textTransform: 'none',
    fontWeight: fontWeightNormal,
    letterSpacing: 'initial',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(1),
  },

  display4: {
    fontSize: fontSizeDisplay4,
    lineHeight: 1.3,
    color: bodyFontColor,
    textTransform: 'none',
    fontWeight: fontWeightLight,
    letterSpacing: 'initial',
    fontFamily: 'inherit',
    marginTop: 0,
    marginBottom: 0,
    similarItemsSpacing: bmodule(1),
  },
};
