#include <stdio.h>
#include <windows.h>

#define SECURITY_WIN32
#include <security.h>

VOID* GetTokenInfo(TOKEN_INFORMATION_CLASS TokenType)
{
    HANDLE hToken = 0;
    DWORD dwLength = 0;
    VOID* pTokenInfo = 0;

    // get the tokens
    if (OpenProcessToken(GetCurrentProcess(), TOKEN_READ, &hToken))
    {
        // get length of the token info
        GetTokenInformation(hToken, TokenType, NULL, dwLength, &dwLength);

        // alloc the memory for the token info
        pTokenInfo = malloc(dwLength);

        // get the actual token info now
        if (!GetTokenInformation(hToken, TokenType, (LPVOID)pTokenInfo, dwLength, &dwLength))
        {
            // rip guess somethings gone wrong, clean up and go
            free(pTokenInfo);
            return;
        }

        // clean up
        CloseHandle(hToken);
        
    }

    // return the tokens
    return pTokenInfo;
}

void main()
{   
    DWORD pCount;
    PWSTR pName = NULL;

    // get our current privs
    PTOKEN_PRIVILEGES pPrivInfo = (PTOKEN_PRIVILEGES)GetTokenInfo(TokenPrivileges);

    // loop though ur privs
    for (pCount = 0; pCount < pPrivInfo->PrivilegeCount; pCount++)
    {
        DWORD pnSize = 0;

        // get the size of the priv name
        LookupPrivilegeNameW(NULL, &pPrivInfo->Privileges[pCount].Luid, NULL, &pnSize);

        // alloc our memory for the name of the priv
        pName = (PWSTR)malloc(++pnSize * sizeof(WCHAR));

        // get the name of the priv
        LookupPrivilegeNameW(NULL, &pPrivInfo->Privileges[pCount].Luid, pName, &pnSize);

        // check if the priv is enabled
        if (wcscmp(pName, L"SeImpersonatePrivilege") == 0)
        {
            printf("w00t\n");
            return;
        } 
    }

    printf("n00t\n");
    return;
}