# Privacy Policy

Shields.io is non-tracking and privacy-respecting. This Privacy Policy explains how we handle your data in compliance with the General Data Protection Regulation (GDPR).

## 1. Hosting and Service Providers

We use [fly.io](https://fly.io) for hosting and [CloudFlare](https://www.cloudflare.com) for DNS and CDN services. These third-party providers process requests to deliver and secure our website. Please refer to their privacy policies for more information:

- https://fly.io/legal/privacy-policy/
- https://www.cloudflare.com/en-gb/privacypolicy/

## 2. Cookies

We do not use any cookies on our website.

## 3. Logs and Data Collection

We do not store any logs of your visits, requests, or other activities on our site.

## 4. Error Reporting

If a request fails, we send an error report to [Sentry](https://sentry.io/), our error-tracking service.
These reports contain technical data about the error but do not include any personally identifiable information (PII), such as your IP address. For details on Sentry's data processing, refer to their privacy policy:

- https://sentry.io/privacy/

## 5. GitHub OAuth App

Users may optionally authorize our [GitHub OAuth app](https://img.shields.io/github-auth).

Authorizing our app shares with us a GitHub token which has read-only access to public data. We only ask for the minimum permissions necessary. Authorizing the OAuth app doesn't allow us access to your private data or allow us to perform any actions on your behalf.

The only information we store is the **GitHub token** and the **timestamp** when you authorized the app.

- The GitHub token is used solely to increase the rate limit for accessing the GitHub API.
- The signup timestamp is stored for internal record-keeping purposes.

We don't collect or store any other information like your username or email address.

If you decide you would not like to continue sharing a token with us, you can revoke the Shields.io OAuth app at https://github.com/settings/applications. You can do this at any time. This will de-activate the token you have shared with us and we'll remove it from our token pool.

## 6. Your Rights

Under the GDPR, users have rights concerning their personal data, including access, correction, deletion, and objection to processing.

Since we process minimal data, these rights are not relevant to most users of the service.

## 7. Contact Us

If you have questions about this Privacy Policy or our data practices, you can contact us at team at shields.io
