---
slug: GHSA-rxvx-x284-4445
title: Our response to RCE Security Advisory
authors:
  name: chris48s
  title: Shields.io Core Team
  url: https://github.com/chris48s
  image_url: https://avatars.githubusercontent.com/u/6025893
tags: []
---

We've just published a critical security advisory relating to a Remote Code Execution vulnerability in Dynamic JSON/TOML/YAML badges: https://github.com/badges/shields/security/advisories/GHSA-rxvx-x284-4445 Thanks to [@nickcopi](https://github.com/nickcopi) for his help with this.

If you self-host your own instance of Shields you should upgrade to [server-2024-09-25](https://hub.docker.com/layers/shieldsio/shields/server-2024-09-25/images/sha256-28aaea75049e325c9f1d63c8a8b477fc387d3d3fe35b933d6581487843cd610f?context=explore) or later as soon as possible to protect your instance.

This is primarily a concern for self-hosting users. However this does also have a couple of knock-on implications for some users of shields.io itself.

## 1. Users who have authorized the Shields.io GitHub OAuth app

While we have taken steps to close this vulnerability quickly after becoming aware of it, this attack vector has existed in our application for some time. We aren't aware of it having been actively exploited on shields.io. We also can't prove that it has not been exploited.

We don't log or track our users, so a breach offers a very limited attack surface against end users of shields.io. This is by design. One of the (few) information assets shields.io does hold is our GitHub token pool. This allows users to share a token with us by authorizing our OAuth app. Doing this gives us access to a token with read-only access to public data which we can use to increase our rate limit when making calls to the GitHub API.

The tokens we hold are not of high value to an attacker because they have read-only access to public data, but we can't say for sure they haven't been exfiltrated. If you've donated a token in the past and want to revoke it, you can revoke the Shields.io OAuth app at https://github.com/settings/applications which will de-activate the token you have shared with us.

## 2. Users of Dynamic JSON/TOML/YAML badges

Up until now, we have been using https://github.com/dchester/jsonpath as our library querying documents using JSONPath expressions. [@nickcopi](https://github.com/nickcopi) responsibly reported to us how a prototype pollution vulnerability in this library could be exploited to construct a JSONPath expression allowing an attacker to perform remote code execution. This vulnerability was reported on the package's issue tracker but not flagged by security scanning tools. It seems extremely unlikely that this will be fixed in the upstream package despite being widely used. It also seems unlikely this package will receive any further maintenance in future, even in response to critical security issues. In order to resolve this issue, we needed to switch to a different JSONPath library. We've decided to switch https://github.com/JSONPath-Plus/JSONPath using the `eval: false` option to disable script expressions.

This is an important security improvement and we have to make a change to protect the security of shields.io and users hosting their own instance of the application. However, this does come with some tradeoffs from a backwards-compatibility perspective.

### Using `eval: false`

Using JSONPath-Plus with `eval: false` does disable some query syntax which relies on evaluating javascript expressions.

For example, it would previously have been possible to use a JSONPath query like `$..keywords[(@.length-1)]` against the document https://github.com/badges/shields/raw/master/package.json to select the last element from the keywords array https://github.com/badges/shields/blob/e237e40ab88b8ad4808caad4f3dae653822aa79a/package.json#L6-L12

This is now not a supported query.

In this particular case, you could rewrite that query to `$..keywords[-1:]` and obtain the same result, but that may not be possible in all cases. We do realise that this removes some functionality that previously worked but closing this remote code execution vulnerability is the top priority, especially since there will be workarounds in many cases.

### Implementation Quirks

Historically, every JSONPath implementation has had its own idiosyncrasies. While most simple and common queries will behave the same way across different implementations, switching to another library will mean that some subset of queries may not work or produce different results.

One interesting thing that has happened in the world of JSONPath lately is RFC 9535 https://www.rfc-editor.org/rfc/rfc9535 which is an attempt to standardise JSONPath. As part of this mitigation, we did look at whether it would be possible to migrate to something that is RFC9535-compliant. However it is our assessment that the JavaScript community does not yet have a sufficiently mature/supported RFC9535-compliant JSONPath implementation. This means we are switching from one quirky implementation to another implementation with different quirks.

Again, this represents an unfortunate break in backwards-compatibility. However, it was necessary to prioritise closing off this remote code execution vulnerability over backwards-compatibility.

Although we can not provide a precise migration guide, here is a table of query types where https://github.com/dchester/jsonpath and https://github.com/JSONPath-Plus/JSONPath are known to diverge from the consensus implementation. This is sourced from the excellent https://cburgmer.github.io/json-path-comparison/
While this is a long list, many of these inputs represent edge cases or pathological inputs rather than common usage.

 <details>
  <summary>Table</summary>
<table>
<thead>
<tr>
<th>Query Type</th>
<th>Example Query</th>
</tr>
</thead>
<tbody>
<tr>
<td>Array slice with large number for end and negative step</td>
<td><code>$[2:-113667776004:-1]</code></td>
</tr>
<tr>
<td>Array slice with large number for start end negative step</td>
<td><code>$[113667776004:2:-1]</code></td>
</tr>
<tr>
<td>Array slice with negative step</td>
<td><code>$[3:0:-2]</code></td>
</tr>
<tr>
<td>Array slice with negative step on partially overlapping array</td>
<td><code>$[7:3:-1]</code></td>
</tr>
<tr>
<td>Array slice with negative step only</td>
<td><code>$[::-2]</code></td>
</tr>
<tr>
<td>Array slice with open end and negative step</td>
<td><code>$[3::-1]</code></td>
</tr>
<tr>
<td>Array slice with open start and negative step</td>
<td><code>$[:2:-1]</code></td>
</tr>
<tr>
<td>Array slice with range of 0</td>
<td><code>$[0:0]</code></td>
</tr>
<tr>
<td>Array slice with step 0</td>
<td><code>$[0:3:0]</code></td>
</tr>
<tr>
<td>Array slice with step and leading zeros</td>
<td><code>$[010:024:010]</code></td>
</tr>
<tr>
<td>Bracket notation with empty path</td>
<td><code>$[]</code></td>
</tr>
<tr>
<td>Bracket notation with number on object</td>
<td><code>$[0]</code></td>
</tr>
<tr>
<td>Bracket notation with number on string</td>
<td><code>$[0]</code></td>
</tr>
<tr>
<td>Bracket notation with number -1</td>
<td><code>$[-1]</code></td>
</tr>
<tr>
<td>Bracket notation with quoted array slice literal</td>
<td><code>$[':']</code></td>
</tr>
<tr>
<td>Bracket notation with quoted closing bracket literal</td>
<td><code>$[']']</code></td>
</tr>
<tr>
<td>Bracket notation with quoted current object literal</td>
<td><code>$['@']</code></td>
</tr>
<tr>
<td>Bracket notation with quoted escaped backslash</td>
<td><code>$['\\']</code></td>
</tr>
<tr>
<td>Bracket notation with quoted escaped single quote</td>
<td><code>$['\'']</code></td>
</tr>
<tr>
<td>Bracket notation with quoted root literal</td>
<td><code>$['$']</code></td>
</tr>
<tr>
<td>Bracket notation with quoted special characters combined</td>
<td><code>$[':@."$,*\'\\']</code></td>
</tr>
<tr>
<td>Bracket notation with quoted string and unescaped single quote</td>
<td><code>$['single'quote']</code></td>
</tr>
<tr>
<td>Bracket notation with quoted union literal</td>
<td><code>$[',']</code></td>
</tr>
<tr>
<td>Bracket notation with quoted wildcard literal ?</td>
<td><code>$['*']</code></td>
</tr>
<tr>
<td>Bracket notation with quoted wildcard literal on object without key</td>
<td><code>$['*']</code></td>
</tr>
<tr>
<td>Bracket notation with spaces</td>
<td><code>$[ 'a' ]</code></td>
</tr>
<tr>
<td>Bracket notation with two literals separated by dot</td>
<td><code>$['two'.'some']</code></td>
</tr>
<tr>
<td>Bracket notation with two literals separated by dot without quotes</td>
<td><code>$[two.some]</code></td>
</tr>
<tr>
<td>Bracket notation without quotes</td>
<td><code>$[key]</code></td>
</tr>
<tr>
<td>Current with dot notation</td>
<td><code>@.a</code></td>
</tr>
<tr>
<td>Dot bracket notation</td>
<td><code>$.['key']</code></td>
</tr>
<tr>
<td>Dot bracket notation with double quotes</td>
<td><code>$.["key"]</code></td>
</tr>
<tr>
<td>Dot bracket notation without quotes</td>
<td><code>$.[key]</code></td>
</tr>
<tr>
<td>Dot notation after recursive descent with extra dot ?</td>
<td><code>$...key</code></td>
</tr>
<tr>
<td>Dot notation after union with keys</td>
<td><code>$['one','three'].key</code></td>
</tr>
<tr>
<td>Dot notation with dash</td>
<td><code>$.key-dash</code></td>
</tr>
<tr>
<td>Dot notation with double quotes</td>
<td><code>$."key"</code></td>
</tr>
<tr>
<td>Dot notation with double quotes after recursive descent ?</td>
<td><code>$.."key"</code></td>
</tr>
<tr>
<td>Dot notation with empty path</td>
<td><code>$.</code></td>
</tr>
<tr>
<td>Dot notation with key named length on array</td>
<td><code>$.length</code></td>
</tr>
<tr>
<td>Dot notation with key root literal</td>
<td><code>$.$</code></td>
</tr>
<tr>
<td>Dot notation with non ASCII key</td>
<td><code>$.??</code></td>
</tr>
<tr>
<td>Dot notation with number</td>
<td><code>$.2</code></td>
</tr>
<tr>
<td>Dot notation with number -1</td>
<td><code>$.-1</code></td>
</tr>
<tr>
<td>Dot notation with single quotes</td>
<td><code>$.'key'</code></td>
</tr>
<tr>
<td>Dot notation with single quotes after recursive descent ?</td>
<td><code>$..'key'</code></td>
</tr>
<tr>
<td>Dot notation with single quotes and dot</td>
<td><code>$.'some.key'</code></td>
</tr>
<tr>
<td>Dot notation with space padded key</td>
<td><code>$. a</code></td>
</tr>
<tr>
<td>Dot notation with wildcard after recursive descent on scalar ?</td>
<td><code>$..*</code></td>
</tr>
<tr>
<td>Dot notation without dot</td>
<td><code>$a</code></td>
</tr>
<tr>
<td>Dot notation without root</td>
<td><code>.key</code></td>
</tr>
<tr>
<td>Dot notation without root and dot</td>
<td><code>key</code></td>
</tr>
<tr>
<td>Empty</td>
<td><code>n/a</code></td>
</tr>
<tr>
<td>Filter expression on object</td>
<td><code>$[?(@.key)]</code></td>
</tr>
<tr>
<td>Filter expression after dot notation with wildcard after recursive descent ?</td>
<td><code>$..*[?(@.id&gt;2)]</code></td>
</tr>
<tr>
<td>Filter expression after recursive descent ?</td>
<td><code>$..[?(@.id==2)]</code></td>
</tr>
<tr>
<td>Filter expression with addition</td>
<td><code>$[?(@.key+50==100)]</code></td>
</tr>
<tr>
<td>Filter expression with boolean and operator and value false</td>
<td><code>$[?(@.key&gt;0 &amp;&amp; false)]</code></td>
</tr>
<tr>
<td>Filter expression with boolean and operator and value true</td>
<td><code>$[?(@.key&gt;0 &amp;&amp; true)]</code></td>
</tr>
<tr>
<td>Filter expression with boolean or operator and value false</td>
<td><code>$[?(@.key&gt;0 &amp;#124;&amp;#124; false)]</code></td>
</tr>
<tr>
<td>Filter expression with boolean or operator and value true</td>
<td><code>$[?(@.key&gt;0 &amp;#124;&amp;#124; true)]</code></td>
</tr>
<tr>
<td>Filter expression with bracket notation with -1</td>
<td><code>$[?(@[-1]==2)]</code></td>
</tr>
<tr>
<td>Filter expression with bracket notation with number on object</td>
<td><code>$[?(@[1]=='b')]</code></td>
</tr>
<tr>
<td>Filter expression with current object</td>
<td><code>$[?(@)]</code></td>
</tr>
<tr>
<td>Filter expression with different ungrouped operators</td>
<td><code>$[?(@.a &amp;&amp; @.b &amp;#124;&amp;#124; @.c)]</code></td>
</tr>
<tr>
<td>Filter expression with division</td>
<td><code>$[?(@.key/10==5)]</code></td>
</tr>
<tr>
<td>Filter expression with dot notation with dash</td>
<td><code>$[?(@.key-dash == 'value')]</code></td>
</tr>
<tr>
<td>Filter expression with dot notation with number</td>
<td><code>$[?(@.2 == 'second')]</code></td>
</tr>
<tr>
<td>Filter expression with dot notation with number on array</td>
<td><code>$[?(@.2 == 'third')]</code></td>
</tr>
<tr>
<td>Filter expression with empty expression</td>
<td><code>$[?()]</code></td>
</tr>
<tr>
<td>Filter expression with equals</td>
<td><code>$[?(@.key==42)]</code></td>
</tr>
<tr>
<td>Filter expression with equals on array of numbers</td>
<td><code>$[?(@==42)]</code></td>
</tr>
<tr>
<td>Filter expression with equals on object</td>
<td><code>$[?(@.key==42)]</code></td>
</tr>
<tr>
<td>Filter expression with equals array</td>
<td><code>$[?(@.d==["v1","v2"])]</code></td>
</tr>
<tr>
<td>Filter expression with equals array for array slice with range 1</td>
<td><code>$[?(@[0:1]==[1])]</code></td>
</tr>
<tr>
<td>Filter expression with equals array for dot notation with star</td>
<td><code>$[?(@.*==[1,2])]</code></td>
</tr>
<tr>
<td>Filter expression with equals array or equals true</td>
<td><code>$[?(@.d==["v1","v2"] &amp;#124;&amp;#124; (@.d == true))]</code></td>
</tr>
<tr>
<td>Filter expression with equals array with single quotes</td>
<td><code>$[?(@.d==['v1','v2'])]</code></td>
</tr>
<tr>
<td>Filter expression with equals boolean expression value</td>
<td><code>$[?((@.key&lt;44)==false)]</code></td>
</tr>
<tr>
<td>Filter expression with equals false</td>
<td><code>$[?(@.key==false)]</code></td>
</tr>
<tr>
<td>Filter expression with equals null</td>
<td><code>$[?(@.key==null)]</code></td>
</tr>
<tr>
<td>Filter expression with equals number for array slice with range 1</td>
<td><code>$[?(@[0:1]==1)]</code></td>
</tr>
<tr>
<td>Filter expression with equals number for bracket notation with star</td>
<td><code>$[?(@[*]==2)]</code></td>
</tr>
<tr>
<td>Filter expression with equals number for dot notation with star</td>
<td><code>$[?(@.*==2)]</code></td>
</tr>
<tr>
<td>Filter expression with equals number with fraction</td>
<td><code>$[?(@.key==-0.123e2)]</code></td>
</tr>
<tr>
<td>Filter expression with equals number with leading zeros</td>
<td><code>$[?(@.key==010)]</code></td>
</tr>
<tr>
<td>Filter expression with equals object</td>
<td><code>$[?(@.d==&lbrace;"k":"v"&rbrace;)]</code></td>
</tr>
<tr>
<td>Filter expression with equals string</td>
<td><code>$[?(@.key=="value")]</code></td>
</tr>
<tr>
<td>Filter expression with equals string with unicode character escape</td>
<td><code>$[?(@.key=="Mot\u00f6rhead")]</code></td>
</tr>
<tr>
<td>Filter expression with equals true</td>
<td><code>$[?(@.key==true)]</code></td>
</tr>
<tr>
<td>Filter expression with equals with path and path</td>
<td><code>$[?(@.key1==@.key2)]</code></td>
</tr>
<tr>
<td>Filter expression with equals with root reference</td>
<td><code>$.items[?(@.key==$.value)]</code></td>
</tr>
<tr>
<td>Filter expression with greater than</td>
<td><code>$[?(@.key&gt;42)]</code></td>
</tr>
<tr>
<td>Filter expression with greater than or equal</td>
<td><code>$[?(@.key&gt;=42)]</code></td>
</tr>
<tr>
<td>Filter expression with in array of values</td>
<td><code>$[?(@.d in [2, 3])]</code></td>
</tr>
<tr>
<td>Filter expression with in current object</td>
<td><code>$[?(2 in @.d)]</code></td>
</tr>
<tr>
<td>Filter expression with length free function</td>
<td><code>$[?(length(@) == 4)]</code></td>
</tr>
<tr>
<td>Filter expression with length function</td>
<td><code>$[?(@.length() == 4)]</code></td>
</tr>
<tr>
<td>Filter expression with length property</td>
<td><code>$[?(@.length == 4)]</code></td>
</tr>
<tr>
<td>Filter expression with less than</td>
<td><code>$[?(@.key&lt;42)]</code></td>
</tr>
<tr>
<td>Filter expression with less than or equal</td>
<td><code>$[?(@.key&lt;=42)]</code></td>
</tr>
<tr>
<td>Filter expression with local dot key and null in data</td>
<td><code>$[?(@.key='value')]</code></td>
</tr>
<tr>
<td>Filter expression with multiplication</td>
<td><code>$[?(@.key*2==100)]</code></td>
</tr>
<tr>
<td>Filter expression with negation and equals</td>
<td><code>$[?(!(@.key==42))]</code></td>
</tr>
<tr>
<td>Filter expression with negation and equals array or equals true</td>
<td><code>$[?(!(@.d==["v1","v2"]) &amp;#124;&amp;#124; (@.d == true))]</code></td>
</tr>
<tr>
<td>Filter expression with negation and less than</td>
<td><code>$[?(!(@.key&lt;42))]</code></td>
</tr>
<tr>
<td>Filter expression with negation and without value</td>
<td><code>$[?(!@.key)]</code></td>
</tr>
<tr>
<td>Filter expression with non singular existence test</td>
<td><code>$[?(@.a.*)]</code></td>
</tr>
<tr>
<td>Filter expression with not equals</td>
<td><code>$[?(@.key!=42)]</code></td>
</tr>
<tr>
<td>Filter expression with not equals array or equals true</td>
<td><code>$[?((@.d!=["v1","v2"]) &amp;#124;&amp;#124; (@.d == true))]</code></td>
</tr>
<tr>
<td>Filter expression with parent axis operator</td>
<td><code>$[*].bookmarks[?(@.page == 45)]^^^</code></td>
</tr>
<tr>
<td>Filter expression with regular expression</td>
<td><code>$[?(@.name=~/hello.*/)]</code></td>
</tr>
<tr>
<td>Filter expression with regular expression from member</td>
<td><code>$[?(@.name=~/@.pattern/)]</code></td>
</tr>
<tr>
<td>Filter expression with set wise comparison to scalar</td>
<td><code>$[?(@[*]&gt;=4)]</code></td>
</tr>
<tr>
<td>Filter expression with set wise comparison to set</td>
<td><code>$.x[?(@[*]&gt;=$.y[*])]</code></td>
</tr>
<tr>
<td>Filter expression with single equal</td>
<td><code>$[?(@.key=42)]</code></td>
</tr>
<tr>
<td>Filter expression with subfilter</td>
<td><code>$[?(@.a[?(@.price&gt;10)])]</code></td>
</tr>
<tr>
<td>Filter expression with subpaths deeply nested</td>
<td><code>$[?(@.a.b.c==3)]</code></td>
</tr>
<tr>
<td>Filter expression with subtraction</td>
<td><code>$[?(@.key-50==-100)]</code></td>
</tr>
<tr>
<td>Filter expression with triple equal</td>
<td><code>$[?(@.key===42)]</code></td>
</tr>
<tr>
<td>Filter expression with value</td>
<td><code>$[?(@.key)]</code></td>
</tr>
<tr>
<td>Filter expression with value after recursive descent ?</td>
<td><code>$..[?(@.id)]</code></td>
</tr>
<tr>
<td>Filter expression with value false</td>
<td><code>$[?(false)]</code></td>
</tr>
<tr>
<td>Filter expression with value from recursive descent</td>
<td><code>$[?(@..child)]</code></td>
</tr>
<tr>
<td>Filter expression with value null</td>
<td><code>$[?(null)]</code></td>
</tr>
<tr>
<td>Filter expression with value true</td>
<td><code>$[?(true)]</code></td>
</tr>
<tr>
<td>Filter expression without parens</td>
<td><code>$[?@.key==42]</code></td>
</tr>
<tr>
<td>Filter expression without value</td>
<td><code>$[?(@.key)]</code></td>
</tr>
<tr>
<td>Function sum</td>
<td><code>$.data.sum()</code></td>
</tr>
<tr>
<td>Parens notation</td>
<td><code>$(key,more)</code></td>
</tr>
<tr>
<td>Recursive descent ?</td>
<td><code>$..</code></td>
</tr>
<tr>
<td>Recursive descent after dot notation ?</td>
<td><code>$.key..</code></td>
</tr>
<tr>
<td>Root on scalar</td>
<td><code>$</code></td>
</tr>
<tr>
<td>Root on scalar false</td>
<td><code>$</code></td>
</tr>
<tr>
<td>Root on scalar true</td>
<td><code>$</code></td>
</tr>
<tr>
<td>Script expression</td>
<td><code>$[(@.length-1)]</code></td>
</tr>
<tr>
<td>Union with duplication from array</td>
<td><code>$[0,0]</code></td>
</tr>
<tr>
<td>Union with duplication from object</td>
<td><code>$['a','a']</code></td>
</tr>
<tr>
<td>Union with filter</td>
<td><code>$[?(@.key&lt;3),?(@.key&gt;6)]</code></td>
</tr>
<tr>
<td>Union with keys</td>
<td><code>$['key','another']</code></td>
</tr>
<tr>
<td>Union with keys on object without key</td>
<td><code>$['missing','key']</code></td>
</tr>
<tr>
<td>Union with keys after array slice</td>
<td><code>$[:]['c','d']</code></td>
</tr>
<tr>
<td>Union with keys after bracket notation</td>
<td><code>$[0]['c','d']</code></td>
</tr>
<tr>
<td>Union with keys after dot notation with wildcard</td>
<td><code>$.*['c','d']</code></td>
</tr>
<tr>
<td>Union with keys after recursive descent ?</td>
<td><code>$..['c','d']</code></td>
</tr>
<tr>
<td>Union with repeated matches after dot notation with wildcard</td>
<td><code>$.*[0,:5]</code></td>
</tr>
<tr>
<td>Union with slice and number</td>
<td><code>$[1:3,4]</code></td>
</tr>
<tr>
<td>Union with spaces</td>
<td><code>$[ 0 , 1 ]</code></td>
</tr>
<tr>
<td>Union with wildcard and number</td>
<td><code>$[*,1]</code></td>
</tr>
</tbody>
</table>
</details>
