# Contributing to Shields

Shields is a community project. We invite your participation through
financial contributions, issues, and pull requests!

## Ways you can help

### Financial contributions

We welcome financial contributions in full transparency on our
[open collective](https://opencollective.com/shields).

### Contributing code

This project has quite a backlog of suggestions! If you're new to the project,
maybe you'd like to open a pull request to address one of them:

[![GitHub issues by-label](https://img.shields.io/github/issues/badges/shields/good%20first%20issue.svg)](https://github.com/badges/shields/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22)

### Contributing documentation

You can help by improving the project's usage and developer instructions.

Tutorials are in [/doc](https://github.com/badges/shields/tree/master/doc):

- When you read the documentation, you can fix mistakes and add your own thoughts.
- When your pull request follows the documentation but the practice changed,
  consider pointing this out and change the documentation for the next person.

API documentation is at [contributing.shields.io](https://contributing.shields.io/):

- This documentation is generated by annotating the code with
  [JSDoc](https://jsdoc.app/about-getting-started.html) comments.
  [Example](https://github.com/badges/shields/blob/b3be4d94d5ef570b8daccfd088c343a958988843/core/base-service/base-json.js#L26-L41)
- Adding a JSDoc comment to some existing code is a great first contribution
  and a good way to familiarize yourself with the codebase

### Helping others

You can help with code review, which reduces bugs, and over time has a
wonderful side effect of making the code more readable and therefore more
approachable. It's also a great way to teach and learn. Feel free to jump in!
Be welcoming, appreciative, and helpful. You can perform first reviews of
simple changes, like badge additions. These are usually tagged with
[service badge][service badge pr tag].

Please review [these impeccable guidelines][code review guidelines].

You can monitor [issues][], [discussions][] and the [chat room][], and help
other people who have questions about contributing to Shields, or using it
for their projects.

Feel free to reach out to one of the [maintainers][]
if you need help getting started.

[service badge pr tag]: https://github.com/badges/shields/pulls?q=is%3Apr+is%3Aopen+label%3Aservice-badge
[code review guidelines]: https://kickstarter.engineering/a-guide-to-mindful-communication-in-code-reviews-48aab5282e5e
[issues]: https://github.com/badges/shields/issues
[discussions]: https://github.com/badges/shields/discussions
[chat room]: https://discordapp.com/invite/HjJCwm5
[maintainers]: https://github.com/badges/shields#project-leaders

### Suggesting improvements

There are _a lot_ of suggestions on file. You can help by weighing in on these
suggestions, which helps convey community need to other contributors who might
pick them up.

There is no need to post a new comment. Just add a :thumbsup: or :heart: to
the top post.

If you have a suggestion of your own, [search the open issues][issues]. If you
don't see it, feel free to [open a new issue][open an issue].

[open an issue]: https://github.com/badges/shields/issues/new/choose

### Requesting new logos

We consume logos via [the SimpleIcons project][simple-icons github], and
encourage you to contribute logos there. Please review their
[guidance][simple-icons contributing] before doing so.

[simple-icons github]: https://github.com/simple-icons/simple-icons
[simple-icons contributing]: https://github.com/simple-icons/simple-icons/blob/develop/CONTRIBUTING.md

### Spreading the word

Feel free to star the repository. This will help increase the visibility of the project, therefore attracting more users and contributors to Shields!

We're also asking for [donations](https://opencollective.com/shields) from developers who use and love Shields, please spread the word!

## Getting help

There are three places to get help:

1. If you're new to the project, a good place to start is the [tutorial][].
2. If you need help getting started or implementing a change, [start a discussion][discussions]
   with your question. We promise it's okay to do that. If there is already an
   issue open for the feature you're working on, you can post there directly.
3. You can also join the [chat room][] and ask your question there.

[tutorial]: doc/TUTORIAL.md

## Badge guidelines

- Shields.io hosts integrations for services which are primarily
  used by developers or which are widely used by developers.
- The left-hand side of a badge should not advertise. It should be a lowercase _noun_
  succinctly describing the meaning of the right-hand side.
- Except for badges using the `social` style, logos and links should be _turned off by
  default_.
- Badges should not obtain data from undocumented or reverse-engineered API endpoints.
- Badges should not obtain data by scraping web pages - these are likely to break frequently.
  Whereas API publishers are incentivised to maintain a stable platform for their users,
  authors of web pages have no such incentive.
- Badges may require users to specify a token in the badge URL as long it is scoped only to
  fetching information and doesn't expose any sensitive information. Generating a token with the
  correct scope must be clearly documented.

## Badge URLs

- The format of new badges should be of the form `/SERVICE/NOUN/PARAMETERS`.
- There is further documentation on this in [badge-urls](https://github.com/badges/shields/blob/master/doc/badge-urls.md)

## Coding guidelines

### Prettier

This project formats its source code using Prettier. The most enjoyable way to
use Prettier is to let it format code for you when you save. You can [integrate
it into your editor][integrate prettier].

Whether you integrate it into your editor or not, a pre-commit hook will run
Prettier before a commit by default.

[integrate prettier]: https://prettier.io/docs/en/editors.html

### Tests

When adding or changing a service [please write tests][service-tests], and ensure the [title of your Pull Requests follows the required conventions](#running-service-tests-in-pull-requests) to ensure your tests are executed.
When changing other code, please add unit tests.

The integration tests are not run by default. For most contributions it is OK to skip these unless you're working directly on the code for storing the GitHub token pool in postgres.

To run the integration tests:

- You must have PostgreSQL installed. Use `brew install postgresql`, `apt-get install postgresql`, etc.
- Set a connection string either with an env var `POSTGRES_URL=postgresql://user:pass@127.0.0.1:5432/db_name` or by using
  ```yaml
  private:
    postgres_url: 'postgresql://user:pass@127.0.0.1:5432/db_name'
  ```
  in a yaml config file.
- Run `npm run migrate up` to apply DB migrations
- Run `npm run test:integration` to run the tests

[service-tests]: https://github.com/badges/shields/blob/master/doc/service-tests.md

### Code organization

There is a [High-level code walkthrough](doc/code-walkthrough.md) describing the layout of the project.

## Pull Requests

All code changes are incorporated via pull requests, and pull requests are always squashed into a single commit on merging. Therefore there's no requirement to squash commits within your PR, but feel free to squash or restructure the commits on your PR branch if you think it will be helpful. PRs with well structured commits are always easier to review!

Because all changes are pulled into the main branch via squash merges from PRs, we do **not** support overwriting any aspects of the git history once it hits our main branch. Notably this means we do not support amending commit messages, nor adjusting commit author information once merged.

Accordingly, it is the responsibility of contributors to review this type of information and adjust as needed before marking PRs as ready for review and merging.

You can review and modify your local [git configuration][git-config] via `git config`, and also find more information about amending your commit messages [here][amending-commits].

[git-config]: https://git-scm.com/book/en/v2/Customizing-Git-Git-Configuration
[amending-commits]: https://docs.github.com/en/github/committing-changes-to-your-project/changing-a-commit-message#rewriting-the-most-recent-commit-message

### Running service tests in pull requests

The affected service names must be included in square brackets in the pull request title so that the CI engine will run those service tests. When a pull request affects multiple services, they should be separated with spaces. The test runner is case-insensitive, so they should be capitalized for readability.

For example:

- **[Travis] Fix timeout issues**
- **[Travis Sonar] Support user token authentication**
- **Add tests for [CRAN] and [CPAN]**

Note that many services are part of a "family" of related services. Depending on the changes in your PR you may need to run the tests for just a single service, or for _all_ the services within a family.

For example, a PR title of **[GitHubForks] Foo** will only run the service tests specifically for the GitHub Forks badge, whereas a title of **[GitHub] Foo** will run the service tests for all of the GitHub badges.

In the rare case when it's necessary to see the output of a full service-test
run in a PR (all 2,000+ tests), include `[*****]` in the title. Unless all the tests pass, the build
will fail, so likely it will be necessary to remove it and re-run the tests
before merging.
