# Awesome by Example [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) [![License](https://img.shields.io/npm/l/generator-awesome-list.svg)](https://www.apache.org/licenses/LICENSE-2.0)

> A curated list of awesome example-based learning resources.

## Contents

- [Languages](#languages)
  - [Clojure](#clojure)
  - [Elm](#elm)
  - [Go](#go)
  - [Haskell](#haskell)
  - [Java](#java)
  - [JavaScript](#javascript)
  - [Python](#python)
  - [Ruby](#ruby)
  - [Rust](#rust)
  - [Scala](#scala)
  - [Other Languages](#other-languages)
- [Databases](#databases)
- [Libraries and Frameworks](#libraries-and-frameworks)
- [Tools](#tools)
- [SaaS and APIs](#saas-and-apis)
- [General Resources](#general-resources)
- [Related Lists](#related-lists)
- [Credits](#credits)
- [Contribute](#contribute)

## Languages

### Clojure

- [4clojure: 4Clojure is a resource to help fledgling clojurians learn the language through interactive problems](https://www.4clojure.com/)
- [Clojure Koans: A set of exercises for learning Clojure](https://github.com/functional-koans/clojure-koans)
- [Clojure Koans: Clojure koans are exercises meant to initiate you to the mysteries of the Clojure language](http://clojurekoans.com/)
- [ClojureScript Koans: The ClojureScript koans walk you along the path of enlightenment to learning ClojureScript](http://clojurescriptkoans.com/)
- [Core.logic Koans: Learn core.logic with koans!](https://github.com/sritchie/core.logic-koans)

### Elm

- [Elm Koans: A set of koans for learning Elm](https://github.com/robertjlooby/elm-koans)
- [Elm-TodoMVC: The TodoMVC app written in Elm, nice example for beginners](https://github.com/evancz/elm-todomvc)

### Go

- [Go by Example: A hands-on introduction to Go using annotated example programs](https://gobyexample.com/)
- [Go Koans: Koans for Go](https://github.com/cdarwin/go-koans)

### Haskell

- [The Haskell Phrasebook](https://typeclasses.com/phrasebook)
- [Learn You a Haskell for Great Good!](http://learnyouahaskell.com/)
- [Haskell Programming from first principles](https://haskellbook.com/) (⚠️ nonfree, proprietary)

### Java

- [Java Koans: A framework and lessons to learn Java syntax and idioms in a logical sequence](https://github.com/matyb/java-koans)
- [Neo4j tutorial: A koan-style tutorial in Java for Neo4j](https://github.com/jimwebber/neo4j-tutorial)

### JavaScript

- [JavaScript Koans: Koans to learn JavaScript](https://github.com/mrdavidlaing/javascript-koans)
- [JavaScript Koans: An interactive learning environment that uses failing tests to introduce students to aspects of JavaScript in a logical sequence](https://github.com/liammclennan/JavaScript-Koans)

### Python

- [Learn Python: 📚 Playground and cheatsheet for learning Python](https://github.com/trekhleb/learn-python)
- [Python Koans: Learn Python through TDD](https://github.com/gregmalcolm/python_koans)
- [Pytudes: Python programs, usually short, of considerable difficulty, to perfect particular skills](https://github.com/norvig/pytudes)
- [geekcomputers/Python: A large collection of simple example Python programs](https://github.com/geekcomputers/Python)

### Ruby

- [Ruby Koans: Learn Ruby with the Edgecase Ruby Koans](https://github.com/edgecase/ruby_koans)
- [Ruby Metaprograaming Koans (Inspired by EdgeCase RubyKoans)](https://github.com/sathish316/metaprogramming_koans)

### Rust

- [A half-hour to learn Rust](https://fasterthanli.me/articles/a-half-hour-to-learn-rust)
- [Rust by Example: Learn Rust with examples (Live code editor included)](https://github.com/rust-lang/rust-by-example)
- [Rustlings: Small exercises to get you used to reading and writing Rust code](https://github.com/rust-lang/rustlings)

### Scala

- [Scalania: Learn Scala by examples](https://github.com/jaceklaskowski/scalania)
- [Scala Exercises: Scala Exercises is an Open Source project for learning different technologies based in the Scala Programming Language](https://www.scala-exercises.org/)

### Other Languages

- [30 Days of Elixir: A walk through the Elixir language in 30 exercises](https://github.com/seven1m/30-days-of-elixir)
- [APLcart: Find your way in APL](https://aplcart.info/)
- [Coffeescript Koans: learn CoffeeScript by doing it](https://github.com/sleepyfox/coffeescript-koans)
- [Dart Koans: Achieve enlightenment through failure](https://github.com/butlermatt/dart_koans)
- [Deno by Example: Learn Web Programming in Deno by Examples](https://github.com/deepakshrma/deno-by-example)
- [DLangKoans: An educational unit test suite for the D Programming Language](https://github.com/ilmanzo/DLangKoans)
- [Erlang Koans: A set of koans for learning Erlang](https://github.com/patrickgombert/erlang-koans)
- [FSharpKoans: A simple, fun, and interactive way to learn the F# language through testing](https://github.com/ChrisMarinos/FSharpKoans)
- [FP Course: Learn Functional Programming concepts with the Haskell programming language](https://github.com/tonymorris/course)
- [GNU Smalltalk Koans: A set of tests to teach you Smalltalk](https://github.com/sl4m/gnu_smalltalk_koans)
- [Lisp Koans: Common Lisp Koans is a language learning exercise in the same vein as the ruby koans](https://github.com/google/lisp-koans)
- [Lua Missions: Lua Koans, minus the Zen stuff](https://github.com/kikito/lua_missions)
- [Writing a Game Boy Emulator in OCaml](https://linoscope.github.io/writing-a-game-boy-emulator-in-ocaml/)
- [Perl Koans: A framework to learn-by-doing for Perl, with a heavy emphasis on testing](https://github.com/forcedotcom/PerlKoans)
- [PSKoans: A simple, fun, and interactive way to learn the PowerShell language through Pester unit testing](https://github.com/vexx32/PSKoans)
- [TypeScript exercises: A set of interactive TypeScript exercises](https://github.com/typescript-exercises/typescript-exercises)
- [V by Example: V by Example is a direct introduction to V by using annotated program examples](https://github.com/v-community/v_by_example)
- [Learn Vimscript the Hard Way](https://learnvimscriptthehardway.stevelosh.com/)
- [Ziglings: Learn the Zig programming language by fixing tiny broken programs](https://github.com/ratfactor/ziglings)

## Databases

- [MongoDB Koans: A way to learn MongoDB and the Ruby driver inspired by EdgeCase Ruby koans](https://github.com/chicagoruby/MongoDB_Koans)
- [SQL Koans: A set of Koans to teach SQL](https://sqlkoans.com/)

## Libraries and Frameworks

- [ReactJS Koans: Learn basics of React.js making the tests pass](https://github.com/arkency/reactjs_koans)
- [Learning Tensorflow: Simple Tensorflow tutorials for learning by example](https://github.com/michaelmendoza/learning-tensorflow)
- [OSMnx Examples: Usage examples, demos, and tutorials for OSMnx (OpenStreetMap)](https://github.com/gboeing/osmnx-examples)
- [Quickserv Examples: Example applications to run with QuickServ](https://github.com/jstrieb/quickserv-examples)

## Tools

- [Git Immersion: A guided tour that walks through the fundamentals of Git](http://gitimmersion.com/)
- [GitHub Actions by Example](https://www.actionsbyexample.com/)
- [Makefile Tutorial: Learn make by example](https://github.com/theicfire/makefiletutorial)
- [Kubernetes for kids](https://www.cncf.io/phippy/the-childrens-illustrated-guide-to-kubernetes/)

## SaaS and APIs

- [Apps Script Samples: Apps Script samples for Google Workspace products](https://github.com/googleworkspace/apps-script-samples)

## General Resources

- [Exercism.io: Level up your programming skills with 3,450 exercises across 52 languages](https://exercism.io/)
- [Learn X in Y Minutes: Scenic Programming Language Tours](https://learnxinyminutes.com/)

## Related Lists

- [ahmdrefat/awesome-koans](https://github.com/ahmdrefat/awesome-koans/blob/master/koans-en.md)

## Credits

- Numerous Koans were adapted from [ahmdrefat/awesome-koans](https://github.com/ahmdrefat/awesome-koans).

## Contribute

Contributions via PR or issue are welcome! Read the [contribution guidelines](CONTRIBUTING.md) first.
