# Contribution Guidelines

Please note that this project is released with a
[Contributor Code of Conduct](CONDUCT.md). By participating in this
project you agree to abide by its terms.

---

Ensure your pull request adheres to the following guidelines:

- Resources should be:
  - Example-based.
  - Technically oriented.
  - Ideally, free and open source.
    - Exceptions may be made on a case-by-case basis, especially in categories lacking many free resources, provided the resources are explicitly noted to be paid, nonfree, or both.
    - Free and open source resources will always be prioritized above paid resources, and if enough free resources are listed, paid ones may be bumped off.
  - Reasonably up-to-date or applicable to today. Outdated resources will be periodically purged from the list.
- Try to categorize resources appropriately. Sub-headings may be added or adjusted when necessary.

Thank you for your suggestions!

## Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult.
If the maintainers notice anything that we'd like changed, we'll ask you to
edit your PR before we merge it. There's no need to open a new PR, just edit
the existing one. If you're not sure how to do that,
[here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md)
on the different ways you can update your PR so that we can merge it.
