import { CreatePost } from '~/app/_components/create-post';
import { api } from '~/trpc/server';

export default async function Home() {
  const hello = await api.post.hello.query({ text: 'from tRPC' });

  return (
    <main>
      <div>
        <h1>Create T3 App (App Router)</h1>

        <div>
          <p>{hello ? hello.greeting : 'Loading tRPC query...'}</p>
        </div>

        <CrudShowcase />
      </div>
    </main>
  );
}

async function CrudShowcase() {
  const latestPost = await api.post.getLatest.query();

  return (
    <div>
      {latestPost ? (
        <p>Your most recent post: {latestPost.name}</p>
      ) : (
        <p>You have no posts yet.</p>
      )}

      <CreatePost />
    </div>
  );
}
