import { APIGatewayProxyEvent, APIGatewayProxyResult } from 'aws-lambda';
import { listChats } from './repository';

export const handler = async (
  event: APIGatewayProxyEvent
): Promise<APIGatewayProxyResult> => {
  try {
    const userId: string =
      event.requestContext.authorizer!.claims['cognito:username'];
    const exclusiveStartKey = event?.queryStringParameters?.exclusiveStartKey;
    const { chats, lastEvaluatedKey } = await listChats(
      userId,
      exclusiveStartKey
    );

    return {
      statusCode: 200,
      headers: {
        'Content-Type': 'application/json',
        'Access-Control-Allow-Origin': '*',
      },
      body: JSON.stringify({
        chats,
        lastEvaluatedKey,
      }),
    };
  } catch (error) {
    console.log(error);
    return {
      statusCode: 500,
      headers: {
        'Content-Type': 'application/json',
        'Access-Control-Allow-Origin': '*',
      },
      body: JSON.stringify({ message: 'Internal Server Error' }),
    };
  }
};
