## API Report File for "@aws-amplify/graphql-api-construct"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { AppsyncFunction } from 'aws-cdk-lib/aws-appsync';
import { BaseDataSource } from 'aws-cdk-lib/aws-appsync';
import { BillingMode } from 'aws-cdk-lib/aws-dynamodb';
import { CfnApiKey } from 'aws-cdk-lib/aws-appsync';
import { CfnDataSource } from 'aws-cdk-lib/aws-appsync';
import { CfnFunction } from 'aws-cdk-lib/aws-lambda';
import { CfnFunctionConfiguration } from 'aws-cdk-lib/aws-appsync';
import { CfnGraphQLApi } from 'aws-cdk-lib/aws-appsync';
import { CfnGraphQLSchema } from 'aws-cdk-lib/aws-appsync';
import { CfnResolver } from 'aws-cdk-lib/aws-appsync';
import { CfnResource } from 'aws-cdk-lib';
import { CfnRole } from 'aws-cdk-lib/aws-iam';
import { CfnTable } from 'aws-cdk-lib/aws-dynamodb';
import { Code } from 'aws-cdk-lib/aws-appsync';
import { Construct } from 'constructs';
import { DataSourceOptions } from 'aws-cdk-lib/aws-appsync';
import { Duration } from 'aws-cdk-lib';
import { DynamoDbDataSource } from 'aws-cdk-lib/aws-appsync';
import { ElasticsearchDataSource } from 'aws-cdk-lib/aws-appsync';
import { EventBridgeDataSource } from 'aws-cdk-lib/aws-appsync';
import { ExtendedResolverProps } from 'aws-cdk-lib/aws-appsync';
import { FieldLogLevel } from 'aws-cdk-lib/aws-appsync';
import { FunctionRuntime } from 'aws-cdk-lib/aws-appsync';
import { HttpDataSource } from 'aws-cdk-lib/aws-appsync';
import { HttpDataSourceOptions } from 'aws-cdk-lib/aws-appsync';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { IDomain } from 'aws-cdk-lib/aws-elasticsearch';
import { IDomain as IDomain_2 } from 'aws-cdk-lib/aws-opensearchservice';
import { IEventBus } from 'aws-cdk-lib/aws-events';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { IGraphqlApi } from 'aws-cdk-lib/aws-appsync';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { ISecret } from 'aws-cdk-lib/aws-secretsmanager';
import { IServerlessCluster } from 'aws-cdk-lib/aws-rds';
import { ITable } from 'aws-cdk-lib/aws-dynamodb';
import { IUserPool } from 'aws-cdk-lib/aws-cognito';
import { LambdaDataSource } from 'aws-cdk-lib/aws-appsync';
import { MappingTemplate } from 'aws-cdk-lib/aws-appsync';
import { NestedStack } from 'aws-cdk-lib';
import { NoneDataSource } from 'aws-cdk-lib/aws-appsync';
import { OpenSearchDataSource } from 'aws-cdk-lib/aws-appsync';
import { RdsDataSource } from 'aws-cdk-lib/aws-appsync';
import { RemovalPolicy } from 'aws-cdk-lib';
import { Resolver } from 'aws-cdk-lib/aws-appsync';
import { RetentionDays } from 'aws-cdk-lib/aws-logs';
import { Stack } from 'aws-cdk-lib';
import { StreamViewType } from 'aws-cdk-lib/aws-dynamodb';

// @public
export interface AddFunctionProps {
    readonly code?: Code;
    readonly dataSource: BaseDataSource;
    readonly description?: string;
    readonly name: string;
    readonly requestMappingTemplate?: MappingTemplate;
    readonly responseMappingTemplate?: MappingTemplate;
    readonly runtime?: FunctionRuntime;
}

// @public
export interface AmplifyDynamoDbModelDataSourceStrategy {
    // (undocumented)
    readonly dbType: 'DYNAMODB';
    // (undocumented)
    readonly provisionStrategy: 'AMPLIFY_TABLE';
}

// @public
export class AmplifyDynamoDbTableWrapper {
    constructor(resource: CfnResource);
    applyRemovalPolicy(policy: RemovalPolicy): void;
    set billingMode(billingMode: BillingMode);
    set deletionProtectionEnabled(deletionProtectionEnabled: boolean);
    static isAmplifyDynamoDbTableResource(x: any): x is CfnResource;
    set pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled: boolean);
    set provisionedThroughput(provisionedThroughput: ProvisionedThroughput);
    setGlobalSecondaryIndexProvisionedThroughput(indexName: string, provisionedThroughput: ProvisionedThroughput): void;
    set sseSpecification(sseSpecification: SSESpecification);
    set streamSpecification(streamSpecification: StreamSpecification);
    set timeToLiveAttribute(timeToLiveSpecification: TimeToLiveSpecification);
}

// @public
export class AmplifyGraphqlApi extends Construct {
    constructor(scope: Construct, id: string, props: AmplifyGraphqlApiProps);
    addDynamoDbDataSource(id: string, table: ITable, options?: DataSourceOptions): DynamoDbDataSource;
    // @deprecated
    addElasticsearchDataSource(id: string, domain: IDomain, options?: DataSourceOptions): ElasticsearchDataSource;
    addEventBridgeDataSource(id: string, eventBus: IEventBus, options?: DataSourceOptions): EventBridgeDataSource;
    addFunction(id: string, props: AddFunctionProps): AppsyncFunction;
    addHttpDataSource(id: string, endpoint: string, options?: HttpDataSourceOptions): HttpDataSource;
    addLambdaDataSource(id: string, lambdaFunction: IFunction, options?: DataSourceOptions): LambdaDataSource;
    addNoneDataSource(id: string, options?: DataSourceOptions): NoneDataSource;
    addOpenSearchDataSource(id: string, domain: IDomain_2, options?: DataSourceOptions): OpenSearchDataSource;
    addRdsDataSource(id: string, serverlessCluster: IServerlessCluster, secretStore: ISecret, databaseName?: string, options?: DataSourceOptions): RdsDataSource;
    addResolver(id: string, props: ExtendedResolverProps): Resolver;
    readonly apiId: string;
    readonly apiKey: string | undefined;
    readonly generatedFunctionSlots: FunctionSlot[];
    readonly graphqlUrl: string;
    readonly realtimeUrl: string;
    readonly resources: AmplifyGraphqlApiResources;
    readonly stack: Stack;
}

// @public
export interface AmplifyGraphqlApiCfnResources {
    readonly additionalCfnResources: Record<string, CfnResource>;
    readonly amplifyDynamoDbTables: Record<string, AmplifyDynamoDbTableWrapper>;
    readonly cfnApiKey?: CfnApiKey;
    readonly cfnDataSources: Record<string, CfnDataSource>;
    readonly cfnFunctionConfigurations: Record<string, CfnFunctionConfiguration>;
    readonly cfnFunctions: Record<string, CfnFunction>;
    readonly cfnGraphqlApi: CfnGraphQLApi;
    readonly cfnGraphqlSchema: CfnGraphQLSchema;
    readonly cfnResolvers: Record<string, CfnResolver>;
    readonly cfnRoles: Record<string, CfnRole>;
    readonly cfnTables: Record<string, CfnTable>;
}

// @public
export interface AmplifyGraphqlApiProps {
    readonly apiName?: string;
    readonly authorizationModes: AuthorizationModes;
    // @deprecated
    readonly conflictResolution?: ConflictResolution;
    readonly dataStoreConfiguration?: DataStoreConfiguration;
    readonly definition: IAmplifyGraphqlDefinition;
    readonly functionNameMap?: Record<string, IFunction>;
    readonly functionSlots?: FunctionSlot[];
    readonly logging?: Logging;
    readonly outputStorageStrategy?: IBackendOutputStorageStrategy;
    readonly predictionsBucket?: IBucket;
    readonly stackMappings?: Record<string, string>;
    readonly transformerPlugins?: any[];
    readonly translationBehavior?: PartialTranslationBehavior;
}

// @public
export interface AmplifyGraphqlApiResources {
    readonly cfnResources: AmplifyGraphqlApiCfnResources;
    readonly functions: Record<string, IFunction>;
    readonly graphqlApi: IGraphqlApi;
    readonly nestedStacks: Record<string, NestedStack>;
    readonly roles: Record<string, IRole>;
    readonly tables: Record<string, ITable>;
}

// @public
export class AmplifyGraphqlDefinition {
    static combine(definitions: IAmplifyGraphqlDefinition[]): IAmplifyGraphqlDefinition;
    static fromFiles(...filePaths: string[]): IAmplifyGraphqlDefinition;
    static fromFilesAndStrategy(filePaths: string | string[], dataSourceStrategy?: ModelDataSourceStrategy): IAmplifyGraphqlDefinition;
    static fromString(schema: string, dataSourceStrategy?: ModelDataSourceStrategy): IAmplifyGraphqlDefinition;
}

// @public
export interface ApiKeyAuthorizationConfig {
    readonly description?: string;
    readonly expires: Duration;
}

// @public
export interface AuthorizationModes {
    readonly adminRoles?: IRole[];
    readonly apiKeyConfig?: ApiKeyAuthorizationConfig;
    readonly defaultAuthorizationMode?: 'AWS_IAM' | 'AMAZON_COGNITO_USER_POOLS' | 'OPENID_CONNECT' | 'API_KEY' | 'AWS_LAMBDA';
    readonly iamConfig?: IAMAuthorizationConfig;
    readonly identityPoolConfig?: IdentityPoolAuthorizationConfig;
    readonly lambdaConfig?: LambdaAuthorizationConfig;
    readonly oidcConfig?: OIDCAuthorizationConfig;
    readonly userPoolConfig?: UserPoolAuthorizationConfig;
}

// @public
export interface AutomergeConflictResolutionStrategy extends ConflictResolutionStrategyBase {
    readonly handlerType: 'AUTOMERGE';
}

// @public
export type ConflictDetectionType = 'VERSION' | 'NONE';

// @public @deprecated
export interface ConflictResolution extends DataStoreConfiguration {
}

// @public
export type ConflictResolutionStrategy = AutomergeConflictResolutionStrategy | OptimisticConflictResolutionStrategy | CustomConflictResolutionStrategy;

// @public
export interface ConflictResolutionStrategyBase {
    readonly detectionType: ConflictDetectionType;
}

// @public
export interface CustomConflictResolutionStrategy extends ConflictResolutionStrategyBase {
    readonly conflictHandler: IFunction;
    readonly handlerType: 'LAMBDA';
}

// @public
export interface CustomSqlDataSourceStrategy {
    readonly fieldName: string;
    readonly strategy: SQLLambdaModelDataSourceStrategy;
    readonly typeName: 'Query' | 'Mutation';
}

// @public
export interface DataStoreConfiguration {
    readonly models?: Record<string, ConflictResolutionStrategy>;
    readonly project?: ConflictResolutionStrategy;
}

// @public
export interface DefaultDynamoDbModelDataSourceStrategy {
    // (undocumented)
    readonly dbType: 'DYNAMODB';
    // (undocumented)
    readonly provisionStrategy: 'DEFAULT';
}

export { FieldLogLevel }

// @public
export type FunctionSlot = MutationFunctionSlot | QueryFunctionSlot | SubscriptionFunctionSlot;

// @public
export interface FunctionSlotBase {
    readonly fieldName: string;
    readonly function: FunctionSlotOverride;
    readonly slotIndex: number;
}

// @public
export interface FunctionSlotOverride {
    readonly requestMappingTemplate?: MappingTemplate;
    readonly responseMappingTemplate?: MappingTemplate;
}

// @public
export interface IAMAuthorizationConfig {
    // @deprecated
    readonly allowListedRoles?: (IRole | string)[];
    // @deprecated
    readonly authenticatedUserRole?: IRole;
    readonly enableIamAuthorizationMode?: boolean;
    // @deprecated
    readonly identityPoolId?: string;
    // @deprecated
    readonly unauthenticatedUserRole?: IRole;
}

// @public
export interface IAmplifyGraphqlDefinition {
    readonly customSqlDataSourceStrategies?: CustomSqlDataSourceStrategy[];
    readonly dataSourceStrategies: Record<string, ModelDataSourceStrategy>;
    readonly functionSlots: FunctionSlot[];
    readonly referencedLambdaFunctions?: Record<string, IFunction>;
    readonly schema: string;
}

// @public
export interface IBackendOutputEntry {
    readonly payload: Record<string, string>;
    readonly version: string;
}

// @public
export interface IBackendOutputStorageStrategy {
    addBackendOutputEntry(keyName: string, backendOutputEntry: IBackendOutputEntry): void;
}

// @public
export interface IdentityPoolAuthorizationConfig {
    readonly authenticatedUserRole: IRole;
    readonly identityPoolId: string;
    readonly unauthenticatedUserRole: IRole;
}

// @public
export interface ImportedAmplifyDynamoDbModelDataSourceStrategy {
    // (undocumented)
    readonly dbType: 'DYNAMODB';
    // (undocumented)
    readonly provisionStrategy: 'IMPORTED_AMPLIFY_TABLE';
    // (undocumented)
    readonly tableName: string;
}

// @public
export interface LambdaAuthorizationConfig {
    readonly function: IFunction;
    readonly ttl: Duration;
}

// @public
export interface LogConfig {
    readonly excludeVerboseContent?: boolean;
    readonly fieldLogLevel?: FieldLogLevel;
    readonly retention?: RetentionDays;
}

// @public
export type Logging = true | LogConfig;

// @public
export type ModelDataSourceStrategy = DefaultDynamoDbModelDataSourceStrategy | AmplifyDynamoDbModelDataSourceStrategy | ImportedAmplifyDynamoDbModelDataSourceStrategy | SQLLambdaModelDataSourceStrategy;

// @public
export type ModelDataSourceStrategyDbType = 'DYNAMODB' | ModelDataSourceStrategySqlDbType;

// @public
export type ModelDataSourceStrategySqlDbType = 'MYSQL' | 'POSTGRES';

// @public
export interface MutationFunctionSlot extends FunctionSlotBase {
    readonly slotName: 'init' | 'preAuth' | 'auth' | 'postAuth' | 'preUpdate' | 'postUpdate' | 'finish';
    readonly typeName: 'Mutation';
}

// @public
export interface OIDCAuthorizationConfig {
    readonly clientId?: string;
    readonly oidcIssuerUrl: string;
    readonly oidcProviderName: string;
    readonly tokenExpiryFromAuth: Duration;
    readonly tokenExpiryFromIssue: Duration;
}

// @public
export interface OptimisticConflictResolutionStrategy extends ConflictResolutionStrategyBase {
    readonly handlerType: 'OPTIMISTIC_CONCURRENCY';
}

// @public
export interface PartialTranslationBehavior {
    readonly allowDestructiveGraphqlSchemaUpdates?: boolean;
    readonly disableResolverDeduping?: boolean;
    readonly enableAutoIndexQueryNames?: boolean;
    readonly enableSearchNodeToNodeEncryption?: boolean;
    readonly enableTransformerCfnOutputs?: boolean;
    readonly populateOwnerFieldForStaticGroupAuth?: boolean;
    // @internal
    readonly _provisionHotswapFriendlyResources?: boolean;
    readonly replaceTableUponGsiUpdate?: boolean;
    readonly respectPrimaryKeyAttributesOnConnectionField?: boolean;
    readonly sandboxModeEnabled?: boolean;
    readonly secondaryKeyAsGSI?: boolean;
    readonly shouldDeepMergeDirectiveConfigDefaults?: boolean;
    readonly subscriptionsInheritPrimaryAuth?: boolean;
    readonly suppressApiKeyGeneration?: boolean;
    readonly useSubUsernameForDefaultIdentityClaim?: boolean;
}

// @public
export interface ProvisionedConcurrencyConfig {
    readonly provisionedConcurrentExecutions: number;
}

// @public
export interface ProvisionedThroughput {
    readonly readCapacityUnits: number;
    readonly writeCapacityUnits: number;
}

// @public
export interface QueryFunctionSlot extends FunctionSlotBase {
    readonly slotName: 'init' | 'preAuth' | 'auth' | 'postAuth' | 'preDataLoad' | 'postDataLoad' | 'finish';
    readonly typeName: 'Query';
}

export { RetentionDays }

// @public
export interface SQLLambdaModelDataSourceStrategy {
    readonly customSqlStatements?: Record<string, string>;
    readonly dbConnectionConfig: SqlModelDataSourceDbConnectionConfig;
    readonly dbType: ModelDataSourceStrategySqlDbType;
    readonly name: string;
    readonly sqlLambdaProvisionedConcurrencyConfig?: ProvisionedConcurrencyConfig;
    readonly vpcConfiguration?: VpcConfig;
}

// @public
export class SQLLambdaModelDataSourceStrategyFactory {
    static fromCustomSqlFiles(sqlFiles: string[], options: Exclude<SQLLambdaModelDataSourceStrategy, 'customSqlStatements'>): SQLLambdaModelDataSourceStrategy;
}

// @public
export type SqlModelDataSourceDbConnectionConfig = SqlModelDataSourceSecretsManagerDbConnectionConfig | SqlModelDataSourceSsmDbConnectionConfig | SqlModelDataSourceSsmDbConnectionStringConfig;

// @public
export interface SqlModelDataSourceSecretsManagerDbConnectionConfig {
    readonly databaseName: string;
    readonly hostname: string;
    readonly keyArn?: string;
    readonly port: number;
    readonly secretArn: string;
    readonly sslCertConfig?: SslCertConfig;
}

// @public
export interface SqlModelDataSourceSsmDbConnectionConfig {
    readonly databaseNameSsmPath: string;
    readonly hostnameSsmPath: string;
    readonly passwordSsmPath: string;
    readonly portSsmPath: string;
    readonly sslCertConfig?: SslCertConfig;
    readonly usernameSsmPath: string;
}

// @public
export interface SqlModelDataSourceSsmDbConnectionStringConfig {
    readonly connectionUriSsmPath: string | string[];
    readonly sslCertConfig?: SslCertConfig;
}

// @public
export interface SSESpecification {
    readonly kmsMasterKeyId?: string;
    readonly sseEnabled: boolean;
    readonly sseType?: SSEType;
}

// @public
export enum SSEType {
    // (undocumented)
    KMS = "KMS"
}

// @public
export interface SslCertConfig {
}

// @public (undocumented)
export interface SslCertSsmPathConfig extends SslCertConfig {
    readonly ssmPath: string | string[];
}

// @public
export interface StreamSpecification {
    readonly streamViewType: StreamViewType;
}

// @public
export interface SubnetAvailabilityZone {
    readonly availabilityZone: string;
    readonly subnetId: string;
}

// @public
export interface SubscriptionFunctionSlot extends FunctionSlotBase {
    readonly slotName: 'init' | 'preAuth' | 'auth' | 'postAuth' | 'preSubscribe';
    readonly typeName: 'Subscription';
}

// @public
export interface TimeToLiveSpecification {
    readonly attributeName?: string;
    readonly enabled: boolean;
}

// @public
export interface TranslationBehavior {
    readonly allowDestructiveGraphqlSchemaUpdates: boolean;
    readonly disableResolverDeduping: boolean;
    readonly enableAutoIndexQueryNames: boolean;
    // (undocumented)
    readonly enableSearchNodeToNodeEncryption: boolean;
    readonly enableTransformerCfnOutputs: boolean;
    readonly populateOwnerFieldForStaticGroupAuth: boolean;
    readonly replaceTableUponGsiUpdate: boolean;
    readonly respectPrimaryKeyAttributesOnConnectionField: boolean;
    readonly sandboxModeEnabled: boolean;
    readonly secondaryKeyAsGSI: boolean;
    readonly shouldDeepMergeDirectiveConfigDefaults: boolean;
    readonly subscriptionsInheritPrimaryAuth: boolean;
    readonly suppressApiKeyGeneration: boolean;
    readonly useSubUsernameForDefaultIdentityClaim: boolean;
}

// @public
export interface UserPoolAuthorizationConfig {
    readonly userPool: IUserPool;
}

// @public
export interface VpcConfig {
    readonly securityGroupIds: string[];
    readonly subnetAvailabilityZoneConfig: SubnetAvailabilityZone[];
    readonly vpcId: string;
}

// (No @packageDocumentation comment for this package)

```
