// NOTE: The API and operations used in these implementations were generated by running `amplify codegen --maxDepth 4`, then edited to
// remove createdAt, updatedAt, and __typename.

import { AppSyncGraphqlResponse, doAppSyncGraphqlMutation, doAppSyncGraphqlQuery } from '../../../utils';
import {
  CreatePrimaryMutation,
  CreateRelatedManyMutation,
  CreateRelatedOneMutation,
  GetPrimaryQuery,
  GetRelatedManyQuery,
  GetRelatedOneQuery,
  ListPrimariesQuery,
  ListRelatedManiesQuery,
  ListRelatedOnesQuery,
  UpdatePrimaryMutation,
  UpdateRelatedManyMutation,
  UpdateRelatedOneMutation,
} from './API';
import { createPrimary, createRelatedMany, createRelatedOne, updatePrimary, updateRelatedMany, updateRelatedOne } from './mutations';
import { getPrimary, getRelatedMany, getRelatedOne, listPrimaries, listRelatedManies, listRelatedOnes } from './queries';

export const doCreatePrimary = async (
  apiEndpoint: string,
  accessToken: string,
  primaryId: string,
  groups: string[],
): Promise<AppSyncGraphqlResponse<CreatePrimaryMutation>> => {
  return doAppSyncGraphqlMutation({
    apiEndpoint,
    auth: { accessToken: accessToken },
    query: createPrimary,
    variables: {
      id: primaryId,
      groups,
    },
  });
};

export const doCreateRelatedMany = async (
  apiEndpoint: string,
  accessToken: string,
  relatedManyId: string,
  primaryId: string,
  groups: string[],
): Promise<AppSyncGraphqlResponse<CreateRelatedManyMutation>> => {
  return doAppSyncGraphqlMutation({
    apiEndpoint,
    auth: { accessToken: accessToken },
    query: createRelatedMany,
    variables: {
      id: relatedManyId,
      primaryId,
      groups,
    },
  });
};

export const doCreateRelatedOne = async (
  apiEndpoint: string,
  accessToken: string,
  relatedOneId: string,
  primaryId: string,
  groups: string[],
): Promise<AppSyncGraphqlResponse<CreateRelatedOneMutation>> => {
  return doAppSyncGraphqlMutation({
    apiEndpoint,
    auth: { accessToken: accessToken },
    query: createRelatedOne,
    variables: {
      id: relatedOneId,
      primaryId,
      groups,
    },
  });
};

export const doGetPrimary = async (
  apiEndpoint: string,
  accessToken: string,
  primaryId: string,
): Promise<AppSyncGraphqlResponse<GetPrimaryQuery>> => {
  return doAppSyncGraphqlQuery({
    apiEndpoint,
    auth: { accessToken },
    query: getPrimary,
    variables: {
      id: primaryId,
    },
  });
};

export const doGetRelatedMany = async (
  apiEndpoint: string,
  accessToken: string,
  relatedManyId: string,
): Promise<AppSyncGraphqlResponse<GetRelatedManyQuery>> => {
  return doAppSyncGraphqlQuery({
    apiEndpoint,
    auth: { accessToken },
    query: getRelatedMany,
    variables: {
      id: relatedManyId,
    },
  });
};

export const doGetRelatedOne = async (
  apiEndpoint: string,
  accessToken: string,
  relatedOneId: string,
): Promise<AppSyncGraphqlResponse<GetRelatedOneQuery>> => {
  return doAppSyncGraphqlQuery({
    apiEndpoint,
    auth: { accessToken },
    query: getRelatedOne,
    variables: {
      id: relatedOneId,
    },
  });
};

export const doListPrimaries = async (
  apiEndpoint: string,
  accessToken: string,
  primaryId: string,
): Promise<AppSyncGraphqlResponse<ListPrimariesQuery>> => {
  return doAppSyncGraphqlQuery({
    apiEndpoint,
    auth: { accessToken },
    query: listPrimaries,
    variables: {
      id: primaryId,
    },
  });
};

export const doListRelatedManies = async (
  apiEndpoint: string,
  accessToken: string,
  relatedManyId: string,
): Promise<AppSyncGraphqlResponse<ListRelatedManiesQuery>> => {
  return doAppSyncGraphqlQuery({
    apiEndpoint,
    auth: { accessToken },
    query: listRelatedManies,
    variables: {
      id: relatedManyId,
    },
  });
};

export const doListRelatedOnes = async (
  apiEndpoint: string,
  accessToken: string,
  relatedOneId: string,
): Promise<AppSyncGraphqlResponse<ListRelatedOnesQuery>> => {
  return doAppSyncGraphqlQuery({
    apiEndpoint,
    auth: { accessToken },
    query: listRelatedOnes,
    variables: {
      id: relatedOneId,
    },
  });
};

export const doUpdatePrimary = async (
  apiEndpoint: string,
  accessToken: string,
  primaryId: string,
  groups: string[],
): Promise<AppSyncGraphqlResponse<UpdatePrimaryMutation>> => {
  return doAppSyncGraphqlMutation({
    apiEndpoint,
    auth: { accessToken: accessToken },
    query: updatePrimary,
    variables: {
      id: primaryId,
      groups,
    },
  });
};

export const doUpdateRelatedMany = async (
  apiEndpoint: string,
  accessToken: string,
  relatedManyId: string,
  primaryId: string,
  groups: string[],
): Promise<AppSyncGraphqlResponse<UpdateRelatedManyMutation>> => {
  return doAppSyncGraphqlMutation({
    apiEndpoint,
    auth: { accessToken },
    query: updateRelatedMany,
    variables: {
      id: relatedManyId,
      primaryId,
      groups,
    },
  });
};

export const doUpdateRelatedOne = async (
  apiEndpoint: string,
  accessToken: string,
  relatedOneId: string,
  primaryId: string,
  groups: string[],
): Promise<AppSyncGraphqlResponse<UpdateRelatedOneMutation>> => {
  return doAppSyncGraphqlMutation({
    apiEndpoint,
    auth: { accessToken },
    query: updateRelatedOne,
    variables: {
      id: relatedOneId,
      primaryId,
      groups,
    },
  });
};
