// NOTE: The API and operations used in these implementations were generated by running `amplify codegen --maxDepth 4`, then edited to
// remove createdAt, updatedAt, and __typename.

import { AppSyncGraphqlResponse, doAppSyncGraphqlMutation, doAppSyncGraphqlQuery } from '../../../utils';
import { CreateTreeNodeMutation, GetTreeNodeQuery } from './API';
import { createTreeNode } from './mutations';
import { getTreeNode } from './queries';

export const doCreateTreeNode = async (
  apiEndpoint: string,
  apiKey: string,
  id: string,
  parentId?: string,
): Promise<AppSyncGraphqlResponse<CreateTreeNodeMutation>> => {
  return doAppSyncGraphqlMutation({
    apiEndpoint,
    auth: { apiKey },
    query: createTreeNode,
    variables: {
      id,
      ...(parentId ? { parentId } : {}),
      value: `${id} value`,
    },
  });
};

export const doGetTreeNode = async (apiEndpoint: string, apiKey: string, id: string): Promise<AppSyncGraphqlResponse<GetTreeNodeQuery>> => {
  return doAppSyncGraphqlQuery({
    apiEndpoint,
    auth: { apiKey },
    query: getTreeNode,
    variables: {
      id,
    },
  });
};
