// NOTE: The API and operations used in these implementations were generated by running `amplify codegen --maxDepth 4`, then edited to
// remove createdAt, updatedAt, and __typename.

import { AppSyncGraphqlResponse, doAppSyncGraphqlMutation } from '../../../utils';
import { CreatePrimaryMutation, CreateRelatedManyMutation, CreateRelatedOneMutation } from './API';
import { createPrimary, createRelatedMany, createRelatedOne } from './mutations';

export const doCreatePrimary = async (
  apiEndpoint: string,
  apiKey: string,
  primaryId: string,
): Promise<AppSyncGraphqlResponse<CreatePrimaryMutation>> => {
  return doAppSyncGraphqlMutation({
    apiEndpoint,
    auth: { apiKey },
    query: createPrimary,
    variables: {
      id: primaryId,
    },
  });
};

export const doCreateRelatedMany = async (
  apiEndpoint: string,
  apiKey: string,
  relatedManyId: string,
  primaryId1: string,
  primaryId2: string,
): Promise<AppSyncGraphqlResponse<CreateRelatedManyMutation>> => {
  return doAppSyncGraphqlMutation({
    apiEndpoint,
    auth: { apiKey },
    query: createRelatedMany,
    variables: {
      id: relatedManyId,
      primaryId1,
      primaryId2,
    },
  });
};

export const doCreateRelatedOne = async (
  apiEndpoint: string,
  apiKey: string,
  relatedOneId: string,
  primaryId1: string,
  primaryId2: string,
): Promise<AppSyncGraphqlResponse<CreateRelatedOneMutation>> => {
  return doAppSyncGraphqlMutation({
    apiEndpoint,
    auth: { apiKey },
    query: createRelatedOne,
    variables: {
      id: relatedOneId,
      primaryId1,
      primaryId2,
    },
  });
};
