<!--
Please make sure to read the Pull Request Guidelines:
https://github.com/aws-amplify/amplify-cli/blob/master/CONTRIBUTING.md#pull-requests
-->

#### Description of changes

<!--
Thank you for your Pull Request! Please provide a description above and review
the requirements below.
-->

##### CDK / CloudFormation Parameters Changed

<!--
Please list any changes to the CDK/CFN params, with a link to references https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html

e.g.

* Conditionally added support for `Code` based AppSync Functions: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-code
* Conditionally added support for `Code` based AppSync Resolvers: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-code
-->

#### Issue #, if available

<!-- Also, please reference any associated PRs for documentation updates. -->

#### Description of how you validated changes

#### Checklist

<!-- Remove items that do not apply. For completed items, change [ ] to [x]. -->

- [ ] PR description included
- [ ] `yarn test` passes
- [ ] E2E test run linked
- [ ] Tests are [changed or added](https://github.com/aws-amplify/amplify-cli/blob/master/CONTRIBUTING.md#tests)
- [ ] Relevant documentation is changed or added (and PR referenced)
- [ ] New AWS SDK calls or CloudFormation actions have been added to relevant test and service IAM policies
- [ ] Any CDK or CloudFormation parameter changes are called out explicitly

By submitting this pull request, I confirm that my contribution is made under the terms of the Apache 2.0 license.
