# Icons

List of available icons in the system.

## Components
- [Blade Components](./components.md)
- [Code Block](./code-block.md)
- [Frame Navigation](./frame-nav.md)
- [Grid](./grid.md)
- [Content](./classes.md)
- [Layout configuration](./layout-config.md)
- [Slide Up Down](./slide-up-down.md)
- [Margins and paddings](./margins.md)
- **Icons**

## List of the icons


| Code | Preview |
|------|---------|
| ```<i class="icon icon-angle-bottom"></i>``` | <i class="icon icon-angle-bottom"></i> |
| ```<i class="icon icon-ar-right"></i>``` | <i class="icon icon-ar-right"></i> |
| ```<i class="icon icon-arrow-left"></i>``` | <i class="icon icon-arrow-left"></i> |
| ```<i class="icon icon-arrow-right"></i>``` | <i class="icon icon-arrow-right"></i> |
| ```<i class="icon icon-box-down"></i> ``` | <i class="icon icon-box-down"></i> |
| ```<i class="icon icon-box-minus"></i>``` | <i class="icon icon-box-minus"></i> |
| ```<i class="icon icon-box-pause"></i>``` | <i class="icon icon-box-pause"></i> |
| ```<i class="icon icon-box-plus"></i>``` | <i class="icon icon-box-plus"></i> |
| ```<i class="icon icon-box"></i>``` | <i class="icon icon-box"></i> |
| ```<i class="icon icon-briefcase"></i>``` | <i class="icon icon-briefcase"></i> |
| ```<i class="icon icon-call"></i>``` | <i class="icon icon-call"></i> |
| ```<i class="icon icon-card"></i>``` | <i class="icon icon-card"></i> |
| ```<i class="icon icon-checkbox"></i>``` | <i class="icon icon-checkbox"></i> |
| ```<i class="icon icon-circle-check"></i>``` | <i class="icon icon-circle-check"></i> |
| ```<i class="icon icon-circle-clock"></i>``` | <i class="icon icon-circle-clock"></i> |
| ```<i class="icon icon-circle-cross"></i>``` | <i class="icon icon-circle-cross"></i> |
| ```<i class="icon icon-circle-plus"></i>```| <i class="icon icon-circle-plus"></i> |
| ```<i class="icon icon-clipboard"></i>``` | <i class="icon icon-clipboard"></i> |
| ```<i class="icon icon-cross"></i>``` | <i class="icon icon-cross"></i> |
| ```<i class="icon icon-data-error"></i>``` | <i class="icon icon-data-error"></i> |
| ```<i class="icon icon-data-time"></i>``` | <i class="icon icon-data-time"></i> |
| ```<i class="icon icon-database-error"></i>``` | <i class="icon icon-database-error"></i> |
| ```<i class="icon icon-database"></i>``` | <i class="icon icon-database"></i> |
| ```<i class="icon icon-dfcheck"></i>``` | <i class="icon icon-dfcheck"></i> |
| ```<i class="icon icon-document"></i>``` | <i class="icon icon-document"></i> |
| ```<i class="icon icon-dots"></i>``` | <i class="icon icon-dots"></i> |
| ```<i class="icon icon-down"></i>``` | <i class="icon icon-down"></i> |
| ```<i class="icon icon-drag"></i>``` | <i class="icon icon-drag"></i> |
| ```<i class="icon icon-exel"></i>``` | <i class="icon icon-exel"></i> |
| ```<i class="icon icon-eye"></i>``` | <i class="icon icon-eye"></i> |
| ```<i class="icon icon-eye2"></i>``` | <i class="icon icon-eye2"></i> |
| ```<i class="icon icon-fb"></i>``` | <i class="icon icon-fb"></i> |
| ```<i class="icon icon-file"></i>``` | <i class="icon icon-file"></i> |
| ```<i class="icon icon-filter"></i>``` | <i class="icon icon-filter"></i> |
| ```<i class="icon icon-flag"></i>``` | <i class="icon icon-flag"></i> |
| ```<i class="icon icon-gift"></i>``` | <i class="icon icon-gift"></i> |
| ```<i class="icon icon-gp"></i>``` | <i class="icon icon-gp"></i> |
| ```<i class="icon icon-graph"></i>``` | <i class="icon icon-graph"></i> |
| ```<i class="icon icon-hdd"></i>``` | <i class="icon icon-hdd"></i> |
| ```<i class="icon icon-head"></i>``` | <i class="icon icon-head"></i> |
| ```<i class="icon icon-in"></i>``` | <i class="icon icon-in"></i> |
| ```<i class="icon icon-intelligence"></i>``` | <i class="icon icon-intelligence"></i> |
| ```<i class="icon icon-link"></i>``` | <i class="icon icon-link"></i> |
| ```<i class="icon icon-loading"></i>``` | <i class="icon icon-loading"></i> |
| ```<i class="icon icon-logo"></i>``` | <i class="icon icon-logo"></i> |
| ```<i class="icon icon-logout"></i>``` | <i class="icon icon-logout"></i> |
| ```<i class="icon icon-mastercard"></i>``` | <i class="icon icon-mastercard"></i> |
| ```<i class="icon icon-message"></i>``` | <i class="icon icon-message"></i> |
| ```<i class="icon icon-money"></i>``` | <i class="icon icon-money"></i> |
| ```<i class="icon icon-nav"></i>``` | <i class="icon icon-nav"></i> |
| ```<i class="icon icon-no-access"></i>``` | <i class="icon icon-no-access"></i> |
| ```<i class="icon icon-openin"></i>``` | <i class="icon icon-openin"></i> |
| ```<i class="icon icon-pin"></i>``` | <i class="icon icon-pin"></i> |
| ```<i class="icon icon-planner"></i>``` | <i class="icon icon-planner"></i> |
| ```<i class="icon icon-plus"></i>```  | <i class="icon icon-plus"></i> |
| ```<i class="icon icon-report"></i>``` | <i class="icon icon-report"></i> |
| ```<i class="icon icon-road"></i>``` | <i class="icon icon-road"></i> |
| ```<i class="icon icon-ruppor"></i>``` | <i class="icon icon-ruppor"></i> |
| ```<i class="icon icon-schedule"></i>``` | <i class="icon icon-schedule"></i> |
| ```<i class="icon icon-search"></i>``` | <i class="icon icon-search"></i> |
| ```<i class="icon icon-sell"></i>``` | <i class="icon icon-sell"></i> |
| ```<i class="icon icon-service"></i> ``` | <i class="icon icon-service"></i> |
| ```<i class="icon icon-settings"></i>``` | <i class="icon icon-settings"></i> |
| ```<i class="icon icon-smile"></i>``` | <i class="icon icon-smile"></i> |
| ```<i class="icon icon-speed"></i>``` | <i class="icon icon-speed"></i> |
| ```<i class="icon icon-stock"></i>``` | <i class="icon icon-stock"></i> |
| ```<i class="icon icon-stop"></i>``` | <i class="icon icon-stop"></i> |
| ```<i class="icon icon-storage"></i>``` | <i class="icon icon-storage"></i> |
| ```<i class="icon icon-timelaps"></i> ``` | <i class="icon icon-timelaps"></i> |
| ```<i class="icon icon-twousers"></i>``` | <i class="icon icon-twousers"></i> |
| ```<i class="icon icon-up"></i>``` | <i class="icon icon-up"></i> |
| ```<i class="icon icon-user"></i>``` | <i class="icon icon-user"></i> |
| ```<i class="icon icon-visa"></i>``` | <i class="icon icon-visa"></i> |
| ```<i class="icon icon-word"></i>``` | <i class="icon icon-word"></i> |
| ```<i class="icon icon-git"></i>``` | <i class="icon icon-git"></i> |
| ```<i class="icon icon-pencil2"></i>``` | <i class="icon icon-pencil2"></i> |
| ```<i class="icon icon-question"></i>``` | <i class="icon icon-question"></i> |
| ```<i class="icon icon-star-circle"></i>``` | <i class="icon icon-star-circle"></i> |
| ```<i class="icon icon-hashtag"></i>``` | <i class="icon icon-hashtag"></i> |
| ```<i class="icon icon-loading-circle"></i>``` | <i class="icon icon-loading-circle"></i> |



## HTML:
An example is how to display an icon:
```html
<i class="icon icon-iconname"></i>
```

## Customization
### Stylus:
If you need to display an icon inside the styles, you can use the `icon()` function, in which you need to specify `icon(iconname, fontsize in px, before / after)`. The last 2 parameters ​​are optional (Default icon size is ```1rem```, default position is ```:before```).
```stylus
.block
    icon(logo, 14px, before)

.block2
    icon(logout, 15px, after)

.block3
    icon(login, 15px)

.block4
    icon(list)
```

### Icon's code
Each icon generates its own symbol code, which you can use in regular CSS. If you go to the ```resources/svg``` folder, you can see it in the name of the icon. When adding a new icon, you need to manually register it before the name of the icon. For example: ```uEA12-clipboard.svg```, where ```clipboard``` is the name of the icon, and ```uEA12``` is its character code.
Example of using symol code:

```css
.icon {
    display: inline-block;
    text-rendering: auto;
    font: normal normal 400 14px/1 icons;
    font-size: inherit;
    -moz-osx-font-smoothing: grayscale;
    -webkit-font-smoothing: antialiased;
}

.icon-clipboard::before {
    content: "\ea12";
}
```
### Gulp task
If the ```.icon``` class intersects with the classes in your system, you can replace it in ```gulpfile.js```, which is in the root of the project.

```js
gulp.task('build:icons', function(){
    return gulp.src('./resources/svg/*.svg')
        .pipe(iconfont({
            fontName: 'icons',
            fontHeight: 1000,
            prependUnicode: true,
            formats: ['ttf', 'eot', 'woff'],
            normalize: true,
            timestamp: runTimestamp
        }))
        .on('glyphs', function(glyphs, options) {
            gulp.src('./resources/svg/template/icons.styl')
                .pipe( consolidate('lodash', {
                    glyphs: glyphs,
                    fontName: options.fontName,
                    fontPath: '../fonts/',
                    className: 'icon'
                }) )
                .pipe( gulp.dest('./resources/css/framework/') )
        })
    .pipe(gulp.dest('./dist/fonts/'));
})
```
