// Copyright (c) 2022-2023 Avram Traian. All rights reserved.

#pragma once

//////// MINIMAL ////////

#include "Core/CoreMinimal.h"
#include "Core/CoreDefines.h"
#include "Core/CoreTypes.h"
#include "Core/Logger.h"
#include "Core/Assert.h"

#include "Core/Memory/Memory.h"
#include "Core/Memory/Buffer.h"
#include "Core/Memory/Arena.h"

#include "Core/Performance.h"

//////// CONTAINERS ////////

#include "Core/Containers/Array.h"
#include "Core/Containers/FixedArray.h"
#include "Core/Containers/String.h"
#include "Core/Containers/StringView.h"
#include "Core/Containers/Span.h"
#include "Core/Containers/HashTable.h"
#include "Core/Containers/RefPtr.h"
#include "Core/Containers/UniquePtr.h"

//////// MATH ////////

#include "Core/Math/MathUtilities.h"
#include "Core/Math/Geometry.h"
#include "Core/Math/Transform.h"
#include "Core/Math/Random.h"