# Professional Skill Certification Management System - CertifyStack

A full-stack web application for managing professional skill certifications, featuring role-based access control, certification renewal automation, and administrative functions.

## 🚀 Features

- **Admin Dashboard:** Manage users, certifications, and approvals.
- **User Dashboard:** Track certifications, view status, and receive notifications.
- **Automated Renewals:** Notify users about upcoming expirations.
- **Certification Verification:** Verify credentials globally.
- **Secure Authentication:** Role-based login system.

## 🖥️ Tech Stack

**Frontend:** JSP, CSS

**Backend:** Spring Boot&#x20;

**Database:** MySQL

**Version Control:** Git & GitHub

## ⚙️ Installation

1. Clone the repository:

   ```bash
   git clone https://github.com/avpkn25/certifystack.git
   ```

2. Navigate into the project directory:

   ```bash
   cd certifystack
   ```

3. Backend Setup:

   - Open the backend folder.

   - Configure `application.properties` with your MySQL credentials.

## 🛠️ Project Structure

```
certifystack/
├── src/
│   ├── main/
│   │   ├── java/com/klef/jfsd
│   │   │   ├── controller
│   │   │   ├── model
│   │   │   ├── repository
│   │   │   ├── service
│   │   │   └── CertifystackApplication.java
│   │   ├── resources
│   │   │   └── application.properties
│   │   └── webapp
│   │   │   ├── admin
│   │   │   ├── css
│   │   │   ├── user
│   │   │   └── homepage codes...
├── pom.xml
└── README.md
```

## 🔐 Dummy Credentials  

Use these credentials to explore the application features:  

### **SuperAdmin Account:**  
- **Username:** `admin` or **gmail:** `admin@gmail.com`
- **Password:** `admin`

### **Admin Account:**  
- **Username:** `praveen` or **gmail:** `praveen@gmail.com`
- **Password:** `praveen`   

### **User Account:**  
- **Username:** `Ram` or **gmail:** `ram@gmail.com`
- **Password:** `Ram@1234` 


## 📸 Screenshots

*Coming soon...*

## 📄 License

This project is licensed under the KLU License - see the [LICENSE](LICENSE) file for details.

## 👨‍💻 Contributors

- **A. V. Praveen Kumar Naidu - Team Leader | Developer**
- **P. Vishnu Asrith - Team Member | Developer**
- **M. S. S. Surendra - Team Member | Developer**

## 🤝 Contributions

Contributions, issues, and feature requests are welcome! Feel free to check the [issues page](https://github.com/yourusername/certification-management-system/issues).

## ⭐ Show Your Support

If you like this project, give it a ⭐ and share it with others!

---

*This was generated with ❤️ by *[***Praveen Kumar***](https://github.com/avpkn25).*

