%define dracutlibdir %{_prefix}/lib/dracut
%bcond_without doc

# We ship a .pc file but don't want to have a dep on pkg-config. We
# strip the automatically generated dep here and instead co-own the
# directory.
%global __requires_exclude pkg-config
%define dist_free_release 61.git20200529

Name: dracut
Version: 050
Release: %{dist_free_release}%{?dist}.2

Summary: Initramfs generator using udev
%if 0%{?fedora} || 0%{?rhel}
Group: System Environment/Base
%endif
%if 0%{?suse_version}
Group: System/Base
%endif

# The entire source code is GPLv2+
# except install/* which is LGPLv2+
License: GPLv2+ and LGPLv2+

URL: https://dracut.wiki.kernel.org/

# Source can be generated by
# http://git.kernel.org/?p=boot/dracut/dracut.git;a=snapshot;h=%%{version};sf=tgz
Source0: http://www.kernel.org/pub/linux/utils/boot/dracut/dracut-%{version}.tar.xz
Patch1: 0001.patch
Patch2: 0002.patch
Patch3: 0003.patch
Patch4: 0004.patch
Patch5: 0005.patch
Patch6: 0006.patch
Patch7: 0007.patch
Patch8: 0008.patch
Patch9: 0009.patch
Patch10: 0010.patch
Patch11: 0011.patch
Patch12: 0012.patch
Patch13: 0013.patch
Patch14: 0014.patch
Patch15: 0015.patch
Patch16: 0016.patch
Patch17: 0017.patch
Patch18: 0018.patch
Patch19: 0019.patch
Patch20: 0020.patch
Patch21: 0021.patch
Patch22: 0022.patch
Patch23: 0023.patch
Patch24: 0024.patch
Patch25: 0025.patch
Patch26: 0026.patch
Patch27: 0027.patch
Patch28: 0028.patch
Patch29: 0029.patch
Patch30: 0030.patch
Patch31: 0031.patch
Patch32: 0032.patch
Patch33: 0033.patch
Patch34: 0034.patch
Patch35: 0035.patch
Patch36: 0036.patch
Patch37: 0037.patch
Patch38: 0038.patch
Patch39: 0039.patch
Patch40: 0040.patch
Patch41: 0041.patch
Patch42: 0042.patch
Patch43: 0043.patch
Patch44: 0044.patch
Patch45: 0045.patch
Patch46: 0046.patch
Patch47: 0047.patch
Patch48: 0048.patch
Patch49: 0049.patch
Patch50: 0050.patch
Patch51: 0051.patch
Patch52: 0052.patch
Patch53: 0053.patch
Patch54: 0054.patch
Patch55: 0055.patch
Patch56: 0056.patch
Patch57: 0057.patch
Patch58: 0058.patch
Patch59: 0059.patch
Patch60: 0060.patch

Source1: https://www.gnu.org/licenses/lgpl-2.1.txt

BuildRequires: bash
BuildRequires: git
BuildRequires: pkgconfig(libkmod) >= 23
BuildRequires: gcc

%if 0%{?fedora} || 0%{?rhel}
BuildRequires: pkgconfig
BuildRequires: systemd
%endif
%if 0%{?fedora}
BuildRequires: bash-completion
%endif

%if %{with doc}
%if 0%{?fedora} || 0%{?rhel}
BuildRequires: docbook-style-xsl docbook-dtds libxslt
%endif

%if 0%{?suse_version}
BuildRequires: docbook-xsl-stylesheets libxslt
%endif

BuildRequires: asciidoc
%endif

%if 0%{?suse_version} > 9999
Obsoletes: mkinitrd < 2.6.1
Provides: mkinitrd = 2.6.1
%endif

Obsoletes: dracut-fips <= 047
Provides:  dracut-fips = %{version}-%{release}
Obsoletes: dracut-fips-aesni <= 047
Provides:  dracut-fips-aesni = %{version}-%{release}

Requires: bash >= 4
Requires: coreutils
Requires: cpio
Requires: filesystem >= 2.1.0
Requires: findutils
Requires: grep
Requires: kmod
Requires: sed
Requires: xz
Requires: gzip

%if 0%{?fedora} || 0%{?rhel}
Recommends: memstrack
Recommends: hardlink
Recommends: pigz
Recommends: kpartx
Requires: util-linux >= 2.21
Requires: systemd >= 219
Requires: systemd-udev >= 219
Requires: procps-ng
%else
Requires: hardlink
Requires: gzip
Requires: kpartx
Requires: udev > 166
Requires: util-linux-ng >= 2.21
%endif

%if 0%{?fedora} || 0%{?rhel} || 0%{?suse_version}
Requires: libkcapi-hmaccalc
%endif

%description
dracut contains tools to create bootable initramfses for the Linux
kernel. Unlike other implementations, dracut hard-codes as little
as possible into the initramfs. dracut contains various modules which
are driven by the event-based udev. Having root on MD, DM, LVM2, LUKS
is supported as well as NFS, iSCSI, NBD, FCoE with the dracut-network
package.

%package network
Summary: dracut modules to build a dracut initramfs with network support
%if 0%{?_module_build}
# In the module-build-service, we have pieces of dracut provided by different
# modules ("base-runtime" provides most functionality, but we need
# dracut-network in "installer". Since these two modules build with separate
# dist-tags, we need to reduce this strict requirement to ignore the dist-tag.
Requires: %{name} >= %{version}-%{dist_free_release}
%else
Requires: %{name} = %{version}-%{release}
%endif
Requires: iputils
Requires: iproute
Requires: (NetworkManager >= 1.20 or dhclient)
Suggests: NetworkManager
Obsoletes: dracut-generic < 008
Provides:  dracut-generic = %{version}-%{release}

%description network
This package requires everything which is needed to build a generic
all purpose initramfs with network support with dracut.

%package caps
Summary: dracut modules to build a dracut initramfs which drops capabilities
Requires: %{name} = %{version}-%{release}
Requires: libcap

%description caps
This package requires everything which is needed to build an
initramfs with dracut, which drops capabilities.

%package live
Summary: dracut modules to build a dracut initramfs with live image capabilities
%if 0%{?_module_build}
# See the network subpackage comment.
Requires: %{name} >= %{version}-%{dist_free_release}
%else
Requires: %{name} = %{version}-%{release}
%endif
Requires: %{name}-network = %{version}-%{release}
Requires: tar gzip coreutils bash device-mapper curl
%if 0%{?fedora}
Requires: fuse ntfs-3g
%endif

%description live
This package requires everything which is needed to build an
initramfs with dracut, with live image capabilities, like Live CDs.

%package config-generic
Summary: dracut configuration to turn off hostonly image generation
Requires: %{name} = %{version}-%{release}
Obsoletes: dracut-nohostonly < 030
Provides:  dracut-nohostonly = %{version}-%{release}

%description config-generic
This package provides the configuration to turn off the host specific initramfs
generation with dracut and generates a generic image by default.

%package config-rescue
Summary: dracut configuration to turn on rescue image generation
Requires: %{name} = %{version}-%{release}
Obsoletes: dracut < 030

%description config-rescue
This package provides the configuration to turn on the rescue initramfs
generation with dracut.

%package tools
Summary: dracut tools to build the local initramfs
Requires: %{name} = %{version}-%{release}

%description tools
This package contains tools to assemble the local initrd and host configuration.

%package squash
Summary: dracut module to build an initramfs with most files in a squashfs image
Requires: %{name} = %{version}-%{release}
Requires: squashfs-tools

%description squash
This package provides a dracut module to build an initramfs, but store most files
in a squashfs image, result in a smaller initramfs size and reduce runtime memory
usage.

%prep
%autosetup -n %{name}-%{version} -S git_am
cp %{SOURCE1} .

%build
%configure  --systemdsystemunitdir=%{_unitdir} \
            --bashcompletiondir=$(pkg-config --variable=completionsdir bash-completion) \
            --libdir=%{_prefix}/lib \
%if %{without doc}
            --disable-documentation \
%endif
            ${NULL}

%make_build

%install
%make_install %{?_smp_mflags} \
     libdir=%{_prefix}/lib

echo "DRACUT_VERSION=%{version}-%{release}" > $RPM_BUILD_ROOT/%{dracutlibdir}/dracut-version.sh

%if 0%{?fedora} == 0 && 0%{?rhel} == 0 && 0%{?suse_version} == 0
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/01fips
%endif

%if %{defined _unitdir}
# for systemd, better use systemd-bootchart
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/00bootchart
%endif

# we do not support dash in the initramfs
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/00dash

# we do not support mksh in the initramfs
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/00mksh

# remove gentoo specific modules
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/50gensplash

%if %{defined _unitdir}
# with systemd IMA and selinux modules do not make sense
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/96securityfs
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/97masterkey
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/98integrity
%endif

%ifnarch s390 s390x
# remove architecture specific modules
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/80cms
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/81cio_ignore
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/91zipl
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/95dasd
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/95dasd_mod
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/95dasd_rules
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/95dcssblk
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/95qeth_rules
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/95zfcp
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/95zfcp_rules
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/95znet
%else
rm -fr -- $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/00warpclock
%endif

mkdir -p $RPM_BUILD_ROOT/boot/dracut
mkdir -p $RPM_BUILD_ROOT/var/lib/dracut/overlay
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log
touch $RPM_BUILD_ROOT%{_localstatedir}/log/dracut.log
mkdir -p $RPM_BUILD_ROOT%{_sharedstatedir}/initramfs

%if 0%{?fedora} || 0%{?rhel}
install -m 0644 dracut.conf.d/fedora.conf.example $RPM_BUILD_ROOT%{dracutlibdir}/dracut.conf.d/01-dist.conf
%endif
%if 0%{?suse_version}
install -m 0644 dracut.conf.d/suse.conf.example   $RPM_BUILD_ROOT%{dracutlibdir}/dracut.conf.d/01-dist.conf
%else
rm -f $RPM_BUILD_ROOT%{_mandir}/man?/*suse*
%endif

%if 0%{?fedora} == 0 && 0%{?rhel} == 0 && 0%{?suse_version} <= 9999
rm -f -- $RPM_BUILD_ROOT%{_bindir}/mkinitrd
rm -f -- $RPM_BUILD_ROOT%{_bindir}/lsinitrd
rm -f -- $RPM_BUILD_ROOT%{_mandir}/man8/mkinitrd.8*
rm -f -- $RPM_BUILD_ROOT%{_mandir}/man1/lsinitrd.1*
%endif

echo 'hostonly="no"' > $RPM_BUILD_ROOT%{dracutlibdir}/dracut.conf.d/02-generic-image.conf
echo 'dracut_rescue_image="yes"' > $RPM_BUILD_ROOT%{dracutlibdir}/dracut.conf.d/02-rescue.conf

%if 0%{?fedora} <= 30 || 0%{?rhel} <= 8
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/kernel/postinst.d
install -m 0755 51-dracut-rescue-postinst.sh $RPM_BUILD_ROOT%{_sysconfdir}/kernel/postinst.d/51-dracut-rescue-postinst.sh
%endif

%files
%if %{with doc}
%doc README.md HACKING TODO AUTHORS NEWS dracut.html dracut.png dracut.svg
%endif
%{!?_licensedir:%global license %%doc}
%license COPYING lgpl-2.1.txt
%{_bindir}/dracut
%{_datadir}/bash-completion/completions/dracut
%{_datadir}/bash-completion/completions/lsinitrd
%if 0%{?fedora} || 0%{?rhel} || 0%{?suse_version} > 9999
%{_bindir}/mkinitrd
%{_bindir}/lsinitrd
%endif
%dir %{dracutlibdir}
%dir %{dracutlibdir}/modules.d
%{dracutlibdir}/dracut-functions.sh
%{dracutlibdir}/dracut-init.sh
%{dracutlibdir}/dracut-functions
%{dracutlibdir}/dracut-version.sh
%{dracutlibdir}/dracut-logger.sh
%{dracutlibdir}/dracut-initramfs-restore
%{dracutlibdir}/dracut-install
%{dracutlibdir}/skipcpio
%config(noreplace) %{_sysconfdir}/dracut.conf
%if 0%{?fedora} || 0%{?suse_version} || 0%{?rhel}
%{dracutlibdir}/dracut.conf.d/01-dist.conf
%endif
%dir %{_sysconfdir}/dracut.conf.d
%dir %{dracutlibdir}/dracut.conf.d
%dir %{_datadir}/pkgconfig
%{_datadir}/pkgconfig/dracut.pc

%if %{with doc}
%{_mandir}/man8/dracut.8*
%{_mandir}/man8/*service.8*
%if 0%{?fedora} || 0%{?rhel} || 0%{?suse_version} > 9999
%{_mandir}/man8/mkinitrd.8*
%{_mandir}/man1/lsinitrd.1*
%endif
%if 0%{?suse_version}
%{_mandir}/man8/mkinitrd-suse.8*
%endif
%{_mandir}/man7/dracut.kernel.7*
%{_mandir}/man7/dracut.cmdline.7*
%{_mandir}/man7/dracut.modules.7*
%{_mandir}/man7/dracut.bootup.7*
%{_mandir}/man5/dracut.conf.5*
%endif

%if %{undefined _unitdir}
%{dracutlibdir}/modules.d/00bootchart
%endif
%{dracutlibdir}/modules.d/00bash
%{dracutlibdir}/modules.d/00systemd
%ifnarch s390 s390x
%{dracutlibdir}/modules.d/00warpclock
%endif
%if 0%{?fedora} || 0%{?rhel} || 0%{?suse_version}
%{dracutlibdir}/modules.d/01fips
%endif
%{dracutlibdir}/modules.d/01systemd-initrd
%{dracutlibdir}/modules.d/03modsign
%{dracutlibdir}/modules.d/03rescue
%{dracutlibdir}/modules.d/04watchdog
%{dracutlibdir}/modules.d/05busybox
%{dracutlibdir}/modules.d/06rngd
%{dracutlibdir}/modules.d/10i18n
%{dracutlibdir}/modules.d/30convertfs
%{dracutlibdir}/modules.d/45url-lib
%{dracutlibdir}/modules.d/50drm
%{dracutlibdir}/modules.d/50plymouth
%{dracutlibdir}/modules.d/80lvmmerge
%{dracutlibdir}/modules.d/90btrfs
%{dracutlibdir}/modules.d/90crypt
%{dracutlibdir}/modules.d/90dm
%{dracutlibdir}/modules.d/90dmraid
%{dracutlibdir}/modules.d/90kernel-modules
%{dracutlibdir}/modules.d/90kernel-modules-extra
%{dracutlibdir}/modules.d/90lvm
%{dracutlibdir}/modules.d/90mdraid
%{dracutlibdir}/modules.d/90multipath
%{dracutlibdir}/modules.d/90nvdimm
%{dracutlibdir}/modules.d/90stratis
%{dracutlibdir}/modules.d/90ppcmac
%{dracutlibdir}/modules.d/90qemu
%{dracutlibdir}/modules.d/91crypt-gpg
%{dracutlibdir}/modules.d/91crypt-loop
%{dracutlibdir}/modules.d/95debug
%{dracutlibdir}/modules.d/95fstab-sys
%{dracutlibdir}/modules.d/95lunmask
%{dracutlibdir}/modules.d/95resume
%{dracutlibdir}/modules.d/95rootfs-block
%{dracutlibdir}/modules.d/95terminfo
%{dracutlibdir}/modules.d/95udev-rules
%{dracutlibdir}/modules.d/95virtfs
%ifarch s390 s390x
%{dracutlibdir}/modules.d/80cms
%{dracutlibdir}/modules.d/81cio_ignore
%{dracutlibdir}/modules.d/91zipl
%{dracutlibdir}/modules.d/95dasd
%{dracutlibdir}/modules.d/95dasd_mod
%{dracutlibdir}/modules.d/95dasd_rules
%{dracutlibdir}/modules.d/95dcssblk
%{dracutlibdir}/modules.d/95qeth_rules
%{dracutlibdir}/modules.d/95zfcp
%{dracutlibdir}/modules.d/95zfcp_rules
%endif
%if %{undefined _unitdir}
%{dracutlibdir}/modules.d/96securityfs
%{dracutlibdir}/modules.d/97masterkey
%{dracutlibdir}/modules.d/98integrity
%endif
%{dracutlibdir}/modules.d/97biosdevname
%{dracutlibdir}/modules.d/98dracut-systemd
%{dracutlibdir}/modules.d/98ecryptfs
%{dracutlibdir}/modules.d/98pollcdrom
%{dracutlibdir}/modules.d/98selinux
%{dracutlibdir}/modules.d/98syslog
%{dracutlibdir}/modules.d/98usrmount
%{dracutlibdir}/modules.d/99base
%{dracutlibdir}/modules.d/99memstrack
%{dracutlibdir}/modules.d/99fs-lib
%{dracutlibdir}/modules.d/99shutdown
%attr(0644,root,root) %ghost %config(missingok,noreplace) %{_localstatedir}/log/dracut.log
%dir %{_sharedstatedir}/initramfs
%if %{defined _unitdir}
%{_unitdir}/dracut-shutdown.service
%{_unitdir}/sysinit.target.wants/dracut-shutdown.service
%{_unitdir}/dracut-cmdline.service
%{_unitdir}/dracut-initqueue.service
%{_unitdir}/dracut-mount.service
%{_unitdir}/dracut-pre-mount.service
%{_unitdir}/dracut-pre-pivot.service
%{_unitdir}/dracut-pre-trigger.service
%{_unitdir}/dracut-pre-udev.service
%{_unitdir}/initrd.target.wants/dracut-cmdline.service
%{_unitdir}/initrd.target.wants/dracut-initqueue.service
%{_unitdir}/initrd.target.wants/dracut-mount.service
%{_unitdir}/initrd.target.wants/dracut-pre-mount.service
%{_unitdir}/initrd.target.wants/dracut-pre-pivot.service
%{_unitdir}/initrd.target.wants/dracut-pre-trigger.service
%{_unitdir}/initrd.target.wants/dracut-pre-udev.service
%endif
%{_prefix}/lib/kernel/install.d/50-dracut.install

%files network
%{dracutlibdir}/modules.d/02systemd-networkd
%{dracutlibdir}/modules.d/35network-manager
%{dracutlibdir}/modules.d/35network-legacy
%{dracutlibdir}/modules.d/40network
%{dracutlibdir}/modules.d/45ifcfg
%{dracutlibdir}/modules.d/90kernel-network-modules
%{dracutlibdir}/modules.d/90qemu-net
%{dracutlibdir}/modules.d/95cifs
%{dracutlibdir}/modules.d/95fcoe
%{dracutlibdir}/modules.d/95fcoe-uefi
%{dracutlibdir}/modules.d/95iscsi
%{dracutlibdir}/modules.d/95nbd
%{dracutlibdir}/modules.d/95nfs
%{dracutlibdir}/modules.d/95ssh-client
%ifarch s390 s390x
%{dracutlibdir}/modules.d/95znet
%endif
%{dracutlibdir}/modules.d/99uefi-lib

%files caps
%{dracutlibdir}/modules.d/02caps

%files live
%{dracutlibdir}/modules.d/99img-lib
%{dracutlibdir}/modules.d/90dmsquash-live
%{dracutlibdir}/modules.d/90dmsquash-live-ntfs
%{dracutlibdir}/modules.d/90livenet

%files tools
%if %{with doc}
%doc %{_mandir}/man8/dracut-catimages.8*
%endif

%{_bindir}/dracut-catimages
%dir /boot/dracut
%dir /var/lib/dracut
%dir /var/lib/dracut/overlay

%files squash
%{dracutlibdir}/modules.d/99squash

%files config-generic
%{dracutlibdir}/dracut.conf.d/02-generic-image.conf

%files config-rescue
%{dracutlibdir}/dracut.conf.d/02-rescue.conf
%{_prefix}/lib/kernel/install.d/51-dracut-rescue.install
%if 0%{?fedora} <= 30 || 0%{?rhel} <= 8
# FIXME: remove after F30
%{_sysconfdir}/kernel/postinst.d/51-dracut-rescue-postinst.sh
%endif

%changelog
* Mon Jul 27 2020 Fedora Release Engineering <releng@fedoraproject.org> - 050-61.git20200529.2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_33_Mass_Rebuild

* Mon Jul 13 2020 Tom Stellard <tstellar@redhat.com> - 050-61.git20200529.1
- Use make macros
- https://fedoraproject.org/wiki/Changes/UseMakeBuildInstallMacro

* Fri May 29 2020 Harald Hoyer <harald@redhat.com> - 050-61.git20200529
- git snapshot

* Mon Mar 16 2020 Harald Hoyer <harald@redhat.com> - 050-26.git20200316
- fixed `--tmpdir` mishandling

* Fri Mar 13 2020 Harald Hoyer <harald@redhat.com> - 050-25.git20200313
- network-manager: ensure that nm-run.sh is executed for rd.neednet

* Tue Mar 10 2020 Adam Williamson <awilliam@redhat.com> - 050-2
- Backport fix for pre-trigger stage early exit from upstream (#1811070)

* Wed Mar 04 2020 Harald Hoyer <harald@redhat.com> - 050-1
- version 050

* Tue Jan 28 2020 Fedora Release Engineering <releng@fedoraproject.org> - 049-27.git20181204.2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_32_Mass_Rebuild

* Wed Jul 24 2019 Fedora Release Engineering <releng@fedoraproject.org> - 049-27.git20181204.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_31_Mass_Rebuild

* Wed Jun 12 2019 Adam Williamson <awilliam@redhat.com> - 049-27.git20181204
- Backport PR #578 to fix RHBZ #1719057 (installer boot bug)

* Thu Feb 14 2019 Adam Williamson <awilliam@redhat.com> - 049-26.git20181204
- Backport PR #541 to fix RHBZ #1676357 (crasher bug)

* Thu Jan 31 2019 Fedora Release Engineering <releng@fedoraproject.org> - 049-25.git20181204.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_30_Mass_Rebuild

* Tue Dec 04 2018 Harald Hoyer <harald@redhat.com> - 049-25.git20181204
- git snapshot

* Wed Oct 24 2018 Harald Hoyer <harald@redhat.com> - 049-11.git20181024
- git snapshot

* Wed Oct 10 2018 Harald Hoyer <harald@redhat.com> - 049-4.git20181010
- fixed spec file
- git snapshot

* Mon Oct 08 2018 Harald Hoyer <harald@redhat.com> - 049-1
- version 049

* Fri Sep 21 2018 Harald Hoyer <harald@redhat.com> - 048-99.git20180921
- git snapshot

* Thu Jul 26 2018 Harald Hoyer <harald@redhat.com> - 048-14.git20180726
- bring back 51-dracut-rescue-postinst.sh

* Wed Jul 18 2018 Harald Hoyer <harald@redhat.com> - 048-6.git20180718
- git snapshot

* Thu Jul 12 2018 Fedora Release Engineering <releng@fedoraproject.org> - 048-1.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_29_Mass_Rebuild

* Fri Jul 06 2018 Harald Hoyer <harald@redhat.com> - 048-1
- version 048

* Fri Jun 22 2018 Adam Williamson <awilliam@redhat.com> - 047-34.git20180604.1
- Test build with proposed fix for #1593028

* Mon Jun 04 2018 Harald Hoyer <harald@redhat.com> - 047-34.git20180604
- git snapshot

* Tue May 15 2018 Harald Hoyer <harald@redhat.com> - 047-32.git20180515
- git snapshot

* Mon Mar 05 2018 Harald Hoyer <harald@redhat.com> - 047-8
- git snapshot

* Tue Feb 27 2018 Javier Martinez Canillas <javierm@redhat.com> - 047-2
- Allow generating initramfs images on the /boot directory

* Mon Feb 19 2018 Harald Hoyer <harald@redhat.com> - 047-1
- version 047

* Wed Feb 07 2018 Fedora Release Engineering <releng@fedoraproject.org> - 046-92.git20180118.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_28_Mass_Rebuild

* Thu Jan 18 2018 Harald Hoyer <harald@redhat.com> - 046-92
- git snapshot

* Fri Jan 05 2018 Harald Hoyer <harald@redhat.com> - 046-64
- git snapshot

* Fri Dec 01 2017 Harald Hoyer <harald@redhat.com> - 046-36
- git snapshot

* Wed Nov 29 2017 Harald Hoyer <harald@redhat.com> - 046-33
- git snapshot

* Thu Oct 12 2017 Peter Robinson <pbrobinson@fedoraproject.org> 046-20
- Add fix for some ARM SBCs

* Tue Oct 10 2017 Harald Hoyer <harald@redhat.com> - 046-19
- git snapshot

* Thu Aug 24 2017 Harald Hoyer <harald@redhat.com> - 046-7
- git snapshot

* Fri Aug 11 2017 Harald Hoyer <harald@redhat.com> - 046-2
- add support for dist-tag less build

* Fri Aug 11 2017 Harald Hoyer <harald@redhat.com> - 046-1
- version 046

* Mon Aug  7 2017 Peter Robinson <pbrobinson@fedoraproject.org> 045-21.git20170515
- Add upstream patches to fix a number of ARM devices with generic initrd

* Wed Aug 02 2017 Fedora Release Engineering <releng@fedoraproject.org> - 045-20.git20170515
- Rebuilt for https://fedoraproject.org/wiki/Fedora_27_Binutils_Mass_Rebuild

* Wed Jul 26 2017 Fedora Release Engineering <releng@fedoraproject.org> - 045-19.git20170515
- Rebuilt for https://fedoraproject.org/wiki/Fedora_27_Mass_Rebuild

* Mon May 15 2017 Harald Hoyer <harald@redhat.com> - 045-18.git20170515
- git snapshot

* Wed Apr 12 2017 Peter Robinson <pbrobinson@fedoraproject.org> 044-178
- Add upstream patches needed for ARMv7/aarch64 fixes

* Fri Feb 10 2017 Fedora Release Engineering <releng@fedoraproject.org> - 044-177
- Rebuilt for https://fedoraproject.org/wiki/Fedora_26_Mass_Rebuild

* Thu Dec 08 2016 Harald Hoyer <harald@redhat.com> - 044-176
- git snapshot

* Fri Aug 19 2016 Harald Hoyer <harald@redhat.com> - 044-117
- git snapshot

* Thu Aug 18 2016 Harald Hoyer <harald@redhat.com> - 044-109
- git snapshot

* Fri Aug 05 2016 Adam Williamson <awilliam@redhat.com> - 044-76
- backport a single commit to fix RHBZ #1358416 (anaconda network init)

* Tue Jun 07 2016 Harald Hoyer <harald@redhat.com> - 044-75
- fix for systemd >= 230
- git snapshot

* Wed Feb 03 2016 Fedora Release Engineering <releng@fedoraproject.org> - 044-18.git20160108
- Rebuilt for https://fedoraproject.org/wiki/Fedora_24_Mass_Rebuild

* Fri Jan  8 2016 Harald Hoyer <harald@redhat.com> - 044-17.git20160108
- include more HID driver
- include machine info file
- fix network carrier detection
- fix nbd
- do not copy over lldpad state
- restorecon the final initramfs image

* Tue Dec  1 2015 Harald Hoyer <harald@redhat.com> - 044-6.git20151201
- fix for readonly /run on shutdown
- fix for the dmsquash-live module
Resolves: rhbz#1286866

* Wed Nov 25 2015 Harald Hoyer <harald@redhat.com> - 044-4.git20151127
- fixes for the dmsquash-live module
- remove udev watch for raid members
- mode 0755 for the livenet generator
Resolves: rhbz#1285903

* Wed Nov 25 2015 Harald Hoyer <harald@redhat.com> - 044-1
- version 044

* Mon Nov 16 2015 Harald Hoyer <harald@redhat.com> - 043-174.git20151116
- git snapshot

* Mon Nov 16 2015 Harald Hoyer <harald@redhat.com> - 043-173.git20151116
- git snapshot

* Fri Nov 13 2015 Harald Hoyer <harald@redhat.com> - 043-172.git20151113
- git snapshot

* Tue Aug 11 2015 Harald Hoyer <harald@redhat.com> 043-60.git20150811
- fixed checkiso timeout
- fixed log output although quiet is set
- fixed qemu detection
- cleanup compressor handling

* Wed Jul 22 2015 Harald Hoyer <harald@redhat.com> 043-40.git20150710.2
- require "xz" to handle the kernel modules

* Fri Jul 10 2015 Harald Hoyer <harald@redhat.com> 043-40.git20150710
- git snapshot

* Wed Jun 17 2015 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 043-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_23_Mass_Rebuild

* Mon Jun 15 2015 Harald Hoyer <harald@redhat.com> 043-1
- version 043, now with the complete tarball

* Thu Jun 11 2015 Harald Hoyer <harald@redhat.com> 042-1
- version 042, the answer to life, the universe and everything

* Thu Feb 19 2015 Harald Hoyer <harald@redhat.com> 041-10.git20150219
- git snapshot

* Sat Jan 31 2015 Harald Hoyer <harald@redhat.com> 041-1
- version 041

* Thu Jan 08 2015 Harald Hoyer <harald@redhat.com> 040-83.git20150108
- git snapshot

* Fri Dec 19 2014 Harald Hoyer <harald@redhat.com> 040-78.git20141219
- git snapshot

* Mon Dec 08 2014 Harald Hoyer <harald@redhat.com> 040-30.git20141208
- fixed dracut-shutdown

* Thu Dec 04 2014 Harald Hoyer <harald@redhat.com> 040-29.git20141204
- git snapshot

* Tue Sep 30 2014 Zbigniew Jędrzejewski-Szmek <zbyszek@in.waw.pl> - 038-36.git20140815
- Allow media check to be cancelled (rhbz 1147941)

* Fri Sep 26 2014 Josh Boyer <jwboyer@fedoraproject.org> - 038-35.git20140815
- Enable early-microcode by default (rhbz 1083716)
- Fix changelog date

* Tue Aug 19 2014 Harald Hoyer <harald@redhat.com> - 038-34.git20140815
- git snapshot

* Sat Aug 16 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 038-31.git20140815
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_22_Mass_Rebuild

* Fri Aug 15 2014 Harald Hoyer <harald@redhat.com> 038-30.git20140815
- git snapshot

* Thu Jul 24 2014 Harald Hoyer <harald@redhat.com> 038-14.git20140724
- fixed lvm modules issues
Resolves: rhbz#1118890
- fixed vlan issues
- fixed prelink for FIPS
- new rd.route parameter
- more ARM modules

* Fri Jul 11 2014 Tom Callaway <spot@fedoraproject.org> - 038-2
- fix license handling

* Mon Jun 30 2014 Harald Hoyer <harald@redhat.com> 038-1
- version 038

* Sat Jun 28 2014 Zbigniew Jędrzejewski-Szmek <zbyszek@in.waw.pl> - 037-14.git20140628
- Pull most bugfixy commits from current git
Resolves: rhbz#1112061

* Sat Jun 07 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 037-13.git20140402
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_Mass_Rebuild

* Fri May 23 2014 Peter Robinson <pbrobinson@fedoraproject.org> 037-12.git20140402
- Fix achi/mmc/sdhci selection for non host based initrd

* Thu Apr 17 2014 Adam Williamson <awilliam@redhat.com> - 037-11.git20140402
- revert broken upstream change that causes RHBZ#1084766

* Wed Apr 02 2014 Harald Hoyer <harald@redhat.com> 037-10.git20140402
- fixed fstab.sys with systemd
- DHCPv6 fixes
- dm-cache module now included
- FCoE fixes

* Thu Mar 20 2014 Harald Hoyer <harald@redhat.com> 037-3.git20140320
- fixed dracut-initramfs-restore with microcode

* Thu Mar 20 2014 Harald Hoyer <harald@redhat.com> 037-1
- version 037

* Thu Feb 06 2014 Harald Hoyer <harald@redhat.com> 036-16.git20140206
- version 036
- parse dns information on "ip=" command line arg
- preserve ownership of files, if root creates the initramfs
- parse ibft nameserver settings
- do not run dhcp twice on an interface
- try to not reload systemd

* Wed Dec 18 2013 Harald Hoyer <harald@redhat.com> 034-74.git20131218
- do not systemctl daemon-reload
- do iscsistart for iscsi_firmware even without network

* Mon Dec 16 2013 Harald Hoyer <harald@redhat.com> 034-70.git20131216
- fixed systemd password waiting
- split out fcoe uefi
- fixed lvm thin tools check

* Thu Dec 05 2013 Harald Hoyer <harald@redhat.com> 034-62.git20131205
- fixed PATH shortener
- also install /etc/system-fips in the initramfs
- nbd, do not fail in hostonly mode
- add ohci-pci to the list of hardcoded modules
- lvm: do not run pvscan for lvmetad
- network fixes
- skip crypt swaps with password files
- fixed i18n

* Wed Oct 30 2013 Harald Hoyer <harald@redhat.com> 034-24.git20131030
- fixed booting with rd.iscsi.firmware and without root=
- fips: include crct10dif_generic
- fixed missing modules in hostonly, which have no modalias
- moved dracut to /usr/sbin

* Mon Oct 21 2013 Harald Hoyer <harald@redhat.com> 034-19.git20131021
- Fixed LVM with thin provisioning
Resolves: rhbz#1013767
Resolves: rhbz#1021083

* Fri Oct 18 2013 Harald Hoyer <harald@redhat.com> 034-18.git20131018
- Fixed LVM with thin provisioning
Resolves: rhbz#1013767
- fixed swap detection in host only mode

* Fri Oct 11 2013 Kyle McMartin <kyle@fedoraproject.org> 034-8.git20131008
- Force mmc_block and usb_storage into ARM initramfs.
Resolves: rhbz#1015234

* Tue Oct 08 2013 Harald Hoyer <harald@redhat.com> 034-7.git20131008
- lvm: install thin utils for non-hostonly
- do not bail out, if kernel modules dir is missing
- dmsquash-live: add /dev/mapper/live-base
Resolves: rhbz#1016726

* Tue Oct 08 2013 Harald Hoyer <harald@redhat.com> 034-1
- version 034
- add option to turn on/off prelinking
    --prelink, --noprelink
    do_prelink=[yes|no]
- add ACPI table overriding
- do not log to syslog/kmsg/journal for UID != 0
- lvm/mdraid: Fix LVM on MD activation
- bcache module removed (now in bcache-tools upstream)
- mdadm: also install configs from /etc/mdadm.conf.d
- fixes for mdadm-3.2.6+
- fcoe: add FCoE UEFI boot device support
- rootfs-block: add support for the rootfallback= kernel cmdline option

* Fri Sep 13 2013 Harald Hoyer <harald@redhat.com> 033-3.git20130913
- do not dhcp members of team, bond, etc.
- harden against weird ppc kernel driver
Resolves: rhbz#1007891

* Thu Sep 12 2013 Harald Hoyer <harald@redhat.com> 033-1
- do not cache the kernel cmdline
Resolves: rhbz#989944
- fixed iso-scan
Resolves: rhbz#1005487
- support blkid with bcache
Resolves: rhbz#1003207
- ifup with dhcp, if no ip= params specified
Resolves: rhbz#989944
- silently try to umount rpc_pipefs
Resolves: rhbz#999996

* Wed Sep 04 2013 Harald Hoyer <harald@redhat.com> 032-23.git20130904
- fixed curl error with zero size kickstart file
Resolves: rhbz#989133
- fixed systemd-cat failure, when systemd is installed
  but not actually running
Resolves: rhbz#1002021
- do not fail on empty dracut module directories
Resolves: rhbz#1003153

* Tue Aug 20 2013 Harald Hoyer <harald@redhat.com> 032-1
- fix for kdump in FIPS mode
Resolves: rhbz#920931
- fixed iBFT booting
Resolves: rhbz#989944
- fixed FIPS mode initramfs creation
Resolves: rhbz#990250
- shutdown: fixed killall_proc_mountpoint()
Resolves: rhbz#996549
- disable lvmetad in the initramfs
Resolves: rhbz#996627
- require dhclient

* Mon Aug 12 2013 Harald Hoyer <harald@redhat.com> 031-29.git20130812
- added missing "then" in initqueue

* Mon Aug 12 2013 Harald Hoyer <harald@redhat.com> 031-28.git20130812
- fixed typo in hostonly device recognition

* Fri Aug 09 2013 Harald Hoyer <harald@redhat.com> 031-24.git20130809
- fixed logging to journal

* Fri Aug 09 2013 Harald Hoyer <harald@redhat.com> 031-23.git20130809
- fixed lsinitrd

* Fri Aug 09 2013 Harald Hoyer <harald@redhat.com> 031-22.git20130809
- lsinitrd.sh: add old cpio signature
- dracut.sh: call find with -print0 and cpio with --null
- dracut.asc: small corrections
- systemd/dracut-initqueue.sh: continue to boot if finished failed
- dracut.sh/dracut-functions.sh: handle root on non-block device
- dracut-functions.sh: removed non dracut-install shell functions
- dracut-functions.sh: inst_multiple == dracut_install
- 51-dracut-rescue.install: fixed rescue image creation
- dracut.sh: do not strip in FIPS mode
Resolves: rhbz#990250
- dracut.sh: check the value of --kver
- crypt: Fix typo--/etc/crypttab not /etc/cryptab
- network/net-lib.sh: fix ibft interface configuration
- iscsi/module-setup.sh: install some modules regardless of hostonly
- multipath: need_shutdown if multipath devices exist
Resolves: rhbz#994913
- omit drivers fix

* Thu Aug 01 2013 Harald Hoyer <harald@redhat.com> 031-7.git20130801
- also install vt102 terminfo

* Wed Jul 31 2013 Harald Hoyer <harald@redhat.com> 031-6.git20130731
- cmssetup: fixed port for zfcp.conf
- lvm: call lvchange with --yes to boot from snapshots

* Wed Jul 31 2013 Harald Hoyer <harald@redhat.com> 031-4.git20130731
- remove action_on_fail kernel command line parameter

* Wed Jul 31 2013 Harald Hoyer <harald@redhat.com> 031-3.git20130731
- do not include adjtime and localtime in the initramfs
- write out vlan configs

* Wed Jul 31 2013 Harald Hoyer <harald@redhat.com> 031-1
- do not include the resume dracut module in hostonly mode,
  if no swap is present
- don't warn twice about omitted modules
- use systemd-cat for logging on systemd systems, if logfile is unset
- fixed PARTUUID parsing
- support kernel module signing keys
- do not install the usrmount dracut module in hostonly mode,
  if /sbin/init does not live in /usr
- add debian udev rule files
- add support for bcache
- network: handle bootif style interfaces
  e.g. ip=77-77-6f-6f-64-73:dhcp
- add support for kmod static devnodes
- add vlan support for iBFT

* Wed Jul 24 2013 Kyle McMartin <kyle@redhat.com> 030-2
- Add ehci-tegra.ko to initramfs to allow rawhide tegra based platforms
  to boot off USB disks.

* Wed Jul 17 2013 Harald Hoyer <harald@redhat.com> 030-1
- support new persistent network interface names
- fix findmnt calls, prevents hang on stale NFS mounts
- add systemd.slice and slice.target units
- major shell cleanup
- support root=PARTLABEL= and root=PARTUUID=
- terminfo: only install l/linux v/vt100 and v/vt220
- unset all LC_* and LANG, 10% faster
- fixed dependency loop for dracut-cmdline.service
- do not wait_for_dev for the root devices
- do not wait_for_dev for devices, if dracut-initqueue is not needed
- support early microcode loading with --early-microcode
- dmraid, let dmraid setup its own partitions
- sosreport renamed to rdsosreport

* Fri Jun 14 2013 Harald Hoyer <harald@redhat.com> 029-1
- wait for IPv6 auto configuration
Resolves: rhbz#973719
- i18n: make the default font configurable
- systemd/dracut-pre-pivot.service: also execute for cleanup hooks or rd.break
- add dracut-shutdown.service.8 manpage
- lvm: redirect error message of lvs to /dev/null
Resolves: rhbz#921235

* Wed Jun 12 2013 Harald Hoyer <harald@redhat.com> 028-1
- lvm: fixed "thin" recognition
Resolves: rhbz#921235
- install libs also from one dir above
  fixes booting power6 generated initramfs on power7
- setup correct system time and time zone in initrd
- cms fixups
Resolves: rhbz#970982 rhbz#971025 rhbz#825199
- iso-scan/filename fixes
Resolves: rhbz#972337
- add udev rules for persistent network naming
Resolves: rhbz#972662

* Tue Jun 04 2013 Dennis Gilmore <dennis@ausil.us> 027-82.git20130531
- add patch to include  panel-tfp410 module on arm systems

* Fri May 31 2013 Harald Hoyer <harald@redhat.com> 027-81.git20130531
- fix btrfs mount flags for /usr
- degrade message about missing tools for stripping
Resolves: rhbz#958519
- set environment vars DRACUT_SYSTEMD, NEWROOT in service file
Resolves: rhbz#963159
- don't add volatile swap partitions to host_devs
- add libssl.so.10 to make kdump work with fips mode
- readd selinux dracut module for kdump
- url-lib/url-lib.sh: turn off curl globbing
Resolves: rhbz#907497
- include btrfs-zero-log in the initramfs
Resolves: rhbz#963257
- proper NAME the network interfaces
Resolves: rhbz#965842
- install default font latarcyrheb-sun16
Resolves: rhbz#927564
- optionally install /etc/pcmcia/config.opts
Resolves: rhbz#920076
- fix ONBOOT for slaves, set TYPE=Bond for bonding
Resolves: rhbz#919001
- add nvme kernel module
Resolves: rhbz#910734
- add xfs_metadump
- selinux: load_policy script fix
- add hid-hyperv and hv-vmbus kernel modules
- add parameter rd.live.squashimg
Resolves: rhbz#789036 rhbz#782108
- wait for all required interfaces if "rd.neednet=1"
Resolves: rhbz#801829
- lvm: add tools for thin provisioning
Resolves: rhbz#921235
- ifcfg/write-ifcfg.sh: fixed ifcfg file generation
- do not wait for mpath* devices
Resolves: rhbz#969068

* Wed May 22 2013 Adam Williamson <awilliam@redhat.com> 027-46.git20130430
- don't specify "p" as a separator for dmraid
Resolves: rhbz#966162

* Tue Apr 30 2013 Harald Hoyer <harald@redhat.com> 027-45.git20130430
- fixed fips mode more
Resolves: rhbz#956521

* Thu Apr 25 2013 Harald Hoyer <harald@redhat.com> 027-39.git20130425
- fix shutdown, if /dev/console is not writeable
- fixed fips mode
Resolves: rhbz#956521

* Thu Apr 18 2013 Harald Hoyer <harald@redhat.com> 027-36.git20130418
- fix initramfs creation on noexec tmpdir
Resolves: rhbz#953426
- more options for lsinitrd
- bash completion for lsinitrd
- do not output debug information on initramfs creation, if rd.debug is
  on the kernel command line
- drop requirement on 'file', lsinitrd can find the magic on its own

* Mon Apr 15 2013 Harald Hoyer <harald@redhat.com> 027-26.git20130415
- do not call plymouth with full path
- include systemd-random-seed-load.service
- fix ca-bundle.crt for ssl curl
Resolves: rhbz#950770
- add support for "iso-scan/filename" kernel parameter

* Wed Apr 10 2013 Harald Hoyer <harald@redhat.com> 027-19.git20130410
- also handle UUID= entries in crypttab in host-only mode
Resolves:rhbz#919752

* Tue Apr 09 2013 Harald Hoyer <harald@redhat.com> 027-17.git20130409
- only include needed /etc/crypttab entries
Resolves:rhbz#919752
- add support for bridge over team and vlan
- support multiple bonding interfaces
- add "action_on_fail=" kernel command line parameter
- add support for bridge over a vlan tagged interface

* Fri Apr 05 2013 Harald Hoyer <harald@redhat.com> 027-10.git20130405
- fix crypto password timeout on the dracut side

* Tue Mar 26 2013 Harald Hoyer <harald@redhat.com> 027-1
- version 027

* Wed Mar 20 2013 Harald Hoyer <harald@redhat.com> 026-72.git20130320
- fix rescue image naming
Resolves: rhbz#923439
- turn off host-only mode if essential system filesystems not mounted
- turn off host-only mode if udev database is not accessible

* Tue Mar 19 2013 Harald Hoyer <harald@redhat.com> 026-62.git20130319
- fix dracut service ordering
Resolves: rhbz#922991

* Mon Mar 18 2013 Harald Hoyer <harald@redhat.com> 026-56.git20130318
- don't fail hard on kernel modules install
Resolves: rhbz#922565

* Mon Mar 18 2013 Harald Hoyer <harald@redhat.com> 026-55.git20130318
- install all host filesystem drivers
Resolves: rhbz#922565

* Sat Mar 16 2013 Harald Hoyer <harald@redhat.com> 026-54.git20130316
- fix for squashfs
Resolves: rhbz#922248
- documentation fixes
- sosreport, mkdir /run/initramfs

* Fri Mar 15 2013 Harald Hoyer <harald@redhat.com> 026-48.git20130315
- use new initrd.target from systemd
- fixed rescue generation

* Wed Mar 13 2013 Harald Hoyer <harald@redhat.com> 026-33.git20130313
- add module-load.d modules to the initramfs
- add sysctl.d to the initramfs
- optimize plymouth module for systemd mode
- add new dracut parameter "--regenerate-all"
- add new dracut parameter "--noimageifnotneeded"
- shutdown: mount move /run /sys /dev /proc out of /oldroot
  before pre-shutdown
- add bash completion for dracut

* Wed Mar 13 2013 Harald Hoyer <harald@redhat.com> 026-19.git20130313
- fix switch-root and local-fs.target problem
- add norescue and nohostonly subpackages

* Mon Mar 11 2013 Harald Hoyer <harald@redhat.com> 026-15.git20130311
- update to recent git

* Fri Mar 08 2013 Harald Hoyer <harald@redhat.com> 026-1
- version 026

* Mon Feb 11 2013 Harald Hoyer <harald@redhat.com> 025-35.git20130211
- update to recent git

* Wed Jan 23 2013 Harald Hoyer <harald@redhat.com> 025-1
- version 025

* Tue Aug 21 2012 Harald Hoyer <harald@redhat.com> 023-13.git20120821
- reintroduce rd.neednet, which reenables anaconda networking
- fix some dracut-install corner cases
- fix FIPS for /boot not on extra partition

* Wed Aug 01 2012 Dennis Gilmore <dennis@ausil.us> - 023-2
- add patch to include omap_hsmmc for arm

* Wed Aug 01 2012 Harald Hoyer <harald@redhat.com> 023-1
- version 023

* Mon Jul 30 2012 Harald Hoyer <harald@redhat.com> 022-99.git20120730
- removed install of missing finished-ask-password.sh

* Mon Jul 30 2012 Harald Hoyer <harald@redhat.com> 022-97.git20120730
- moved crypt setup to systemd units

* Fri Jul 27 2012 Harald Hoyer <harald@redhat.com> 022-63.git20120727
- fixed dracut-install bug if /var/tmp contains a symlink
- fixed some partx issues

* Mon Jul 23 2012 Harald Hoyer <harald@redhat.com> 022-5.git20120723
- dracut.8: added more documentation about executing dracut

* Fri Jul 20 2012 Harald Hoyer <harald@redhat.com> 022-2.git20120720
- fixed some race condition for resume from hibernation

* Fri Jul 20 2012 Harald Hoyer <harald@redhat.com> 022-1
- version 022
- host-only kernel modules fix

* Fri Jul 20 2012 Harald Hoyer <harald@redhat.com> 021-1
- version 21
- systemd in the initramfs reenabled
- new option "--kver"

* Wed Jul 18 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 020-97.git20120717
- Rebuilt for https://fedoraproject.org/wiki/Fedora_18_Mass_Rebuild

* Tue Jul 17 2012 Harald Hoyer <harald@redhat.com> 020-96.git20120717
- disabled systemd in the initramfs, until it works correctly

* Wed Jul 11 2012 Harald Hoyer <harald@redhat.com> 020-84.git20120711
- add back "--force" to switch-root, otherwise systemd umounts /run

* Wed Jul 11 2012 Harald Hoyer <harald@redhat.com> 020-83.git20120711
- more systemd journal fixes
- nfs module fix
- install also /lib/modprobe.d/*
- fixed dracut-shutdown service
- safeguards for dracut-install
- for --include also copy symlinks

* Tue Jul 10 2012 Harald Hoyer <harald@redhat.com> 020-72.git20120710
- stop journal rather than restart
- copy over dracut services to /run/systemd/system

* Tue Jul 10 2012 Harald Hoyer <harald@redhat.com> 020-70.git20120710
- more systemd unit fixups
- restart systemd-journald in switch-root post
- fixed dracut-install loader ldd error message

* Mon Jul 09 2012 Harald Hoyer <harald@redhat.com> 020-64.git20120709
- fixed plymouth install
- fixed resume
- fixed dhcp
- no dracut systemd services installed in the system

* Mon Jul 09 2012 Harald Hoyer <harald@redhat.com> 020-57.git20120709
- more fixups for systemd-udevd unit renaming

* Mon Jul 09 2012 Harald Hoyer <harald@redhat.com> 020-55.git20120709
- require systemd >= 186
- more fixups for systemd-udevd unit renaming

* Mon Jul 09 2012 Harald Hoyer <harald@redhat.com> 020-52.git20120709
- fixed prefix in 01-dist.conf

* Fri Jul 06 2012 Harald Hoyer <harald@redhat.com> 020-51.git20120706
- cope with systemd-udevd unit renaming
- fixed network renaming
- removed dash module

* Mon Jul 02 2012 Harald Hoyer <harald@redhat.com> 020-22.git20120702
- fixed kernel modules install

* Mon Jul 02 2012 Harald Hoyer <harald@redhat.com> 020-21.git20120702
- moved /usr/bin/dracut-install to /usr/lib
- more speedups

* Fri Jun 29 2012 Harald Hoyer <harald@redhat.com> 020-1
- version 020
- new /usr/bin/dracut-install tool
- major speedup of the image creation

* Mon Jun 25 2012 Harald Hoyer <harald@redhat.com> 019-92.git20120625
- support vlan tagged binding
- speedup initramfs emergency service
- speedup image creation
- fix installkernel() return codes
Resolves: rhbz#833256
- add qemu and qemu-net modules to add qemu drivers even in host-only
- speedup btrfs and xfs fsck (nop)
- no more mknod in the initramfs (fixes plymouth on s390)

* Thu Jun 21 2012 Harald Hoyer <harald@redhat.com> 019-62.git20120621
- do not require pkg-config for systemd
- i18n fixes
- less systemd services in the initramfs

* Thu Jun 21 2012 Harald Hoyer <harald@redhat.com> 019-57.git20120620
- systemd is now the default init in the initramfs

* Mon Jun 18 2012 Harald Hoyer <harald@redhat.com> 019-40.git20120618
- new upstream version

* Mon Jun 11 2012 Harald Hoyer <harald@redhat.com> 019-16.git20120611
- new upstream version

* Tue Jun 05 2012 Dennis Gilmore <dennis@ausil.us> 019-2
- include omapdrm with the arm modules

* Mon Jun 04 2012 Harald Hoyer <harald@redhat.com> 019-1
- version 019-1

* Tue May 22 2012 Harald Hoyer <harald@redhat.com> 018-74.git20120522
- new upstream version

* Thu May 17 2012 Dennis Gilmore <dennis@ausil.us> 018-53.git20120509
- add patch to pull in arm storage modules

* Wed May 09 2012 Harald Hoyer <harald@redhat.com> 018-52.git20120509
- new upstream version

* Fri May 04 2012 Harald Hoyer <harald@redhat.com> 018-40.git20120504
- new upstream version

* Wed Apr 25 2012 Harald Hoyer <harald@redhat.com> 018-37.git20120425.1
- fixup for multipath and iscsi host-only detection

* Wed Apr 25 2012 Harald Hoyer <harald@redhat.com> 018-37.git20120425
- fixed udevd location

* Tue Apr 24 2012 Harald Hoyer <harald@redhat.com> 018-33.git20120424
- new upstream version

* Thu Apr 19 2012 Harald Hoyer <harald@redhat.com> 018-25.git20120419
- fixed network for non-network root (like installer media)

* Wed Apr 18 2012 Harald Hoyer <harald@redhat.com> 018-22.git20120418
- new upstream version

* Mon Apr 16 2012 Harald Hoyer <harald@redhat.com> 018-12.git20120416
- new upstream version, which fixes various anaconda loader issues

* Thu Apr 05 2012 Harald Hoyer <harald@redhat.com> 018-1
- version 018

* Thu Mar 22 2012 Harald Hoyer <harald@redhat.com> 017-62.git20120322
- fixed /run prefix copying

* Wed Mar 21 2012 Harald Hoyer <harald@redhat.com> 017-59.git20120321
- new upstream version, which fixes various anaconda loader issues

* Mon Mar 12 2012 Harald Hoyer <harald@redhat.com> 017-43.git20120312
- live image: fixed image uncompression
- live updates for livenet

* Thu Mar 08 2012 Harald Hoyer <harald@redhat.com> 017-40.git20120308
- add s390 ctcm network kernel module

* Thu Mar 08 2012 Harald Hoyer <harald@redhat.com> 017-39.git20120308
- kill dhclient silently
- cleanup and fix network config writeout to /run/initramfs/state
Resolves: rhbz#799989
- various cleanups

* Fri Mar 02 2012 Harald Hoyer <harald@redhat.com> 017-22.git20120302
- nfs path fixes for live image over nfs
  root=live:nfs://10.10.10.10:/srv/all/install.img ip=dhcp rd.neednet

* Thu Mar 01 2012 Harald Hoyer <harald@redhat.com> 017-19.git20120301
- fixed include of some kernel modules

* Wed Feb 29 2012 Harald Hoyer <harald@redhat.com> 017-17.git20120229
- update to latest git
- fixes for convertfs (/usr-move)

* Fri Feb 24 2012 Harald Hoyer <harald@redhat.com> 017-1
- version 017

* Fri Feb 17 2012 Harald Hoyer <harald@redhat.com> 016-9.git20120217
- update to latest git

* Wed Feb 15 2012 Harald Hoyer <harald@redhat.com> 016-1
- version 016

* Mon Feb 13 2012 Harald Hoyer <harald@redhat.com> 015-9.git20120213
- update to latest git

* Sun Feb 12 2012 Kay Sievers <kay@redhat.com> - 015-9.git20120210
- fix dependency loop in systemd service files

* Fri Feb 10 2012 Harald Hoyer <harald@redhat.com> 015-8.git20120210
- update to latest git

* Thu Feb 09 2012 Harald Hoyer <harald@redhat.com> 015-7.git20120209
- update to latest git

* Thu Feb 09 2012 Harald Hoyer <harald@redhat.com> 015-4.git20120209
- update to latest git

* Wed Feb 08 2012 Harald Hoyer <harald@redhat.com> 015-3.git20120208
- update to latest git

* Tue Feb 07 2012 Harald Hoyer <harald@redhat.com> 015-1
- version 015

* Thu Feb 02 2012 Harald Hoyer <harald@redhat.com> 014-81.git20120202
- update to latest git

* Thu Feb 02 2012 Harald Hoyer <harald@redhat.com> 014-80.git20120202
- update to latest git

* Thu Jan 26 2012 Harald Hoyer <harald@redhat.com> 014-77.git20120126.1
- rebuild for rawhide

* Thu Jan 26 2012 Harald Hoyer <harald@redhat.com> 014-77.git20120126
- update to latest git

* Thu Jan 26 2012 Harald Hoyer <harald@redhat.com> 014-76.git20120126
- update to latest git

* Thu Jan 26 2012 Harald Hoyer <harald@redhat.com> 014-75.git20120126
- update to latest git

* Thu Jan 26 2012 Harald Hoyer <harald@redhat.com> 014-74.git20120126
- update to latest git

* Thu Jan 26 2012 Harald Hoyer <harald@redhat.com> 014-73.git20120126
- update to latest git

* Thu Jan 26 2012 Harald Hoyer <harald@redhat.com> 014-72.git20120126
- update to latest git

* Mon Jan 23 2012 Harald Hoyer <harald@redhat.com> 014-65.git20120123
- update to latest git

* Mon Jan 23 2012 Harald Hoyer <harald@redhat.com> 014-61.git20120123
- update to latest git

* Tue Jan 17 2012 Harald Hoyer <harald@redhat.com> 014-38.git20120117
- update to latest git

* Fri Jan 13 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 014-10.git20111215
- Rebuilt for https://fedoraproject.org/wiki/Fedora_17_Mass_Rebuild

* Thu Dec 15 2011 Harald Hoyer <harald@redhat.com> 014-9.git20111215
- update to latest git
- lots of patch changes

* Fri Oct 21 2011 Harald Hoyer <harald@redhat.com> 013-100.git20111021
- update to latest git

* Thu Oct 20 2011 Harald Hoyer <harald@redhat.com> 013-93.git20111020
- update to latest git

* Wed Oct 19 2011 Harald Hoyer <harald@redhat.com> 013-85.git20111019
- update to latest git

* Tue Oct 04 2011 Harald Hoyer <harald@redhat.com> 013-15
- fixed mdraid container handling
Resolves: rhbz#743240

* Thu Sep 22 2011 Harald Hoyer <harald@redhat.com> 013-13
- fixed mdraid issues
- fixed btrfsck
Resolves: rhbz#735602

* Wed Sep 21 2011 Harald Hoyer <harald@redhat.com> 013-12
- removed patch backup files
- reintroduced /dev/live

* Tue Sep 20 2011 Harald Hoyer <harald@redhat.com> 013-11
- move mounting of securitfs to a seperate module
Resolves: rhbz#737140

* Tue Sep 20 2011 Harald Hoyer <harald@redhat.com> 013-10
- mount securitfs with the correct source
Resolves: rhbz#737140

* Tue Sep 20 2011 Harald Hoyer <harald@redhat.com> 013-9
- do not carry over initramfs udev rules
Resolves: rhbz#734096

* Fri Sep 02 2011 Harald Hoyer <harald@redhat.com> 013-8
- hopefully fixed one part of a loop/udev and loop/mount race
Resolves: rhbz#735199

* Wed Aug 31 2011 Harald Hoyer <harald@redhat.com> 013-7
- add /lib/udev/input_id to the initramfs
- fix hmac install

* Tue Aug 30 2011 Harald Hoyer <harald@redhat.com> 013-6
- fixed environment passing to real init
Resolves: rhbz#733674
- fixed lvm on md

* Mon Aug 29 2011 Harald Hoyer <harald@redhat.com> 013-5
- fixed rhel/fedora version checks

* Wed Aug 17 2011 Harald Hoyer <harald@redhat.com> 013-4
- fixed crash with livenet installed

* Wed Aug 17 2011 Harald Hoyer <harald@redhat.com> 013-3
- fixed live iso mounting
Resolves: rhbz#730579

* Fri Aug 12 2011 Harald Hoyer <harald@redhat.com> 013-1
- fixed symlink creation for lorax

* Wed Aug 10 2011 Harald Hoyer <harald@redhat.com> 011-41.git20110810
- fixed getargs() for empty args

* Wed Aug 10 2011 Harald Hoyer <harald@redhat.com> 011-40.git20110810
- fixed symbolic link creation in the initramfs
Resolves: rhbz#728863

* Wed Jul 20 2011 Harald Hoyer <harald@redhat.com> 011-15.git20110720
- "eject" is optional now
- refined shutdown procedure

* Mon Jul 18 2011 Harald Hoyer <harald@redhat.com> 011-1
- version 011

* Fri May 20 2011 Harald Hoyer <harald@redhat.com> 011-0.1
- git snapshot of pre-version 011

* Fri Apr 01 2011 Harald Hoyer <harald@redhat.com> 010-1
- version 010

* Thu Mar 31 2011 Harald Hoyer <harald@redhat.com> 009-5
- fixed PATH and kmsg logging

* Thu Mar 31 2011 Harald Hoyer <harald@redhat.com> 009-4
- fixed dmsquash rule generation
- fixed fips boot arg parsing
- fixed plymouth pid generation

* Wed Mar 30 2011 Harald Hoyer <harald@redhat.com> 009-3
- fixed dhcp
- added /lib/firmware/updates to firmware directories 
- fixed LiveCD /dev/.initramfs fallback
- fixed cdrom polling
- dropped net-tools dependency

* Tue Mar 29 2011 Harald Hoyer <harald@redhat.com> 009-2
- fixed empty output file argument handling:
  "dracut '' <kernel version>" 

* Mon Mar 28 2011 Harald Hoyer <harald@redhat.com> 009-1
- version 009

* Thu Mar 17 2011 Harald Hoyer <harald@redhat.com> 009-0.1
- version 009 prerelease

* Tue Feb 22 2011 Harald Hoyer <harald@redhat.com> 008-7
- fixed lvm version parsing

* Tue Feb 22 2011 Harald Hoyer <harald@redhat.com> 008-6
- fixed lvm version parsing

* Mon Feb 21 2011 Harald Hoyer <harald@redhat.com> 008-5
- fixed i18n unicode setting
- set cdrom in kernel polling

* Fri Feb 18 2011 Harald Hoyer <harald@redhat.com> 008-4
- readded dist tag

* Fri Feb 18 2011 Harald Hoyer <harald@redhat.com> 008-3
- fixed i18n
- turned off selinux by default

* Wed Feb 09 2011 Harald Hoyer <harald@redhat.com> 008-2
- do not write dracut.log to /tmp under any circumstances
- touch /dev/.systemd/plymouth after plymouth started

* Tue Feb 08 2011 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 008-1.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_15_Mass_Rebuild

* Wed Feb 02 2011 Harald Hoyer <harald@redhat.com> 008-1
- version 008-1

* Mon Jan 17 2011 Harald Hoyer <harald@redhat.com> 008-0.11
- removed "mount" requirement

* Thu Nov 18 2010 Harald Hoyer <harald@redhat.com> - 008-0.10
- dracut-008 pre git snapshot
- fixes /dev/dri permissions
Resolves: rhbz#626559

* Fri Nov 12 2010 Harald Hoyer <harald@redhat.com> 008-0.9
- dracut-008 pre git snapshot
- fixes /dev/.udev permissions
Resolves: rhbz#651594

* Wed Nov  3 2010 Harald Hoyer <harald@redhat.com> - 008-0.8
- fixed fsck -a option

* Fri Oct 29 2010 Harald Hoyer <harald@redhat.com> 008-0.7
- added fsck to initramfs

* Fri Oct 29 2010 Harald Hoyer <harald@redhat.com> 008-0.6
- fixed rpm macros

* Fri Oct 29 2010 Harald Hoyer <harald@redhat.com> 008-0.5
- dracut-008 pre git snapshot

* Mon Aug 09 2010 Harald Hoyer <harald@redhat.com> 007-1
- version 007

* Thu Jun 17 2010 Harald Hoyer <harald@redhat.com> 006-1
- version 006

* Fri Jun 11 2010 Harald Hoyer <harald@redhat.com>
- Remove requirements, which are not really needed
Resolves: rhbz#598509
- fixed copy of network config to /dev/.initramfs/ (patch 146)
Resolves: rhbz#594649
- more password beauty (patch 142)
Resolves: rhbz#561092
- support multiple iSCSI disks (patch 143)
Resolves: rbhz#580190
- fixed selinux=0 (patch 130)
Resolves: rhbz#593080
- add support for booting LVM snapshot root volume (patch 145)
Resolves: rbhz#602723
- remove hardware field from BOOTIF= (patch 148)
Resolves: rhbz#599593
- add aes kernel modules and fix crypt handling (patch 137, patch 140 and patch 147)
Resolves: rhbz#600170

* Thu May 27 2010 Harald Hoyer <harald@redhat.com> 
- fixed Requirements
- fixed autoip6 
Resolves: rhbz#538388
- fixed multipath
Resolves: rhbz#595719

* Thu May 06 2010 Harald Hoyer <harald@redhat.com> 
- only display short password messages
Resolves: rhbz#561092

* Thu May 06 2010 Harald Hoyer <harald@redhat.com>
- fixed dracut manpages 
Resolves: rhbz#589109
- use ccw-init and ccw rules from s390utils
Resolves: rhbz#533494
- fixed fcoe
Resolves: rhbz#486244
- various other bugfixes seen in Fedora

* Tue Apr 20 2010 Harald Hoyer <harald@redhat.com> 
- fixed network with multiple nics
- fixed nfsidmap paths
- do not run blkid on non active container raids
- fixed cdrom polling mechanism
- update to latest git

* Thu Apr 15 2010 Harald Hoyer <harald@redhat.com>
- fixed dracut manpages
- dmraid parse different error messages
- add cdrom polling mechanism for slow cdroms
- add module btrfs
- teach dmsquash live-root to use rootflags
- trigger udev with action=add
- fixed add_drivers handling 
- add sr_mod
- use pigz instead of gzip, if available

* Thu Mar 25 2010 Harald Hoyer <harald@redhat.com> 
- removed firmware requirements (rhbz#572634)
- add /etc/dracut.conf.d
- Resolves: rhbz#572634

* Fri Mar 19 2010 Harald Hoyer <harald@redhat.com> 
- version 005

* Fri Mar 19 2010 Harald Hoyer <harald@redhat.com> 
- fixed rpmlint errors (rhbz#570547)
- removed firmware package from dracut-kernel (rhbz#572634)
- add dcb support to dracut's FCoE support (rhbz#563794)
- force install some modules in hostonly mode (rhbz#573094)
- various other bugfixes
- Resolves: rhbz#570547, rhbz#572634, rhbz#563794, rhbz#573094

* Thu Feb 18 2010 Harald Hoyer <harald@redhat.com> 004-15
- fixed "selinux=0" booting (rhbz#566376)
- fixed internal IFS handling
- Resolves: rhbz#566376

* Fri Jan 29 2010 Harald Hoyer <harald@redhat.com> 004-5
- fixed firmware.sh bug (#559975 #559597)

* Tue Jan 26 2010 Harald Hoyer <harald@redhat.com> 004-4
- add multipath check

* Tue Jan 26 2010 Harald Hoyer <harald@redhat.com> 004-3
- fix selinux handling if .autorelabel is present
- Resolves: rhbz#557744

* Wed Jan 20 2010 Harald Hoyer <harald@redhat.com> 004-2
- fix emergency_shell argument parsing
- Related: rhbz#543948

* Fri Jan 15 2010 Harald Hoyer <harald@redhat.com> 004-1
- version 004
- Resolves: rhbz#529339 rhbz#533494 rhbz#548550 
- Resolves: rhbz#548555 rhbz#553195

* Wed Jan 13 2010 Harald Hoyer <harald@redhat.com> 003-3
- add Obsoletes of mkinitrd/nash/libbdevid-python
- Related: rhbz#543948

* Wed Jan 13 2010 Warren Togami <wtogami@redhat.com> 003-2
- nbd is Fedora only

* Fri Nov 27 2009 Harald Hoyer <harald@redhat.com> 003-1
- version 003

* Mon Nov 23 2009 Harald Hoyer <harald@redhat.com> 002-26
- add WITH_SWITCH_ROOT make flag
- add fips requirement conditional
- add more device mapper modules (bug #539656)

* Fri Nov 20 2009 Dennis Gregorovic <dgregor@redhat.com> - 002-25.1
- nss changes for Alpha 3

* Thu Nov 19 2009 Harald Hoyer <harald@redhat.com> 002-25
- add more requirements for dracut-fips (bug #539257)

* Tue Nov 17 2009 Harald Hoyer <harald@redhat.com> 002-24
- put fips module in a subpackage (bug #537619)

* Tue Nov 17 2009 Harald Hoyer <harald@redhat.com> 002-23
- install xdr utils for multipath (bug #463458)

* Thu Nov 12 2009 Harald Hoyer <harald@redhat.com> 002-22
- add module 90multipath
- add module 01fips
- renamed module 95ccw to 95znet (bug #533833)
- crypt: ignore devices in /etc/crypttab (root is not in there)
- dasd: only install /etc/dasd.conf in hostonly mode (bug #533833)
- zfcp: only install /etc/zfcp.conf in hostonly mode (bug #533833)
- kernel-modules: add scsi_dh scsi_dh_rdac scsi_dh_emc (bug #527750)
- dasd: use dasdconf.sh from s390utils (bug #533833)

* Fri Nov 06 2009 Harald Hoyer <harald@redhat.com> 002-21
- fix rd_DASD argument handling (bug #531720)
- Resolves: rhbz#531720

* Wed Nov 04 2009 Harald Hoyer <harald@redhat.com> 002-20
- fix rd_DASD argument handling (bug #531720)
- Resolves: rhbz#531720

* Tue Nov 03 2009 Harald Hoyer <harald@redhat.com> 002-19
- changed rd_DASD to rd_DASD_MOD (bug #531720)
- Resolves: rhbz#531720

* Tue Oct 27 2009 Harald Hoyer <harald@redhat.com> 002-18
- renamed lvm/device-mapper udev rules according to upstream changes
- fixed dracut search path issue

* Mon Oct 26 2009 Harald Hoyer <harald@redhat.com> 002-17
- load dm_mod module (bug #530540)

* Fri Oct 09 2009 Jesse Keating <jkeating@redhat.com> - 002-16
- Upgrade plymouth to Requires(pre) to make it show up before kernel

* Thu Oct 08 2009 Harald Hoyer <harald@redhat.com> 002-15
- s390 ccw: s/layer1/layer2/g

* Thu Oct 08 2009 Harald Hoyer <harald@redhat.com> 002-14
- add multinic support
- add s390 zfcp support
- add s390 network support

* Wed Oct 07 2009 Harald Hoyer <harald@redhat.com> 002-13
- fixed init=<command> handling
- kill loginit if "rdinitdebug" specified
- run dmsquash-live-root after udev has settled (bug #527514)

* Tue Oct 06 2009 Harald Hoyer <harald@redhat.com> 002-12
- add missing loginit helper
- corrected dracut manpage

* Thu Oct 01 2009 Harald Hoyer <harald@redhat.com> 002-11
- fixed dracut-gencmdline for root=UUID or LABEL

* Thu Oct 01 2009 Harald Hoyer <harald@redhat.com> 002-10
- do not destroy assembled raid arrays if mdadm.conf present
- mount /dev/shm 
- let udevd not resolve group and user names
- preserve timestamps of tools on initramfs generation
- generate symlinks for binaries correctly
- moved network from udev to initqueue
- mount nfs3 with nfsvers=3 option and retry with nfsvers=2
- fixed nbd initqueue-finished
- improved debug output: specifying "rdinitdebug" now logs
  to dmesg, console and /init.log
- stop udev before killing it
- add ghost /var/log/dracut.log
- dmsquash: use info() and die() rather than echo
- strip kernel modules which have no x bit set
- redirect stdin, stdout, stderr all RW to /dev/console
  so the user can use "less" to view /init.log and dmesg

* Tue Sep 29 2009 Harald Hoyer <harald@redhat.com> 002-9
- make install of new dm/lvm udev rules optionally
- correct dasd module typo

* Fri Sep 25 2009 Warren Togami <wtogami@redhat.com> 002-8
- revert back to dracut-002-5 tarball 845dd502
  lvm2 was reverted to pre-udev

* Wed Sep 23 2009 Harald Hoyer <harald@redhat.com> 002-7
- build with the correct tarball

* Wed Sep 23 2009 Harald Hoyer <harald@redhat.com> 002-6
- add new device mapper udev rules and dmeventd 
  bug 525319, 525015

* Wed Sep 23 2009 Warren Togami <wtogami@redaht.com> 002-5
- Revert back to -3, Add umount back to initrd
  This makes no functional difference to LiveCD.  See Bug #525319

* Mon Sep 21 2009 Warren Togami <wtogami@redhat.com> 002-4
- Fix LiveCD boot regression

* Mon Sep 21 2009 Harald Hoyer <harald@redhat.com> 002-3
- bail out if selinux policy could not be loaded and 
  selinux=0 not specified on kernel command line 
  (bug #524113)
- set finished criteria for dmsquash live images

* Fri Sep 18 2009 Harald Hoyer <harald@redhat.com> 002-2
- do not cleanup dmraids
- copy over lvm.conf

* Thu Sep 17 2009 Harald Hoyer <harald@redhat.com> 002-1
- version 002
- set correct PATH
- workaround for broken mdmon implementation

* Wed Sep 16 2009 Harald Hoyer <harald@redhat.com> 001-12
- removed lvm/mdraid/dmraid lock files
- add missing ifname= files

* Wed Sep 16 2009 Harald Hoyer <harald@redhat.com> 001-11
- generate dracut-version during rpm build time

* Tue Sep 15 2009 Harald Hoyer <harald@redhat.com> 001-10
- add ifname= argument for persistent netdev names
- new /initqueue-finished to check if the main loop can be left
- copy mdadm.conf if --mdadmconf set or mdadmconf in dracut.conf

* Wed Sep 09 2009 Harald Hoyer <harald@redhat.com> 001-9
- added Requires: plymouth-scripts

* Wed Sep 09 2009 Harald Hoyer <harald@redhat.com> 001-8
- plymouth: use plymouth-populate-initrd
- add add_drivers for dracut and dracut.conf
- do not mount /proc and /selinux manually in selinux-load-policy

* Wed Sep 09 2009 Harald Hoyer <harald@redhat.com> 001-7
- add scsi_wait_scan to be sure everything was scanned

* Tue Sep 08 2009 Harald Hoyer <harald@redhat.com> 001-6
- fixed several problems with md raid containers
- fixed selinux policy loading

* Tue Sep 08 2009 Harald Hoyer <harald@redhat.com> 001-5
- patch does not honor file modes, fixed them manually

* Mon Sep 07 2009 Harald Hoyer <harald@redhat.com> 001-4
- fixed mdraid for IMSM

* Mon Sep 07 2009 Harald Hoyer <harald@redhat.com> 001-3
- fixed bug, which prevents installing 61-persistent-storage.rules (bug #520109)

* Thu Sep 03 2009 Harald Hoyer <harald@redhat.com> 001-2
- fixed missing grep for md
- reorder cleanup

* Wed Sep 02 2009 Harald Hoyer <harald@redhat.com> 001-1
- version 001
- see http://dracut.git.sourceforge.net/git/gitweb.cgi?p=dracut/dracut;a=blob_plain;f=NEWS

* Fri Aug 14 2009 Harald Hoyer <harald@redhat.com> 0.9-1
- version 0.9

* Thu Aug 06 2009 Harald Hoyer <harald@redhat.com> 0.8-1
- version 0.8 
- see http://dracut.git.sourceforge.net/git/gitweb.cgi?p=dracut/dracut;a=blob_plain;f=NEWS

* Fri Jul 24 2009 Harald Hoyer <harald@redhat.com> 0.7-1
- version 0.7
- see http://dracut.git.sourceforge.net/git/gitweb.cgi?p=dracut/dracut;a=blob_plain;f=NEWS

* Wed Jul 22 2009 Harald Hoyer <harald@redhat.com> 0.6-1
- version 0.6
- see http://dracut.git.sourceforge.net/git/gitweb.cgi?p=dracut/dracut;a=blob_plain;f=NEWS

* Fri Jul 17 2009 Harald Hoyer <harald@redhat.com> 0.5-1
- version 0.5
- see http://dracut.git.sourceforge.net/git/gitweb.cgi?p=dracut/dracut;a=blob_plain;f=NEWS

* Sat Jul 04 2009 Harald Hoyer <harald@redhat.com> 0.4-1
- version 0.4
- see http://dracut.git.sourceforge.net/git/gitweb.cgi?p=dracut/dracut;a=blob_plain;f=NEWS

* Thu Jul 02 2009 Harald Hoyer <harald@redhat.com> 0.3-1
- version 0.3
- see http://dracut.git.sourceforge.net/git/gitweb.cgi?p=dracut/dracut;a=blob_plain;f=NEWS

* Wed Jul 01 2009 Harald Hoyer <harald@redhat.com> 0.2-1
- version 0.2

* Fri Jun 19 2009 Harald Hoyer <harald@redhat.com> 0.1-1
- first release

* Thu Dec 18 2008 Jeremy Katz <katzj@redhat.com> - 0.0-1
- Initial build
