# Awesome Web Apps (that work without login)

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Mentioned in Awesome](https://awesome.re/mentioned-badge.svg)](https://awesome.re)
[![Contributors needed](https://img.shields.io/badge/contributors-needed-yellow.svg)](CONTRIBUTING.md)
[![Join the chat at https://gitter.im/aviaryan/awesome-no-login-web-apps](https://badges.gitter.im/aviaryan/awesome-no-login-web-apps.svg)](https://gitter.im/aviaryan/awesome-no-login-web-apps?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![Open Source Helpers](https://www.codetriage.com/aviaryan/awesome-no-login-web-apps/badges/users.svg)](https://www.codetriage.com/aviaryan/awesome-no-login-web-apps)

Curated list of awesome web apps that work without requesting you to create an account.

#### Inspiration

To save the world from creating user accounts and installing software applications for every damn thing.

#### Some pointers

* The web apps linked in this list provide most of their core features without login. Some websites that require registration have also been included in this list because of lack of a proper alternative. They have been tagged with `[Account]` in their listing.
* Most of the apps mentioned here do provide some kind of a user account feature to save history and progress. But as already stated before, a user account is not necessary to use the main features of these apps.


## Contents

* [Audio and Video](#audio-and-video)
* [Business and Finance](#business-and-finance)
* [Communication](#communication)
* [Document editors](#document-editors)
	* [Latex](#latex)
	* [Markdown](#markdown)
	* [Others](#doc-eds-others)
* [Drawing](#drawing)
* [File Converters](#file-converters)
* [File Hosting/Sharing](#file-hostingsharing)
* [Games](#games)
* [Graphics, Image and Design](#graphics-image-and-design)
* [Internet Downloaders](#internet-downloaders)
* [Music, Radio and Podcasts](#music-radio-and-podcasts)
* [Notepads and Notebooks](#notepads-and-notebooks)
* [Privacy, Security and Cryptography](#privacy-security-and-cryptography)
* [Programming Editors and IDEs](#programming-editors-and-ides)
* [Programming Tools](#programming-tools)
* [Search Engines](#search-engines)
* [Study and Education](#study-and-education)
* [Text based tools](#text-tools)
* [Utilities (uncategorized)](#utilities)
* [Miscellaneous](#miscellaneous)


### Audio and Video

* [bfxr](http://www.bfxr.net/) - Make sound effects for your games.
* [MP3 Cut](http://mp3cut.net/) - Online audio cutter.
* [TwistedWeb Online](https://twistedwave.com/online/) - Powerful audio editor. Files not saved online.
* [Filelab Audio Editor](http://www.avs4you.com) - Audio editor with basic features like trim, merge, cut audio.
* [Until AM](http://mix.until.am/) - Online music mixer, DJ software.
* [YOU.DJ](https://you.dj/) - Online music mixer, DJ software sourcing music from SoundCloud.
* [VideoToolbox](http://videotoolbox.com) `[Account]` - Video editor with all the common editing features. Size limited to 600mb.
* [AI Vocal Remover](https://vocalremover.org) - Separate voice from music by artificial intelligence.
* [Ambient Mixer](https://www.ambient-mixer.com/) - Listen to free audio atmospheres (e.g. Scottish Rain/Slytherin Common Room) or mix your own ambient sound online.
* [Vileo](https://lukasbach.github.io/vileo/) - Record your screen or webcam and download the video from within your browser.
* [Youtube Dynamic Playlists](https://youtube.ndo.dev) - Create on-the-fly playlists of YouTube videos.


### Business and Finance

* [ShapeShift.io](https://shapeshift.io) - Instant cryptocurrency conversion.
* [Cryptrader.com](https://cryptrader.com) - Cryptocurrency price charts and indicators. Saving your settings requires an account.
* [TradingView.com](https://www.tradingview.com/) - Real-time information and market insights from various exchanges. Requires an account for saving settings.
* [ICOStats.com](https://icostats.com/) - Track &amp; compare performance of ICOs. Displays detailed stats like ROI since ICO, ROI vs ETH since ICO, and charts for comparing the historical performance of ICOs.
* [InvoiceToMe](https://invoiceto.me/) - Generate professional invoices from various templates with your company details.


### Communication

* [Tlk.io](https://tlk.io/) - Create a room with any URL (eg `tlk.io/some-room`) you wish and chat in groups.
* [Discord](https://discordapp.com/) - Voice and text conference online. Username is asked at start to create a temp avatar.
* [Gruveo](https://www.gruveo.com/) - Video conference online. Just like Tlk.io, easy to remember custom URLs.
* [Whereby](https://whereby.com/) - Video conference online. Create any room like `whereby.com/some-room` and starting chatting.
* [Videolink2](https://videolink2.me/start) - Video conference online. Link generated, share link to invite other participants.
* [GetARoom.io](https://getaroom.io/) - Video conference online. Has mobile browser support, just click start new call and share the link.
* [FaxZero](https://faxzero.com/) - Send an online fax for free.
* [A2fax](https://www.a2fax.com/) - Send free faxes online. No ads on cover pages. Add your own logo to cover page.
* [GoTeam](https://goteam.video/) - Video meeting rooms. Create any room like `goteam.video/some-room` . Username is asked after room creation.


### Document Editors

#### Latex

* [Papeeria](https://papeeria.com/) - Latex preview with an option for downloading as a PDF available without registration.
* [Overleaf](https://www.overleaf.com/) `[Account]` - Unlimited collaborators and projects, git access in the free account.
* [Sharelatex](https://www.sharelatex.com) `[Account]` - Latex editor with unlimited private projects. 1 collaborator in free account.

#### Markdown

* [Dillinger](http://dillinger.io/) - Powerful Markdown WYSIWYG with export to HTML and PDF. User account to save documents.
* [Github.md](http://aviaryan.in/javascripts/github.md/) - Simple GitHub-style Markdown (GFM) preview with print feature.
* [HackMD](https://hackmd.io) - A collaborative, powerful, real-time online markdown editor with preview.
* [Markdown Live Preview](http://markdownlivepreview.com/) - Instant Markdown preview.
* [Markdownify](http://www.amitmerchant.com/markdownify-web/) - Minimal Markdown editor.
* [StackEdit.io](https://stackedit.io/) - Rich in-browser markdown editor that works offline.

#### <a name="doc-eds-others"></a> Others

* [EtherCalc](https://ethercalc.net/) - Online spreadsheet editor, exports to Excel.
* [PdfEscape](https://www.pdfescape.com/) - Edit or create PDFs in browser itself.
* [Browserpad](http://browserpad.org/) - A server-less plain text editor in the browser. Allows you to open and save plain text files.
* [WriteURL](http://www.writeurl.com/) - A collaborative real-time online text editor.


<a name="drawing"></a>
### Drawing

* [SVG-Edit](https://svg-edit.github.io/svgedit/releases/svg-edit-2.8.1/svg-editor.html) - Powerful SVG editor with lots of features. Open source.
* [Method Draw](http://editor.method.ac/) - Clean and feature-rich SVG editor. Exports to PNG.
* [A Web Whiteboard](https://awwapp.com/) - Touch-friendly online collaborative whiteboard app.
* [Witeboard](https://witeboard.com/) - A real-time whiteboard for your team. No signups required.
* [Draw.io](https://www.draw.io/) - Flowchart and UML drawing tool. Lots of drawing styles available. Exports to PNG and integrates with Google Drive.
* [AutoDraw](https://www.autodraw.com/) - Draw beautiful sketches, thanks to Google's Machine Learning. Drawings can be downloaded as PNG.
* [kleki](http://kleki.com/) - MS Paint like interface in browser.
* [JSPaint](https://jspaint.app) - A replica of 1990's MS Paint in the browser. Open source.
* [bubbl](https://bubbl.us/) - Create mind-maps, brainstorm ideas in the browser.
* [ScribbleMaps](http://www.scribblemaps.com/) - Create custom google maps.
* [Sketchpad](https://sketch.io/sketchpad/) - Create digital artwork and export to popular image formats JPEG, PNG, SVG, and PDF.
* [Piskel](https://www.piskelapp.com/) - Free online editor for animated sprites & pixel art
* [PixelCraft](https://pixelcraft.web.app) - A Pixel Art Editor and animation creation tool


### File Converters

* [Cloud Convert](https://cloudconvert.com/) - Convert from anything to anything including audio, video, font, document and lots more. Excellent integration with cloud storage services like Google Drive and Dropbox. Direct links.
* [Online Convert](http://www.online-convert.com/) - Collection of audio, video, image, document, ebook and archive converter. No file size limits and direct download links upon conversion.
* [PDF <=> EPUB](http://pdfepub.com/) - PDF to EPUB converter and vice versa.
* [Pandoc Try](https://pandoc.org/try/) - Inter markup conversion using Pandoc. Supported - Latex, Markdown, HTML, RST and lots more.
* [Print Friendly](https://www.printfriendly.com/) - Convert any webpage to simple format. Then download it or print as PDF.
* [OnlineOCR](https://www.onlineocr.net/) - Convert a scanned PDF into DOC, XLS or TXT.
* [GifDeck](http://gifdeck.in/) - Convert slides from slideshare to GIF.
* [favicon-generator](http://www.favicon-generator.org/) - Generate favicons for your web-apps or icons for your Android or iOS apps by uploading your desired image.
* [freetools.site](https://freetools.site/) - Free online tools. Convert or edit documents, images, audio, video and more.


### File Hosting/Sharing

* [EFShare](http://efshare.com/) - Peer to peer secure file sharing.
* [RGhost](http://rgho.st/) - File hosting service, Max limit 100mb without login.
* [ImgSafe](https://imgsafe.org/) - Image hosting service with small direct links.
* [Clyp](https://clyp.it/) - Audio sharing without limits, rich API.
* [SendVid](https://sendvid.com/) - Video hosting service.
* [Archive.org](https://archive.org/) `[Account]` - Unlimited file hosting of any type, no limits on bandwidth and upload size.
* [MultCloud](https://www.multcloud.com/home) - Cloud service to manage, move, copy and migrate data between multiple cloud services. Supports all major cloud services. No sign-up required, 2TB cloud storage, download large files directly to the cloud, no size restrictions.
* [Firefox Send](https://send.firefox.com) - Mozilla's free fileshare program. Up to 1gb without account, 2.5gb with account.


<a name="games"></a>
### Games

* [Typeracer](http://play.typeracer.com/) - Evaluate your typing speed while racing against others.
* [Spark Chess](https://www.sparkchess.com/) - Learn to play chess, play with users around the globe or play with AI depending on your skill level.
* [Miniclip](https://www.miniclip.com) - Collection of a variety of free games that can be played without giving your email. Flash required.
* [CrossCode](http://www.cross-code.com/en/start) - A retro-inspired 2D game set in the distant future. Comes with great game mechanics such as combos, puzzles, skill trees, quests, items and more.
* [agar.io](https://agar.io/) - The goal is to gain as much mass as possible by eating agar and cells smaller than the player's cell while avoiding larger ones which can eat the player's cells.
* [paper-io](http://paper-io.com) - The objective of the game is to control 100% of the arena. You play as a small, ever moving square with a small starting territory that corresponds to your square's color.
* [diep.io](https://diep.io/) - Diepio is a game where you play as tanks and shoot things. Shoot shapes to upgrade your tank, then shoot players for lots of points.
* [skribbl.io](https://skribbl.io/) - Several players connect to a lobby and one of them is given a word that they need to draw without saying what it is while the others have to identify it.
* [surviv.io](https://surviv.io/) - Surviv.io is a 2D battle royale game. You only have one live per game, no respawn.
* [nitrome](https://www.nitrome.com/) - Collection of free pixelart games. New games doesn't require flash.
* [Orion](https://orion.lukasbach.com/) - Board/puzzle game. Cleverly combine tiles from bags to fill up the board.
* [Gidd.io](https://gidd.io/) - Collection of classic games like UNO, Yatzy, Scattergories and GeoGuess.

### Graphics, Image and Design

* [PhotoPea](https://www.photopea.com/) - Image editor that looks like Photoshop and has most of its features.
* [Pixlr Editor](https://pixlr.com/editor/) - Image editor by Pixlr. Lots of features.
* [Photo Editor | Befunky](https://www.befunky.com/features/photo-editor/) - Image editor with lots of filters and effects.
* [Logo Makr](https://logomakr.com/) - Logo maker with nice collection of SVGs. Requires payment to export logo as SVG (PNG is free).
* [Online Logo Maker](https://www.onlinelogomaker.com/) - Make logos online. Extra user account feature to save creations.
* [Coolors](https://coolors.co/) - Color palettes generator.
* [Tiny PNG](https://tinypng.com/) - Smart PNG and JPEG compression.
* [Realtime Board](https://realtimeboard.com/) `[Account]` - Collaborative blackboard with huge area, screen sharing, video & voice communication.
* [ezGIF](https://ezgif.com/) - GIF images editor (cropping, scaling, optimizing and more).
* [Adobe Color CC](https://color.adobe.com/) - Color scheme designer.
* [Burner Bonanza](https://burner.bonanza.com/) `[Account]` - Tool to remove the background of an image and instantly share on Facebook or Twitter, login to download the edited image as PNG or JPEG.
* [IcoMoon](https://icomoon.io/app/) - A platform that helps you in finding vector icon packs, hosting icons as SVGs or fonts and to generate SVG + PNG + icon fonts of selected icons.
* [Flaming Text](http://flamingtext.com/) - An online logo or name generator/creator, modify your logo according to your wish and get in many formats including PNG and JPEG.
* [LeanLogoMaker](https://leanlogomaker.com) - Generate 100s of logos, pick your favourite and download. Includes covers and profile images for your social media sites.
* [doka.photo](https://doka.photo/) - Easy to use photo editor. You can crop, rotate, flip, add a filter, resize and annotate.
* [CleanIcons](https://cleanicons.xyz) - Download Font Awesome icon fonts as PNG's.
* [Mancer](https://mancer.app) - Design, share, and order T-Shirts from the browser. Designs can be exported as PNGs.
* [Branition Colors](https://branition.com/colors) - Hand-curated collection of color pallets best fitted for branding.


### Internet Downloaders

* [savefrom.net](http://en.savefrom.net/) - Download from YouTube, Dailymotion, Vimeo and more.
* [Youtube Converter & Downloader](https://www.onlinevideoconverter.com/video-converter) - Download YouTube video in any audio/video format.
* [keepvid](http://keepvid.com/) - YouTube, SoundCloud, Facebook downloader.
* [dOnline](http://https://doonline.cc/video-downloader-converter.html/) - Download from YouTube, Instagram, Vimeo, SoundCloud, Facebook downloader.
* [Bitport](https://bitport.io/welcome) `[Account]` - Torrent downloader. Limited to 1 torrent of 1gb per day in free account.
* [Seedr](https://www.seedr.cc/) `[Account]` - Cloud based torrent downloader. Limited to multiple torrents of total size of 2gb in free account. Unlimited bandwidth. 500mb increase on contributing a new user.
* [ZbigZ](https://zbigz.com/) - Torrent downloader that lets you chose the files to download from a torrent. File size limit is 2gb and download is capped to 50kbps in the free version.


### Music, Radio and Podcasts

* [Podbay](http://podbay.fm/) - Listen to any podcast online, individual episodes can be downloaded.
* [Internet Radio](https://www.internet-radio.com/) - Listen to over 40k radio stations.
* [Stitcher](http://www.stitcher.com/) - Listen to podcast online.
* [AnyAudio](http://anyaudio.in/) - Stream and download music.
* [Muki](https://muki.io) - WebAudio-based chiptune & MIDI player, with a nice collection of video game music.
* [MusixHub](http://www.musixhub.com) - Play artists and albums video songs online, powered by YouTube.
* [plug.dj](https://plug.dj/) - Listen to thousands of DJs, powered by YouTube, sign-in required to become a DJ.
* [Jango Radio](http://www.jango.com/) - Free Internet radio, listen to hundreds of genre stations or create your own with your favorite music.
* [Anime Openings](http://openings.moe/) - Free anime radio, listen or download anime opening and ending videos.
* [NoteFlight](https://www.noteflight.com/login) `[Account]` - Print music sheets, write your own music online (review).
* [ongaku](https://ongaku.js.org/) - Online anime music radio, with [desktop port](https://github.com/Anshuman-Verma/ongaku-desktop).
* [Radio Garden](http://radio.garden/) - Listen to thousands of radio stations worldwide by selecting a city on the globe.


### Notepads and Notebooks

* [aNotepad](https://anotepad.com/) - Saves your notes without a user account using cookies.
* [shrib](https://shrib.com/) - Save note to a custom URL and edit it later.
* [Notepad](http://notepad.js.org/) - Offline capable Notepad PWA.
* [ProtectedText](https://www.protectedtext.com/) - Encrypted notes without ads, sessions, or cookies.
* [Taskade](https://taskade.com/) - Collaborative notes, task lists, and outlines. Sign up is optional.
* [WriteXO](https://writexo.com/) - Online Notepad with rich-text support, password protection and custom URLs.


### Privacy, Security and Cryptography

* [Cryptii](https://cryptii.com) - Offers modular conversion, encoding and encryption with a wide variety of ciphers and methods.
* [Encipher.it](https://encipher.it/) - AES-256 text encryption and decryption.
* [Encrypted Pastebin - Defuse.ca](https://defuse.ca/pastebin.htm) - Set password on your public pastes.
* [jotti](https://virusscan.jotti.org) - Scan any suspicious file or email attachment for viruses.
* [scr.im](http://scr.im/) - Share e-mail address freely without worrying about spam.
* [10 Minute Mail](https://10minutemail.com/10MinuteMail/index.html) - A temporary fully functional email address for 10 minutes (extendible).
* [BugMeNot](http://bugmenot.com/) - A platform for finding and sharing logins of different websites. It helps you find credentials for signing in into different websites.
* [Cloverleaf](https://cloverleaf.app) - An open source app to replace your password manager without storing your passwords anywhere.

### Programming Editors and IDEs

* [TutorialsPoint Online Tools](https://www.tutorialspoint.com/codingground.htm) - Online terminals for Ipython, Octave, Powershell, Redis and lots others. Also has a good collection of IDEs for programming languages.
* [Ideone](http://ideone.com/) - Online IDE supporting most popular languages.
* [codepad](http://codepad.org/) - Online compiler which also allows you to create project (you get alloted a subdomain for your project). Note that there's no support for reading from stdin.
* [Repl.it](https://repl.it/) - Online terminals for all popular programming languages.
* [Codechef IDE](https://www.codechef.com/ide) - Simple single file code compiler supporting major languages.
* [Cloud9](https://c9.io/) `[Account]`  - Very powerful online dev environment, just like your local PC.
* [Codepen.io](https://codepen.io/) - Playground for front end web development.
* [JS Bin](https://jsbin.com) - Collaborative web development and debugging tool.
* [Codenvy](https://codenvy.com) `[Account]` - Cloud workspace for developers, supports most popular stacks including Android, Hadoop, Selenium, NodeJS and lots more.
* [SQLFiddle](http://sqlfiddle.com/) - Tool for easy online testing and sharing of database problems and their solutions.
* [Brainfuck Visualizer](http://fatiherikli.github.io/brainfuck-visualizer/) -  Javascript Brainfuck Interpreter + Visualizer. Helps you understanding how code is working.
* [PythonTutor](http://pythontutor.com/visualize.html#mode=edit) - Visualize Python, Java, JavaScript, TypeScript, Ruby, C, and C++ code execution in your Web browser.
* [DartPad](https://dartpad.dartlang.org/) -DartPad is an open-source tool that lets you play with the Dart language in any modern browser.


### Programming Tools

* [CSS Minifier](https://cssminifier.com/) - Minifies CSS by removing whitespace and comments.
* [UglifyJS JavaScript minifier](https://skalman.github.io/UglifyJS-online/) - Minifies and obfuscates JavaScript.
* [HTML minifier by @kangax](https://kangax.github.io/html-minifier/) - HTML minifier. Minifies inline CSS and JavaScript too.
* [JavaScript compressor](http://javascriptcompressor.com/) - JavaScript compressor and obfuscater.
* [Android Asset Studio](https://romannurik.github.io/AndroidAssetStudio/) - Android launcher icon, notification icon etc generator from existing images.
* [Website Speed Test | Pingdom](https://tools.pingdom.com/) - Feature-rich website tester.
* [Google Structured Data Testing Tool](https://search.google.com/structured-data/testing-tool) - Test a webpage for structured data and SEO.
* [Regulex](https://jex.im/regulex/) - JavaScript regular expression visualizer.
* [GTmetrix](https://gtmetrix.com/) - Analyze your site’s speed and make it faster.
* [BuildWith](https://builtwith.com/) - Find the technology stack to know everything about a website.
* [WooRank](https://www.woorank.com/) - SEO Audit tool, provides website review with global and local rank in terms of traffic generated.
* [CSS Typeset](http://csstypeset.com/) - Visual typeset editor. Play around with font-face, word-spacing and other text attributes and download the corresponding CSS.
* [pForm](http://www.phpform.org/) - Create HTML forms through a simple WYSIWYG GUI and download the corresponding code.
* [CSS Autoprefixer](https://autoprefixer.github.io/) - A postprocessor for handling vendor prefixes in CSS. Just paste the regular CSS and get the vendor prefix handled CSS instantly.
* [CSS Matic](https://www.cssmatic.com/) - CSS tools to quickly generate gradients, border radius, noise textures and box shadow and get corresponding CSS or SASS.
* [Carbon](https://carbon.now.sh) - Create and share beautiful images of your source code.
* [jsonstore.io](https://www.jsonstore.io/) - jsonstore.io offers free, secured JSON based API endpoints for small projects. It supports common types of HTTP operations like POST, GET, PUT, DELETE etc.
* [ObjGen](http://www.objgen.com/) - This app helps you generate code (JSON, HTML, etc) in real time as you type in only the key words, types and properties using a text based syntax.
* [JsonFormatter](https://jsonformatter.curiousconcept.com) - View json in human readable form.
* [DebugBear Speed Test](https://www.debugbear.com/test/website-speed) - Test site speed and Core Web Vitals.


### Search Engines

* [Iconfinder](https://www.iconfinder.com/) - Download all your favourite icons in one place.
* [Emoji Search Online](https://www.webpagefx.com/tools/emoji-cheat-sheet/) - Intelligent emoji search engine.
* [RSS Feed Search](http://ctrlq.org/rss/) - Find RSS feeds from search terms.
* [IWantMyName](https://iwantmyname.com/) - Helps you search domains across all TLDs.
* [Similar Sites](http://www.similarsites.com/) - Find websites similar to the one you enter.
* [Google Fonts](https://www.google.com/webfonts) - Collection of open-source fonts by google.
* [ChooseMyPC](https://choosemypc.net/) - Search for the best combination of parts considering your requirements for your PC under a given budget.
* [Flaticon](https://www.flaticon.com/) - Largest search engine for free icons.
* [icon8](https://icons8.com/) - Designers, download the design stuff for free — icons, photos, UX illustrations, and music for your videos.


### Study and Education

* [Calculatoria Calculator](http://www.calculatoria.com/) - Scientific calculator online with progress stored on your system.
* [WolframAlpha](https://www.wolframalpha.com) - Powerful computational knowledge engine. See [plotting graphs examples](https://www.wolframalpha.com/examples/PlottingAndGraphics.html) for help on how to plot graphs.
* [Desmos Graphing Calculator](https://www.desmos.com/calculator) - Plot multiple 2D plots on same sheet, see graph intersections.
* [Geometry sheet by MathIsFun](https://www.mathsisfun.com/geometry/drawing.html) - Simple geometry sheet online if you want to play with figures.
* [Directed Graph Editor](http://bl.ocks.org/rkirsling/5001347) - Play with directed graphs.
* [Calcul](http://www.calcul.com) - Collection of different calculators including matrix, unit converters, mathematical distributions and more.
* [Word Safety](http://wordsafety.com/) - Check if words are abusive in any languages.
* [OEIS®](http://oeis.org/) - The On-Line Encyclopedia of Integer Sequences®, helps in cryptography as well as formulating odd looking sequences.
* [Directed Grap Editor (CS Academy)](https://csacademy.com/app/graph_editor/) - Draw directed graph systems with and without edge values and physics.
* [Abc-Map](https://abc-map.fr) - Create geographical maps, pick data from the data store, process data to create visualizations, export or share your maps online. 
* [KeepFormula](https://keepformula.github.io/) - Keep Formula is a simple app to make your calculations easier.


<a name="text-tools"></a>
### Text based tools

* [Diff Checker](https://www.diffchecker.com/) - Compare two text passages and view differences.
* [CopyPasteCharacter](http://www.copypastecharacter.com/) - Copy special characters that are generally unavailable in a keyboard.
* [PolishMyWriting](http://www.polishmywriting.com/) - Paste a text and get feedback on your writing.
* [Wordle](http://www.wordle.net/) - A toy to generate 'Word Clouds' form a given piece of text.
* [tYp3r](http://typ3r.aavi.me) - dA aNn0Y1Ng t3Xt g3NeRa7or (The annoying text generator :-P).
* [Telegraph](http://telegra.ph/) - Minimalist publishing tool that supports richly formatted text.
* [DiffNow](https://www.diffnow.com/) - Advanced, online and free File Difference checking, with options like Upload file, compare files by their links or Text Input.
* [Write.as](https://write.as/) - Cross-platform writing and publishing tool that supports Markdown and editing / deleting past posts.
* [Emojify](https://madelinemiller.dev/apps/emojify/) - A tool to spice up text, lyrics, or poems by adding emojis.


<a name="utilities"></a>
### Utilities (uncategorized)

* [Dataflow kit](https://dataflowkit.com/dfk) - Extract structured data from Web pages.
* [E.gg Timer](http://e.ggtimer.com/) - Simple countdown timer application.
* [QR Code Generator](http://zxing.appspot.com/generator/) - Different types of QR codes like contact info, WiFi, calendar etc supported.
* [QR Code Scanner and Generator](https://sharesnip.rosano.ca) - Scan via camera and files, download as SVG or PNG, works offline.
* [RANDOM.ORG](https://www.random.org/) - Random number generator, dice rolls, password generator, random bitmaps and more stuff based on the concept of randomness.
* [Web-Capture](https://web-capture.net/) - Webapp for converting webpages to popular formats (PDF, JPEG, ZIP) just by submitting link.
* [PrintWhatYouLike](http://www.printwhatyoulike.com/) - Print any webpage or save it as HTML or PDF.
* [WhatTheFont](http://www.myfonts.com/WhatTheFont/) - Determine font name from an image.
* [Image Metadata Viewer](http://exif.regex.info/exif.cgi) - View hidden data (metadata) of any image.
* [WhoIsHostingThis](http://www.whoishostingthis.com/) - Find the web host of any website.
* [TypingWeb](https://www.typing.com/student/start) - Master touch-typing with ease.
* [Acronym Creator](http://acronymcreator.net/) - Create acronym for organization, algorithm, or anything having at least two words.
* [TallTweets](http://talltweets.com/) - Send tweets longer than 140 characters.
* [Postify](http://postfity.com/) `[Account]` - Schedule posts on Facebook, Twitter & LinkedIn.
* [Krutidev <--> Unicode](http://wrd.bih.nic.in/font_KtoU.htm) - Convert Krutidev to Unicode (Mangal) and vice versa in one click.
* [Resume Nation](https://resume-nation.github.io) - An open source resume builder progressive web app which can work offline. It has a few themes to choose from and it can export the resume in PDF form.
* [Daily Todo](https://dailytodo.org/) -  Simple todo list maker.
* [Mailinator](https://www.mailinator.com/) - Disposable email service.
* [Randommer](https://randommer.io/) - Random data generator and validator.
* [Meditation Timer](https://meditation.koti.cloud/) - A meditation timer to keep track of your sessions.
* [Bucket Listy](https://bucketlisty.com/) - Bucket list manager with unique ideas where you can add your own.


### Miscellaneous

* [rollApp](https://www.rollapp.com/) `[Account]` - Run desktop applications on any device.
* [is.gd](https://is.gd/) - Link shortener with custom URLs and open API (no tokens).
* [Bitly](https://bitly.com/) - Powerful URL shortener with REST API.
* [Superbetize](http://superbetize.com/) - Categorize your grocery list.
* [isup.me](http://isup.me/) - Check if website is unavailable just for you or everyone else.
* [Dictation.io](https://dictation.io/) - Online voice dictation software supporting large number of languages.
* [followupthen](https://www.followupthen.com/) - Easiest way to setup email reminders.
* [lmgtfy](http://lmgtfy.com/) - When your friends are too lazy to use Google on their own.
* [IFTTT](https://ifttt.com/) `[Account]` - Create a connection between your favourite online services. For example, if one needs to tweet their instagrams as native photos on twitter then IFTTT can come in handy.
* [AlarmDJ](https://alarmdj.com) - Online Alarm clock, use MP3 files and YouTube videos as alarm.
* [Edubirdie](https://edubirdie.com/plagiarism-checker) - An online plagiarism checker which gives percentage of similarity comparing our content with online resources.
* [Morsify](https://morsify.net) - Online Morse code translator.
* [Dub](https://dub.sh/) - Open-source link shortener.
* [3dHousePlanner](https://www.3dhouseplanner.com/) - 3D home design application on the web.
-----

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Avi Aryan](http://aviaryan.in) has waived all copyright and related or neighboring rights to this work.
