# Hamsters.js

**Author**: Austin K. Smith

**Website**: [Hamsters.io](http://www.hamsters.io)

**Description**: 100% Vanilla Javascript Multithreading & Parallel Execution Library

**License**: Artistic License 2.0

[![npm version](https://img.shields.io/npm/v/hamsters.js.svg?style=flat-square)](https://www.npmjs.com/package/hamsters.js)
[![downloads](https://img.shields.io/npm/dm/hamsters.js.svg?style=flat-square)](https://www.npmjs.com/package/hamsters.js)

# Environment Support

* All major browsers Internet Explorer 10 and greater
* ReactNative
* Node.js
* Javascript shell environments
* Inside existing worker threads (Threading inside Threads)

# Examples

You can find a view examples of the library in action using the links below.


[Atomic Operations](https://www.hamsters.io/examples/atomic-operations)

[Collatz Conjecture](https://www.hamsters.io/examples/collatz-conjecture)

[Fibonacci Sequence](https://www.hamsters.io/examples/fibonacci-sequence)

[Mandelbrot Set](https://www.hamsters.io/examples/mandelbrot-set)

[Square Root](https://www.hamsters.io/examples/square-root)


# Installing Hamsters

[HTML](https://www.hamsters.io/wiki/html)

[ReactNative](https://www.hamsters.io/wiki/react-native)

[Node.js](https://www.hamsters.io/wiki/node)


# Using Hamsters

[Initializing](https://www.hamsters.io/wiki/initializing)

[The Basics](https://www.hamsters.io/wiki/basics)

[Restructoring Standard Functions](https://www.hamsters.io/wiki/restructuring)

[Promises](https://www.hamsters.io/wiki/promises)

[Sorting](https://www.hamsters.io/wiki/sorting)

[Persistence](https://www.hamsters.io/wiki/persistence)

[Transferable  Objects](https://www.hamsters.io/wiki/transferables)

[Atomic Operations](https://www.hamsters.io/wiki/atomics)

[Memoization](https://www.hamsters.io/wiki/memoization)

[Debugging](https://www.hamsters.io/wiki/debugging)

[Limitations](https://www.hamsters.io/wiki/limitations)


# Support Hamsters.js

Hamsters.js thrives through community support. Your contributions help us deliver updates, maintain the project website, and continue innovating. If you find Hamsters.js valuable, please consider making a donation. Your generosity ensures the project's sustainability and growth. Thank you for your support!


 [Donate to Hamsters.js](https://www.hamsters.io/donate)