part of 'at_demo_credentials.dart';
// relay1, relay2, iotdevice1, iotdevice2, cloudvm1, cloudvm2, policy1, policy2,
// colin, chris, gary, gareth, xavier, jeremy, curtly, don, denise, barbara

/// All keys class for `@alice🛠`
class AliceKeys {
  /// CRAM key for `@alice🛠`
  static const String _cramKey =
      'b26455a907582760ebf35bc4847de549bc41c24b25c8b1c58d5964f7b4f8a43bc55b0e9a601c9a9657d9a8b8bbc32f88b4e38ffaca03c8710ebae1b14ca9f364';

  /// PKAM private key for `@alice🛠`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCDVMetuYSlcwNdS1yLgYE1oBEXaCFZjPq0Lk9w7yjKOqKgPCWnuVVly5+GBkYPYN3mPXbi/LHy3SqVM/8s5srxa+C8s5jk2pQI6BgG/RW59XM6vrGuw0pUQoL0bMyQxtR8XAFVgd54iDcgp4ZPLEH6odAgBraAtkIEpfwSwtMaWJCaS/Yn3q6ZoVOxL+O7DHD2dJWmwwjAJyDqEDeeNVuNHWnmj2ZneVXDnsY4fOR3IZdcGArM28FFcFIM6Q0K6XGiLGvJ2pYPywtzwARFChYJTBJYhNNLRgT+MUvx8fbNa6mMnnXQmagh/YvYwmyIUVQK1EhFNZIgezX9xdmIgS+FAgMBAAECggEAEq0z2FjRrFW23MWi25QHNAEXbSS52WpbHNSZJ45bVqcQCYmEMV4B7wAOJ5kszXMRG3USOyWEiO066Q0D9Pa9VafpxewkiicrdjjLcfL76/4j7O7BhgDvyRvMU8ZFMTGVdjn/VpGpeaqlbFdmmkvI9kOcvXE28wb4TIDuYBykuNI6twRqiaVd1LkKg9yoF0DGfSp8OHGWm/wz5wwnNYT6ofTbgV3gSGKOrLf4rC1swHh1VoNXiaYKQQFo2j23vGznC+hVJy8kAkSTMvRy4+SrZ+0MtYrNt0CI9n4hw79BNzwAd0kfJ5WCsYL6MaF8Giyym3Wl77KoiriwRF7cGCEnAQKBgQDWD+l1b6D8QCmrzxI1iZRoehfdlIlNviTxNks4yaDQ/tu6TC/3ySsRhKvwj7BqFYj2A6ULafeh08MfxpG0MfmJ+aJypC+MJixu/z/OXhQsscnR6avQtVLi9BIZV3EweyaD/yN/PB7IVLuhz6E6BV8kfNDb7UFZzrSSlvm1YzIdvQKBgQCdD5KVbcA88xkv/SrBpJcUME31TIR4DZPg8fSB+IDCnogSwXLxofadezH47Igc1CifLSQp4Rb+8sjVOTIoAXZKvW557fSQk3boR3aZ4CkheDznzjq0vY0qot4llkzHdiogaIUdPDwvYBwERzc73CO3We1pHs36bIz70Z3DRF5BaQKBgQC295jUARs4IVu899yXmEYa2yklAz4tDjajWoYHPwhPO1fysAZcJD3E1oLkttzSgB+2MD1VOTkpwEhLE74cqI6jqZV5qe7eOw7FvTT7npxd64UXAEUUurfjNz11HbGo/8pXDrB3o5qoHwzV7RPg9RByrqETKoMuUSk1FwjPSr9efQKBgAdC7w4Fkvu+aY20cMOfLnT6fsA2l3FNf2bJCPrxWFKnLbdgRkYxrMs/JOJTXT+n93DUj3V4OK3036AsEsuStbti4ra0b7g3eSnoE+2tVXl8q6Qz/rbYhKxR919ZgZc/OVdiPbVKUaYHFYSFHmKgHO6fM8DGcdOALUx/NoIOqSTxAoGBALUdiw8iyI98TFgmbSYjUj5id4MrYKXaR7ndS/SQFOBfJWVH09t5bTxXjKxKsK914/bIqEI71aussf5daOHhC03LdZIQx0ZcCdb2gL8vHNTQoqX75bLRN7J+zBKlwWjjrbhZCMLE/GtAJQNbpJ7jOrVeDwMAF8pK+Put9don44Gx';

  /// PKAM public key for `@alice🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAg1THrbmEpXMDXUtci4GBNaARF2ghWYz6tC5PcO8oyjqioDwlp7lVZcufhgZGD2Dd5j124vyx8t0qlTP/LObK8WvgvLOY5NqUCOgYBv0VufVzOr6xrsNKVEKC9GzMkMbUfFwBVYHeeIg3IKeGTyxB+qHQIAa2gLZCBKX8EsLTGliQmkv2J96umaFTsS/juwxw9nSVpsMIwCcg6hA3njVbjR1p5o9mZ3lVw57GOHzkdyGXXBgKzNvBRXBSDOkNCulxoixrydqWD8sLc8AERQoWCUwSWITTS0YE/jFL8fH2zWupjJ510JmoIf2L2MJsiFFUCtRIRTWSIHs1/cXZiIEvhQIDAQAB';

  /// APKAM private key for `@alice🛠`
  static const String _apkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCmeLQL28BNyIOYotfSnWfjLtdIKNLTdlla17SmnLdq7xmWIozoup35T7dkDWdP2jDJAYBDTpw1wwIz393t1fuB0Y8newERBfyYV0QYRnvCMDH5XLXZN6g5Ec74Z4kP/hv7PUWh+ZdOSoYCpeM2f6kJw7lBBwtM7xTheSlCIeCYmA7/JT+QeAcHLMIexdnOE/HPzXGL6Uu7bZQGoe9E4esnGv9qhhBiu/gBauh7LRGumL1SgCEVSx0BS1WYSYoy0nxQVOVf6pMfsKai6ERE+OjANQa+s4nKrJ0w+ESMeXQa38ZglJaGFbu4on27TvDpgGsEMtK0JyeFri5v3MNXq7lxAgMBAAECggEACZV3YBtlpdS+ZsIxRKnVOkoPENNw18W/fTBf8Ruin6BmS7Nvg1KDF8BUIYl4AivglSHl/XoAGkRA0zW3NCMWmLG02SQGurEqiqazf+ZG57YYmm+Q9JF0uNximwBy7p3FhKBRavLQmCxILMzaGOAenjZLawf5yZMWE6kDDBChOoemfuljHNM85FIeHZ+vgudeGi7sY9OG5+oa+RoG7axX+3Dj+BlFUV/o30LImt/Hg96cp1h2a7eCiaI1Cs3ALEM0oPlKbAj8Pg6D62+STSMkpd6z8v1LNSi3pOWqCgD+F/ur3+q7vdcQ4uV5Bd6FQv6EPb7PCnNaDbJBxSiPw0stFQKBgQDxFTslKml55O3OK36t9Yo8zPiH44p+VHMClMCkHH4QSGwQaODIIln63IdM2WfdlSsYfmoToljFOs2W39z7xpG0/g/L2Pe2nrSlFkhUB/PUSTyjnc9gS/w/v3jFxtj0EhGzNc7c2Tsu9WbisLYH7eod0NhvGWInCu9j8KL38M6KRwKBgQCwxZ9UiDrPHUrMEl31up/CEZ8RgMBSW/x5wD9VFZO2hD9KrFdckBd45FGaTFII5wG53XEOUaMCI2VXP2SNM15eaYxQ3v2y1z0k5xqhR7XG+oI0MmFVOkz6NEakC2AJGBZYZwzbFiu3tu1ygu1gBoauEsgMzmCMhQmZNZXfftHChwKBgQDmEbva8QmtsSKcwXdobk4ZTgbUL/sIKnGDghABzcskoOi4FE6Hz/iM5g4c8dEkbmmtO17iE+mhd0eh90u93zdIQbkzcYCdAAInFge6Ych4y9eZ0U2JeZpl/8UzAVwkOGY531zl+E15t+oS5k8hbBQjlh4mkFPSLKZeetQbx+xjmwKBgQCJZPDUCRZ8iG3sc5IoPieR9ZRHTGUvHmP8VZpkDWNEB0ISTiWQwkYcJonufcd9N9+1kRIgaP9j2BMaXyFORlDg3PS8nrVdXcIefqnKFSyKPYcZ/tZ8IdZW2m7Vbin0p44mo+HwHylXn4yq5myNqETh46MtoPKWBYlSVb3pem6a3QKBgEyy3E24xqxVNcto9+euhTBvtbPV4YmQIkvXQCLJwEF+Cljbo6xe6mTMZOR+xGVji3FUjbXjP/fPfjVuWaFfPd2WK0zlQWUesMatMTa0Kq3XohUiViTUWlZTV0mzn5Mq2+inE5srLi7+eSHV4bI0FzjRXVDpv3zWIvQJrLtJ51LA';

  /// APKAM public key for `@alice🛠`
  static const String _apkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApni0C9vATciDmKLX0p1n4y7XSCjS03ZZWte0ppy3au8ZliKM6Lqd+U+3ZA1nT9owyQGAQ06cNcMCM9/d7dX7gdGPJ3sBEQX8mFdEGEZ7wjAx+Vy12TeoORHO+GeJD/4b+z1FofmXTkqGAqXjNn+pCcO5QQcLTO8U4XkpQiHgmJgO/yU/kHgHByzCHsXZzhPxz81xi+lLu22UBqHvROHrJxr/aoYQYrv4AWroey0Rrpi9UoAhFUsdAUtVmEmKMtJ8UFTlX+qTH7CmouhERPjowDUGvrOJyqydMPhEjHl0Gt/GYJSWhhW7uKJ9u07w6YBrBDLStCcnha4ub9zDV6u5cQIDAQAB';

  /// Public encryption key for `@alice🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0sYjWt6TTikajY3HjvdN3sn2Ve3O+i84/gBrWPqhGNSdImz3W2l9dMSHm4wyixsxMSQaL+rECjwnvp3sRdW3M51sDCvWa06MLptvdrtnMjzDrvP45hUJY/i6WeDW8qeEOf9zuo+BLcQ3pkV1KZyhBj80OndLS/y00T8fYB9KnS5Z/iN7KW7Hxuv0isMPXxL1i8AZos7m5GuWq7CfRFKJIZ6vqYBUJCVSQCUVo1llyjElodSywcf1KjCvBOKuMPnUQCs+pKJt3QMFI0U7D+yinnlEdr6TBfOzMMPS3Du1LHpTGt7rqyxZrX8p4kpVb/CyL6wkelMuahHDOeNFBNyF0wIDAQAB';

  /// Private encryption key for `@alice🛠`
  static const String _encryptionPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDSxiNa3pNOKRqNjceO903eyfZV7c76Lzj+AGtY+qEY1J0ibPdbaX10xIebjDKLGzExJBov6sQKPCe+nexF1bcznWwMK9ZrTowum292u2cyPMOu8/jmFQlj+LpZ4Nbyp4Q5/3O6j4EtxDemRXUpnKEGPzQ6d0tL/LTRPx9gH0qdLln+I3spbsfG6/SKww9fEvWLwBmizubka5arsJ9EUokhnq+pgFQkJVJAJRWjWWXKMSWh1LLBx/UqMK8E4q4w+dRAKz6kom3dAwUjRTsP7KKeeUR2vpMF87Mww9LcO7UselMa3uurLFmtfyniSlVv8LIvrCR6Uy5qEcM540UE3IXTAgMBAAECggEAfImMLE3k1cLdqJQEPIoNHb1RatZXfGXYk+QliW6VLzm5GrUttnpvIUZaJeNBngXUHAgL3RInATEn/q4LA/xSAhJa3Bou2DqSA5vd0VbLk9hpev82qqP1Z3d4jFCYUMoAC9DPTYUrO6J7iyfxIUQltK41qvH/sIdBQ327iS0UBihhiKg16BOKG4SoFJHZfhhL6m86+jnsaBTaAWb8hpa/Mwqs5eDHF78DHK8o+4Q6DufDi34nCwdxEexL3MFa9L0qGbQAqJshgDcJ6yxUzb5+tw3XXpiE0yG9aZ5gPaS2UgOYY1m2mmF4RjFSiLmKyN99H99ycA59enVFyfYh4SnuMQKBgQDq9IwkVyDkNxkaW6hyYMzBwNqId74JUNjXCWyzDJ58JWaNvFYYY4ujSCLTdfdugmVTIUjqXMVsxzq/e9jNaOj7u27/3inqn1VC88GFJJiUiLQcTP1T5ySP4jy5GVrhQ1zP8PtiRqE34emYfVY8OLa7bwf5CufgbL5RzKPrfIafKQKBgQDlpx8DoETRPE7FyZJg9xiUTyZmI/P6RmhCO86knbQa4hEWiCuEIiOheJQxdcW6yCNImbJNSEFUnpweiHEw4xdMmlpR4JDkvsGOyjLI6Y36Yxbi+AipvTuYZ/La7fuOeEjwD7OlgJmva2jEQL6GlhmTibgt5dfwzOiAP0gC4tXomwKBgQDAnZDSLfeSADV9LU0vz3mtEYxWOkw52OSbjWdmdd7ricHESnUOc3VDe9zJHLmnCBFHEE91im5zWfUoi8BVzT7LOIKsEpaseMjuJWUt4K2Rf2ygkuFPSnvn1SHQ4R9m8tGAy19a1upOJM9bKs1qe1ga2tBfc3havOtdpfVwFVtL2QKBgDFsPehx3V2KNQmrz6y+gLOqNQFWS3NZI6bdaCNVLSV78WF//J17G1/sqzfZuKvx1mYRbaXkHusvFzoa8wEqXiFGNpnYUlZoFw+7xCIo4T05hftilbqx1tl9xW4IOVL33/qJ5od/nZN68hkKNfaQ5wAxa0m1ZTuVXZP8CmtUleRxAoGAQcz+GcrzLybY8EMOhYRbb79H8tQ+SoFkTOmJV4ZQDxzg18dPd8+U3YaMp3QngxncOSpjSwsuqpw/SqxHBQE/v91uEzLfPPS2QJ5COBvXM2Y7PsSmMnukIOM0NrtU8MIonv+l7UsHDeCllqe5+uRPpBUUk2mljPVprXo0SDjQr1U=';

  /// AES key for `@alice🛠`
  static const String _aesKey = 'vR+w/lx9qitj/W2+SfFxbjeRM8VdaYGsxG6lxYCVQ0w=';

  static const String _apkamSymmetricKey =
      'L3czUyrn44iOhBIYMkoNkLfriNeXcWwOH6PDHugBTY0=';
}

/// All keys class for `@ashish🛠`
class AshishKeys {
  /// CRAM key for `@ashish🛠`
  static const String _cramKey =
      'feacb0894de2d9476e903be2164b01194dcce1490acf6d588400ef469cdd6eb1027e2baae02acd820c3a4727905f3e4866572714fe554aa2284ec8bdced0d767';

  /// PKAM private key for `@ashish🛠`
  static const String _pkamPrivateKey =
      'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCcREINL3XrjroiefgN+yPrKWjwYq7n5JLsheT0dWdvE+s37wjgSVPYKJ3KIFXzGAYQguxBBig+g79qn08KaX06xHDe/m0wwwO1Y3592t8/25YRrBL7feu50X8b2XP9cezJwrdpzSDdnWvfG62ZM16Xrr5j+qR+5tCbDsN0loMuE3F9Nbt8Vf8KsNfIGzkrr12WJM87WPuksBGFJA7Yyq/F+iaXu6vLdB2fI9jiYa3kRlVWsFymdewhp1wtvD2Q+Or932dUJPoJ/Fz3JV4YLvrCN9j2MaBCGoC6smW6LY7qwEwUHLAvIVfl/c+Qz+pCmowT3zlSDss21IM7F2vmVOUnAgMBAAECggEAYptj/sQDKih/ZkAG+nOOf9c6o+3xpt0CpYP8LRJkuaAdHseUl0tOQCmpICH1epefRA4JnSKQhJpIULTEgLJ+VnYdL2nnZwy4K17kM/DITZh4AyDNPauA81myVtWKLtUT8WEQsg/B/HZY2omxqunSd+7Jr3c7E+T8n8vaJJjRoGGgtMIIuzxTR/Y16hT7va6PkjnrK/nAgVtzSbuamfHT7pB/vgyGWSkL8DAxCw3T+ot6U1YNHEOHNs2f8/TWI1ltiTeeoQiSjHPQXHDOJyrjYqs1tEne21k8NhbVUPRpe+U1YZR3r4Co2GcLwZS6aBvkBEeXMwNu4OC3rupgsz8+mQKBgQDeYBquzP+CYbLXn2Cdy9Lldp5fAm68lqSpZ8ScWlxnogZusDwTWwlPNyOjNU339NTdMuweJLEsBYVe7dMpdvgEal/Dx97NXlDBpsYgd3bmQtaJtgruFSMY1ko5fvYo5PmIPzX9fZ6Vm9ESkuuGppK6WqeAC0Y57FpsFy2zM1M5lQKBgQCz5SjIZeO4wo+wr6jcRPy7RUucBPXU4mDg38FWsJgnXdW7C6qtcd0BHzh6ZKOMYjoqejF5ukN08GF1vxqbRzBxY8U4BLFeTeW6hh1+/DYkZaMcNV00+B6Ga7hyNTN7ySgcqe9pjh5hioYNDA10pW6IvrX9lsVJj9w/Hpnv4cZMywKBgQCjo+8ewQYpiQGVgNgVZp9Mcoy6d8zLhMOpUg4xzKEBNg8rtw6OY8im/XmBKcG1fPqDyGxPBktGjM2HfNWORtjeTvUn2lYPpJ8i0josPB1H9tlvP4Itj2pjZZX7V32HvHAQHgv5/U4M5DvnQiyFyuBguENYi3NjPpWPw0LDAzr0PQKBgQCei4Wg8GN9b0OyRW4+CzLuXUkgzSJXp9gX+DvuCh9e+o0ml0aqLCLKHVjqTY3yaJO44g5+qNFQ25YZbv6lAV3JYVPsZf5oDaE8/Xw7cU7KTyUs9D8cMty8PW3GgerI2uVWNdLBpbZS4wH3t7qYJkC/lczRHTLs/TPwESk8SDA7dwKBgQDWGislMMXlgzsk9HohJiikfT0Adbhi5nfGViQ6YubTdjhJtlph7UH+/jPkaHJNifffteLw2zHF7AFnvqdtTJ8kS2kAIZHIjlZ4ZXj8JzkgXoC+Kn4S2zwfH0e2zEVhBUCabT/myiRC15UJMUeb2LZW1cwp/Tx/EQBa4pCalGAKHQ==';

  /// PKAM public key for `@ashish🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnERCDS916466Inn4Dfsj6ylo8GKu5+SS7IXk9HVnbxPrN+8I4ElT2CidyiBV8xgGEILsQQYoPoO/ap9PCml9OsRw3v5tMMMDtWN+fdrfP9uWEawS+33rudF/G9lz/XHsycK3ac0g3Z1r3xutmTNel66+Y/qkfubQmw7DdJaDLhNxfTW7fFX/CrDXyBs5K69dliTPO1j7pLARhSQO2Mqvxfoml7ury3QdnyPY4mGt5EZVVrBcpnXsIadcLbw9kPjq/d9nVCT6Cfxc9yVeGC76wjfY9jGgQhqAurJlui2O6sBMFBywLyFX5f3PkM/qQpqME985Ug7LNtSDOxdr5lTlJwIDAQAB';

  /// Public Encryption key for `@ashish🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAkvpV9qxUuXyrwSjqWOPV3lJK8Zr2Zrj5XQzB28wnhl+EDyv9MpvdqSDNHNsmBp+/2AnYt6Zjadx1SoOz5YKZxxa3xsC4KR2mr093mt7wGjB6nfA8GswffDdpCAKZKnHfz0yVJ3huGu1NLwm0sf1FbZkgOMKb8ddYI8d3jJtdTsiE6rLoDvklkHT7mxabq2yqW4qSvhLn2KxhMNR4gHKiW6iE5a404mwNhPGTxvYhBf3AKPihZ7WibGxACjXtDxed2A4ZoZAAMpIrL1nXraEuOtHdC+GEuLj9wBbRMOw9UFjFjpvYvvPJC9uLVo2Oeu0eY7wjmQn44C8B9ac4PBFCywIDAQAB';

  /// Private Encryption key for `@ashish🛠`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCS+lX2rFS5fKvBKOpY49XeUkrxmvZmuPldDMHbzCeGX4QPK/0ym92pIM0c2yYGn7/YCdi3pmNp3HVKg7PlgpnHFrfGwLgpHaavT3ea3vAaMHqd8DwazB98N2kIApkqcd/PTJUneG4a7U0vCbSx/UVtmSA4wpvx11gjx3eMm11OyITqsugO+SWQdPubFpurbKpbipK+EufYrGEw1HiAcqJbqITlrjTibA2E8ZPG9iEF/cAo+KFntaJsbEAKNe0PF53YDhmhkAAykisvWdetoS460d0L4YS4uP3AFtEw7D1QWMWOm9i+88kL24tWjY567R5jvCOZCfjgLwH1pzg8EULLAgMBAAECggEAT6e4ew1+hWBZvT+tcitYNzsmPrabH6TUEGffkH2eVibh7U8L1CfBA+4w+5iRjTl6wVzkxPM6IZ9HOfESyCn1qX5YbzD3HeFh+tT4n0h/m9H2Qi52hJdn4Owu0haGaAh7IWAB3fhYw+Mj14BNG8GFpRY97kUaOwFYVVu/IMb61LzlFyR3cwhltJ8GNWsEOAKaOfGojkHyd4/y9ZMzgDGkACq82DJsmtqW1XcqOxjQqe3U1b/pSn3NYjUrdXvHhhMmGeANZDPjwXObX73/hTVDkdSKv+662tuj8NJateQKnUCPHm9tTbK80IUrhcxEuq6WrvH6iuvPISruJ+7/k/qkgQKBgQDt4BqmFUdIwPo5YDOOb4vDmxTFga3tcfWXl/RWu38GkXJCvB8SpQ/NfyuXyNNemqIBiEKXZNY7qtkjTYdjtu9X0TmDwRiKopVh2DCZ348QjngOhIQQy+T2mj/HLRkCa5Nj3ntWS1ORkwDsZv+tlMjFW9PgkhMdTYjnFlYJHsCdqwKBgQCeLTkrrbpGlQGQXVSaYWGKiJ3M4/t0FWxuFA1uZAA/0ndv0rK/fHYrwR0ZBemXI7YM7y6k0D0O2h6rID0jmk3PPOLrYtfW+Iuxbihs0ZjKsPovtnpOctBuyjqm1h+ZKO6iosZJW/hcspKaIOYnT35NqR9U6Pay4tNuarCLVgmPYQKBgQCzUJtmFWY+DtLRi5Zxyd5m3rHCzSXKd3x2ASM8emygC+ZBLkSSLoGCHFpFOis0BocXdpsUOvxP0FONDDWCUnWMEnkzu8z/PN40+t5wMBlNlsgj0XsomjsINnDbeUCAFY3u29jHzVK6y0EH9ADK3fyW4ckPYa4tCbSo1qqWh2sVrwKBgC84lwG4Ko0ZvM7JXhF8ku8Vm+5n/VCJeMZgDCZxijWDco6amyxZTrn/O92Vi0fIrHeuDAG9/QxrB47U4Au57BK7PY9CAee2aZW9qinaZL/WF8qYsmirFBiPHPVjpSlHM/6vk3yhDUM3OFb1DWCc9brfi3AA4G1FFBO5nBzswYvhAoGBAIk7BrTdMPlZ4uDpcvyUVI49tFwqs1rKlOdtQ6Wa8QmcRF3wYSNiFqF2LMT15PZ87s4ru/Rpj89d7FEKMnOSBtLZFt+Fplegv2169l4YS4u4SRVI512otYw6E8J3oCYxakAgotb/CAdpo6GRZjibXwI+TiCC1y004045A0vl/Y27';

  /// AES key for `@ashish🛠`
  static const String _aesKey = 'xGClLauE1qGLredkswXPBKNnUzNiAwG7XL3gv0jQQN4=';

  static const String _apkamSymmetricKey =
      'Ud3CMD14E6DyutUlKBa2kjFj+kPlB3+Hf7CpCiNdDJ4=';
}

/// All keys class for `@barbara🛠`
class BarbaraKeys {
  /// CRAM key for `@barbara🛠`
  static const String _cramKey =
      'b43edaa255f738c763c2c79df4d49a4173b02c132e164b77650383fffe16f045ef8065c2ec05df8f4ae3475e04e83c7c99e96f52de9c4d1a915b67d24f590c99';

  /// PKAM private key for `@barbara🛠`
  static const String _pkamPrivateKey =
      'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDXV0f0gIjSRl/bxXtBJzhii3TJfFWJIeVetrsnXBWcjMD0l0oCauwsNcMyOyDic0dnHeEdGFLBgubI45y81wLrRoiimylpEJGQVjWxIslqXyU57ht9AIkqpzXcBgfvmt+oIZvqj3/r2h8cbz1gH96D3Nfp5kmhU+BNA8O0VYAeT220zJ0R24cnBCYon/VfLmPmw3Yk/1bVrc+IBwAmVCtRuNh+Z/dlPZ26J38FZXUw9LYQAmW8OHum7gek6ZDu7eYLZu0N7GRBxmRP0hWD2NGAVrGvyg4H51uSFOdfOpHMnQWghyRphnb7pRc+6lZqqSWMvOJkmdvJgoDpa2KAMqBDAgMBAAECggEAdnTB1UL7gMhLpOZ+Rbngb30NUmS93MCznyVf0Gf8T3CyGBo9ERVmM2+jn7cdANSvO48ZLVsa8u4iK/HhX5PbPDdBpEk8P1po6IAz6uwa5hPOs45CusGXssnme9EpfmmwjJloXmBv2vrS0F504bLGQb0zXKxcZo1wPo1Kk6HQ51qBxtLqMKeLcS+5uZ3CAS35oi5I85KNS1DQC9Dv7p/z1KRT9GTMLgLKj0cObBnQv6FhZnL1ZRLZr/jvLVH9O/R9tt+FNCxHni0jxZ2jd+2dmacTb/16SRy4r0cyOe3OBkoSjgsauBTJiPLfQyTtiOf5sp9V5BQ1Ykzy0icfCxCfKQKBgQDtcVNDlIePzTNOE+wgWlSfRZVXcO4reMyJndDWXHLhYxHujjW9yV535xpe2t/xp7f/TO+0wWjIUemAJenPqfny4wb+0bC7FxfT6c7ZeMN3yMzOYVw0Sqd5F/c2N2rcVL1uzJmuMKooy6PkPz6c8xDynzpu9un3yTNKh8YXx2fA9wKBgQDoK8Bo4W7zE/KGZSH1OQA8Xc5TaI0IskiXQMJh49egzWHonpQWcFBkKf/QNQeHLP5b/2Ezn+i2TTWPnFxXdPyEG+AN6Hymr2qdTYZ5v1X80a/e7K8JRs+h+Jf5w0u3AFys4DNb8JbuTcw88nnHKL94dtC1OyB7SudSvDZ/+KeUFQKBgQCkzQY8nqekcIlOhNdb8TZQwawQ38n/FD3qukWLsujtdKSqjbvROSW/VQDhm0rZ4E39/blWHPOMLgZCMo5g2xonsdlWHdZrVHDuXZZ7LK2GwzEbgUnM5Y/tpWupDre1q387mviDhTVlUUo0joz3xGEb9NZK1Ee5+sUF0sz0Div+KwKBgQC0Ybm+QtgW17qoHE8D3WOHg0JYn3Rj+1BW46OitojDkI6vUvWvcVekWtU8CNdueNCu3X3BxE3jxZ0FlPBRqry+T4IGjEi8oLFuwdrnIHdIVAoWY0GjLXcIWsKI9OkQp6FZV1/P4N8DC0LRX3qp98i7aWTCScv0vr93EnAtgR2B+QKBgQCX9Fzau/gYyFzRpsc6q3QwTVIEGCbYatqgp9ygZG6JvsvSXxnTWyydPLE4UJ9enx1wnVnJoNERLT2paeiAPWEw7SdE0wTH4Q2hmiMXgLevYegqMJnii4N4QQ8cc9Up/0CO83dYPAUtsoiEM1xFJOKLYW3/NlPj5zsQW/PjCDTu+g==';

  /// PKAM public key for `@barbara🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA11dH9ICI0kZf28V7QSc4Yot0yXxViSHlXra7J1wVnIzA9JdKAmrsLDXDMjsg4nNHZx3hHRhSwYLmyOOcvNcC60aIopspaRCRkFY1sSLJal8lOe4bfQCJKqc13AYH75rfqCGb6o9/69ofHG89YB/eg9zX6eZJoVPgTQPDtFWAHk9ttMydEduHJwQmKJ/1Xy5j5sN2JP9W1a3PiAcAJlQrUbjYfmf3ZT2duid/BWV1MPS2EAJlvDh7pu4HpOmQ7u3mC2btDexkQcZkT9IVg9jRgFaxr8oOB+dbkhTnXzqRzJ0FoIckaYZ2+6UXPupWaqkljLziZJnbyYKA6WtigDKgQwIDAQAB';

  /// Encryption public key for `@barbara🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyvS3xLWgKuekekE9+D5+MIZ6Xx5Cjn8Xnm9D00xhUNu8/9C5wTgbMPX8XUfMGyOA85ymt9dkDl0BmrN8Rz8MPKpxNB94nRQuMO+0af1Tu2csxdAUZyn14usd0WYaahBhyUw36VKhuyhHoFOEmt2GHCiRiKr4pE3WPX8aod8JiJjzyzvREkQcn8NhxLi9k7ISPDwwp46NkBex10SV+oJ0YEDL1VGJHBdNTKm1q3e3mWorK391oK4gKmJv2zA/pFBdG0NXaPS9DYHRT3486nw6x3jVLybriCQBhfYAZrtUyfsc0tqCDD+YCFcWqhotSz2cA6Oj/Uu4TTHgnaSPc3BNNQIDAQAB';

  /// Encryption private key for `@barbara🛠`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDK9LfEtaAq56R6QT34Pn4whnpfHkKOfxeeb0PTTGFQ27z/0LnBOBsw9fxdR8wbI4DznKa312QOXQGas3xHPww8qnE0H3idFC4w77Rp/VO7ZyzF0BRnKfXi6x3RZhpqEGHJTDfpUqG7KEegU4Sa3YYcKJGIqvikTdY9fxqh3wmImPPLO9ESRByfw2HEuL2TshI8PDCnjo2QF7HXRJX6gnRgQMvVUYkcF01MqbWrd7eZaisrf3WgriAqYm/bMD+kUF0bQ1do9L0NgdFPfjzqfDrHeNUvJuuIJAGF9gBmu1TJ+xzS2oIMP5gIVxaqGi1LPZwDo6P9S7hNMeCdpI9zcE01AgMBAAECggEALVmJRpce9vdTtU2mvzWXlNg3t9FXJegYKvrJuQk0JZE0JiVJnHcg/Eu63E0Sum2wfr7eMe4bGWqG1T6N4o2f+l5LdU4i8VZ1C9JECfrlHtbrFjhslrC1lMLcotGhzVljwEsbozMnmF5jwttmogQl11zpSBSMAoqx+IPSO6FOzAqa5ktoUbfKYblVEpYEMFcW3ayedpGmg1gH5pJ0fPE8zI3uMOrJfazjmGnuEJrUjeA1Ju7x3jQZpOQXN6Fd7DWzNm92GIt0Bb+LA258r5uBTgyL2WN9CWRR7L0SglcZo6nr+Ez4o1E2TZeX8twqpV7i7vqWHVlsD4//o5698ts/AQKBgQD8utdGndfd/s/RtKKiaWes/1w3gwqZSOKdo95aGzGHI+FJW1L+UnJ/GrSKLsQH/SuGT9Hky367IAkrM5aUN7Wm1XXyfNJA+PkkCttM85HcqcRkl70s3YlNVdBeDWR0kyCi4dpwM7kVFlCVpgC6oDfO2d/UUZkokCLj5V9rtNrnxQKBgQDNlQCj9UuEdWRx2ysJFUFji9Ski8tmYWKdNfIIasnwSADIEsQck2jJWPMrKcDzot/XSjrNgjfbwgO/GbWu0rQJEB9EwZer0Z8/69+zgvl0rM+/bzeQtaECWNyTC5+HkcPlhOC58YbVMxf1ZnvOzdGzd7TCCURVQ1DfJc2JzxC2sQKBgQDkR+x+F8NN/YVAObaRlz4TkJF+fvpK3P/9PnBw2ZFSLUGonjoICPbtAnVDP9zIDpGK/3xq+rjdU6GUiUOhW/TT3opsXv0XvQxl1vyhtHzzYdFIv5sb9Hu6BCJzYgt0FRVsqy9BHCc4+fAOTGTqLiBa0ogQYyhB8HfjfGNFiZYVtQKBgEt+03xigTgEcD2LkdNFFf07hXxjxe80BiXbgKVsqfnuRzMyCQjBbXK7kpkgPTZ7cp46KTv8/QxbxEpyY5Du2aSWYhU6zrsPQN8VfNIMYBVjvOr9Kbefq6AUB/SMCSqc8gagdHJ0auJyX/MDjqXUWZUBecTj6E8zaEh6Nm/MNcQRAoGBALcJwlkylocU7gZhmlsgVLVzeM1IjX7SevRUukMpWoD0Vn4gpRT6wLzu0vjgVLGnbTozy2EAi6Ing6FSTum6qmTKVxtMviVlgrQas+A8+7J7tEDmRq8sGl9CTwX/w87Ky185pkNSdBecZBXdji1y3gLuj8de0qYf9VECH4fiubAU';

  /// AES key for `@barbara🛠`
  static const String _aesKey = '5fwTqTnFJ6xyhTf9t70seOlbxe2KvqFO5w3UWkPDGac=';

  static const String _apkamSymmetricKey =
      'zWq0K1DX+wM7AizdUsZfRT5Qe4sAy+u+qOwQYxIVcEU=';
}

/// All keys class for `@bob🛠`
class BobKeys {
  /// CRAM key for `@bob🛠`
  static const String _cramKey =
      '33c2df30b79743ff880fc1c832a5c69170974dd736231b84ee360df89a0faff1f6efe0e83064144a7b4e5029334ad1daedc49bf82c0be1f763f590c28e33ba0a';

  /// PKAM private key for `@bob🛠`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCxGGbUHy3bpdMQdvQn5F5dAMEbcDsaYDYsvqYAkjLKGPwgl5pk8gdxU6HnWLaXJDwZd4xRaUDHYToGD+k1xp2SEFjMsxD4PAA9k/hKtddEpaDHEGiC3kOf3VD12BJ3VyFsikZutZtgwF7o5cJCdU5Ppqno5ThChV5I3ZUelfoumqQF1iKnZ3z/NdtWAyFs7HNcuO+bL7ls28CNpVkrPxHbydLL/Y/qqR9xeJ5wm8WnQr5YRVFgYGNi03NlsW0UODkE3mufXAC8ALnQ3W9iQa/pW3QXwMKzuyebF29Jfsx/ELvfnzbgRdlKPNEI++phQyMrvZ67uhSewQnAUrW8+aTfAgMBAAECggEBAInMtf6qgDFgd7phBRyhWze85YXnL2YXpS/t7ReWqwSMqmrl7FJN7bKl494zLmiu3kDmv/19C9XYdqDO8qVQdb15EM+/Kh4t+fXwVIw1sFqPEmqy/s+OCUq0mFGjnsLTvoNJmQJ+N3fyWCea2CyEQLpDsgQxkDRauIG0QVs6UiC+EWaolgYtDvNrXgybjjQyvbdSV5jxuYHvt8uzjyUVDQy22mq9H2S3ztI7KqZYoikoAq+baP5RHqD0CBd7hlZPjEo8+aeQN1WeXKiNQGO6JTfWQRquiGpQkwaVXt7kYPwQ0tYrpOXOT9kCWot+aTMbgyIkUmP44IoxMcsyBzi+PVECgYEA5ErweSkb+DGBKSDOcWJDhsfS6jLTu8fe1Y7h9TtRR4436GzpEPFQPd4192e96oe/IjibWQiIqm4KIwXPw7clXMhOtFpMu5935cJfzWkSaa+m9lHRmn/ire52J13KZc7eYpYQiSXue2aKVLQhG1VDXePO+N6M9gR5Mz52IokFzukCgYEAxpbB6mEbk3//hLNknZGj/WTFQV3FNG43sIn9KZckdBV+9sczAetKNvjScuX4ceNG7XyCnVCl9qmz0+TAGmWfnGB/u4EHyRc5iNNo3q/DVRhUPHeOpSdQw+VOEMN47HELdqzOrK0q4BbSJlFdsHjL0P/oFDWVeY0sqghBb8/4SIcCgYB5gU1GH1QsoCSPgE+AV317QeWHEvBQlIuMfJTVEfIrtI0bHsRZaSZ9F0T/3e5d4kwfaaN9GqaqlxC8HT68e0DehholsZ3/ilulJPQaft728y9ZEKkPoxtB2ZZ3U1sDHryMGjTI2jB461WayZiJVLMbSMGDAehilHTxikAUF3vI6QKBgQCU7WInXwPLLeZ1ogMGl74fvX6gcq39j9p7rkAI/Kv90lEQyHpcKhPR/e/08rnKzuLWHtXlHCIaRVHyyk22fhegsk2YVD9+cshW8BRpS+501nX1ksOK310WS9SrhawdxPkP2rBzlrncq8CVs9dLDIvtBL0KytR5/4FLUj2gmJpd6QKBgGNLjdysAYCd0GVVe7kKTuBks12jrMWbJqYq35NRTnKt3qYPe8Xuzy5WETDMWtWleIfXpbb+NEIQJ7ifs3dAJZ6/s/jo/tRawS8Hpa6j2oeGFcvCiI9rukd0gXuUDD2d0//RHxyJXpraE+5wx7JhAFm2opZOez98BgRoo0hISwAj';

  /// PKAM public key for `@bob🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsRhm1B8t26XTEHb0J+ReXQDBG3A7GmA2LL6mAJIyyhj8IJeaZPIHcVOh51i2lyQ8GXeMUWlAx2E6Bg/pNcadkhBYzLMQ+DwAPZP4SrXXRKWgxxBogt5Dn91Q9dgSd1chbIpGbrWbYMBe6OXCQnVOT6ap6OU4QoVeSN2VHpX6LpqkBdYip2d8/zXbVgMhbOxzXLjvmy+5bNvAjaVZKz8R28nSy/2P6qkfcXiecJvFp0K+WEVRYGBjYtNzZbFtFDg5BN5rn1wAvAC50N1vYkGv6Vt0F8DCs7snmxdvSX7MfxC735824EXZSjzRCPvqYUMjK72eu7oUnsEJwFK1vPmk3wIDAQAB';

  /// Public Encryption key for `@bob🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAne3nQ++AIaeL/JWNDmZhJFY/iV7ZMAunsHcfTOH7G6cVnl6tssqKuune5jHcPdoq1JdzNj0O/tP00+CFeiKROEPwXLeVbyNdZ+AWjO7dUCHf9q9TX6rE/6WVzcVptyD7q4RIBSijOjJiduE32QD1iqckQ8lKa4HmNJoe4a1IaiyqEFyD8sZyiqTHI2GK7qHiHoIH32YkP/c60xvE7rZ8uS0fqr7yoq7fcLCiPZk44OCLBjSx+wPwlqfDaq4ogyeamte1mIePPPLjQCDPyLvktAotXNtOkZ2KzYBr7A/GFbYT39OFM2QmE22mVfmEniBhrDRhhFTvsIXuxSRE9UAVFwIDAQAB';

  /// Private Encryption key for `@bob🛠`
  static const String _encryptionPrivateKey =
      'MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCd7edD74Ahp4v8lY0OZmEkVj+JXtkwC6ewdx9M4fsbpxWeXq2yyoq66d7mMdw92irUl3M2PQ7+0/TT4IV6IpE4Q/Bct5VvI11n4BaM7t1QId/2r1NfqsT/pZXNxWm3IPurhEgFKKM6MmJ24TfZAPWKpyRDyUprgeY0mh7hrUhqLKoQXIPyxnKKpMcjYYruoeIeggffZiQ/9zrTG8Tutny5LR+qvvKirt9wsKI9mTjg4IsGNLH7A/CWp8NqriiDJ5qa17WYh4888uNAIM/Iu+S0Ci1c206RnYrNgGvsD8YVthPf04UzZCYTbaZV+YSeIGGsNGGEVO+whe7FJET1QBUXAgMBAAECggEAWtxJxqsfM72aa1p7SgKa9vXsHhOErwC1nHAcgPYuq00owfHEy219/WWaSSP8i1VeeOsdbOIaI4A8hj3RbWA/3ngv7JfukH9vONkTAEhY6cZjfSCHvi2Yo2BX3IgsdyCxyo8ThGxJ5KyiO7T9lYrYucnJsno3p7yXfkIBbGNumy5lzmxnB9tUpteu/742/kebuyKO9zX/ssjjn1Fg4WrxMRtBGt8sRe6m1Gv1NOS0DxhII52ElFSCX66fQeA5JR3bwNpqAhBpUZbbbigqk5VARpGObWZCUh8dJjpsF5BUl1NOrOVYgQ/7uxukDmZ6O/iTN/7u1WvdiB13JbSNNuMqeQKBgQDyTQeADnCBkY8KwV3hZeQo9gXrdTbv5IOmvxjpoT8+bSgTYMq6U8VCdV8PDEhH8m3UF8SA7a7B97IxQRTHLvYhxK3Kn8zKiFyNnPqwQYpmkciUA2KqSqIT4cW1VaYK4o1K8shcqDCDxBa4oI9jz7lx5hr7SvgmKrDkcAevINJ5XQKBgQCm27ZCRAnsCue7H7g9Katz2GnmlrsalCraUI23FqloPhIp+o4aqFaWTOBM9mkgNxnMCnKNlMNn2wUH+mpQnFbIDxtH0MGyqmNdf9+G9/ZPJQHU4ypcLukOZLOhKqc3Y8zjZ2CoDjdiHTW0xyplqa99DAKbopNLRW7uNz1b5fu9AwKBgCHflu7WFfBnMwIj6kX6gp0fV9CFAHslDSqgiJEQ09CcXf/nhi/qSidyVSm7Y9d7EtOVxwjnMYk4YZb1LDx0WkB6SHmNQYoG6jl5+qntX7XbJ5lZp896w5HX/FXPdXkMFwilTFF3yeCB51NETwd7IMfFjXwYDPz49uXYq5pWElaZAoGAeLeAVtTOsNz65iB+tJFPH5K0m0T1vLbxgdzBinJ0wZwWnBRPdu3PJxIbPNMRH2N94Ga2lcPI03xbWXhMLmHNTxPO0tgvKsmm9eAroYQHyR6nApQO835k0ir84l7vd11WwDbscOlIHE2xq0ZkYASxl7B2uo6WLeDf7qw8Uh5DUG0CgYAnSWae63GKBQxUQ5M9ILL9XPzfsOweZ+EaWjz/CgibdGf1EmUXErcKJaRUvGzsIkJlL907tr2FDhNB4eB+5uORrZtTNxP1Gz4EH0ORYNDa2sAlQ+ma8ruMXuOuEgL8W2/k8Buf/tG9TL6FACDuN1Rj1aLFkjk0bGM5oztwOtxzyg==';

  /// AES key for `@bob🛠`
  static const String _aesKey = 'TZHYMVJoAroWr+Yf/gPN9RNC63qvCRKXiBhWDj5un4E=';

  static const String _apkamSymmetricKey =
      '8QHaELcv0QBSBLTc/dpNHenbuZeT95+0GDwq3Lugbt8=';
}

/// All keys class for `@colin🛠`
class ColinKeys {
  /// CRAM key for `@colin🛠`
  static const String _cramKey =
      '540f1b5fa05b40a58ea7ef82d3cfcde9bb72db8baf4bc863f552f82695837b9fee631f773ab3e34dde05b51e900220e6ae6f7240ec9fc1d967252e1aea4064ba';

  /// PKAM private key for `@colin🛠`
  static const String _pkamPrivateKey =
      'MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDtDpsY3qjwDIgmMc+rU4EWoJqOlfgEJrBhoZM7N/Asp/N/tkcbDjWHTEVwmpstoWNw8JiMFOUuN/U2RFyaU764zABWLzNT4k17qCPPMj8VBEIIj8z9SGR4HXVhZXHCezrtjKvwnp3fK2hU1tEQMeDbmHTLZYAcEOwj/rQw8jzXSnRPEuzfNM02gSBVJ2JJG9J3qksRL3EB1hgPc4BpQQZQsu6/poyYN7G25LIcD3fIWpesfTGAkTNb4SkTlm5QC1CmAyUXvRWGuYpq7HOy2XwZvJOrJzGQ+5kjGA75oWZh0otn+TlVrhRb4ShPPMu11c8CvqvGwV/03LNoomZ4WpsRAgMBAAECggEARyNx8cWn5tmr5eJe0qgtfe/WUeG5Wu2NUs8dEtFXlt8T2IiH0Bu0fpSp5f/Pf6MF53ecH7WJjRQn1xAuxfVJr8UweKyTd6Ha5LfxfxUyDwmHE3Cr8HpQBCe6+O5rdBRs+6qSUpQXBkjNd2A7vuNo+h1HN16PUlzVsHuX8XRQQ761OXBBLMOorFPLgcLM3lrzdPwul9hrkuy7pnCKQeREypLPNdw5d5RrFL195IN/f1mxlOds8Bkw1Qsd5h0/dwP8iRetABquDbHWo8LAw2E+B7EycyFRkALDfD6f8kGdo0JC00ODdlzsaS16LZXUxzHpHEYyZAzZxyBeTEsj+WH/wQKBgQD+J/WTeTxjoM2R2IuKjjCVeHB8AWD1KKL/bQt/9TPg/Wdw3rvnbSKcgGoysVRdhQ6l9Ni1Xapd534QaoqaszCuj4r6/iJWo8jUpVml8C0V6Zg4GYjfmiDTM+pJeEZ5670wj6gOsKt7vYVlqa1A95HAFhTecBEYGefcmawvp19MGQKBgQDuxuOFWwaEUkFw6ySP7YfA/MiK8eGFlJjx1EwBuS0lIdYmEnCH722dMk5CNlIICps3i1i0HU2GEAQJMYZRyx9ksyl6JIrto0A2PTSA9cOW8xcyKImTVHrLXLaP02sXglwI29prJOGnXX9elhjCdFkQNfGHVNmfwe+0eYb7kgUluQKBgD0nLj66yB4Mvgneucyv497DKQWda0/x5C5jdYXnYQE819vfrATGTLKtb2AdLPiHoHusC0ywaeLIZZvbltgcT5Vg8obsCSUhqZwI4SY9QQvptfehpT5wHn/TGQduij6hy1bY6g4G0mwmsOdCSW69YvN+HK1c96/9470/uJ+KvTJZAoGATUA1jgiEFD1UhMbevl335L0j2Kgm8YPA88RejtQtQe0vjoO6upAA47HJ1ewjIAzmaNMBcMxmL3BxDdRjA4V286pvSeAWvolpleK5YNuiWuzs3UJ2OB9F1xN40RFyfVmkkw0mHjIBe5dpRN3ExuzDf9Yj/Ue7XM9u0PHcdPmqBqkCgYBnmRxijc63kSWE1EOOlFQK3TGGII87MOvpI5t7Cs86AMmAVTS3MhJgInxLWRExF5A4Boowbu5ShbaVwIjvJLm+jyJWzEkjifmkEVDvjjNzXyR89Cn40RB2vxOUUJlT+BIT0kRPpn9StZcmXOEJDxdSoig+5XfclVTbyp1M4NNP7g==';

  /// PKAM public key for `@colin🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA7Q6bGN6o8AyIJjHPq1OBFqCajpX4BCawYaGTOzfwLKfzf7ZHGw41h0xFcJqbLaFjcPCYjBTlLjf1NkRcmlO+uMwAVi8zU+JNe6gjzzI/FQRCCI/M/UhkeB11YWVxwns67Yyr8J6d3ytoVNbREDHg25h0y2WAHBDsI/60MPI810p0TxLs3zTNNoEgVSdiSRvSd6pLES9xAdYYD3OAaUEGULLuv6aMmDextuSyHA93yFqXrH0xgJEzW+EpE5ZuUAtQpgMlF70VhrmKauxzstl8GbyTqycxkPuZIxgO+aFmYdKLZ/k5Va4UW+EoTzzLtdXPAr6rxsFf9NyzaKJmeFqbEQIDAQAB';

  /// Public Encryption Key for `@colin🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApLQ+CrLLF4Ndp7PKgZ+oRfzL8zJkiu4VXT7z8e5nsM7cUWOZ1f0Az2ct4FyF981NtN1pkf/4Vk3X5OMF2vmEKWzhxuocTYx+X19lbLnZkvYD+SEwKhf6BRfH0vREeKtijmPF/jCB0bKZ0Vffld4kz5F+PBmc93C6XeIm/T+n1ojKrQpDIwgIoPVa1OiP4Xx1prLsr9W2UbrH/h5F2+lsK5HwM35o64h4BXX3IdATYL8TQPCM47Tt1FiP1eMUim/81wO+18SeQJRqqPpm6FBnhfEGFELzBCsXJAn6eP+jKkpAobqviUD7HdxSYlhCROT+CuVXqbtu53YBXB/puvMNcQIDAQAB';

  /// Private Encryption Key for `@colin🛠`
  static const String _encryptionPrivateKey =
      'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCktD4KsssXg12ns8qBn6hF/MvzMmSK7hVdPvPx7mewztxRY5nV/QDPZy3gXIX3zU203WmR//hWTdfk4wXa+YQpbOHG6hxNjH5fX2VsudmS9gP5ITAqF/oFF8fS9ER4q2KOY8X+MIHRspnRV9+V3iTPkX48GZz3cLpd4ib9P6fWiMqtCkMjCAig9VrU6I/hfHWmsuyv1bZRusf+HkXb6WwrkfAzfmjriHgFdfch0BNgvxNA8IzjtO3UWI/V4xSKb/zXA77XxJ5AlGqo+mboUGeF8QYUQvMEKxckCfp4/6MqSkChuq+JQPsd3FJiWEJE5P4K5Vepu27ndgFcH+m68w1xAgMBAAECggEBAICPXDoXkyUYWfs0AGari7qNd1iuRgKXkj+Fiv6Vu4QsA5bX6tU4NfCuNgYB0mQ5cWUyylu29E3RVyqG9iQVTU7UeWs9g7gYaO/i05VJgAYRV8qXWDQTIQnmpQgJuISEKlrAkGQ30q0u/peEQraFfjAy/djFmVsfN6lehFZ64HQ4c4NgXqDRlwkvmEuLiLCZyy2APlu05kjlyiQEziwFVKhmbI2dglQxTtIbEfP7aUsGxLkiw6lTGRJ2lMYMjTtXqD6PQ5YXurV20z8Z4sRt4JuWUucaUArRkniH74SBj94dPo56WDjInbFRibr8J9cNAg8Kl33jJrsP4sL7l1EE5AECgYEAzcfROCf6jRnX5PYEymr5tS6JSb2Wpbjqcz42HTtL13beiVKR/TER/9noLs5eMmXZ/V/PSdRDyk1dWf9vXEr283tDlS7m/E6HzW0nUXCEEaT/ySS417xSEtyXKWX0qH2Q+SoY4GF+D/pnMGa95ZozXi/GQd8VCPwtdcRAUWQ7xEECgYEAzOYqC3Csycw2cKKnE6p+eBv8CYG0xfjsQqopvEIOD7SPbOx5LgfXtG5X1G5r9lYuBpyJhkyJbuK9GXrI6w7hcgTxGZqOfTE2TWJFzisxUGQ7qn6vKI05wqLJaFXKiSLzvLjFElqOjhtoyWHg4Ty86zeIzi0fkk/g8zrhQpH/PTECgYEAqrBZCeSXflz2aLPsy14qnK/qLuF0ySf2SPtMdbjOsv2ln3B/Ke5/CKNeZRzGo7U6OWI0lf/c7zx294TagUqpRtNy/pa2AIi/OpWU7IeQ9PXROa4dKM3LoluZgzxP0Ua+bv8NPWmA4I4K8+n1EDN08mZcZB0/3IEY0DumQh0LOkECgYAtR9QU0SKuOd3yCE/p7ayjOHP7WdmsQnVbyiUNAIABAoMLrDqfbIZDznrEbF6ZgrQLK/7MWg+pHJxzjAnowFIcE3GAmgJRMlXwxf3tMOhl/rCc3gAxcvxHwhfGYecvZTT+CMssYizMxMvkbSf4Pqb1SEGIZrpqaBKrTeDICGGikQKBgQCWnbibJXLkPfNy0q5aRKqyePBaiO56ZHaObuXBZ0qLjsVleLYx/jGJSz1cCHBinUUwDkOseZqt6JZkd7psadtesW+829iw7YZYokmmjUQ6P9oeVxcVfw5fgCBWoQ4VZpK2h3hF6pFm55xxHAF0KTjRnGLiaZ+NolDap6h43RTNTg==';

  /// AES key for `@colin🛠`
  static const String _aesKey = 'wQjp3HXO5cIsIR7lL74ySwtjJ7VP3OLBJKsLiLuRFcM=';

  static const String _apkamSymmetricKey =
      'xpmA6M/9K5bDEpJPGwH5gk3B+aLeReLJXSuIRq3jL70=';
}

/// All the keys for `@egbiometric🛠`
class EgBiometricKeys {
  /// CRAM key for `egbiometric🛠`
  static const String _cramKey =
      'LsAi8y2qXh6SJwl2C3LIuuZUo3SiZ8fNAH6b7FvUmimShvOu-nSMhYrFEZGeoIf2rNu148AD7QNCD5GJjHWe7FuLW4Q0xvhmw8uvONlipE3VxCVDj8AyQiS6lyn6SPTi-GnNlDTO10d-4aEMKyHXin';

  /// PKAM private key for `@egbiometric🛠`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDTowSZhDyOBal4RV/BhoskrgEEvGKfVYqYm3K4CNXZgkUmoS2BeqdPKTs+qGrSrp8VDzVgY5nJfsGiF+VQjrsYZXgXC1R00XVXEyduy7ElZH7jbck7h40R2rvX+fnMZxHeicy2yCUgpPnp/yiVLSBEzfGs235VF+mgAY0LEQu7RAACYjWnXc310RwqvJK7xR4O0a8/f4UyVf7kre2AhJmkl9y5t1+v82oJWOVdC30Ef7scL6RPkFFUmqpZkA9XVAyi0Mbr9w5HoQLlPpSkrMzLiP6fbTRqWcAaA4E9ucQNvEOECM55xJYb4kwcr2eXYUMXL2xlLRJrROx15CS1jK8XAgMBAAECggEAQ28D/i5mZRJkx0/DjRRjrZJL/MhR3FcTTEDrsrwN97pMclyU9VaxjMWkfPiI4QyG39zysv3JeKyM4isfBCYWc1WRiDYx+O7spowR2nnIvhNhYvIOVouAZZn+lHiwIXMN/IyH0A3B1r76apbExZOVXpcIVH2zqUVvSW51FHuf81DJIH/JOrU+OyrFd3FwsFpBCurJaZMBEaBDtMtvOzzOB/ySIW2XPzLuRbmJlfIwzwmMS62cMUKQ91Q036kwfc30dqiMiU3jdYHVN2wwzkGQUB6ehqv7y8EQRaf5y598XfSuFVTp9NaqEtIw6Ja6px0u6tcnri/TWafQCMGFzdSyYQKBgQDrTR0omHfqy1eyQ4vcOlTvuOAve0wUaHI1o6GIxgrStcjqTrP1GBm9KHprjZT0A38Uzs3b+7eGhkKDwebwEmhjG0yj5T2s0e9p0KD2USxFjdZAvQWz7y8pAqFo5AsIe0FA1AG4lw2i12xQrU2BGPttdAmJd45NkX3y0KmmcLixKQKBgQDmQP2hnHBVRWIvyoRLrhmKC8B1JTdnnGQmXPxbn60g1VN4Hl8I2hK8oso7V9B8MKmdx3yCcEE29ZvkvJwNQqKFA3ImYxsBQXP5OkJbYnQ2gTYa6siQ1pxVDbhCuT2nCEe3g1ejYt3NH2Kj5MhTCkEtu5efVpD+vuo8peuiWAUmPwKBgDBcsyeK3urVTHsJQw/KtXZoCzv3HZX8Oa0oqqTP/517W4Y9EuPHRlMIpNDCUuEsbsw6DTmvrPLrWXR3QB4LyoTEMaZmEZ0ZsRmQleTKnkzVcDnyH9/xw0GslrxWUqY1nx3R9WCZO2ZC3LJgTFPCbLr8ZJFqj0cGJlrn5FafSHaxAoGBAM9x/FCvZhGdOlH+bmTUzVOvNM0WI62onB5oJkDSQqPTLqmJC2wpNTpYnEUM39wT560sPkQyqL7AV5ykRSA5Sbz3Fs/4+CqQctE3KPO2Zyd4EGv93YeIoz6J5tnOlPo5Hov6vGmKuHSG81Lf24/dLE3stjUrQ+UP0m+juQEBtln3AoGBANdhLgT1kvKkDbQxDy4QRTWLEw2sMbI/Rrc/w65HM0JiA8D2CTDZDrw5pztssYP133pvUqsW9V1ItFAjxcSpqRh/pAmmuv0gWxzV9ZSJ6mnWsyzCtL8N60i8ypsWvuf8mtho3uxfPaQqTOpDKESmoG3eD6uZ9m/gFowFypPQ8fq3';

  /// PKAM public key for `@egbiometric🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA06MEmYQ8jgWpeEVfwYaLJK4BBLxin1WKmJtyuAjV2YJFJqEtgXqnTyk7Pqhq0q6fFQ81YGOZyX7BohflUI67GGV4FwtUdNF1VxMnbsuxJWR+423JO4eNEdq71/n5zGcR3onMtsglIKT56f8olS0gRM3xrNt+VRfpoAGNCxELu0QAAmI1p13N9dEcKrySu8UeDtGvP3+FMlX+5K3tgISZpJfcubdfr/NqCVjlXQt9BH+7HC+kT5BRVJqqWZAPV1QMotDG6/cOR6EC5T6UpKzMy4j+n200alnAGgOBPbnEDbxDhAjOecSWG+JMHK9nl2FDFy9sZS0Sa0TsdeQktYyvFwIDAQAB';

  /// Public Encryption key for `@egbiometric🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAk5ZoGT/u2hrIAonTwZZR1K+gkezftNSNKUw+OhHwh2wvnuqlPx1KXDPm1aqDpf+CGDzVOk2qrXZwcljhbficTOGK7A6/jvSOKjc9S/dk/o0Akw1GTjW3yKGkwsxsez56Tgj7s7HKc8NaAP2BGK7+WVCUErkFpp40Yh1rlW9Srl/ka0c1UXqWBaneb0WJ3RTIJ51lDbVxNtuvI/AdofPzvDTeC+tm/+9xkyBhyqLS4DkRnv6SgufLJ0sd2jgsg7V4dWPZzWlPu1WcFI7P6QGeaaCqr/eLMAsKq2kt6nfLBlB1KXMnIzlzdHwF18nQbvh23uBaOY7EmOP5lxwVVatXpQIDAQAB';

  /// Private Encryption key for `@egbiometric🛠`
  static const String _encryptionPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCTlmgZP+7aGsgCidPBllHUr6CR7N+01I0pTD46EfCHbC+e6qU/HUpcM+bVqoOl/4IYPNU6TaqtdnByWOFt+JxM4YrsDr+O9I4qNz1L92T+jQCTDUZONbfIoaTCzGx7PnpOCPuzscpzw1oA/YEYrv5ZUJQSuQWmnjRiHWuVb1KuX+RrRzVRepYFqd5vRYndFMgnnWUNtXE2268j8B2h8/O8NN4L62b/73GTIGHKotLgORGe/pKC58snSx3aOCyDtXh1Y9nNaU+7VZwUjs/pAZ5poKqv94swCwqraS3qd8sGUHUpcycjOXN0fAXXydBu+Hbe4Fo5jsSY4/mXHBVVq1elAgMBAAECggEBAIuENnoQDvoNMR/9LLmnIUo+kDsCQmOOPrdYhMaeaNOL+ORwiq/EP6QzyDYZ0AOfK1tAPo20F/GMsjXWQZyU1SR0XcBTHNDF7JKJz589ijJ8Fpvsg5axfz/hVoBzgOVspW+ZXF99ZZXTiQTAoEY2PuktnByq3WWpznkluKr2JqIBOhwbUdR7ncr4m0p7cmcqmK1+TBGeCbBrhesIKMxzRCxLJgLw/UCv26oG/pgCgfjjAvL+M08IGpBPcWAHzn8pqOvHfc++Eg7592N5mqwG84lFx+INBlr5xE7pXPIB8ZMFNB7PQdl/WUGFYECDk9lJBhxfQt2DDXEQcspp7j2L4mECgYEA8XxZJWeiKJ3D95CatDgmjFhlQv4Dhn+JMWtPpOQM7+rJLMBjJgOur4gu6I6SIU8SVJ5qKDgWeRg5j7lUgPqFHMh5HsgRpUkV+QOtYYRsZdyoq+8E/AcROvaqytMkowSPs1SHqDS1sUXfigxUR9nadhiF1RBAzEJ+yn76OQOJQZ0CgYEAnHVIByVUiSnOdo6kCaDkuvSue/Po7VaQBZJ0HiER6IkB3dbjtdLbQhc6xo5A6GUitLrKfugbV3hkruk+rtVfeyCvok8/J5WmE3JUV4w1MPJRKIjjBUYbabaQLop0pjHuR9eGlvteeIwk8wIXVt51oucdsZdgpL06j7A1oE6z86kCgYBT7UyqRFdGWHZ4PwiVZAJ5umsPGmstPnv28f3PJ/cbFvVuGTscRiFbHjB3YL2G2A1d3WS1r7CXy4SN3/JvlSHYPBBkU1JWqIz7a3zBrJ1j1YnFn5+S2/3wCTSYo0NTaM1snQ88tX0ELG2hc+GCy0My0hkJUMnEc8PPKsxaLlFwvQKBgDrOllEhReH8Vb8YJC3+TJq8xyyN5Bn5NE7z2jNM6MdHX+07DQHVjFYOFyh0ZY80HFRj9SK4KTa6aNWZk9bxGl9UTM+sC6fcRrz+dxck+wU3vyuGMBZWYI1eclkb73ZcRBy6tLrhJoQW4Ph5673aBctCJVYP+OJSwcUqTS3BB0BpAoGAderD3T+fWac6fDvwqktbLo5oEZY8DC5MLs19kbXzRZ3gWl/6Nu+nunUEiP4u9AfYTG/qTjqD9QplD4oL/cWmO99Mb0PmZP+VpvbJw26EwvRp2Xs1wQeXWuvarTYD+zimg/UEC5C1EY/OrNOYYwBgu+70voZF6gqSUT9LWoXiw/E=';

  /// AES key for `@egbiometric🛠`
  static const String _aesKey = '6EI4LavFXYHC/layLd+3ouXNyEUG9gyPk/ji7C3iidA=';

  static const String _apkamSymmetricKey =
      '8XwV3ijbI501guymko92UZeEEFuGhZFSkDhucLWr7Zs=';
}

/// All keys class for `@egcovidlab🛠`
class EgCovidLabKeys {
  /// CRAM key for `@egcovidlab🛠`
  static const String _cramKey =
      'VkBTIoOH8LdgQ3ZZTgwQcCue8r7AkYZIa4iXtkPWQzP2XxZbaok51FkenmTi7VAycS4NhtorLjHyiipenAO6kjaLJ-qyqc-C07rO0QcWIPi5b0jIMo-zyTTFnPQP1nmmSI306ltdKkWu8W6gsmCTqq';

  /// PKAM private key for `@egcovidlab🛠`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC7SETW3urPyVD7QFdK/qNC3jM65mnY55Qu/T1uobbMN7SibDKJwn0TtUMh3tJsDz7JRwhN4L23YspJzfV9bugPtjBiJUc4Ujn1EaLKw7A8cXD8wC4bEMk2lrc0V7NBnlu3KwUNKoZmk32XxBPQ+aCWQgxcQZriBo3i8SUCHWXfwouObmIV1FhAgm6iXyBpHM5IWdfAeCpQqG9GFiyioErbzOp1lrGBXKKo2tZYJIfYzbtEcZLdbYmmUgAfqI06C9SEuXjtN+HykMoPJEntPwGtqO85HamJE7mqdqXC0VdJLUi0JW55Y9I+xAoh2HI0mfVtLEDxtzL5nD6lEfsRzTOFAgMBAAECggEALwaOgoWm4FXkh7I4ORSHWhsBMiD5IwXDJ6le65Cfnde++6m/Zuf3ECPLn42buJZ7ZX74jtWHzax4rt+QbNaUXp2YuIwzveintOmgvtk0P3kcrdpzuUgVvidKCVKcKDXjQbMDqbKr3MXcG2eYsjh8Ij6ja+btRSPwLLPwXv+SvQRlb4HtV2wfxC/mVxFMc5qpr4x9abQk8KQXoDszq9sseEFzhOnuvcmLCrPq1PCRzt62h37mBWnGLg2awExz8kg9xX7HGlxb3GoZ/7xJYhLhDD69LcPAUYvUrq8zjn+rlpROotXsNpAUVchNWSzyv2DsQXSnmuVHLarGZH1peGOmAQKBgQD9olJKPiPO6JwZxuwBG6Oq/sWvFFELnMMTMrxkF+2C2ddrIyKqpiPOx2FefGBY80bfbDcoGq5il/FESkg36pkDLpYq42hYTdAaM32jMGrNyofANj8P6OWWrd10snlbNrgCR8XVel4gad83wAb/cTpPVh/7AVDti79b7OJi/qXS8QKBgQC9B3/UPlcxGe1iz+GU9X+mzMfaqyIJ2DhdoE/kD4H9l/UQtW7eCkLFYM5iMLcCuXZY0srSPRZWmZT904WaZsfRfwMf2Tha1lETw+g4f2hA2A5+V5uMuYEMy4DjcN58aRQ+uHfBn2AggPC4eQ4e0IIwsZrBZ0z5l2ZX111M0J3B1QKBgQDYrrUosj+7Q6QgrX3wUGGZ80CFm5DFn+5UV3L0/DAwKtVLtV+ndHqA7Hr10sIpG+U/eN8CRxEWMAKxudhK1QRV4JXwHAmH7ypLSBQct393QoCJKI7lk62Y9f6M9PCSiYPYhuKvx3Pksy49HbOcxWnwX37A3NX7qvkXmp+pvS2DsQKBgBFtUZGltbAnLcWAWNG82GnuUzaLtHWn43puPy9NZrSUf9lsgK4j0AgWZrCSwSyVIJ4LwPsk+pw9SIkmKRkVBLMBvK4A/rsRKyRhWVVsGZZw1NU9CnAs4gLl+Bn/2+MoZN9rbk8BfIFCoe6/6ldY7cfDd/sApQ4VsS/EASwFx6WJAoGBAMX4otq//s+stoEutpjNI0MCX3aVNGyov5zd2LbDphSNGbPE5q0eQIAYKf6MVRVBFt5GRQVvNOrf1IteGmlDkMgH9mcZa1xpbyS2plcSV4nwe1XxnideHJ1QA6p5TTwtgKpoB0BgfSkxLjfXZwdr+KR97Ieq2Pjl66rVNGgUrRNT';

  /// PKAM public key for `@egcovidlab🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAu0hE1t7qz8lQ+0BXSv6jQt4zOuZp2OeULv09bqG2zDe0omwyicJ9E7VDId7SbA8+yUcITeC9t2LKSc31fW7oD7YwYiVHOFI59RGiysOwPHFw/MAuGxDJNpa3NFezQZ5btysFDSqGZpN9l8QT0PmglkIMXEGa4gaN4vElAh1l38KLjm5iFdRYQIJuol8gaRzOSFnXwHgqUKhvRhYsoqBK28zqdZaxgVyiqNrWWCSH2M27RHGS3W2JplIAH6iNOgvUhLl47Tfh8pDKDyRJ7T8BrajvOR2piRO5qnalwtFXSS1ItCVueWPSPsQKIdhyNJn1bSxA8bcy+Zw+pRH7Ec0zhQIDAQAB';

  /// Public Encryption Key for `@egcovidlab🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA9erwjxVQ+vthdivKZO8mTSvpQuEWj4/ajg+rMQoJznhR97A3fEoepCmgNEFTsIczrN0F44M2usZXo+eDqSq2ir+GaEC2L8jDr3sZSKGrM88PcHDTgEAdGzKvooIrHnZetO+vIbAK2Ju8JicenDdJ4C7BQXDg99vPXfHVfj1FE7YWJjLPjJDOeHAUGZT9JkaTmWh6BEvBDxTZp2vv9xo//78XgLqAAJuEgCuvI4c5PW0Li1Y35xeGJFSHqZykufHS/9Nql+9Ne7GCHaEXlJehYfNpq9aHtR7kiKd8rDKp2erqrZbTlOmjoRtsfbZZFrwssG3DtF8S5E1JwyMKi7OrSQIDAQAB';

  /// Private Encryption Key for `@egcovidlab🛠`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQD16vCPFVD6+2F2K8pk7yZNK+lC4RaPj9qOD6sxCgnOeFH3sDd8Sh6kKaA0QVOwhzOs3QXjgza6xlej54OpKraKv4ZoQLYvyMOvexlIoaszzw9wcNOAQB0bMq+igisedl60768hsArYm7wmJx6cN0ngLsFBcOD3289d8dV+PUUTthYmMs+MkM54cBQZlP0mRpOZaHoES8EPFNmna+/3Gj//vxeAuoAAm4SAK68jhzk9bQuLVjfnF4YkVIepnKS58dL/02qX7017sYIdoReUl6Fh82mr1oe1HuSIp3ysMqnZ6uqtltOU6aOhG2x9tlkWvCywbcO0XxLkTUnDIwqLs6tJAgMBAAECggEBANhpuu2QKsXUt35RJzoQI7rCK/MJNtt8Ey/1pgfv95VV2XyJ/SpJ6BE7+JpD6yxsrxMvJuGDNYTEy5eYRAt5ZU9RIS1Z1XrTyTICuMtsSse7LrEa+WXiBjtLLblrqBqUvN+qFosk60aYNsm0n4GGPmMlgjje53v4WtMn4WPI86NVXxKGJlGIg4P3PWmRcM+2tliwGDDOilo/5u7MocLzMf/sudyHGSHgzEEPK53tf24FoCZsOrXmvcSe9Q7M52F9c8P6JTmUqdJFWl2NHoQySFntxhMIOWKvwHi76J8cVIP/tF34O7VfKUKyxyO11uF5ZdM72dKM2UkdX2xFKH7YsCkCgYEA/7X0SyHtQ/9DmnXln5I0SjYJ05bCh47PIV3UXyFin7rP4gpecNCNnzLQMk1h5Zuyj3ZJRV3r9MMFhXW3PoncZc31lgKSh0R9Qg99aMmwoHxuYjlQzjP4pOXT46YCE585LU+KAoNFm9nUCt+ppzSjx6G2ZZrav0Lk21s2pQsVbgMCgYEA9jImUED9qRStYQS/ZYcKmTeXyB0qOLUcKLxF+GbDIsx/zmXnxlEmXIlKtMlSX7dU4ZHExv2+LBBwvpWBEuyVoSzMQavSq3/H/Im3XANZyXSrI96WLn8utCRY7DOhINvNSPDNE+jD06Q/hD8MGzezGxQfxV6iToIjda/j/rgI9cMCgYEArjPgDHs9b3BsNsMQvsfUlaYAxcPUHJN+qoWIk5Jj5NtYme5kbki14nm0ekBbbBfI6pEz02zrvWBK16PdRV6X5kcMgriX6E0RZDq3PfcBPCPo80OGuCORxYzI8DJ9Aa8cPbENHS8e8dDQ8uNyaXWkCfEyGEAJu/ivfnzCWmeVns8CgYBa+Dzf+qPADjviVXbDdRqdcsVK1Dv9qC43fxn7pz0DZrzy7wStat7Z4oEQPDOL2poqn0ounSPf9FM0mNmQvIqte3gd6/d0F0s2LUzrWvGaVtnF70Fe/O+s8KFK5ejr00wPX6rnaGKzmUU/AGzgwbwUjWMP8t/WUo/3tH5yaF4nMQKBgDtpQZL3TjFqmNaBIkeJQpadsl2AqZbCbKm/tMMU8LCaMj440fEKixVyhrsJDRUEjXC3oMtapP2cBRCAT097iT3m2bFx9er+wTtzrNoMFztJBttCjDqghshe8tdqrIbc16uIB9Wtw2AbrxgaIogLGU3oiWaWv9oXRzOiKykFAG8Z';

  /// AES key for `@egcovidlab🛠`
  static const String _aesKey = 'ZIiuBBvtCSRlC9kEZ0K+1vCOKQ/JQvf7Vx82idT7UrA=';

  static const String _apkamSymmetricKey =
      'HJ7YPNZHyQXT3hOx5JaaAWUXnnA/SuEBpGgP/fq3Qk8=';
}

/// All keys class for `@egcreditbureau🛠`
class EgCreditBureauKeys {
  /// CRAM key for `@egcreditbureau🛠`
  static const String _cramKey =
      'NC6gYrJMRM5R4N-FUQs7KTv1jrOlj8x8ai1JFFBBrflcUxihJHtJCArMx5eENuvHn4imKnlbrbyYuJUlsYoVTkid9gAwXco4-3rd0thxzwo9bYHNW4hYkAqISElyxbzO9s20NFbbWSEkhoGN4IY9yJ';

  /// PKAM private key for `@egcreditbureau🛠`
  static const String _pkamPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCUzNLPgeoSRgojlNN3/G1H1hDWfSeQLZFFrVSQ1Muc7gnPzFeeIYr2BWu276r+y3JT6MDA8flKchYesl5RXD4NgkeFgZj7j095qniWGdAthwBGjXNFv+uf3Cpcqo+Npm2+dNrV9ur7EaqiL9PaUt52HzDU9ZXN+FpI+rmVUJEwJ8dwRtFa2mJnmQf3+48rIJvEOYZVhHb98U2NXWnfMe/kkapNVH38EGO2Nk5TlfhCwBRxL2jorg7KD7nl+ht+qGjoExuPTsY71PuN4nDY92R84bQCFal87Dfy06crC6LKRrbh2iS3Y8VI/nmvFN4oNpbbOaIo0apk1JlcIQDGBz7nAgMBAAECggEAO4QVScRXwEldYs/zKUnA1/vKLlBO0782HN1wNqG2cyVOrVu5K9mUwER4yengxhrPtrog5suh/2HUcSC80uQHOdYDD2Y/r1ap3isOIlNezebyeEW5douGDiG8m+XolyqbOJN6uBwT7qopSsfAf9Gngy2ElZlI+uI8EnaeZhecitqxdedaVXcYEibl7ap8ftiwrA5Cq9pBQzL987FXLLnfIHVKCkkxFd7luafi5tdoaMG58VIG1hHyXdO8xsxiwppbClH1vCDglj3WykgofHn0IzAfAwGfY84zoPxL4RqJ68+wpPZ87FV/OgnL+95kCZlTrm6nPutOESGOM6VHaLh5kQKBgQDWurZHpswGBpSg523+Fqk9ixdtaaNXldGKuLXvrbKWHS9yZbRBZwxY3nVvSMgEzIOJK3Tc2ppJo5/EkH5gKG1FlPGS8fHWM6TsigO6jN7LcUI5GihU3eN11S/xvoypkSWQ+A2YQmip1oYPaER8FRpnP1XMCRx9cvuaNhBRT6WkvwKBgQCxZjTrW1iUDanXICy+WkDbrnve1M192cetv6d1hkRk1zXlDY4s6CU4zn+3QfDuUEEvllu53fYnp1l2BGc3qPV6w6MSP4Yfzos0rpUs3yGCIfSjkioSdg84HkjnhS5EDscKisrrODi540xmHpfliW7kifdBMb2LmA02h9HR91qn2QKBgFkfe8J3f1zM5Gl4RNXeD/ZkQZ/+5XXXz/XUvmaxYFsf1+6SOeOfYqeMBY/f1GzxeXK4X7O+46TGzewm0N0WSmxD6pRD6U0veDdY/T0zdNFZu9O5gJ3gzqS8jD65CObkQIRQAEx+27QKPvAsJaielavexLx/15xV2gnigJlPBoA/AoGAFSdx8grfgjAq65tLmptalpe077qCkppQpFhxWKNdLoU3SQwXwyUfoymEs06qs1BgpZMRdxWPz+S110vpHwsH0s7XeEqY7NwNX4feBA7LiSARcxvv5mmroO6DlRAdl0IH3Cr2zZvTr9758kd9p4J+9cO5900+JBJKqREDJT2Q0ukCgYEArOah1b1XxRkk2HomQR2iR1e8qWnPrCGlNqc7Xsx55TJqR8nT8Zpvp9fVn/mYvmix1TZRoE1/xQKMIC20VaGURd9fL26quXe8oiJ+hj9HPBitHgOssuFcwqFcppnXyaLwUN4NEp7IH4mOukSYiMpZwtJDmBmPKm8AHVAAwF7C/Yo=';

  /// PKAM public key for `@egcreditbureau🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAlMzSz4HqEkYKI5TTd/xtR9YQ1n0nkC2RRa1UkNTLnO4Jz8xXniGK9gVrtu+q/styU+jAwPH5SnIWHrJeUVw+DYJHhYGY+49Peap4lhnQLYcARo1zRb/rn9wqXKqPjaZtvnTa1fbq+xGqoi/T2lLedh8w1PWVzfhaSPq5lVCRMCfHcEbRWtpiZ5kH9/uPKyCbxDmGVYR2/fFNjV1p3zHv5JGqTVR9/BBjtjZOU5X4QsAUcS9o6K4Oyg+55fobfqho6BMbj07GO9T7jeJw2PdkfOG0AhWpfOw38tOnKwuiyka24dokt2PFSP55rxTeKDaW2zmiKNGqZNSZXCEAxgc+5wIDAQAB';

  /// Public Encryption Key for `@egcreditbureau🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvBS8pkbG9bhYwGtcPbbkDoGACZblh4ZroB8qLCknrOGnWCsralq9i04E2JywqOVmRPhvayo5NjhpeR6vGqkWUbb2GLz1SjK+RqpkLyiwsNkH1Awi1WZwxToQ428Gib2cMsleJOQNyQlgVjWK4mvRj32UNwkXTdEwfzihBVJaLInJJW9xtjy2ZH3HqKvWJcYXaKsM7zhPj4yXf+AEpW81zf+ThRZtSO9FgCj1k9VUINhM3rS1yrykBJViHVO0/g0G2QH1ypo9REuH351Pfkm6tOn96aGVk6/qP/OSZCZBifGBc82i9+suslZ7FWDkWHS0YrgUJZ9hQMEpZnXheNtjqQIDAQAB';

  /// Private Encryption Key for `@egcreditbureau🛠`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC8FLymRsb1uFjAa1w9tuQOgYAJluWHhmugHyosKSes4adYKytqWr2LTgTYnLCo5WZE+G9rKjk2OGl5Hq8aqRZRtvYYvPVKMr5GqmQvKLCw2QfUDCLVZnDFOhDjbwaJvZwyyV4k5A3JCWBWNYria9GPfZQ3CRdN0TB/OKEFUlosicklb3G2PLZkfceoq9YlxhdoqwzvOE+PjJd/4ASlbzXN/5OFFm1I70WAKPWT1VQg2EzetLXKvKQElWIdU7T+DQbZAfXKmj1ES4ffnU9+Sbq06f3poZWTr+o/85JkJkGJ8YFzzaL36y6yVnsVYORYdLRiuBQln2FAwSlmdeF422OpAgMBAAECggEANMGgVQe/YUdvZbH3srvtZoA+uPHhuk0jPUvgmXiFz4GQXjPlvrRrPHsK8vOovgdy01/YaPf0ClhyhW3s8g6B2zP1/eRq7YAkTVAYP/4q6cBG6NzqnG9arIfoGtOWwuYzvS8swC5UC5McubHVHkPeCWDRRUrAhaxq7RSmXgbGkn0remvT0JMAac4yZN0GXS0Xan+8BzYFI2waxIw4w/5cunC4MpT1O5bWVkQQK99EwI+CG6QPn6rP1vHiiWU4sBoD8/b0odhB06CT3F50r5pGoiOb+htefit188QEFkNSida5e88feR0uYW54AM1tjsyH8J0O/qYSADD874K9vd9UbQKBgQD7RW1fsL5d11dOEQf9fksvi3IF7S282aW9KTkJ4Wttpjgtn4A1yXWzRzG0rftDw7vpV4PhbvepTmY5jc3Xuds8/3zJRb9rNzLx/5tAQt+cRgQ3aiU6zt1epfNdpqkxk+fWnBy4ce1rj3p11FVSCV5riFNgJ0djBVi0qCfR4RX3rwKBgQC/nt9SbFbExbV2o6NpU+P0XIR06Xmu3NJA+i8yzPCDJC4F6k41X6OoA9/r6K/DIgwn4Z+M/fHMvuC4lBgOr1g1lK+KyUY4waA7HuEN6Ict0MeG1SrEqvoCeFCBPsju9+ZxuZa3sMbGn3+aJWkCZTpeyM4SbeAcHQkoxUW6zanYJwKBgQDN8fqSSpfM7FnXV2g4IdJX9rAPIXWyaqVIZEgmzAa0CV/ULP31l9iLh1e7IjpmMUCMITmrhLsinmp008AaB3AlD7ZkdXFN3CE6bej+g5EpUc3U6X/4MmMIV3YflSDpzLNhl/SGTIJu/Vs+xjjkE1+7PTIxBiChjVlGQOjaQeUyawKBgQCpsdJntdXpkIUxOZ1fi5FWOBB9UL4YIyp3rJfbzy43lPTE/Eiib74I7tWAn6H3ltFZCDA5tjJKdceg7lWXu6TMXo5OxAxR+vchJCl+HayI4FmyiFjFrfyV72Kr8qQTLKqBkC9vITgHcfyY0AR8wJS+l+oW3AMaIoSX/IvR8Iw3BQKBgFCakeQfoIIsxp6nYYFGar9f5FAYNvJ415VetD4eqc8xMat4XDYvIYBFDGzZ/nBe1XLdOrOep3r6N3EBKqjTWBKwDrw87sjCp4UmgmBMlumrW7NXJAroDcfoqjwUZtMQ7+WB0Np8AKH9V9o8NReGebH0yL62LCXhHMecQv8yWthK';

  /// AES Key for `@egcreditbureau🛠`
  static const String _aesKey = 'SgGiUL55OIxq+pU51g5Hn90seYS5+w5weQNVevo9Xa4=';

  static const String _apkamSymmetricKey =
      'BtJqw2vBfg2by7TmqTM/mZii7fzkv9G0VP2dwQKn2qE=';
}

/// All keys class for `@eggovagency🛠`
class EgGovAgencyKeys {
  /// CRAM key for `@eggovagency🛠`
  static const String _cramKey =
      'ikpnBQu2SAQsgxNb6mLoGQrVGK4GrUB2wjWLGzHisojHUtm27-tv4knY8KgPeoUZGxXQVofFoLoltqkQbYnzJeLI6864jMxJyjEKc82DYtvQextapZUZVjliZRTaNsbS6Vd8bYqE7iEEDEHcj60hV5';

  /// PKAM private key for `@eggovagency🛠`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCbMfnQbE0qdSgxaWaGfMVG86cxtiBbfIeJcsc3ztzTaKSdmdC7Cd9UE0oDlg+5zBKCzTrSoeqtz95vZJLopjQaZKy/Hqd6uDc1fAxyI4TBkKDSdeN02Fzj7wTzIMLyOvvKYSSwlUwu/hd1i0qzgeEXAw2xv7ddeuUZmS/src39DFci9aaMLahFOXiEVp+0NBvwxIF9U6Lyfz0c1BiugZ6S+ZKd9x0yapynGMqdiaJXshsm/gdB/VHzraFgK7GCfeyP8UkJhAiXndRizuvANbi2Eg5YxYKaCRtaV+j396sQmdHBfFLxVuN94fHeWsI9tvkEgHUrYJTrkmytVJU69ywLAgMBAAECggEASBwReiFIPYkQMt1JcQW6WDxQHE4GfNvA0kGNhUXN30EI892LWcy9gwAvbLkl92t10mbvhP0M4NPsA5AUnprTLMxIY8kngmLj7CsGUWZlgdbkksWJ+Tmq95GQmDNJwWlcou0+Mfo82rzfQ5OEEyIu5xVZIJT26y12E83UscEULBX9ddBe/kQ5G0SgKpEbzxXCoZo1IjBZ0nfcDw/UpL2yoAMogq7l5a/NXDHeWWNv7OKVbvFC7OdHAHL2fsBKmIdOPTaGohIXyk9RTVbx4IsTZvWwzhjlMqAQHb8PB2vrKANFpMBXGoTFSaNdgyQ+qWHtpwpdoUBHEbYjwPHFzuGgYQKBgQDOD6Mf16nivPSW5YXyso7p2mbfvQrkeU5zo/YdCQfLhVgTXEYjpTjq5pyQ9iwqWkdeflmpWVi0MPN2AXN5DfVmxy9+IQGRX8Qz/j7+nzTV5QX/tB9SICR6fOQKYAjWkdTqnAdzvgNbeGL/wronhzk/nqIikreOmvru4TNj6hRWmwKBgQDAzonC74ElP+vOWZtY7UmLpL9H4KNwJ+GY9vbAmX48KMunTwNMlyisXPHvSsoiYRXf4SOqfHxl8NkZWzc4rOCjRXwGToWYIMOC2GQdqHtZuWOgPrE1WQlaI5T4NJalDATkHp8vbd+Tb0ZoYYqlpSA0e/yqhPjSG5WNy4uPN1EfUQKBgEtdyMoCtS4q8kKmnEFSMZcyvGGk4PEDtT/yfjfMb79ue/JI05aB/blcs3MJtsmez2+uQtj/xsPRC5rjmPpzsofu3l4BcHNdVYO2wA+c51Q8Od92X+ZHv0/VkgqBaXohSICupMMeglfYRk1JSZDfkn7EZITEqMJNyO3KDGPE3791AoGBAJxPFTpXRyD2yGobFSkr/iLa5kQUZwwHGQsUtIkCJ2gIPsqd8PPH3C6Yj39K58KlaMF+2ZZeo89VSfwXihZFeTyEmX7Xa9EgRsCuQ8QTkiT0ekMwcCPq0f0kuaHbqIGX0+NIvA8MiWQSo0b+RRPzYb+LARURBlP4Du/Mo5Dw7LBxAoGBAItHGbft/lGlaCJ12GK+XOkwEKEzXWlVmW2AvLpXwG2sVJnlVy+xRoQV4JYPpL12//YsPN8uuAPvti4UtCSNjw9ozOb/dV/WTM32H+IV4TcwwIlqTe0JP6alkH4nMkVwA1O1GbmUo3GXnxunK7+TKyxy6JRLAM8JRhqLQtuSyteb';

  /// PKAM public key for `@eggovagency🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmzH50GxNKnUoMWlmhnzFRvOnMbYgW3yHiXLHN87c02iknZnQuwnfVBNKA5YPucwSgs060qHqrc/eb2SS6KY0GmSsvx6nerg3NXwMciOEwZCg0nXjdNhc4+8E8yDC8jr7ymEksJVMLv4XdYtKs4HhFwMNsb+3XXrlGZkv7K3N/QxXIvWmjC2oRTl4hFaftDQb8MSBfVOi8n89HNQYroGekvmSnfcdMmqcpxjKnYmiV7IbJv4HQf1R862hYCuxgn3sj/FJCYQIl53UYs7rwDW4thIOWMWCmgkbWlfo9/erEJnRwXxS8VbjfeHx3lrCPbb5BIB1K2CU65JsrVSVOvcsCwIDAQAB';

  /// Public Encryption key for `@eggovagency🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtE8TC8034yPYVhy0WXxZKT94T8r3tXMQce7U+xrBuY/RKyAf0Flsa160AerA1mKHGQBR3OMcXU1+Hcdwgj/ITyA3hJbyzwJArx+e4OHWc2WCoxw6wtBDUTlSQZbdtxD8FFBaK7UUCtxYSC1rP571g0WfJK7HQWWbgKXG2s8SmZSXRM6juqHgznAR1Qcs+vUoM0p9PGd0e8kUGrEOlVQsOV2owyVqOT9Kq1Ely2ye8EHKXAotVueJC+OGcaTnOik1Pg3YOa3NcnhuriMcRHcMl3WyGRA28DKK6tc5kyYp3/TY0oBRyFITd/DKypPmPsbTXmSsyFHRB+Woy2wEWrt+9QIDAQAB';

  /// Private Encryption key for `@eggovagency🛠`
  static const String _encryptionPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC0TxMLzTfjI9hWHLRZfFkpP3hPyve1cxBx7tT7GsG5j9ErIB/QWWxrXrQB6sDWYocZAFHc4xxdTX4dx3CCP8hPIDeElvLPAkCvH57g4dZzZYKjHDrC0ENROVJBlt23EPwUUFortRQK3FhILWs/nvWDRZ8krsdBZZuApcbazxKZlJdEzqO6oeDOcBHVByz69SgzSn08Z3R7yRQasQ6VVCw5XajDJWo5P0qrUSXLbJ7wQcpcCi1W54kL44ZxpOc6KTU+Ddg5rc1yeG6uIxxEdwyXdbIZEDbwMorq1zmTJinf9NjSgFHIUhN38MrKk+Y+xtNeZKzIUdEH5ajLbARau371AgMBAAECggEAKn+k1phFPvVY7VsQqzLi9RTvr6cAYbVAQApyCsmQtcMPIyIMPZiGNHx64yTI1P8eJqdrpCunqNo2CqDShPCxruzCCS9nBaHbSyuh0BGK8WIQu49QzlA2PbPMDoeXtKl9MPCLgFfK5JBxAnoqGDHIXmuPih7j+icP0u/AAhzinm4BMIx328sTuvwdsTWMWwOKAdKvKnGCY2IC3H4kwBx0bZg9Sn1827ZATpj/OXjJSVxeBuI3k58Uvo1ftdoOxHjufhbmZFsnIDhWDR53SMKaAoGR/dWkloeNqirOp+VzfvRagz9lH9w4pLtwhhue47xNePkjVWXJDF4WmfMm1IM/wQKBgQDd2r+ZJZ5ZeNCmeBE61I9HSGzGK6Njtg9djTjKSWOP3Zgh2G650nJiMzlQxRuL2Cvr+nrDMJg57/mgBtAOu7+vKqpK3rHVgf1SZPmrao08pK+VuPPeTgnjbR+e/jpS7YR6o13cJINIu5TeIi9W+FWTknm6jiba/fz2QdpSlLPLEQKBgQDQD2UH5JjwuEh73T8r9pIT8GgQo6wrmwK+0GhA4OBPjy+YReacoH0PXjOLd4I7xyIPUP/8bIBTRl8IQVZE2sLE0et5agG6VQU5Q5n2o8FcpkwgdlMHijVx+249Lq6QQd/2HRJgtEaBZuRMOVpI2fhhXlQLuU/19AwUsoqJ423NpQKBgQDGQoFs1CBxprUXvz7uixxLwJ5sbn0CU6XhnZ29sN4HqCkXPfqdl0LfHRXAZ5VZYOLHbL2eh2PSivFSoCP4trHzUTaD2AWmXxdKNbClDoCPTEEZlQJijOzrUA6tIFZw24/DpRDw9bRZIEFGTdhuaVjYm1Krc/OnSslwLKN1nywZcQKBgGSTDIOEPWofquo1SRQ3XOXGkId6lv99LxaOJ9c03TmYPameIJwV+F41azU/z/SVjiFZRmT/DgkzOz0CWHFwTjZWQz2twKgR8TR9OS/AePgQazxF9lzusmcm42Mv7bJOJbUS2I9mla53zmQKVVpiA28N6hLAwaZjEnPu2olNJwcBAoGAEwxuhHmcTAMKi2xvhUL1uzPgTVBoCsR1Ghj9OEuQ27ZBUJq59n5c/PKKDjs2EuJdXH3/1jrZ+SnYz+tRn/eecumlGhsaAi0fQFlWhzchNKEHsmRax+AHB37ObZUsC5eExM63QMrAJwYkVOiaCUIbfghSh9mUciaNo7ucWj3Hlqk=';

  /// AES key for `@eggovagency🛠`
  static const String _aesKey = 'zk2XLGrWXMIvgQC9vLLRn3bnsdXZ1NfROS7GAQaZbgs=';

  static const String _apkamSymmetricKey =
      'Jk3toSj6uGUgEcUvkOkY4EPMXCR4CnZpeLnMYvnQVs0=';
}

/// All keys class for `@emoji🦄🛠`
class EmojiKeys {
  /// CRAM key for `emoji🦄🛠`
  static const String _cramKey =
      '1fcb2d6d665d3a79e2eafaec38947a4f4ca3db79430a47fb43b510f46ef9a03991a0ba4ec217ff2173b5cf1324737787263c1dd28b2c0979ea06ed79f0b40118';

  /// PKAM private key for `emoji🦄🛠`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCRXKqlapdOA+zTmI9nHGSGO8G1RaaHjdSll4NyGEdvwJwRKk1jSpRR0KaXpC+mTZNyJqrhsddqPWMfN/9hz3XCui3Sbmq3ecAMjdl1e3qyMs3RnQYPp754wd4DAfcA/DQqo01DFzPEqUO80eW5Q190HcRGNqUlAPFQ+mVHK9MiUnAQEiChNPEkALz8YIvFQgF99l5ylVywlMNk88IpqqEdJH6WZFpInj+6X3cjMktfpT90jqOauWOJe6JFwENlCpp+fvGys2859qV1sqKcjS+QHMM+6ERWucnnMhUIXFNQLOJP5EApR2etv0EWDsUDQJPpDRwRDqmAb72VKmBDXB0FAgMBAAECggEACuP0bPw1ZcTpg1jUtZbs+RmVA626MkGwAs/9KxkikP7PMoIG1j+KKS8GrCnC4CTDvTOkbdBTIUSEHpylZ4CRhAtKz48yM5jNiKM//YtIv/0Kan/nKlkY7hcoOPV2uf4rMl6VtUcRu9QqnQTkvyKLDjoEsHX7nXAapER+PfzMjq+dcJV2CtU+bJuG/Yp7XhQTIz8vTF03nzAluJ4v365RttiqFMKigaf3xsRk/Qx2V8H0RF4F/RK6Mo7dGfKZ6gbnFELTh3WGfJLrO7yDiLjGGsNZGEp5qLoOlusGFbOSTxLcKfQlHxAfuelhj9L0cVrpzgQ1v3zGz+e9d9WZcNsEqQKBgQDRjyC6n9VAVaUYnVHvnBWgt9H3bwUlTmIBeE+YXUwXyyR9uB9u2AxNQzBal9oso7udSv8hh/TUCb0uPyilrWxLMyg8I54vUIj4Zziig4FX91tMSBW2sYL05sBttSFR9zU0FRwVJq4ceuNKSLx+xkOYscN0yr5CdkXMAMFVQrkU7wKBgQCxk3URUS7SzuHDY+Geh61o1rSWy9pA9LgvRWLBhzk8na90BSCQtB3qm0FEuFD06FGzWe4RmwVAE8MPJcldCGP2E6jj8oIeHvQZXb2BcO+KP1CKRjMdzDqEcvXTFWmDI4RJJI4HmOa6+1N+Mev2+LhpLgGcPLF4AFVAVL7mlgq1SwKBgE9UGDatlMOi6DmWLFNBSeqqS2CYdWE29+DIk5EBGHIVY333+mYygQ2qdp6Ex4GIhdg4cLZXyjWObkAYhqGZMdqRxhRmA1az7PXj1Uun7onHSJdq3lVng0SEKaoeHDv0Ef7iUtwq5VRArNQNDtYK5cHi4TPQIA/2x9s/GfDVrkyfAoGBAIwE1Z5eASnAb0v+Cf1Sxm2QPr1Y6DOnw0Oi1of69CrTu3EkSdVP8Pb4jLJ/E3bJaQKeupWvQqiP7JKZHPn6j7eNMPLsWaUeiyMlQzQ5tOexnPQq/ktUqh+d9jAHBjedXcW+yS88ZVKysdcjzgfjfqWQ3Twwr08MFCyxpgVz8eWZAoGBAM9TedxR25ngdAKAf/JbO/BKuYAiPr1Wd1SFLIMRxKrTFXNZQ+H4kN3b6pIGypvbwHb6sGq7LQihA1iV/vqnsR0pZZCVfRca/tSdl5cWmcZtTJtQqAgcZjkSCDLiMCVTR4fMjY/LOBTmbw2GCzZkBO3nAWGS7z4YdVOG863g41rX';

  /// PKAM public key for `emoji🦄🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAkVyqpWqXTgPs05iPZxxkhjvBtUWmh43UpZeDchhHb8CcESpNY0qUUdCml6Qvpk2Tciaq4bHXaj1jHzf/Yc91wrot0m5qt3nADI3ZdXt6sjLN0Z0GD6e+eMHeAwH3APw0KqNNQxczxKlDvNHluUNfdB3ERjalJQDxUPplRyvTIlJwEBIgoTTxJAC8/GCLxUIBffZecpVcsJTDZPPCKaqhHSR+lmRaSJ4/ul93IzJLX6U/dI6jmrljiXuiRcBDZQqafn7xsrNvOfaldbKinI0vkBzDPuhEVrnJ5zIVCFxTUCziT+RAKUdnrb9BFg7FA0CT6Q0cEQ6pgG+9lSpgQ1wdBQIDAQAB';

  /// Public Encryption key for `emoji🦄🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiZyTF6EgsWF3spE/Z03lyTMWeQSrXRJJuz8IdX9ceUMbpIoM2neY1bHW2sRZRSwiudgxUp0bU3YLi5lS2MWGPZ0pdyUCJD1ob43+iUHazGRM+aiqAVxAXOB21ElpvcWJua9kYLIs7+K1d0Bb3ck5J/w9T9pyrOo1pFu7jSvXnjNIuGXyjnW2hIsUAkYylm0Xaan51YDJ4+vgIgWTSemEiFypIFs5O1+jzwOMfazP1b0xDAO893eP39v4ISjVEqo90Lv0fyo4J/YghFg9JOwBEOzeqaxT/4lOoXtcjiKb1AyEwtP8KWZTA0VVZqhIrFTx+TF7UvRZZJPtkMwETcDuWwIDAQAB';

  /// Private Encryption key for `emoji🦄🛠`
  static const String _encryptionPrivateKey =
      'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCJnJMXoSCxYXeykT9nTeXJMxZ5BKtdEkm7Pwh1f1x5Qxukigzad5jVsdbaxFlFLCK52DFSnRtTdguLmVLYxYY9nSl3JQIkPWhvjf6JQdrMZEz5qKoBXEBc4HbUSWm9xYm5r2Rgsizv4rV3QFvdyTkn/D1P2nKs6jWkW7uNK9eeM0i4ZfKOdbaEixQCRjKWbRdpqfnVgMnj6+AiBZNJ6YSIXKkgWzk7X6PPA4x9rM/VvTEMA7z3d4/f2/ghKNUSqj3Qu/R/Kjgn9iCEWD0k7AEQ7N6prFP/iU6he1yOIpvUDITC0/wpZlMDRVVmqEisVPH5MXtS9Flkk+2QzARNwO5bAgMBAAECggEAS4fACHEs448uxrkIRugvnm5HAGd6sxvtkjO3rd4Y4Inf60DGa0bHgUsaNXsd0GS4Lq8l60VGEVoyXg3qtgY8dycC8l1Cvqdh4hDay3V05UiMI1/a5+I9hXzCXCRrQHji7iMBgj1pgsU5etm9Uo82qua8tE6fMJ9gj/S1jXep4i9MMUUg+omL+3OhULSRZuUpp2fUp+pmGZAeJYwCVjNhsBxU5TK2YiNh2dEVe8SdqRzQWNhPvfrOhPtqiUhtgoGgIvQkXIUywj72KgOJtaKvTqhl6Hx95M/DWKlLZdjdbGIqlbvyn4y9v6kfiA3QO7ho/iilvLKJ38T5p0Du+AnNkQKBgQDiL0FlkjrIeLTJwz80oPSL7fjv/Ftzv5uYXsAJx9Fd/y9eUIfw0OQHj9qUs8LXBDJeTXNe4DsKee2v5kNHJFMiyl7WkZRQoEfJ45SPKOE1WG3srehH9dDpEHqO8bSXiAIceoE/IiGtySisH5OU0llkqfK2xfPR7Ub52rTrj+9d2QKBgQCbwF4A1BoIONUf4JLJlS0Lo6YxJGJ9zeY6KGL6+HTiQNr8YzX5ojAktfZD8KSi+E+8ZI9EcltInV1F06N/UhMil9KrsrCP531ts3K94eC6gKqU6tT9UXQS7C/Llr+m9TYBX6fRVhlNPRShz5KGu+jNGAG92CHz8iVAULwtaLPpUwKBgQCyXTOEBpGmf1GJ/hc8yGSwaCQ0E9yGZaYsvSNRUyqupkrTZEwfQotfzzg+pZdTefLCXO9K9SZ593bRjJKnamTI/a9WI41DG3IhKf9/+WvHZomg5+9Rt+5brGwJh1+zU0Te8lgz0hWe9w/E1E3MQSjPchl9upKwjB25cJfVXzcS2QKBgQCFEAW/g3VyDMvX3g7J9Y50YS180m7qt9u3WAWoEFgba/kqor/cM7oZwvNP++lL6gSFGQxlF6XxFbA4FaWbAs2iQj8TvSem6ch4zlR68N0DuSUC8NViThJykCINNw8pXljzN3uyFnKrUEGuNB4kyakMfzQNsvbe6ML2fYMm8Eq0TQKBgQC9nZfbvxcyXttxXnbmc5OAUZ1jEGR7nA0MtW8LoY+qvZe0wewU7/Z89NRFnhZCx5T9Au+qSI/GlP2uHAOWqYUeI8LfLTixUM5WT0sQHXSAsEOmrc08YvhH3Zbijds/iEckLNhRcomVlv1r0cWqLcYNKJh46ec/9cf1eqUis3d7Pg==';

  /// AES key for `emoji🦄🛠`
  static const String _aesKey = 'JYKQzePXSDT5eDGw+CCLMx7o3m+MiN3Ykkhc+2Xq1IY=';

  static const String _apkamSymmetricKey =
      'ZeJpFsd/VO138yh4KkJqTF7D16mI/WbL4OJqceNp4KI=';
}

/// All keys class for `@eve🛠`
class EveKeys {
  /// CRAM key for `@eve🛠`
  static const String _cramKey =
      'c292e64ebe852ac39ef39ac5e83392672d66bdfe0e1d496bf777347019271b05012756b7d19d18beefb5f21027ef6e66b5f1637280982ca7bb295c94adf85f23';

  /// PKAM public key for `@eve🛠`
  static const String _pkamPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCJ+otmdhvfPN0YBKc8EwUAp6Oh+9mKAIILylBNBw4+Q2wsV+4+C7W0C0V5wv5XI0sXCNkt5nGm/ERRGanDVrd0jfeLARB1/Fvamo3vPAsZMKySwGKNOrdqSalu8OH4ezeO2KT0YGZAZ5dLKDpbZItSR+x+nRWJJ//AY+ov99jVa0ljR9abTwycLBYva0S1BEM82tVwKL3ktnnWilNF0RGlHE9yPyknBe8Tt1go72adPBDk9dH22Jl8umy+8eRhdyvBkTa6TrxtrpHDIMi8u7t7SdfPab7IRjpTxo+fgPHv7UiYcIRHD7dY1El78IXhsBY9sHQuGNbXpzDPFHCizgnLAgMBAAECggEAcnWy+lZ0HKZCys/hY0Zr2fU3GwLvnTl6qAk2wA9gU2pe7BItgq74Ftla0v1dPC/89KjUcO0/zsRqb9SYLYFcQoYamedSHm4wTJH1uEXY9xaXsk2B86KH0NY2hd+xtQ2SMx+pB0iIylik+yXt8y7fHGyp1Qa+fL7/vDumZBB4geF4jRGVJjvYgG9FhCK80Wu61Qo8Qm6R79z7hwA0xE5ENzgG/G6GgTxpMAcqj9NQeTqfUCUZ9JJ7LBGUzy3i9ZwrYpZBucdt3oKVLjgFcw55Pa5YhkDmAarKWExyWifKPf9kg4I6Er6IhxfvIXftghFZ1OqkFYvg7L8AN4HZckmlsQKBgQDcMBLDRvIuRYqyLXZTlIjXuGUot7cFdS00yG+sPv/4kwFJx0XpAbcpr1io82YfMLrCsLkDnao4gs8SOnVsPWEDVBNCLYoGgpyOi8XfJpYWOCiIakihuoKzh6sgM53cRCIZPf6czpjHt1r4OFBvrjnFqE0LcwxiBF+YOHPUp6J4HQKBgQCga4sHhUrNT1oGIDlUEWbg/725F5Y7H1THVFxtKYQWXGGk5jtW1+i8/U0qMIbR0Ex9HoJRN7MJe9KoB9cfeeUWV53SuLSqIxWcj2BR2onUQW1umjDsrDFzBka5oTMflr843swPsrz4GVbuuueBbi/Eg3lFrWJCIvZ3xl/i/731BwKBgQCVM/oy2wtWsYbncAkDX95Ol0PtEHhzuVA1uTB6/oHDdhHkZaUI3EG6fHhOnAhyUDntnYTxX1AuVO1uQ7C39OudLsaSDHvAJ5dgvHQL34DKc6l7rtGizditQNyDyJZK4NxeUHUM2q4Kf0Okebx/wQai2oXCoWYdsSr54h8TVbixPQKBgFMd5XcMFOmzh41M/OcV7Rv+5aoVEn2niiGNECZvMET1sJHjyDMCw0/IXkbRxcjICBl7yUGTfmwXf9oX1do1KgEdfGRF1zWf3/6yOtGuTWNwUubPdTHrNePHCLX9U6O2U3V/2nL3xPk3B9fBd1mUYaOMCzWS1Co4O0NrwRq4Lw/ZAoGAZEKP2bCw5IkUh/OGZEfpmSPnh+DbM3iqLzn6JD2SdWZ4SZ59d+4z10s5ErDfAwRxFa/mkF9ALKUpx4J70Xr5/ua+liV8ISCRsdmD7q0evHIyVYo2V+bfzlXkAO0RJXw1bRIGSlzpJwjDXEfi/ZPrsxp618xzpYKPNPvnFhwBt8s=';

  /// PKAM public key for `@eve🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAifqLZnYb3zzdGASnPBMFAKejofvZigCCC8pQTQcOPkNsLFfuPgu1tAtFecL+VyNLFwjZLeZxpvxEURmpw1a3dI33iwEQdfxb2pqN7zwLGTCsksBijTq3akmpbvDh+Hs3jtik9GBmQGeXSyg6W2SLUkfsfp0ViSf/wGPqL/fY1WtJY0fWm08MnCwWL2tEtQRDPNrVcCi95LZ51opTRdERpRxPcj8pJwXvE7dYKO9mnTwQ5PXR9tiZfLpsvvHkYXcrwZE2uk68ba6RwyDIvLu7e0nXz2m+yEY6U8aPn4Dx7+1ImHCERw+3WNRJe/CF4bAWPbB0LhjW16cwzxRwos4JywIDAQAB';

  /// Public Encryption key for `@eve🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAr0S/6t1i5ou8f9WOtj0wrcZSsUoju4njhzylnV9lmtnIlcg+gp0F6nxxyDAR8NO0lfJ795YD8wqq5JgLMwCsbncZsWUuOa/fZx9VsNB1TGqDXxyenqWEdk+1+UshpjOnhJtgjHu9fpkiTQxuw8X6LL3CY4D+L9aryY+jsJQT24dfkyuUtCYvB7sgDDY50JmFGoDFY7jwANTSfyIEcadkGMA0ciYW13I0wmca8lbEbNxKVpXRqW87+IZG1WGEkDmnItXlPQ6l6YxCq2XYf4qlvcG3KQEeGasFuTUZTV7o8z+Tqdgg8htAL2XPzjHO0p2za0UnkHvRFKSHDnI3mQs04QIDAQAB';

  /// Private Encryption key for `@eve🛠`
  static const String _encryptionPrivateKey =
      'MIIEugIBADANBgkqhkiG9w0BAQEFAASCBKQwggSgAgEAAoIBAQCvRL/q3WLmi7x/1Y62PTCtxlKxSiO7ieOHPKWdX2Wa2ciVyD6CnQXqfHHIMBHw07SV8nv3lgPzCqrkmAszAKxudxmxZS45r99nH1Ww0HVMaoNfHJ6epYR2T7X5SyGmM6eEm2CMe71+mSJNDG7DxfosvcJjgP4v1qvJj6OwlBPbh1+TK5S0Ji8HuyAMNjnQmYUagMVjuPAA1NJ/IgRxp2QYwDRyJhbXcjTCZxryVsRs3EpWldGpbzv4hkbVYYSQOaci1eU9DqXpjEKrZdh/iqW9wbcpAR4ZqwW5NRlNXujzP5Op2CDyG0AvZc/OMc7SnbNrRSeQe9EUpIcOcjeZCzThAgMBAAECgf9w9t67gfU8otPbkMlqrAWz+x9RJXfiZ/0+LNiRlerm43dlEqs3g/1MJOkxHcpybgD2pFNCQG5LN5TtwRF2zfhVOm5U5+HjTHew/4E7dSAlIIGLy+ZwWj4GA1pGUyZc+O3/iiWwZhC8h/aTsm+xvuh/7c5cU8eBDdurDely5f3mf0YVtBDzsoXDOfuOEfUWr6SDB4qdacokF9Dsx+QsogQlHHdL0IEF9zu+GRB9mGUXfTdBj9Eelm7LHbhN4Z+2gju6ZuI76koAQiPVDbaj+rn4aFdeSZGjsnl1ywCWrTTTw4G1MHmGXHaP6MhZkB4VNxlA/osHJnF/8AxF9M9RUZUCgYEA9W7w4UIeJ138Y5O6bNuMJCoSRA+BvBri/FXrPSaEJq6XKErDBXo/6u8QAnx3tAQQi8gXrRl3BZReK1JocAk7I3HRbTxY2AqYH4b4Zpk/y6Uq4I83/N23c2+yH7ywdJ2U1wlV4QDdTRXtURMPKH84xxK41UiVXQS7TdrQjmYzSFcCgYEAttB7oVytTlGyuCe5EPpCjBMS4hMfTWoBaxQePUc4ql2M8rKWk/FpvqRH4T6Ldb5PJVoWE/1/45HZvDeRPX8H6CwnNE0L4J5+AN5PHpekRTqDvJKarokdSR80roAc7h9pDiA0ZBIUE8zeXDIQ26B0KCCMouzWNP5Az18RPbgTCYcCgYA47k0N02pvM0vyRTg/PAYb9W5bP0WWvp3cbomsm5yX5HPHst/eC2d8NYv/J6QUq8Syx+1GB9wl/S6C2hDDvEBtjl9H+XGaW4rB9Wr1UaMMt/lkMZSJIV0Gd+hXmEtOIad+4fl7wdmTofx0i/k+KZSgCOW7A6Ux+IECJDmwbmCC7QKBgBvpXNbYJYWtp5HCTtkuvHZSezGVJdRV+P12Rt+oPhiUy+5KIf9YfoKi5m6XdAd4FPFo/bHzpFEEda/s8/nlqTljdGDh2oxi5m4PgxjyohwHwRFLeN5pBNWjNBHocYJRvWJwvE8DC5myT8jXxAckSlfOEGrXqiTRJOgEZcd8kTuFAoGAa37PitN34IrObhpUYue2BfTMvKL2j4VbeqWqB/1RZV+W5toGO7TVhHy2TGUBbSUfS1mmv07kcYoVL1sUL6vMCYG5cPVu2Ldtn4BNBLGXGj+OH9Z1vq+d/nuXuNh+df2IOwaqN6bXKTqxVNR/Tl2Qi4s5/NgK8feEpmzGuU7e9f0=';

  /// AES key for `@eve🛠`
  static const String _aesKey = 'rc98zzkVUQSB7jLffAtNI71xj0fUKidSXCwM0yknycI=';

  static const String _apkamSymmetricKey =
      'SJKyV6L4rYA2SB8r7PWl0nRnSry3+aazt6MPiRxAzbM=';
}

/// All keys class for `@jagan🛠`
class JaganKeys {
  /// CRAM key for `@jagan🛠`
  static const String _cramKey =
      '0f0ecff314fc3183baea1e94f125e268005557b4763dc744ea41c5693161084d8127d768566613313b1dff887c87be6a80a1fc6fc09d5234fcad093cea82d855';

  /// PKAM private key for `@jagan🛠`
  static const String _pkamPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCMmUcNl+QffWwgOvvqtVkEZhsF0B+LBMKt/byGZVe54JtXjlgJOe6CMPh1Ruvb1tTErzfr/DEHeXNE7YZ0VkXig6yBXz7K6LoIGE+TOaSXD225gmw0RmYZpb3VHwnMoKPucBTTtOH4iDBuOZItTUEhTRyU1ziknuBwgTu8PumEqGv5rUbfvDvon1dZTBJn5ekzR0LrW/XPH4lMxelkllARw0WziJe/fG7YzOCZhwPcskPeZcIkJoaFmhG6tcshtn86A+EiGJfHfzBhiHYB4rq64uC2ndNoRHUGb4lEp/1w7YNJHfRHAp3qO9Tf2mFCWHDHqo71Dlad2sWW7zgPUMr3AgMBAAECggEAL1C556oxHCPSSnpvIsqKvX87ItaqdtdQSMt2MWhTgHtE6888c0ZqrKecRaNrZl1C1zn8QM9rFI/bqduhfu81r4gOeq8564EsceL0jKA+cpO/oklw7pqua30qiFlcq993q5tOdvyNe10hp0Z6mgJAo9tWfgR7zHKnJ1Vma/BkF78tujbdCBAQEm2N6CvRkIYZ7h8iyFN5arVD1ys+hHccNMvvnoTS+Sk2HZvGo4E1qRyfpr+ElXs4C3gWCqAR7KKzYHa6VHKJ7g/6EbDxmyrdO6O3ILedOaHIU+oFSQsmYdnLC9NuDCF94OnH9rwM800WuZXieaXWjHrDkzU8owSCQQKBgQD5GTu4KIPIAJDOprCwiBmWU9KBAuFW0h99Vm+07dd7NJ5UmWncsEt/T5fa+Ubv9Zql3FJkvuQTG0h4rhihyXWdVXTJJSXPAycGy88B+AHOrXQiTwOjDP8UtKATiNDifALEj9B1PV5w6dSsjZmRLp3ES0P/dL8COyqnHpzou62BoQKBgQCQfn5zTM2j8Y5QuvG4h9po5qnZvobthX6hTB0xe/AwkxZ5ZtzXeWtgHiFwAQi7ZJlj3NNhm+jEMccgvhPLNmwhl437VtBgLYUF9zzSXsTun5q/+nAuvYD99mMLg6HnZZlbAnJZ3UuEznLqy9/xCbA6E3yCY+0hE80CUpCko0M1lwKBgQDfTU2J01f/bPJjLm7qcbduWYo1eN2EtSzhcSEGssgefJcLA9QwsCGd6T4aYKjE6AlQcmeyRKW0sxqOhJM0RaMX/cmJn7F7GDpeD0ptW2RTYI7hSq/Z9QaeCyYNHPMUdVMN3lZjIzaMRjIO1Yk66u0nUMmOMZwhZeTgl8LVp5jswQKBgAHhc5nilQaePUD1vfGt6vzUi79myHDM/QHycKrVNyIat/8qhJNVZD1jBwJjMQ7nV0vCcwnhMp1jHHljn/RUKAIj69gqoBmwXfve5O7EBwIoF6aKBu3Ez6n+i/l5ZCET5HQXyw86XyJCYaKGtsp3WtDWshcsX8i/bjqqgnFyIozPAoGARuKqI4hACdfXJ1pcZqJdUPlg+NZRmzkc1+ycyT9+136rCGVs5XuWcy7VS71E5gMVeRf9OcXG5QjHysUEdvdSipW9R/swJLuyN1PWeIw0tgsCJb0CpgWYpg/2GsJMrKxjb1JWaFE1wVg1s62cEUiNJLLx3z566oqVu9zCPKanf44=';

  /// PKAM public key for `@jagan🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjJlHDZfkH31sIDr76rVZBGYbBdAfiwTCrf28hmVXueCbV45YCTnugjD4dUbr29bUxK836/wxB3lzRO2GdFZF4oOsgV8+yui6CBhPkzmklw9tuYJsNEZmGaW91R8JzKCj7nAU07Th+IgwbjmSLU1BIU0clNc4pJ7gcIE7vD7phKhr+a1G37w76J9XWUwSZ+XpM0dC61v1zx+JTMXpZJZQEcNFs4iXv3xu2MzgmYcD3LJD3mXCJCaGhZoRurXLIbZ/OgPhIhiXx38wYYh2AeK6uuLgtp3TaER1Bm+JRKf9cO2DSR30RwKd6jvU39phQlhwx6qO9Q5WndrFlu84D1DK9wIDAQAB';

  /// Public Encryption key for `@jagan🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiA2irG/gmj16sOA672R/u116dt6Ol5nVah9HOppsbkRGo6QH/l2nEUbpZFAfZtp//RLF8Xqoa4+upjUEGUZ4aTBHPLvRC81z+BXomAZKPywbNseEpotAqz6hApo2auEMf1Lx47A6Ee2kakp299GX/8FK5F7A3pDQZz4FYa7jY3Z4fcLEi3eoRGTODO2ecT/MdJ/oKoAgWUro8iWgJnlB78xXDCVPTEtiArjrto3ZZYzinMJC39Jci4ixXEhROF088vrsZJUud9231y8t7ypQo6O1y8/gT3qUb07Uek8kbZrnpaEmMs4rsSwRCs4O9Wr6dVz2XwzHPs0Ms4y1Cyx3pQIDAQAB';

  /// Private Encryption key for `@jagan🛠`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCIDaKsb+CaPXqw4DrvZH+7XXp23o6XmdVqH0c6mmxuREajpAf+XacRRulkUB9m2n/9EsXxeqhrj66mNQQZRnhpMEc8u9ELzXP4FeiYBko/LBs2x4Smi0CrPqECmjZq4Qx/UvHjsDoR7aRqSnb30Zf/wUrkXsDekNBnPgVhruNjdnh9wsSLd6hEZM4M7Z5xP8x0n+gqgCBZSujyJaAmeUHvzFcMJU9MS2ICuOu2jdlljOKcwkLf0lyLiLFcSFE4XTzy+uxklS533bfXLy3vKlCjo7XLz+BPepRvTtR6TyRtmueloSYyziuxLBEKzg71avp1XPZfDMc+zQyzjLULLHelAgMBAAECggEAYkIOwSCPgnVyPXnDto7LXSL2xhCXxM85/UmXpLBQLRasOZTGnSM//E9NUcA33Y1iMAC16l9ecUg0px7U1fg6ECXo3Oj74d1AquQPtnOcfaE6Ckbv+2PIkaRKnlmHgYsE/pOF1J26YqZRPt6GqxW5A+GyV9pCyrqleFqnglPPL04VH3k6l0WSq5lYPErpbSYuFTxN5EZr14i5SglVq+IfSKgfV32a5hkETzhZIHYoPgfZnNlRO7YsxcvTGdIOz1d53lZPuZGDAJ/NDIpMB8MKWZaSTqiN97t2c1P4Yv55rTQUiQfnDsQH6ikAnCDS0353GZPLZImqVvAUbXHMkticQQKBgQDo9p88JHp0UtXIa5/WqXLGjDG08oh0396GI/mme42SD2RJwWdb3YoWaRJtWNtdco0LPhf8tHEetkJOukjkY3q5I5gIeMGPrrapQI6wx0kqY2qGzWDnVRLnioQEj4X7Q1WGqUrB2WxojWRaILPOZeW7f7Cb23R4mzibxp2kq4+jdQKBgQCVgcV9uQh0Dr55O4m7bTfB6EQf/i83eqzWUhTkdtzkrXyRM6ySEmmYnnoPIwLWcmVTtP56AEPHEvVIOVUy1O0yKqFgfA9DtoltViGphe5pNnovpEVawWDod2o1aBAwmpWXb0U1QHgGud9bdS90YTyMsCfUT6eb7oPuhh+sCGrtcQKBgQDg7DQjkii0pMGJhvfE/sc1EWhwhvXeucKUCqnf5kxyZ+/xEg0j8gp/xqSm9HKfj5jD8Qih0OmiuF/euRblg3Kay9Xe4BAqFIqBcTYTUeW/SkswqZxU3Zup99+ss5GtXX52zH7EGJMFgvYP2qEfttwOoqM2Z7TVOTB3nlTYB1hgfQKBgDXIcVtA7SGTDEJggLPEHoLLI3a+4g17PCH9dTaa6+v33Q//Ht2Nch9NI2u+lI7AqGLsgX8yCS/cShCpT1Tx9EJPw64J8xPQ3q9OhN2PKK0AxAPPfIOhfVMjYjnELc7OTXIkvSjjAEqrIwarqV6cfEPAOxPNc+ZMb3mnFk202YKBAoGBAIQ91Ik+iBbYFM/R28/gI4tOVkz91igNqf1KO+SArNRrz4JVoAuvya736/iQcEhUpNP9YWYsSnZ/2P2+CJd6fnms50s0RbIeXpG0e54rwCGdffmUn7+0pjON2cgRvya9ebT+RGUNg7rrE8krdyul/KUzLN2ahzoATPQNMrd07mVQ';

  /// AES key for `@jagan🛠`
  static const String _aesKey = 'u7WlCn0lal6s4I7yR1sRanhfKaRQtqdVNOgI/F2izl8=';

  static const String _apkamSymmetricKey =
      'cOLGDtn7106a/4DFEUpeGP76CLcyUkYhdPC0Jqf8mb0=';
}

/// All keys class for `@kevin🛠`
class KevinKeys {
  /// CRAM key for `@kevin🛠`
  static const String _cramKey =
      'e0d06915c3f81561fb5f8929caae64a7231db34fdeaff939aacac3cb736be8328c2843b518a2fc7a58fcec8c0aa98c735c0ce5f8ce880e97cd61cf1f2751efc5';

  /// PKAM private key for `@kevin🛠`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCIsWdigHXeVNyRVRV89la9el9VHlWHKOoxTJFMPUCsL2wFiBGvHL5T4qZ1GGAfwoy0a5B/6vNVl2Khxt0ImO/b3tjZEbdiDpI6E257Dfn06gHWul7blXgtWMTf2hsaM3dnRNm3ck05P98Y9OBTMHOws4YiF6JnMa/vpNwxqA4MR4Su9QjOrqR4slRBClTb9kEzs3oautMvBaT6NUI8sI1n4ceqr3ozD6RfNiFb1tg9L3vi0yshY3R3HRjRDtECjf37phM3V0AVB7P8sPcSL/+8LHUrFsVDuRgKhIudbEp6R52n25n1oWwcMEzgA/L5AQJtEHVMwFAmKKQSuTZrarZ1AgMBAAECggEAYEJFoqkB2AJ8nN+E1U4IAUCWt7M32YlnejYIL98GlvqCIFcU1PLx2NLIE7eJoXP4b+k7hckneIO10mTfLHm+l2AT5rDCKgxGzxz19TP/bIgJqXPu7sUQLybO5TCLW2UY1aE3jCay2Pjwm3t+KTb6kVmqwIFSPUdRNPoskc9drSj8HEr3Qzf+3q2oJaKx38aL1qZjowdvZPs7lizYjR77HSR2h/AR5xZ5oec4RMfK9TlMc2e4kk5IOSCZgcld+T7krXIFQ+1E/E0r4ibUSZazR/JsOAuo5TZqULuHyb4iSQ1zh7Zbg4qC7DLZnVQ8S4JHWXI8KszwzrgZSB43gVL99QKBgQDFjGUVZzBSVqvQ6nnK1ehpJjm5o6f4Bs29tw4q1nMvJ4emdR2QMzKziRDrkm5SlP2iC9sci9XT5Q/mYCqW/1laLopK7fbG0F0+tfRGO4LV/UzoMkQbueP3QqotbNeEqruvCLeoGVG0AwfPQ8IWJvm2/ALHfWXxIfj2EkoFEI+wqwKBgQCxI2vyl+gDVubzl2HdIcJRaiBCpUNhA+Sg5tvylYT7+tmzns3zQa0cR1D1WkpPGiJo7Sw1x3okqL7PCVRdw+BMSiriB9SW+CNxYWoLH/ruz4KnbE0bdUHHqV9/sTM3oPbby0/WRTSH2hy0TYpenzFJTU+RhoxEx+hM//zh0w51XwKBgQCuqrXtuLE2/D8ql0dcmsnFvvCnPRaU7J8ZMTOrmLV7af48paygBUS9DWISiARXrDieANGZaeKEWjI2xayimeANJr1MBx99JlprykHTn2bNggtv+pHR2gjAZQdG5segG72aw6BvVwOwoEVVc1m2cHu22Rgz/qIWFK2mFQGxfLUvxQKBgH/wzJv4edxHnSHdehLEulwhYdGhGextammItN4efmGdSjZBAhGrowPkwqWjpD5D6wyMGT1yqVbnBoH1BBmBS3TusNB2xWaRLNBMgtIsNAremEiioYKui2dRfyd0bkDEougXjb9+VrW0pLzZsJItOuTt0QWT/6YCGVfcIONelHfTAoGBAL+QwsfMpmBXvh9LE5MYm0JCtwBT8lMleFLyccexJeDcG880UxHicKfp+kCYhaxx+rdXObvVfyg6UWQfWjbr4dyugI7Pk3BzYPBXaQeYWSo+6hFmRRlm9R1BNyZZelxPwzOSUwk9o6MFepAhh3S9L51hDKSH/XaR+nFl9K704aCm';

  /// Private Encryption key for `@kevin🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiLFnYoB13lTckVUVfPZWvXpfVR5VhyjqMUyRTD1ArC9sBYgRrxy+U+KmdRhgH8KMtGuQf+rzVZdiocbdCJjv297Y2RG3Yg6SOhNuew359OoB1rpe25V4LVjE39obGjN3Z0TZt3JNOT/fGPTgUzBzsLOGIheiZzGv76TcMagODEeErvUIzq6keLJUQQpU2/ZBM7N6GrrTLwWk+jVCPLCNZ+HHqq96Mw+kXzYhW9bYPS974tMrIWN0dx0Y0Q7RAo39+6YTN1dAFQez/LD3Ei//vCx1KxbFQ7kYCoSLnWxKekedp9uZ9aFsHDBM4APy+QECbRB1TMBQJiikErk2a2q2dQIDAQAB';

  /// Public Encryption key for `@kevin🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvH1ErXT/nImTNAhExbgT+10ySxT/3z5A9QRyhKWfCTp39sy1BODYbEqiwX35egXYr9KbNHMg7i6AzaYfiNGIOEVlx8fViePuQCLKqxMwC7uWxHfe77FuGA/P8SqiVB47OfT7BzwatENZLisbB2X9poYThjuQqsmfeSI4BxGVLpb4ivCZ9gi9bFGhI3RrDOVAFJgizm5wCeiEXfgV51WBFzK3HfF1SNgMpJQ7qTyR7902dw2BXNC2+tTnyAXQNx5KchFO+LVDNLQECTOER0CBtx98KshOaoHCXHTwtphVoE1uHqVO1zkuGxW5Lgz2TR13WBR8ziCJb54d3G1vTfxMjQIDAQAB';

  /// Public Encryption key for `@kevin🛠`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC8fUStdP+ciZM0CETFuBP7XTJLFP/fPkD1BHKEpZ8JOnf2zLUE4NhsSqLBffl6Bdiv0ps0cyDuLoDNph+I0Yg4RWXHx9WJ4+5AIsqrEzALu5bEd97vsW4YD8/xKqJUHjs59PsHPBq0Q1kuKxsHZf2mhhOGO5CqyZ95IjgHEZUulviK8Jn2CL1sUaEjdGsM5UAUmCLObnAJ6IRd+BXnVYEXMrcd8XVI2AyklDupPJHv3TZ3DYFc0Lb61OfIBdA3HkpyEU74tUM0tAQJM4RHQIG3H3wqyE5qgcJcdPC2mFWgTW4epU7XOS4bFbkuDPZNHXdYFHzOIIlvnh3cbW9N/EyNAgMBAAECggEAUoAN6FIWc2CwAo0/9L6eWF4xXjWhzQfFjLjWmwKW+oYR7f8pmCoF8Fg2prRJ1sPqVQK8lhdyKW5HSDvW/56eneqaIvhvmbwfEwlnZbuvQuNnmTTSal1hz7xUCr3bcTAOQk7c9Qy0r4Pu68tIOFPG0vVKZG1745T+bRmyJj3m6w2/C1kySp5Z4LBL5tvNoVz/s2UKTZ18GeH65Wx1770kLKuCALlocyUBN6RsfUWYCNv15uH21dIAtvAqKMf42WuHzHlucoX667HMXbeE6F4xNk3MfdzfNjHaWKrQvfyyzihaWICakDwbPUAkJa4gZVSwqfEbzSXBqd3sPMTIsYPKwQKBgQDeASVzJqGUDwoiBBAWDWSHCWi18uGO3surE3IvgR3Jx3mimHp6te2WoG9JdDZGvrMyg8RAjcm/rEdd/q3zp1nSsLu+27p4aUCc91MUrQYN10WdG3sBIZr4yKMVntAqQQpMSchxhZ5Q/7XR/lAYfj0iH0gwDSsAtvc3e/NkeoWDPQKBgQDZWklCI4LJmE32KlzgLK6ctreJLZ9EQQ6wAvaIgKkKWxYzmngsUrxM1SjvKFwlGR8aVZ4lUGzjZZH/5y+GqNeL5deoDJclWIqGiHnKFtcwWyAb8ia2KkoxX7nRhMXwrULcJCPHORwtA5HL6issQnBv765zF1o7LfEWq5OP81RDkQKBgQC+TtU/pPoV5d6V0k3H2as3ZwVwE8jvpGWLPZxAxLo4YtsOWw+DablFyjocCZcNhiQvRW1SuTkdKh3zoYKUv/zr87y9m7Z5yiAtboa1zqzF6KgwSYJkMd6bLcM/oWhpEGA3jXhaeGSCovHGFe+rT2wweAh1yJP4hN/fnE3E8JLLMQKBgQCUWY5k6Q3sgNq9aN6pV3X6mq+cnpn1IR5gPjV8p6w42EDICed6ASJqopbk3Tw/Se0zsTpWp5UahAnpiyaiF32/C6ptFeLX553tAxt1Nq+7XocE6/tGHIk1N+wBOElN40QeM0CEStOTWbtaXcMH23UYwZPlFAxPFiVWXtdBykg6MQKBgEqLuBtGCwTzeHqYuOYZkPZJb8+OVWyW7ENkKU7+1+w9CDj4keH2olzf+h/mulL+JeM4OwbCum/LFNRm16oo4M9AxRD1WomJh4KoRXBUcf7aNKueHBOuNCj05kbggtuE3ByiJCqs9mBdAMQP48umq2Uyvh+HEpV+pbLfaQwUYVGU';

  /// AES key for `@kevin🛠`
  static const String _aesKey = '/1wmMjcbIMYfdV09lDIysEm8KSWiVEe2UX8G9AteObc=';

  static const String _apkamSymmetricKey =
      'hKKC4wBaHazyOyvUFrtolU3qpjGokJSIAtY3XP1sIfI=';
}

/// All keys class for `@murali🛠`
class MuraliKeys {
  /// CRAM key for `@murali🛠`
  static const String _cramKey =
      '721741f1f9e191ac85f8af185b57627f6b2a66be8f8c40228d15a8b17373ceaf1c17ff575af621d3b231f63b06a8ba3661c551d301b79b04e8ff9063f00c2de8';

  /// PKAM private key for `@murali🛠`
  static const String _pkamPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC8GOJYSgfKEoUVs/KzHsPZ93tEsowW72OuPjCfo2lFt3SKbeR07Xu1qEk/qBX4asC5LQCXzG+371eLA++cxOzb25XdI5qi/8zWvYYpyUHAKjMz+mzcs+V8Huh8iv0HGjsNVHFFRSqlAvM/RdQPPA/yeRKa879dYDWAUsVwzNGkE6Wb5HQcujBnNQlddnB02EJiv42SOm3Gl2KQO14ptF5cL+3BSzEDia1o/xhHqcJl+1vzkgR8NnHdonwJkuWanNlsQ6wPNHsEG70gaXS6dcsgG6Ke3BQQiny9EpXwQ/UqZGCKpfOyjQk2lz7PO1o6iOHRh1MfwqonH3R75+3f1G4/AgMBAAECggEAOPZ0PXaV6002fn8TZclQWIcJDqHfqOZwUolE4mNzcwh+w5lKEVsGFtpS7HMzzBpQKQQG5PGld5eE9HWJr/k3HdHfDaxFnU1INFQK+EaZod9lyDzzkNbuDWuyzlytCeSYs426C9dJddVx4tx7vu1aivy9dK2Sa23CZg0q++EbL8u6dvXdLWJWs8dEcLkKW1hfhquA89Xd7eQrMmBFfTt9RQatkZ+tKvATCiz0aZtLzwzXyg6W9Q13I/ngqpGxbYQG3Qr4MRyN9toVBnq5ftxrQznzeoVWPACWKfuRYmXrrkeQojZiltdJz96+9KjI6y4b1lvUMmtU7vUO81AkxS0wYQKBgQDc2KvoxDXUuJNZIumJTskw8TxdztqQaVa+F8e7E9nUZrrJmRa7eCZmIjWDWnc9I23QTOOJPR2e29sJ36I98PynErV7IVffuHhujbBxa5Z5etAenWB/tfdekOEQZ8Kb8h4aKDKKh7pz+PjF6hoeFwg4CsvQnSlaBL5FFnrAG/vZbwKBgQDaCbU4nEeugMb2dk3DTFvHOVACbtAmlIxA3CO39jn08lmEev+TyLEsfuJDIPn0Wg8M3w6JpWDFQ6BoAb4/OCZ3jOGkfMGsV57EpzwdiVSKXaCPd3TWLyxGSwZVBZEfYSxMUiI99Cwn5YbbZaE4lD/ixP7VbrpkwWufEXEmhlUwMQKBgQCdb9kdlsLJYsuoP7s8p23F9jOSrGQjjvTHjyxTsVMYmCOQlBIgkwbMyJZdjaBzdU5TsHyE2YzEMvdzknmWrrVuZWf630pFsrwoE9o1AP3EnEjBim/Am3g9cgsAJvgVNAVBoGZnW1sQUe0HKlx0FvdE/G1Pyrov8jGyDtRzH3/rAQKBgE97DnaOcYrpIp4hTgONSD99Yu8gGfyWVfImzVZ4CXSDC6LBe30RwZQoxK4XzUYHtkjI3vHKOVZvan+/cux0uYEG+BIP8EG0xwmEtONHdmvh6W+i6hJRq+AL5UkE+Hvp3k4L+rN+2MHKZ7h+eaC4Wfl+Oi7vaD7mSyb3Iroaad9hAoGAbaozEbBH/kKUi73yRao7rGXCmFiqsvP4V3zaFQZYLzEWz/u6WMl4P+bfJLDnCWN9Gh4Ie9Z/lVl8jST+M6+qRzYTzuJtaZCI7UlGJzv+1Zcxq3a3EWq7uHOSMWM/XuUV8hlc9hCzEaDhG8Wa1+Rrg9tkgaRKblZtL6YzM8SeFtU=';

  /// PKAM public key for `@murali🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvBjiWEoHyhKFFbPysx7D2fd7RLKMFu9jrj4wn6NpRbd0im3kdO17tahJP6gV+GrAuS0Al8xvt+9XiwPvnMTs29uV3SOaov/M1r2GKclBwCozM/ps3LPlfB7ofIr9Bxo7DVRxRUUqpQLzP0XUDzwP8nkSmvO/XWA1gFLFcMzRpBOlm+R0HLowZzUJXXZwdNhCYr+NkjptxpdikDteKbReXC/twUsxA4mtaP8YR6nCZftb85IEfDZx3aJ8CZLlmpzZbEOsDzR7BBu9IGl0unXLIBuintwUEIp8vRKV8EP1KmRgiqXzso0JNpc+zztaOojh0YdTH8KqJx90e+ft39RuPwIDAQAB';

  /// Public Encryption key for `@murali🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqxjwrGbRX9cYQC867Z340Za/aekXSjDT3dmeUZDr1LL2biuemkdknO2Jeh6jxYua69V3eEsDV032SIFcaVOEKE8jY8hVFq1h6KNjUNJVF++RwFmCM0H+9Oh35BppgwThqFBFSTy70L/bzzKSKH2WI/Vk4lqPcwU0U/BGzzUxdUSR1kDX4LN8WJF9ehX7rQb0vweU2GVg16cFRcLhodBRdoC9/8Gb6ekKuT151f4ohd5qxeOpF1xNOFgHos7Bdbtpz/DrsHS5EpNCNc5GvNV66Xsv8kXGzhMCvcxuXOl7IKsAiCxISyAb2F/y0WnJZZMQXIuYr2WkgbMeNSbHPh8OvQIDAQAB';

  /// Private Encryption key for `@murali🛠`
  static const String _encryptionPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCrGPCsZtFf1xhALzrtnfjRlr9p6RdKMNPd2Z5RkOvUsvZuK56aR2Sc7Yl6HqPFi5rr1Xd4SwNXTfZIgVxpU4QoTyNjyFUWrWHoo2NQ0lUX75HAWYIzQf706HfkGmmDBOGoUEVJPLvQv9vPMpIofZYj9WTiWo9zBTRT8EbPNTF1RJHWQNfgs3xYkX16FfutBvS/B5TYZWDXpwVFwuGh0FF2gL3/wZvp6Qq5PXnV/iiF3mrF46kXXE04WAeizsF1u2nP8OuwdLkSk0I1zka81Xrpey/yRcbOEwK9zG5c6XsgqwCILEhLIBvYX/LRacllkxBci5ivZaSBsx41Jsc+Hw69AgMBAAECggEAOO8jpzrPkUTSHQmaYlee5J91MpkN1vJIjhpMRHglAbJLrn11WYFISbABf1GSzbmW48M07iKIChU3Twk85w+TepZbAGk5Z0Jqwi8cbViQWFav+YHPgZ8EaBqzSoQ/eAm3zXpok+ZR2TT+wAPj/vVLcMvHtkrMUUn6D7R0256nxo1u+fdJ5vsBefhSKR23zNfp+ynU54s20Gc4ejqDujbIow+aiJZv9y/asPG5UdSWN6ykhoPlOCv+VqAlGT7OWFKAMTUfIZb1UsqCIYKN+BNbwFBkFcuzr8AM5Xxd1DoNcBVdLOY6j+6k2kd4U0XxvLAhE0FZDVt5J82jGtmDJQyRQQKBgQDjFixG3XnXArYnM8667+LrdIK2UGbxu94pMjRR16g7v+miShASdcxzmBr/oDAHJrSwYg4t6QIyarj0nIfUqUNefQS28qjDBuQRMHwAcYcZZ5QwynJZsyHu5KP/Hqm2V4C7mU84jpKygiDQl9GSXIsIldQ+5ADrAvpFVkyNOwGFpwKBgQDA4dCHpFFmW2BcFIHXn3fpg2JPNSnXBmVl64QRVKUj30As5KMpgULiP5qP9KfogYArm+S+p6uK5s6kqdLDNOMwqCGLD21n8EOzOjtd1bbzxuC/OUu1SCmmqMd64Y+StNj5lxx1FmkbGT96kAM20QnvUdz1U1KeCODprL5z4L9c+wKBgQCztaBklHEPjr3IWF+J4L2byCCJVyegtiQiRfDRs/EXF9E09ZeyhDbAY+c51PMtNZxY2cCO5I8whvTH3/g+e5Us+ZL5lR+o95MVZ2E6mJ1ppWbJFe1Yv0JjY93Ez+dOvgDKdZEUGQBO9Fwzt3HKeiItMSU+gAGZ+klFBf6e5ctWkQKBgFckbpspwOD2vaU8WqE5Weq1QjA4+6s7J4qRijxuOqHnVk4yCglRbg9b3w/U4BtqjqalKwZ8KEN8HbZFR4SMG2y7OVRjZvGDmoKZ94JgcOTYYGfkkfDYJoE2VdGNoNkOPc0d2WyI8HmewZA1Ck60yMFIAgUQXQ4rQrowImemDa8LAoGAYc8Tp8LUNj4fYzTA0zE7YwBga0eTB8F9eHYhimAhBRScG5FYQHlGgNvwfAATclJfX2ikBRHidWUYGM/4+z10ZX+98uwGEwPgUWJCy8mLJ6CJb88a0j7LQjOYd5ZT+Qi96X5Y4RRYj7/2CHaq1KvoywqsGoaVaiTK1opj33c7F64=';

  /// AES key for `@murali🛠`
  static const String _aesKey = '7l00PvmXMD9i1z0Q72O7RNQc6D9/9k9FrqfvCZcEBqs=';

  static const String _apkamSymmetricKey =
      'S2e/rEr28kzOlirkSBNYCoRMd0Orh8h8M4JE7bnzC74=';
}

/// All keys class for `@naresh🛠`
class NareshKeys {
  /// CRAM key for `@naresh🛠`
  static const String _cramKey =
      '680b1d580b4bdfb5231b6db336fa4713e29726ee5f4f9ea776d1853c8c94043a2e83b97f1d97adb6c971f0536da0574287314bea647cd5096fe8025222180712';

  /// PKAM private key for `@naresh🛠`
  static const String _pkamPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCItqg+W1CwArqB6CRhKEmXCzdOpgIWn1BvvNDkb7FhWcFEWoIqTsWKE8odXnN7Lf/QHwQDL7MWnT4D20XXOlwcDmRLiSwkSiiMXeb8Q0qvH4U2AFPi9tnGnGVhEe9PylJzhn3iV0GkkBAfkMw0ee4gllbqljt0tYqJ7D2ETOuxU14R+7gQpIzqLAvt53ReGlrD6c3NVR0tF75O/Ul8eTcjR8E9kb7Dhhthe1bZ75aUspG6GD0zoZzbA4l3QMXAvINUKj5E6Rdr3QBdBAct+67att2p9+4oglcnVkpUKlaEAX44wUtZddtELvxaFXG8/thCBkN17F8P9COTyzj4skdtAgMBAAECggEADV6Xe2mgrWXG6XdTP3EaKTw+j2FqqN2xlwvG/d/yX8vQO6gCPLLxXHxs8oxPDMfF0YuG7+zVPavo6aWi4dZiNZgutLhYacAa0QdJ1HecMR4K/+nuSi7Lw0F+JI0Fcy8c+xE29FCGKdqwyPV3Etats+Af5dcFP3eVccF5jpubHP8d4WloPtYV/A/b2Tac7th3AQXt9x6sk3nvTJl2Gui3R8TR3lkE4VxAuOqcPtD+Oqi8dARsHbXHcgeON7I2wN0sIZnb31cm6BoEZlJKpoqx1qPMGTEmR/8LGKzbc0Kj0pisawu15eUB0dhccn2BMDScAdE21vzpKpU4e91KKQTeAQKBgQDh0tgRF0HUmljJnwbs8txg9RVPKNt4ZlUSkSwsO3YAGGKTTv22X+TJWKmtcn3yG8uRgNWSAFuOCX1xB4WAamSTOeXNUq3DbalNnsCrk0w1KjLdhiE0U/0V4DmrCCCifPl0z5UgQ9s5HdzJVuO7iXLIyxsblc70HiyueHRtX+zagQKBgQCa+3aCanQQEABRuTqi7AFOoQ6dCarTn9/rMN1ZUI7Ppgh23NkBtBJbsbAurfmmPmLSf3JbOjpjWOS2Z3xhnUlmBp2Jdrl1+ZyH3rW311iph2NWQmLKPcJx+wVKQH2TtBaTY1Xpbrj2UTaqkf7L0pJStoAUfp86ofS2DVPrGaD+7QKBgBDSdgn/44WE4exTDl8EUGpgl2/IKWE0rk2txs6ct1OWfXFfxwKY7iAZnLow9zTb4TQ7lq1DnY5dIp0S5F0Gj+tvurCq4grW1m/TzaJ6XIjxVcyuuzZ8szO3+lPFTTkNej+7Xu6CX4hHszTEZj6IJKbUinZpmHsS7F0q1/F13d0BAoGAUwMD3CDm37+iXCOpq6BbpuEPcb++1zFX/6KhvPgwNjrJZ9ktBwOLnb+UDbyz7n6V8ge/meubYKE5iBXwAlz79oDumrWT6wPy+reof7sBy3QwGgDe51KjNufsUnQujxGz0egwGSNsQMsJS919K3EzXMhR3ChiY0ZiS6zh2RhWKpUCgYEAhySdCC3vbVwG06ltF9DIVWwyD1/zffMc+NTdI82aeRwRjgc1O0ZcSimf2o4feEXNVCe6WW+ZW9HrykHq0ANVibTMPNvsuhAk92HgMB3vndPCsIs0keyxgIIBEHrVHM/cDf26quz0t2GvCgKANqTu4VTX5c0ECwk4aJQ1C7FXLew=';

  /// PKAM public key for `@naresh🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiLaoPltQsAK6gegkYShJlws3TqYCFp9Qb7zQ5G+xYVnBRFqCKk7FihPKHV5zey3/0B8EAy+zFp0+A9tF1zpcHA5kS4ksJEoojF3m/ENKrx+FNgBT4vbZxpxlYRHvT8pSc4Z94ldBpJAQH5DMNHnuIJZW6pY7dLWKiew9hEzrsVNeEfu4EKSM6iwL7ed0Xhpaw+nNzVUdLRe+Tv1JfHk3I0fBPZG+w4YbYXtW2e+WlLKRuhg9M6Gc2wOJd0DFwLyDVCo+ROkXa90AXQQHLfuu2rbdqffuKIJXJ1ZKVCpWhAF+OMFLWXXbRC78WhVxvP7YQgZDdexfD/Qjk8s4+LJHbQIDAQAB';

  /// Public Encryption key for `@naresh🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAh9Ky9vpVPdEueodV7CzJRnaxsgqvQcVhz5VGQFcVN0v3yDxUGEZjILAJ+UiqEoKhOEP3LGMqNpC0kdOfjch2D2TujJu9HtgvrkhxqamfOGykTk4ixC3VDtAwBlqIEi5/T90g2DeyPifdIPFsn3RxIs8rYq6egOpPMkcttf9OONvGxdmlvdMNbsgZQE0AgPKJXT4l5h8BMTrkYSSwBcJLbRKO4FKhOkqbNPF4b/flmcjJ5y7miio0wh0fxAMS5ijdTSocf3HD5ncIA4udiR2tT+J2n/6YbQKlMlWUtqjwq2EnVz+SXKHnNXkaF50CaSXF5LzjuClw4zAdGVVg8v2YywIDAQAB';

  /// Private Encryption key for `@naresh🛠`
  static const String _encryptionPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCH0rL2+lU90S56h1XsLMlGdrGyCq9BxWHPlUZAVxU3S/fIPFQYRmMgsAn5SKoSgqE4Q/csYyo2kLSR05+NyHYPZO6Mm70e2C+uSHGpqZ84bKROTiLELdUO0DAGWogSLn9P3SDYN7I+J90g8WyfdHEizytirp6A6k8yRy21/04428bF2aW90w1uyBlATQCA8oldPiXmHwExOuRhJLAFwkttEo7gUqE6Sps08Xhv9+WZyMnnLuaKKjTCHR/EAxLmKN1NKhx/ccPmdwgDi52JHa1P4naf/phtAqUyVZS2qPCrYSdXP5Jcoec1eRoXnQJpJcXkvOO4KXDjMB0ZVWDy/ZjLAgMBAAECggEALB1NL1ajdQ6KEBYA3FK3lQFcOb2qqqwXVrrfNGqUY39zHUAq+C90ZtuGgccOJjDzeDjrASm8PjjFzU901TI01k8sA9NZm7kP04WIFVkYc9UlkKFkPV+9gbAwyP+CjpU3mJLz5gZBCFseQWLoqunBDVNIfibFKI3x5xyjRieEGocbzpnf0C+MKH28bKa0nRu9HRmdwP3ugKXlzu90r6es2ShynUcwEQBqx4LzYQc0YMbi5dT5UJwJAbQQKO9hKiysRQDzT+Vv52mBkKRiOImf7Qboww/UmXXjsrExKb9qMr2OAHjs4YN/9eMTyqMpeg5M6F5EU2w6wiNvJd2C0b3E0QKBgQDlWniaQ/unYNBwKHnOj8+F0CAwZGmegX1osPup5q3SBH4lUXPp92mPuxkm9QJrt6tZkORCz6MvbfP2mqzBoiRn1Qu/f+CU4XLiNSkFvP4IuzcjtxS0rMsockKS+xXvlo001fIFTrib3bPhPfm/iYpNRJpPp+5qe5mwcumbzDagbwKBgQCXmmhBf8Qm3atmfBDaSzA3bJy1wgfxVwzzMwT482s0Y65qsR/WEkLrraKYrbRYwxIpZSJP9KwXd9fWhrGfccr9cmEVYZmCL5kGujqhQ2f3PoxSVTgE4YAvy+v+cz0iZLZN+s802Gl7JO7i6TBVNidtGI5gkaGJzcOUx48ABOEDZQKBgD0cLAI+lvD0FNWtkzb8jnjDCbCbMKExM28PqR6N/kZ1N/9NgqsWZyQK4BrHMYvt9lP5DTjYBkz+6QAOGnXFdBnOZED0G6zPnUK0k2eaAb3l1D1J7NRvLfpq514uVJvv61PmpYPQg9PT8LfVQZRNW3JXEx6iSh5JLJwdIi2G7g81AoGAGwhXasaDjYKdW4rn3mTl1hwx3V8Z13j0QDFqw5F0HkVgBnpK+PsMn8W4Zo0iyWkPRf5YnfU88npWLFScO5go4ASTNyLOIp6mJML0TWkdksK+drfnY0dqehtcm2SlFArtTv5YEE4+kMzHJAL8sVUUtqlYSfPt4Aqmw1LKNvCnxtkCgYEAz0DKXKGtscLpd5o3qf3hJHKfOHxe7wJdG6bQcuQMD8Ue1vgTsQjE5YnGT6zPsrkAzq9l38yzxpPoJIAX6JwXbuvHG5ZImEouNA+hPtxn2ROqlhZ1mliQX5VvHWoWZrCyDMLJX+rTt3gH8KFPdCQL0yRddGhl9jgv8EWfaVKk9yQ=';

  /// AES key for `@naresh🛠`
  static const String _aesKey = 'PZBVVg6AzUdzeuj01tozYB7EoQ6N+pj/ghdu21IhnFQ=';

  static const String _apkamSymmetricKey =
      'KcnMMvXYAnGoFA+T9sBw+IeiI04dsWqneLtZc88i00Y=';
}

/// All keys class for `@naresh🛠`
class PurnimaKeys {
  /// CRAM key for `@purnima🛠`
  static const String _cramKey =
      '91890877b8054eb456e6dbd0a739d5433c200529cbe885754b7d9947b8eaa317459785bec8afb904eec947ddb36e8a22eafe12a54a39373d381f08c468ccea3f';

  /// PKAM private key for `@purnima🛠`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCFtbUMP/tNEH4N6VwB1cfUNIvJQcAyaLLc9kVvco5bNW/vy3PXSekGVVebkDiFHYg1fAjGzjCING7hRfrkC9mI485nCaFzNFoqcQ2mcPmBVBjgPijIkkPXIvXhkyvnZain7fSkV09q4lpL3VrGw32s/5HfNHyHJQ1D+58Yn6FVWWzX0/KKU9T5dxdBjO/ce+KksqkZyZaBPoNhdpywBC6eMNDRke8K94JlfdsB73QriSM8GFDPyh9x7FLiSZ3D9iW6JSuB1ucbXp4DUAsy8OeqY46K7C6QjahM6KRHYhNATV1BFaZhIvKtu78h86YtNEL20ho0QhE/2CFG4fULMDL9AgMBAAECggEAcL2MwZ51Kz6buukn/hgenQwNTY4WG6ryHaO9WkIyTC+biYp3y3BzfjaZXv7U2VDUV5yU3eRfQYlMcMAL0xs2udizYWfabQQYfq7CfrPFfUnGi9V9l9jUQOMmhaQNIdgyxB286JEB0rK2xj8HWo7dOfBoM9bSpTUVoVvZgu6eHxLGxKjxFM8CFX2XOxOTateMHf4TT163WKRy0fAJ7EOl1ar0GIO6CkYK8FL1J8sr7Oa9QFv6doSiiUnUl4uWptlKF9+EhiDfiiGhFZIYfeljpjh7ZOY3e8pYgdVhsucBxGZGyIh/3ojf6/1pAKhRm27rDSAWpgZvkMdsA7aOBKxT9QKBgQC8+UfT2JOj9F/jBM/sLssjC+AklXOklVfNhzs9kUYWxg37jW9iUzUtyvRts9tGDTjs6rg+qnKHBoAZA8SAU/xggJDTF7dfhIQGsjcYzkPIYI9pGmGZWhSDLPpKpIVfbMtCQnizDU465M8DmAZIe0cWXRZRrzOROf4By5podXbsGwKBgQC1InzXpLDPsqS52MKi3vuasKzk0x6rKNYh3z2U/1DsIzz8ZYraXyJ1aTQP5ExW4tcDvx1DW2fZ9F6CU/fVmHwJ1IvL0BZzdvTtWav66a62mYsgf9X10a4B+bKZb9MfnTGjg0K+qGXgs6ZTCukBYAkw00tnULc2S+5wPkl2tnKexwKBgQCJSl35teYFfpxPNYbNo21np9APJBkhIHLq2e2bHDkcgIVWFXovqB4Bh+qu7LVInoCV9y0mMfUEzh8wjUEsrlez0JPnGNrbZU36A23t8qTiJezqwgTYQc6XQo0Qv5g6LLM7D0nbY7ZLKUKQ7Njbvdx2jeiSLcQ8JTK6IS6r53MfswKBgEOQr7zIg+OVoXhpcIDMaFHVYUihr6jsvKM54IC5k/fhVRhY0CiQoAvnyDG9WPR3/Pg6y7GaYOyeCLrYk3OrQ2lvTQ4jepxrXQVEE7Cuhis6rvjadncRVbUK7SHq4nfCbQevKLBxpD7jBEGpqiyHJCaASnopU43/WNupgEG14J91AoGBAIyq4QWYzRuv0VYhfLvd9Ydvj3d4kN4n4d7ZoJp8nfUxU9Aue9TXrGEuN8lBLLKV+9HALeOc0ptwIVFf3tBSoudDXXfksHbeHyZw67+HLnzkPy8hs1flj3jiMNf5aIBNjEp+nWR/RwN5rz1IMzOMYirpz+CCmZ3DWb9wjffAAvXM';

  /// PKAM public key for `@purnima🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAhbW1DD/7TRB+DelcAdXH1DSLyUHAMmiy3PZFb3KOWzVv78tz10npBlVXm5A4hR2INXwIxs4wiDRu4UX65AvZiOPOZwmhczRaKnENpnD5gVQY4D4oyJJD1yL14ZMr52Wop+30pFdPauJaS91axsN9rP+R3zR8hyUNQ/ufGJ+hVVls19PyilPU+XcXQYzv3HvipLKpGcmWgT6DYXacsAQunjDQ0ZHvCveCZX3bAe90K4kjPBhQz8ofcexS4kmdw/YluiUrgdbnG16eA1ALMvDnqmOOiuwukI2oTOikR2ITQE1dQRWmYSLyrbu/IfOmLTRC9tIaNEIRP9ghRuH1CzAy/QIDAQAB';

  /// Public Encryption key for `@purnima🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArLxzqTp+6Sf8k11yheBt0yjhDRZVWsb1LCuWFgmnUE7QCjQgi1hCiR4s10fZl5CAD9nmDCIhj7Y6dpsD/1WyG5vkDCyc7fmYSlrXqzmGzINoIlZ+WyMsbAQ3H0kO92n8kHY0lY5YxHZMjpGW+kpVNzNn5Uin2xN4YNmvQyscp/5r7m4ZhWK8Oh+UVOK7Yqs1BrTxThx//e9rj4DjPm0heLwQCywHHP1SvDOcZoWICTReV92w0UY+RWBns64JFPtt1D6J9iZiUMI+0dnMZ39sETYfT04HM2r5wZeagcBXt5AGj1tBBrrUb/73/7rv/coeWGeEbTIs2RMmarKFJw3nuQIDAQAB';

  /// Private Encryption key for `@purnima🛠`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCsvHOpOn7pJ/yTXXKF4G3TKOENFlVaxvUsK5YWCadQTtAKNCCLWEKJHizXR9mXkIAP2eYMIiGPtjp2mwP/VbIbm+QMLJzt+ZhKWterOYbMg2giVn5bIyxsBDcfSQ73afyQdjSVjljEdkyOkZb6SlU3M2flSKfbE3hg2a9DKxyn/mvubhmFYrw6H5RU4rtiqzUGtPFOHH/972uPgOM+bSF4vBALLAcc/VK8M5xmhYgJNF5X3bDRRj5FYGezrgkU+23UPon2JmJQwj7R2cxnf2wRNh9PTgczavnBl5qBwFe3kAaPW0EGutRv/vf/uu/9yh5YZ4RtMizZEyZqsoUnDee5AgMBAAECggEAKGkeFeUdc6ZrLH6cID3U86WIoOsspMQO73py7kzr25nUic6QHolTZ4irrOGeQhsIGq07aHNDrr9PBhhV4xJFTLg3rbFyNSpDOoHuGpymsIm9fusFPIUKC2shCiypV7Bv6cv9mU9n7O5QErp0u7FQJk3cbIOG4XW4n8/NdMVNOu+is/6jBfyFfRQL+/6smCk5UQaERF7yFml47ClwYmxVBXZaPuq6B1ozqCvOvqLl04MARQFkiGqXpBdK6mlEV+PIgJH58Klk1aB3nOI7/8UUz4bFKfF0tnKlO6sqmPY6rCbt9GTFqwupEmdAn2CgNmQx+WS8RW38s0EiHAqVQA2gEQKBgQD5cGknKQA5fO5+HtmKG1nbSc4O9OTEKR/AUReSvJK0b8+ZCiDoc57JAU21EhZKQqH1+8CbZVyfzJEEv+jKaTGb9vomY/YxTVFMf/4PaJ54sRB1RHOxxNfzsQ3UwTl6W5tjRYGgsC7s5PO4DgSNVPSUZmeWDJR8oS2Lf513Xz/VAwKBgQCxR5B770KYN9s+84l7s0jG5j8oKTXBfFLrVVjgGslndiIZ0CNZIi+JFt/pKLo8qrUTEias7yqaa3hguEJLJCOTrawi4DVPJsAjDYDB+KY75cw5F12HUxF1oSDgdxzPj5+DpF6iaVvQmapKDVeNfL85tLWieDirMECdb8d9rIHdkwKBgQDbpxiB6oIPHauqliH8ku9CwrBYzWByOMCECyTWC4aoq9lEq/2klMQbvzEdpUrJo/mZclL+xHiXI34Ej7ZAH/gWnptTmS0f5zUTR5aDHR6Hq2yRx3CV94AvUReb5Xdm/ypLddabmOoJo+fWiUmK52flEnRfVr6fLRO9Ruh0SQUd3wKBgGqnZ2FofGQflqO02M22+t3Ov8hlopWZOjmiyylodCrug22MLvf8/SQ4wtT/T6wX94BVtzbrXHIyneVydU/Hmi/KmHkS8n+ADLAJ+6C2+yumAMuIJxi2/RYLrj/c6VRmT81fIiALytUg3bZXeIkCt/j7oxrvwQgcq4MMMLSHCEpJAoGBAM+OCx6/hDpsVwK9oNcIdhv2hXx3E9K1X0FDHFq6IUWrT05NIhhJ9DGxic93o4AZpjiCzD0P4N1MQ2WWmcfnDYXnuwT5NTuU44dO5TyvJvy5GDhZMOHp67sE/qFJfbHaAi7xKVg8Xt+tToFNTRBSoFj6WttNagzCQFD2AGSXWAxv';

  /// AES key for `@purnima🛠`
  static const String _aesKey = 'A+PLEY7DkKBUqx7Gy/Dt3P/rnehaN9td2E9sVuepiBQ=';

  static const String _apkamSymmetricKey =
      'm6fOwRXTMdYPLhjjI5Hq3zfF8OXz3byQWIPo/DPgQFM=';
}

/// All keys class for `@sameeraja🛠`
class SameerajaKeys {
  /// CRAM key for `@sameeraja🛠`
  static const String _cramKey =
      '67f75d44efbbd30547b9d090cf67134bc591b65ea7e1c4dec42d08e50ec4b89fc7ba5431ab1ae0b1fb4c99878955ca1f90798422526a070ef1bf2ad428c6353a';

  /// PKAM private key for `@sameeraja🛠`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC/PECWWstNQq3kHcyX8eePUaGhliPvnQpKoAC5A9u++HTkFZ82BHxLkkfhFCVi83Qf8QCvyC9O77+6QA0/PhPoiq2ijkIaXRFlHwSWHo7Xr29kzdteA8KA1ckaktB4Ed00R2ntrP503s77DxYEe9eDr3RmULbGMjeiQ8dUpg80jQtQGZ76050P0K8FLPpeNmO6nyQ72nHXId7fqkxsXF5f6QrepiGUTqJcu+2knG2tXMoeVw62eaNiVqxR8Ing01q9gVTEyceOVK3/ainlCXKFf80nx7Nhvt2LIcpnWhLt8iMisLkm8R1EGHux1a94m8iOPS4NY+GOxqBxgX1w6unRAgMBAAECggEAHF5ZznQlmI59sUtiYF/4U+BuM8RMDG2lazCVKt0RqiC9ZmB2v9Kmhadrlk4gxa8L2PkteuYdbn5OWNjLnkgdN+/qliS4VaTcwb16NrLNyd0yjyeilS3FmsscDB8fYdB0mh7F7gYtsTSkS8YPJBci/1v1zn/GvVwRuLaJSVthAhBwc7QgLCsTM2H0S4n6G52iaVuJ0ULp1xG5PjEAfuJ42WnhezHUOpQOvRzD0wgmr9VRP2kgBo5DL4uH5ub28cTSRJ8T7/jo2BUT+Ydi7U6ZccJ/XrHtpCJXsv73VwJ6HAuu3DBMqtHtXQK8Lo4qgD93d6/KNUd4CgDgxof71fVMgQKBgQDvu1XICANO5zRiwvxfAyevxYQVoEUQXb7euXHp8xo2aL3JfqBAGm2LrbzvRRQfKex6PKnnP/QADT/9QYCojr+LDWrch0AzhmDIuJ13jLBsUhSADdtyAGTzE/iSeHWe+cSA6w/3v6OXvZKsvKTFCH2zmWlqwDyDGcCD4+5lLTY8uQKBgQDMNm2vO2eStxbNj+o0TYeQ9l72d2/NYh7l0csWsWztJIvRVI90WG4WmaClzC3WVZ7xpXi3MQzwVRHacq9zIMo9FfUQ4sZiPMbdyEPCEsp+2EJZ+PlBKwCaHhasAWHeiDjuvdaOPLwPAbOKxsjt2ag6KNOAmbxfoS9TtTXsIi552QKBgQDo4HNI+De2ezRRSBZ+eYMg5V8U3vaYGmji1QRKfiQVfJP4W3ByNPn7OM+TIuiUCVa1u55UjLSLJFPnwayokNqSynrnNN9x7fSwp14YFuv+nZFaf5uP18A4vUq3hhrETt7LWQzO3zOcoMQN1sa8vC3XvIxB7fIabHat6EnZsRzByQKBgASXzMu+KEwydf7Vl8zpWX03LVeZxBf4dv1wRIMUJoEG62Yf4sIZIxC7D9PqzbUeY97He/mSztmw8B/bqHqMaEALeGGS2CdpeoeOc4ev6IIF1ygy41hF4VOWDah8t3jL04v7FRJJ52jm/uTGJ8rBtHjqZidkTcpQ08GsN7RB6I2xAoGBANEn4oq1ThKQY7J3q60oFOWOBRK3iOlTy3Pdk1eTj40vTbMPdJ7en4JYd7nZFW5037QVX+nPEd00iDIqEaZxIo3PrIYhzc0fdsWNjvGUpLSMhigxGzy7NmchMEP/1CslE1sk45BOkHB86fjOQI+mtiuYochTo4mh9uXwK7UuQ9iV';

  /// PKAM public key for `@sameeraja🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvzxAllrLTUKt5B3Ml/Hnj1GhoZYj750KSqAAuQPbvvh05BWfNgR8S5JH4RQlYvN0H/EAr8gvTu+/ukANPz4T6Iqtoo5CGl0RZR8Elh6O169vZM3bXgPCgNXJGpLQeBHdNEdp7az+dN7O+w8WBHvXg690ZlC2xjI3okPHVKYPNI0LUBme+tOdD9CvBSz6XjZjup8kO9px1yHe36pMbFxeX+kK3qYhlE6iXLvtpJxtrVzKHlcOtnmjYlasUfCJ4NNavYFUxMnHjlSt/2op5QlyhX/NJ8ezYb7diyHKZ1oS7fIjIrC5JvEdRBh7sdWveJvIjj0uDWPhjsagcYF9cOrp0QIDAQAB';

  /// Public Encryption key for `@sameeraja🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAhxeCDBQPE8YJ+0ymCl3sOT/7WTjuIk9jkd0yvSd1IHcmQi4UgivIdppJKGwHVX3LLulfXahZuuqCtUbRkSLklyL2QhFU8Rtnhfyukl3Oo/0QTkUzIEbkezruSBq5zwyALxSzih+2+8PiM8s+AvRDo7ZwdQdKscrvrKGBxITOqf8BqSxuLGcp5LKK3iFh1VV/6pQYDjTXi09T1N/p+xMeMwJdhx1VY9BCsmnDXp7RKYq2wQxh3PnpuX2S1cgmZK5RfPKyz2FdzVNjptNoHTfAHuh/MHNEto6cFNYNLxjdXAykQy8qYFgECXT5CnbZklrplJZOMaYgqSyil4ywhIM1OQIDAQAB';

  /// Private Encryption key for `@sameeraja🛠`
  static const String _encryptionPrivateKey =
      'MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCHF4IMFA8Txgn7TKYKXew5P/tZOO4iT2OR3TK9J3UgdyZCLhSCK8h2mkkobAdVfcsu6V9dqFm66oK1RtGRIuSXIvZCEVTxG2eF/K6SXc6j/RBORTMgRuR7Ou5IGrnPDIAvFLOKH7b7w+Izyz4C9EOjtnB1B0qxyu+soYHEhM6p/wGpLG4sZynksoreIWHVVX/qlBgONNeLT1PU3+n7Ex4zAl2HHVVj0EKyacNentEpirbBDGHc+em5fZLVyCZkrlF88rLPYV3NU2Om02gdN8Ae6H8wc0S2jpwU1g0vGN1cDKRDLypgWAQJdPkKdtmSWumUlk4xpiCpLKKXjLCEgzU5AgMBAAECggEAB+e1QXWvCC4viVgL41FpsFPxJmBxduqEXhW+kVkMvpCaWYcOxis/uMkAfPANYdBRonYfkYB3d7ufWHJDcyXCkKGIHYecG9vJrAqEQKZioC//00SzYDElz5w8M1X1B4uouJiShQOkFol45CUBhPS8PIlBfWem1E6WxdhRmqlW2pWuN/SvHCfHBwX5drrGzwFxHiodDeHv+mhwxzqbOM13kS8aM6YzzdZFh4YJ5UBOGkLB+YCv8Ittit/BZDLeIq4D11smUZQchL2kP/zRECmqa1Gxdr96Q595mkeO7IuL4Nro3zPV2L78giU+mhOPICsXLqPX7KDyOyrb/gjXmnIdvQKBgQDory1njff9FWUE9sAEOI1VmRY6OZzJL0+K3UK4dhCme4zd2f0dbA+6HwIkaUxmiPLeAlKyVVSCM12ZtK6JfuK9zPByt7TgF2Q7GatOYl8dYTK4vda529krwipDIAq1hnrEer0tcjR7VpyCOqhK8auTWRJljpq1ss1NCNN0+OarBwKBgQCUoOL8Jjf1Joy0yNufT/+hGWc48wi+1TIa1EaVfThhPnTwX3bmud3QWX3SZ+ypEiZ7vWmvcpgdVy1fdzHjjZqLhNHgL4r5ajmW2mLXHHVEfGrkY/8R498T882vwEExnsd+2WuTjeQq98BzHm6NT5CbVyZIVHv5RgDeAkj6LKPNvwKBgE8+2gfaogrfrnfyUZMeb4QnjxplZLBgHIb+tCp+i00n5uHny/ypQPHyfZhJBGwnWA+kWuXBifaN5+LhVlAdlrttgLaROljXnptCMsWPWzV2VP/2J5tE9MGibyJNV1hbZJRl+OfxbU5UQRlZQNfFVtnoDAvqdWZMbv89ckb0PhshAoGARcCf5mB1YIsf+/RMBh+AQ/XtGLAOiaj6o9a97Yhf/ltWfD0BS1UtgYuOXkHBsrM+9lG1mM56D0MLm0MQWc/qGNJTwRfu7BDrSB3jxzqm2mZdsCQx4A6GchG4lWPv9L6kt6aIMy6jR3sQibZdgdo2boDfCZEEwb8Vxxthbm+mzHcCgYAVWrk3Y2z6voVHtgb2uSk4q+MrzZQh2xCsCXuyvK+1dtlppTD44P9Tp8TGiGL4VU8XkwIeyURXaC5xGZGaPBryRAhzMhMWvoao5yE3s+E0jPXHBj3yYz/Cpnouv565C0qtyA3DMpPutqYq0kcZSFn/DEaTDdoHLjVpeSczy45XTw==';

  /// AES key for `@sameeraja🛠`
  static const String _aesKey = 'GAnfgPgtcuHywoiZAzQTKwTPMP2T2YkPk1MjNjWvWQ0=';

  static const String _apkamSymmetricKey =
      'MvT6ySjAvsqFS/zJHmnkXojr8tpNokKXVqs1IR9Rr98=';
}

/// All keys class for `@sitaram🛠`
class SitaramKeys {
  /// CRAM key for `@sitaram🛠`
  static const String _cramKey =
      '15cdce8f92bcf7e742d5b75dc51ec06d798952f8bf7e8ff4c2b6448e5f7c2c12b570fe945f04011455fdc49cacdf9393d9c1ac4609ec71c1a0b0c213578e7ec7';

  /// PKAM private key for `@sitaram🛠`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCTauOYbRGwtdJUdIhUyRCXZggjPw2T2y8l6oo+DRb7qaeWqTruvcqmCj9lL+yCauu7VHYdzN9Gn6wQogMutl7LaNcBaDrfmyclpRGFJBuvJHazM4DAA1WZntQYkFVErihAdB+tzui+MzE7Io5av8OsfPH/mKBz7AQi8pAEOW1IoRIOKAcdX0wzuL8lXbn6dYZPejyQhT3344xElWmr6jzuxZC4sVnjIBOGiUY3Y3Nj6g4byJ1LYbyOuaYTll3lD4id0YgAoNS4M9SG8Hnyu7BH9QLLJKJTLmko2vLg/FywbHBRJhhfiwaVi4gp+G4UNHAdEhswciJHmqrQY9xoEaj5AgMBAAECggEAerzDE/SzhuJLZV/E5nqlYrhjzBzCTDlwruvw/6rcWNovG2R5Ga9RWx8rGy9khk1JSaYP1c3ulBl7JDoP1kOm90qpwJUsd2HxnQkrZiPjHNaKMbeO2c+s5IN16aG6LL2n68oDWi3sX/e1ZJvn1CzXWPSKdBl6dimqZAJ639mEYLPfEbfo2jqZpJktmpdaVvI8cgi+TSnOdLdSF+uAZzEOuG1SK7hg05SjOb4WuWT7ZmE/jipL/u7LLI77bOHkSWU8Eg2hxkAjy0x+TkYc/Gimf2SqDVsdutA3egpAX/sVHNJT8pE0u9WtFiiKlTx84ebtBmAV8K4/Kx5dBCO5G7vdtQKBgQDFa9LH9WSJJGiPJ/ngGZ4fM4FF1GbGpfvaHl2DB32LFTbNECjs/9+QQWkijJPSSUhdbNBIzm0qR8XM65vtGEUn8bIxX8OtFuRDVlTYPBjFJN0eLtPQyfguBsimQdnRdghJBdBENuwVJJHh9Hac0uiKRd+yN6i3p2XfeGcmjOBXswKBgQC/KMW7J+gzzwUJHtxJP1CEFDYtzRtirc0vK9rdLQxLtwlLGfhEXuv5jKrFUNrNFPYHEaVDeaARzdKeC/Lo5A3Sl/y7y4aF8vQei7aR56DayCKw7C5PnXYVQGF+ENvCrd6WgqiUJUTkVWdy/viTnnbWDnWZA/O4yq1g5t4x2FXmowKBgCo337CRQrmtRoruspoBAHaNriR/wqbSkiRYAAloTamzlK+PuCDOq0GPK2uPAoGi2E3aWkRnmKLFDIDBFexDF27uWfwDDbZzQcdArA4989IdCwhMXVG2D1PQcZJUXL9VbXooOxyLXjs7QdM/UypAVChVvvu+uV7k9n0uo2h0EfnPAoGBAIPiPmE8TDCKUIAVYYfLfeJSC3sX+h/fpyM3T32u2b/XHTtKRIXvM0DtcthFS1+YaZFA9FMUM4J1DS1rMwDIblzv7TcnWL1LfG8ilygctVacI4sKt3zINzK8Q0b1nJi42kvfAy2KdPhPj9q/3IIEHxrZyPpzxo+kjW/AeGXNSp6fAoGBAIs0AWG/LR1VsSw4D9/Zareo0lUr72A4awoPVRqzD70RvwT1+hC3jOxjt6tSi9fY2oSYUPx++mBd+G+CYIqBESRBLhvJLoSTKGZuQyWnJfslkZDg6ojWCXxKAv90J3QRikh/1XRtTqVqIOBBVvF72faC3Dn/jPOB/N0ggvUL1URJ';

  /// PKAM public key for `@sitaram🛠`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAk2rjmG0RsLXSVHSIVMkQl2YIIz8Nk9svJeqKPg0W+6mnlqk67r3Kpgo/ZS/sgmrru1R2HczfRp+sEKIDLrZey2jXAWg635snJaURhSQbryR2szOAwANVmZ7UGJBVRK4oQHQfrc7ovjMxOyKOWr/DrHzx/5igc+wEIvKQBDltSKESDigHHV9MM7i/JV25+nWGT3o8kIU99+OMRJVpq+o87sWQuLFZ4yATholGN2NzY+oOG8idS2G8jrmmE5Zd5Q+IndGIAKDUuDPUhvB58ruwR/UCyySiUy5pKNry4PxcsGxwUSYYX4sGlYuIKfhuFDRwHRIbMHIiR5qq0GPcaBGo+QIDAQAB';

  /// Public encryption key for `@sitaram🛠`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqZzijT3bJuSYOOC+Hs41BqZHQrn5h02aWZAR/gDvJAi+8X7RZYI0O164Tg5tN53X06hDp0E20OG39bAchL9pQ6TYVVIPZ262brQxH2opoXeFaOTnvq310CTcstn+1fdrkjyW5LhcBDQEFrmMhc5v51n+CcjfeQDnFBAaBhtsSXozqw/XW4NwNK25eAqSEUALHD7Ic4Wr7np4dLotAycxghkBpIe6J3QMGzStEhTtN6QsXfNRr/y55X3o+4MgTYJHQK3KrgaoivK76GVGgY1EofWHZR12T7yZO6A3yBzLBnU14AuyFl8CYZHI0UL3SHRkhZYATLjbuMlratHihRkdnwIDAQAB';

  /// Private encryption key for `@sitaram🛠`
  static const String _encryptionPrivateKey =
      'MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCpnOKNPdsm5Jg44L4ezjUGpkdCufmHTZpZkBH+AO8kCL7xftFlgjQ7XrhODm03ndfTqEOnQTbQ4bf1sByEv2lDpNhVUg9nbrZutDEfaimhd4Vo5Oe+rfXQJNyy2f7V92uSPJbkuFwENAQWuYyFzm/nWf4JyN95AOcUEBoGG2xJejOrD9dbg3A0rbl4CpIRQAscPshzhavuenh0ui0DJzGCGQGkh7ondAwbNK0SFO03pCxd81Gv/Lnlfej7gyBNgkdArcquBqiK8rvoZUaBjUSh9YdlHXZPvJk7oDfIHMsGdTXgC7IWXwJhkcjRQvdIdGSFlgBMuNu4yWtq0eKFGR2fAgMBAAECggEAY2QvzhylQ5FJMmtgfaTQpejicVORyZvMCxfFs1bQzAjj+5gZFKbL/M5wqi0CC0lPpBRCMMyiVp0us6ZTz+ZqxNzgeH7xz+asuQqWjpYjdx8W6nTY6IAAP8yaF6RvFOs7+iHPOpBeO4hPrRFmKzLhmGy/1PQFIF9LChK1bUa8mgEwlZOTg2XhYcvABLScYG4eOK8GOOVkDX6KWeKC+5sGZuUA474jZLO/hExtGihpxGGvADyvWrwtkDtuyns4YxPbwIEAgxdKxmlf/cxebetyNBeChJY4H5UNndhN8bm+CqPDT+q7HjusavT7oRedyXvr0SZqqSj6W11JbtrYw8JtwQKBgQDnt+ZiWd94wcNAxS7n9ZGpK0Dapa48hmNPCJafEFqWo615JhiuYoPVh1E7cjWHnUOTj1iphTUmI4jAYopAIdpvRwIvgu/7XzNdCZI85WgMAa3u0nBaLOINBi3wwYoe5rKBnTbkX+L84koe7Jt50QRASz/H40xVWt+VwLkXJLOPRwKBgQC7Yu+W0rPoChDhzf9p3i14vzqR5OiMDRHABGkdYtPYGl1LzUkOQbsmjWjVfX4neItlhQOOLHZpChOrKGkVuRRLIlq6T6VlU7c42mwj285nGrV14fFrBcg/jrRMc5qKLarGDEo83j+VW6XL7du7bRTBdStK8i93wLSbsjo7xi2a6QKBgHx2mTcG0zRHz5sAzzsk+oKFiyZmi/pSrREMqerym9YCQPGr9uHkZK/TKVzm8b3QSTX/bz5PIMdFmvTLeTsNdAkFeTUP/dtlvW8h7vzqtEKOvGBlhJfLN/iK8y44pvoGLKfWTF/K6V+wJOQLb0+1Z7UpNi8l9iB62VHU3RaDTjeNAoGAPknn7JHDvdlCvVy1j2KMaPvgI0kdSBi8EsEkk+EbHFW/N4hYxYVyCaGt/HGHsuUuKSPrB6KeBdKUsStwqwjnxwX3dMEu8JzAZgStN8pENR+6vCHMF1BHvWDZbCRtdYsynjzNnKggKKzbUwuRJB9ha+Ff77zLrJoBL1QyaVY6KKkCgYBrp6fjLQK7G4fP9H7Ruak+vhrLug2luymFiHzJI89FLeXV6JTxsutjFAWvw6iFDFmo+se6S54n1/yUV3o1zYDraS5ZevqN9TRefi2ddmKjDdLPeXT+bRF/bv0jh9YAL33u0v5PorOJDT7bnLLb1t6lWHJGPXYP77COs2RMvk7tYA==';

  /// AES key for `@sitaram🛠`
  static const String _aesKey = 'REqkIcl9HPekt0T7+rZhkrBvpysaPOeC2QL1PVuWlus=';

  static const String _apkamSymmetricKey =
      'KsmGhxHU+2f1DITP4QQqvziX5UuQ8G/YgIpwoMqUZpo=';
}

/// All keys class for `@relay1` // same as alice
class Relay1Keys {
  /// CRAM key for `@relay1`
  static const String _cramKey =
      'b26455a907582760ebf35bc4847de549bc41c24b25c8b1c58d5964f7b4f8a43bc55b0e9a601c9a9657d9a8b8bbc32f88b4e38ffaca03c8710ebae1b14ca9f364';

  /// PKAM private key for `@relay1`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCDVMetuYSlcwNdS1yLgYE1oBEXaCFZjPq0Lk9w7yjKOqKgPCWnuVVly5+GBkYPYN3mPXbi/LHy3SqVM/8s5srxa+C8s5jk2pQI6BgG/RW59XM6vrGuw0pUQoL0bMyQxtR8XAFVgd54iDcgp4ZPLEH6odAgBraAtkIEpfwSwtMaWJCaS/Yn3q6ZoVOxL+O7DHD2dJWmwwjAJyDqEDeeNVuNHWnmj2ZneVXDnsY4fOR3IZdcGArM28FFcFIM6Q0K6XGiLGvJ2pYPywtzwARFChYJTBJYhNNLRgT+MUvx8fbNa6mMnnXQmagh/YvYwmyIUVQK1EhFNZIgezX9xdmIgS+FAgMBAAECggEAEq0z2FjRrFW23MWi25QHNAEXbSS52WpbHNSZJ45bVqcQCYmEMV4B7wAOJ5kszXMRG3USOyWEiO066Q0D9Pa9VafpxewkiicrdjjLcfL76/4j7O7BhgDvyRvMU8ZFMTGVdjn/VpGpeaqlbFdmmkvI9kOcvXE28wb4TIDuYBykuNI6twRqiaVd1LkKg9yoF0DGfSp8OHGWm/wz5wwnNYT6ofTbgV3gSGKOrLf4rC1swHh1VoNXiaYKQQFo2j23vGznC+hVJy8kAkSTMvRy4+SrZ+0MtYrNt0CI9n4hw79BNzwAd0kfJ5WCsYL6MaF8Giyym3Wl77KoiriwRF7cGCEnAQKBgQDWD+l1b6D8QCmrzxI1iZRoehfdlIlNviTxNks4yaDQ/tu6TC/3ySsRhKvwj7BqFYj2A6ULafeh08MfxpG0MfmJ+aJypC+MJixu/z/OXhQsscnR6avQtVLi9BIZV3EweyaD/yN/PB7IVLuhz6E6BV8kfNDb7UFZzrSSlvm1YzIdvQKBgQCdD5KVbcA88xkv/SrBpJcUME31TIR4DZPg8fSB+IDCnogSwXLxofadezH47Igc1CifLSQp4Rb+8sjVOTIoAXZKvW557fSQk3boR3aZ4CkheDznzjq0vY0qot4llkzHdiogaIUdPDwvYBwERzc73CO3We1pHs36bIz70Z3DRF5BaQKBgQC295jUARs4IVu899yXmEYa2yklAz4tDjajWoYHPwhPO1fysAZcJD3E1oLkttzSgB+2MD1VOTkpwEhLE74cqI6jqZV5qe7eOw7FvTT7npxd64UXAEUUurfjNz11HbGo/8pXDrB3o5qoHwzV7RPg9RByrqETKoMuUSk1FwjPSr9efQKBgAdC7w4Fkvu+aY20cMOfLnT6fsA2l3FNf2bJCPrxWFKnLbdgRkYxrMs/JOJTXT+n93DUj3V4OK3036AsEsuStbti4ra0b7g3eSnoE+2tVXl8q6Qz/rbYhKxR919ZgZc/OVdiPbVKUaYHFYSFHmKgHO6fM8DGcdOALUx/NoIOqSTxAoGBALUdiw8iyI98TFgmbSYjUj5id4MrYKXaR7ndS/SQFOBfJWVH09t5bTxXjKxKsK914/bIqEI71aussf5daOHhC03LdZIQx0ZcCdb2gL8vHNTQoqX75bLRN7J+zBKlwWjjrbhZCMLE/GtAJQNbpJ7jOrVeDwMAF8pK+Put9don44Gx';

  /// PKAM public key for `@relay1`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAg1THrbmEpXMDXUtci4GBNaARF2ghWYz6tC5PcO8oyjqioDwlp7lVZcufhgZGD2Dd5j124vyx8t0qlTP/LObK8WvgvLOY5NqUCOgYBv0VufVzOr6xrsNKVEKC9GzMkMbUfFwBVYHeeIg3IKeGTyxB+qHQIAa2gLZCBKX8EsLTGliQmkv2J96umaFTsS/juwxw9nSVpsMIwCcg6hA3njVbjR1p5o9mZ3lVw57GOHzkdyGXXBgKzNvBRXBSDOkNCulxoixrydqWD8sLc8AERQoWCUwSWITTS0YE/jFL8fH2zWupjJ510JmoIf2L2MJsiFFUCtRIRTWSIHs1/cXZiIEvhQIDAQAB';

  /// APKAM private key for `@relay1`
  static const String _apkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCmeLQL28BNyIOYotfSnWfjLtdIKNLTdlla17SmnLdq7xmWIozoup35T7dkDWdP2jDJAYBDTpw1wwIz393t1fuB0Y8newERBfyYV0QYRnvCMDH5XLXZN6g5Ec74Z4kP/hv7PUWh+ZdOSoYCpeM2f6kJw7lBBwtM7xTheSlCIeCYmA7/JT+QeAcHLMIexdnOE/HPzXGL6Uu7bZQGoe9E4esnGv9qhhBiu/gBauh7LRGumL1SgCEVSx0BS1WYSYoy0nxQVOVf6pMfsKai6ERE+OjANQa+s4nKrJ0w+ESMeXQa38ZglJaGFbu4on27TvDpgGsEMtK0JyeFri5v3MNXq7lxAgMBAAECggEACZV3YBtlpdS+ZsIxRKnVOkoPENNw18W/fTBf8Ruin6BmS7Nvg1KDF8BUIYl4AivglSHl/XoAGkRA0zW3NCMWmLG02SQGurEqiqazf+ZG57YYmm+Q9JF0uNximwBy7p3FhKBRavLQmCxILMzaGOAenjZLawf5yZMWE6kDDBChOoemfuljHNM85FIeHZ+vgudeGi7sY9OG5+oa+RoG7axX+3Dj+BlFUV/o30LImt/Hg96cp1h2a7eCiaI1Cs3ALEM0oPlKbAj8Pg6D62+STSMkpd6z8v1LNSi3pOWqCgD+F/ur3+q7vdcQ4uV5Bd6FQv6EPb7PCnNaDbJBxSiPw0stFQKBgQDxFTslKml55O3OK36t9Yo8zPiH44p+VHMClMCkHH4QSGwQaODIIln63IdM2WfdlSsYfmoToljFOs2W39z7xpG0/g/L2Pe2nrSlFkhUB/PUSTyjnc9gS/w/v3jFxtj0EhGzNc7c2Tsu9WbisLYH7eod0NhvGWInCu9j8KL38M6KRwKBgQCwxZ9UiDrPHUrMEl31up/CEZ8RgMBSW/x5wD9VFZO2hD9KrFdckBd45FGaTFII5wG53XEOUaMCI2VXP2SNM15eaYxQ3v2y1z0k5xqhR7XG+oI0MmFVOkz6NEakC2AJGBZYZwzbFiu3tu1ygu1gBoauEsgMzmCMhQmZNZXfftHChwKBgQDmEbva8QmtsSKcwXdobk4ZTgbUL/sIKnGDghABzcskoOi4FE6Hz/iM5g4c8dEkbmmtO17iE+mhd0eh90u93zdIQbkzcYCdAAInFge6Ych4y9eZ0U2JeZpl/8UzAVwkOGY531zl+E15t+oS5k8hbBQjlh4mkFPSLKZeetQbx+xjmwKBgQCJZPDUCRZ8iG3sc5IoPieR9ZRHTGUvHmP8VZpkDWNEB0ISTiWQwkYcJonufcd9N9+1kRIgaP9j2BMaXyFORlDg3PS8nrVdXcIefqnKFSyKPYcZ/tZ8IdZW2m7Vbin0p44mo+HwHylXn4yq5myNqETh46MtoPKWBYlSVb3pem6a3QKBgEyy3E24xqxVNcto9+euhTBvtbPV4YmQIkvXQCLJwEF+Cljbo6xe6mTMZOR+xGVji3FUjbXjP/fPfjVuWaFfPd2WK0zlQWUesMatMTa0Kq3XohUiViTUWlZTV0mzn5Mq2+inE5srLi7+eSHV4bI0FzjRXVDpv3zWIvQJrLtJ51LA';

  /// APKAM public key for `@relay1`
  static const String _apkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApni0C9vATciDmKLX0p1n4y7XSCjS03ZZWte0ppy3au8ZliKM6Lqd+U+3ZA1nT9owyQGAQ06cNcMCM9/d7dX7gdGPJ3sBEQX8mFdEGEZ7wjAx+Vy12TeoORHO+GeJD/4b+z1FofmXTkqGAqXjNn+pCcO5QQcLTO8U4XkpQiHgmJgO/yU/kHgHByzCHsXZzhPxz81xi+lLu22UBqHvROHrJxr/aoYQYrv4AWroey0Rrpi9UoAhFUsdAUtVmEmKMtJ8UFTlX+qTH7CmouhERPjowDUGvrOJyqydMPhEjHl0Gt/GYJSWhhW7uKJ9u07w6YBrBDLStCcnha4ub9zDV6u5cQIDAQAB';

  /// Public encryption key for `@relay1`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0sYjWt6TTikajY3HjvdN3sn2Ve3O+i84/gBrWPqhGNSdImz3W2l9dMSHm4wyixsxMSQaL+rECjwnvp3sRdW3M51sDCvWa06MLptvdrtnMjzDrvP45hUJY/i6WeDW8qeEOf9zuo+BLcQ3pkV1KZyhBj80OndLS/y00T8fYB9KnS5Z/iN7KW7Hxuv0isMPXxL1i8AZos7m5GuWq7CfRFKJIZ6vqYBUJCVSQCUVo1llyjElodSywcf1KjCvBOKuMPnUQCs+pKJt3QMFI0U7D+yinnlEdr6TBfOzMMPS3Du1LHpTGt7rqyxZrX8p4kpVb/CyL6wkelMuahHDOeNFBNyF0wIDAQAB';

  /// Private encryption key for `@relay1`
  static const String _encryptionPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDSxiNa3pNOKRqNjceO903eyfZV7c76Lzj+AGtY+qEY1J0ibPdbaX10xIebjDKLGzExJBov6sQKPCe+nexF1bcznWwMK9ZrTowum292u2cyPMOu8/jmFQlj+LpZ4Nbyp4Q5/3O6j4EtxDemRXUpnKEGPzQ6d0tL/LTRPx9gH0qdLln+I3spbsfG6/SKww9fEvWLwBmizubka5arsJ9EUokhnq+pgFQkJVJAJRWjWWXKMSWh1LLBx/UqMK8E4q4w+dRAKz6kom3dAwUjRTsP7KKeeUR2vpMF87Mww9LcO7UselMa3uurLFmtfyniSlVv8LIvrCR6Uy5qEcM540UE3IXTAgMBAAECggEAfImMLE3k1cLdqJQEPIoNHb1RatZXfGXYk+QliW6VLzm5GrUttnpvIUZaJeNBngXUHAgL3RInATEn/q4LA/xSAhJa3Bou2DqSA5vd0VbLk9hpev82qqP1Z3d4jFCYUMoAC9DPTYUrO6J7iyfxIUQltK41qvH/sIdBQ327iS0UBihhiKg16BOKG4SoFJHZfhhL6m86+jnsaBTaAWb8hpa/Mwqs5eDHF78DHK8o+4Q6DufDi34nCwdxEexL3MFa9L0qGbQAqJshgDcJ6yxUzb5+tw3XXpiE0yG9aZ5gPaS2UgOYY1m2mmF4RjFSiLmKyN99H99ycA59enVFyfYh4SnuMQKBgQDq9IwkVyDkNxkaW6hyYMzBwNqId74JUNjXCWyzDJ58JWaNvFYYY4ujSCLTdfdugmVTIUjqXMVsxzq/e9jNaOj7u27/3inqn1VC88GFJJiUiLQcTP1T5ySP4jy5GVrhQ1zP8PtiRqE34emYfVY8OLa7bwf5CufgbL5RzKPrfIafKQKBgQDlpx8DoETRPE7FyZJg9xiUTyZmI/P6RmhCO86knbQa4hEWiCuEIiOheJQxdcW6yCNImbJNSEFUnpweiHEw4xdMmlpR4JDkvsGOyjLI6Y36Yxbi+AipvTuYZ/La7fuOeEjwD7OlgJmva2jEQL6GlhmTibgt5dfwzOiAP0gC4tXomwKBgQDAnZDSLfeSADV9LU0vz3mtEYxWOkw52OSbjWdmdd7ricHESnUOc3VDe9zJHLmnCBFHEE91im5zWfUoi8BVzT7LOIKsEpaseMjuJWUt4K2Rf2ygkuFPSnvn1SHQ4R9m8tGAy19a1upOJM9bKs1qe1ga2tBfc3havOtdpfVwFVtL2QKBgDFsPehx3V2KNQmrz6y+gLOqNQFWS3NZI6bdaCNVLSV78WF//J17G1/sqzfZuKvx1mYRbaXkHusvFzoa8wEqXiFGNpnYUlZoFw+7xCIo4T05hftilbqx1tl9xW4IOVL33/qJ5od/nZN68hkKNfaQ5wAxa0m1ZTuVXZP8CmtUleRxAoGAQcz+GcrzLybY8EMOhYRbb79H8tQ+SoFkTOmJV4ZQDxzg18dPd8+U3YaMp3QngxncOSpjSwsuqpw/SqxHBQE/v91uEzLfPPS2QJ5COBvXM2Y7PsSmMnukIOM0NrtU8MIonv+l7UsHDeCllqe5+uRPpBUUk2mljPVprXo0SDjQr1U=';

  /// AES key for `@relay1`
  static const String _aesKey = 'vR+w/lx9qitj/W2+SfFxbjeRM8VdaYGsxG6lxYCVQ0w=';

  static const String _apkamSymmetricKey =
      'L3czUyrn44iOhBIYMkoNkLfriNeXcWwOH6PDHugBTY0=';
}

/// All keys class for `@relay2` // same as ashish
class Relay2Keys {
  /// CRAM key for `@relay2`
  static const String _cramKey =
      'feacb0894de2d9476e903be2164b01194dcce1490acf6d588400ef469cdd6eb1027e2baae02acd820c3a4727905f3e4866572714fe554aa2284ec8bdced0d767';

  /// PKAM private key for `@relay2`
  static const String _pkamPrivateKey =
      'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCcREINL3XrjroiefgN+yPrKWjwYq7n5JLsheT0dWdvE+s37wjgSVPYKJ3KIFXzGAYQguxBBig+g79qn08KaX06xHDe/m0wwwO1Y3592t8/25YRrBL7feu50X8b2XP9cezJwrdpzSDdnWvfG62ZM16Xrr5j+qR+5tCbDsN0loMuE3F9Nbt8Vf8KsNfIGzkrr12WJM87WPuksBGFJA7Yyq/F+iaXu6vLdB2fI9jiYa3kRlVWsFymdewhp1wtvD2Q+Or932dUJPoJ/Fz3JV4YLvrCN9j2MaBCGoC6smW6LY7qwEwUHLAvIVfl/c+Qz+pCmowT3zlSDss21IM7F2vmVOUnAgMBAAECggEAYptj/sQDKih/ZkAG+nOOf9c6o+3xpt0CpYP8LRJkuaAdHseUl0tOQCmpICH1epefRA4JnSKQhJpIULTEgLJ+VnYdL2nnZwy4K17kM/DITZh4AyDNPauA81myVtWKLtUT8WEQsg/B/HZY2omxqunSd+7Jr3c7E+T8n8vaJJjRoGGgtMIIuzxTR/Y16hT7va6PkjnrK/nAgVtzSbuamfHT7pB/vgyGWSkL8DAxCw3T+ot6U1YNHEOHNs2f8/TWI1ltiTeeoQiSjHPQXHDOJyrjYqs1tEne21k8NhbVUPRpe+U1YZR3r4Co2GcLwZS6aBvkBEeXMwNu4OC3rupgsz8+mQKBgQDeYBquzP+CYbLXn2Cdy9Lldp5fAm68lqSpZ8ScWlxnogZusDwTWwlPNyOjNU339NTdMuweJLEsBYVe7dMpdvgEal/Dx97NXlDBpsYgd3bmQtaJtgruFSMY1ko5fvYo5PmIPzX9fZ6Vm9ESkuuGppK6WqeAC0Y57FpsFy2zM1M5lQKBgQCz5SjIZeO4wo+wr6jcRPy7RUucBPXU4mDg38FWsJgnXdW7C6qtcd0BHzh6ZKOMYjoqejF5ukN08GF1vxqbRzBxY8U4BLFeTeW6hh1+/DYkZaMcNV00+B6Ga7hyNTN7ySgcqe9pjh5hioYNDA10pW6IvrX9lsVJj9w/Hpnv4cZMywKBgQCjo+8ewQYpiQGVgNgVZp9Mcoy6d8zLhMOpUg4xzKEBNg8rtw6OY8im/XmBKcG1fPqDyGxPBktGjM2HfNWORtjeTvUn2lYPpJ8i0josPB1H9tlvP4Itj2pjZZX7V32HvHAQHgv5/U4M5DvnQiyFyuBguENYi3NjPpWPw0LDAzr0PQKBgQCei4Wg8GN9b0OyRW4+CzLuXUkgzSJXp9gX+DvuCh9e+o0ml0aqLCLKHVjqTY3yaJO44g5+qNFQ25YZbv6lAV3JYVPsZf5oDaE8/Xw7cU7KTyUs9D8cMty8PW3GgerI2uVWNdLBpbZS4wH3t7qYJkC/lczRHTLs/TPwESk8SDA7dwKBgQDWGislMMXlgzsk9HohJiikfT0Adbhi5nfGViQ6YubTdjhJtlph7UH+/jPkaHJNifffteLw2zHF7AFnvqdtTJ8kS2kAIZHIjlZ4ZXj8JzkgXoC+Kn4S2zwfH0e2zEVhBUCabT/myiRC15UJMUeb2LZW1cwp/Tx/EQBa4pCalGAKHQ==';

  /// PKAM public key for `@relay2`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnERCDS916466Inn4Dfsj6ylo8GKu5+SS7IXk9HVnbxPrN+8I4ElT2CidyiBV8xgGEILsQQYoPoO/ap9PCml9OsRw3v5tMMMDtWN+fdrfP9uWEawS+33rudF/G9lz/XHsycK3ac0g3Z1r3xutmTNel66+Y/qkfubQmw7DdJaDLhNxfTW7fFX/CrDXyBs5K69dliTPO1j7pLARhSQO2Mqvxfoml7ury3QdnyPY4mGt5EZVVrBcpnXsIadcLbw9kPjq/d9nVCT6Cfxc9yVeGC76wjfY9jGgQhqAurJlui2O6sBMFBywLyFX5f3PkM/qQpqME985Ug7LNtSDOxdr5lTlJwIDAQAB';

  /// Public Encryption key for `@relay2`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAkvpV9qxUuXyrwSjqWOPV3lJK8Zr2Zrj5XQzB28wnhl+EDyv9MpvdqSDNHNsmBp+/2AnYt6Zjadx1SoOz5YKZxxa3xsC4KR2mr093mt7wGjB6nfA8GswffDdpCAKZKnHfz0yVJ3huGu1NLwm0sf1FbZkgOMKb8ddYI8d3jJtdTsiE6rLoDvklkHT7mxabq2yqW4qSvhLn2KxhMNR4gHKiW6iE5a404mwNhPGTxvYhBf3AKPihZ7WibGxACjXtDxed2A4ZoZAAMpIrL1nXraEuOtHdC+GEuLj9wBbRMOw9UFjFjpvYvvPJC9uLVo2Oeu0eY7wjmQn44C8B9ac4PBFCywIDAQAB';

  /// Private Encryption key for `@relay2`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCS+lX2rFS5fKvBKOpY49XeUkrxmvZmuPldDMHbzCeGX4QPK/0ym92pIM0c2yYGn7/YCdi3pmNp3HVKg7PlgpnHFrfGwLgpHaavT3ea3vAaMHqd8DwazB98N2kIApkqcd/PTJUneG4a7U0vCbSx/UVtmSA4wpvx11gjx3eMm11OyITqsugO+SWQdPubFpurbKpbipK+EufYrGEw1HiAcqJbqITlrjTibA2E8ZPG9iEF/cAo+KFntaJsbEAKNe0PF53YDhmhkAAykisvWdetoS460d0L4YS4uP3AFtEw7D1QWMWOm9i+88kL24tWjY567R5jvCOZCfjgLwH1pzg8EULLAgMBAAECggEAT6e4ew1+hWBZvT+tcitYNzsmPrabH6TUEGffkH2eVibh7U8L1CfBA+4w+5iRjTl6wVzkxPM6IZ9HOfESyCn1qX5YbzD3HeFh+tT4n0h/m9H2Qi52hJdn4Owu0haGaAh7IWAB3fhYw+Mj14BNG8GFpRY97kUaOwFYVVu/IMb61LzlFyR3cwhltJ8GNWsEOAKaOfGojkHyd4/y9ZMzgDGkACq82DJsmtqW1XcqOxjQqe3U1b/pSn3NYjUrdXvHhhMmGeANZDPjwXObX73/hTVDkdSKv+662tuj8NJateQKnUCPHm9tTbK80IUrhcxEuq6WrvH6iuvPISruJ+7/k/qkgQKBgQDt4BqmFUdIwPo5YDOOb4vDmxTFga3tcfWXl/RWu38GkXJCvB8SpQ/NfyuXyNNemqIBiEKXZNY7qtkjTYdjtu9X0TmDwRiKopVh2DCZ348QjngOhIQQy+T2mj/HLRkCa5Nj3ntWS1ORkwDsZv+tlMjFW9PgkhMdTYjnFlYJHsCdqwKBgQCeLTkrrbpGlQGQXVSaYWGKiJ3M4/t0FWxuFA1uZAA/0ndv0rK/fHYrwR0ZBemXI7YM7y6k0D0O2h6rID0jmk3PPOLrYtfW+Iuxbihs0ZjKsPovtnpOctBuyjqm1h+ZKO6iosZJW/hcspKaIOYnT35NqR9U6Pay4tNuarCLVgmPYQKBgQCzUJtmFWY+DtLRi5Zxyd5m3rHCzSXKd3x2ASM8emygC+ZBLkSSLoGCHFpFOis0BocXdpsUOvxP0FONDDWCUnWMEnkzu8z/PN40+t5wMBlNlsgj0XsomjsINnDbeUCAFY3u29jHzVK6y0EH9ADK3fyW4ckPYa4tCbSo1qqWh2sVrwKBgC84lwG4Ko0ZvM7JXhF8ku8Vm+5n/VCJeMZgDCZxijWDco6amyxZTrn/O92Vi0fIrHeuDAG9/QxrB47U4Au57BK7PY9CAee2aZW9qinaZL/WF8qYsmirFBiPHPVjpSlHM/6vk3yhDUM3OFb1DWCc9brfi3AA4G1FFBO5nBzswYvhAoGBAIk7BrTdMPlZ4uDpcvyUVI49tFwqs1rKlOdtQ6Wa8QmcRF3wYSNiFqF2LMT15PZ87s4ru/Rpj89d7FEKMnOSBtLZFt+Fplegv2169l4YS4u4SRVI512otYw6E8J3oCYxakAgotb/CAdpo6GRZjibXwI+TiCC1y004045A0vl/Y27';

  /// AES key for `@relay2`
  static const String _aesKey = 'xGClLauE1qGLredkswXPBKNnUzNiAwG7XL3gv0jQQN4=';

  static const String _apkamSymmetricKey =
      'Ud3CMD14E6DyutUlKBa2kjFj+kPlB3+Hf7CpCiNdDJ4=';
}

/// All keys class for `@device1` // same as bob
class Device1Keys {
  /// CRAM key for `@device1`
  static const String _cramKey =
      '33c2df30b79743ff880fc1c832a5c69170974dd736231b84ee360df89a0faff1f6efe0e83064144a7b4e5029334ad1daedc49bf82c0be1f763f590c28e33ba0a';

  /// PKAM private key for `@device1`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCxGGbUHy3bpdMQdvQn5F5dAMEbcDsaYDYsvqYAkjLKGPwgl5pk8gdxU6HnWLaXJDwZd4xRaUDHYToGD+k1xp2SEFjMsxD4PAA9k/hKtddEpaDHEGiC3kOf3VD12BJ3VyFsikZutZtgwF7o5cJCdU5Ppqno5ThChV5I3ZUelfoumqQF1iKnZ3z/NdtWAyFs7HNcuO+bL7ls28CNpVkrPxHbydLL/Y/qqR9xeJ5wm8WnQr5YRVFgYGNi03NlsW0UODkE3mufXAC8ALnQ3W9iQa/pW3QXwMKzuyebF29Jfsx/ELvfnzbgRdlKPNEI++phQyMrvZ67uhSewQnAUrW8+aTfAgMBAAECggEBAInMtf6qgDFgd7phBRyhWze85YXnL2YXpS/t7ReWqwSMqmrl7FJN7bKl494zLmiu3kDmv/19C9XYdqDO8qVQdb15EM+/Kh4t+fXwVIw1sFqPEmqy/s+OCUq0mFGjnsLTvoNJmQJ+N3fyWCea2CyEQLpDsgQxkDRauIG0QVs6UiC+EWaolgYtDvNrXgybjjQyvbdSV5jxuYHvt8uzjyUVDQy22mq9H2S3ztI7KqZYoikoAq+baP5RHqD0CBd7hlZPjEo8+aeQN1WeXKiNQGO6JTfWQRquiGpQkwaVXt7kYPwQ0tYrpOXOT9kCWot+aTMbgyIkUmP44IoxMcsyBzi+PVECgYEA5ErweSkb+DGBKSDOcWJDhsfS6jLTu8fe1Y7h9TtRR4436GzpEPFQPd4192e96oe/IjibWQiIqm4KIwXPw7clXMhOtFpMu5935cJfzWkSaa+m9lHRmn/ire52J13KZc7eYpYQiSXue2aKVLQhG1VDXePO+N6M9gR5Mz52IokFzukCgYEAxpbB6mEbk3//hLNknZGj/WTFQV3FNG43sIn9KZckdBV+9sczAetKNvjScuX4ceNG7XyCnVCl9qmz0+TAGmWfnGB/u4EHyRc5iNNo3q/DVRhUPHeOpSdQw+VOEMN47HELdqzOrK0q4BbSJlFdsHjL0P/oFDWVeY0sqghBb8/4SIcCgYB5gU1GH1QsoCSPgE+AV317QeWHEvBQlIuMfJTVEfIrtI0bHsRZaSZ9F0T/3e5d4kwfaaN9GqaqlxC8HT68e0DehholsZ3/ilulJPQaft728y9ZEKkPoxtB2ZZ3U1sDHryMGjTI2jB461WayZiJVLMbSMGDAehilHTxikAUF3vI6QKBgQCU7WInXwPLLeZ1ogMGl74fvX6gcq39j9p7rkAI/Kv90lEQyHpcKhPR/e/08rnKzuLWHtXlHCIaRVHyyk22fhegsk2YVD9+cshW8BRpS+501nX1ksOK310WS9SrhawdxPkP2rBzlrncq8CVs9dLDIvtBL0KytR5/4FLUj2gmJpd6QKBgGNLjdysAYCd0GVVe7kKTuBks12jrMWbJqYq35NRTnKt3qYPe8Xuzy5WETDMWtWleIfXpbb+NEIQJ7ifs3dAJZ6/s/jo/tRawS8Hpa6j2oeGFcvCiI9rukd0gXuUDD2d0//RHxyJXpraE+5wx7JhAFm2opZOez98BgRoo0hISwAj';

  /// PKAM public key for `@device1`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsRhm1B8t26XTEHb0J+ReXQDBG3A7GmA2LL6mAJIyyhj8IJeaZPIHcVOh51i2lyQ8GXeMUWlAx2E6Bg/pNcadkhBYzLMQ+DwAPZP4SrXXRKWgxxBogt5Dn91Q9dgSd1chbIpGbrWbYMBe6OXCQnVOT6ap6OU4QoVeSN2VHpX6LpqkBdYip2d8/zXbVgMhbOxzXLjvmy+5bNvAjaVZKz8R28nSy/2P6qkfcXiecJvFp0K+WEVRYGBjYtNzZbFtFDg5BN5rn1wAvAC50N1vYkGv6Vt0F8DCs7snmxdvSX7MfxC735824EXZSjzRCPvqYUMjK72eu7oUnsEJwFK1vPmk3wIDAQAB';

  /// Public Encryption key for `@device1`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAne3nQ++AIaeL/JWNDmZhJFY/iV7ZMAunsHcfTOH7G6cVnl6tssqKuune5jHcPdoq1JdzNj0O/tP00+CFeiKROEPwXLeVbyNdZ+AWjO7dUCHf9q9TX6rE/6WVzcVptyD7q4RIBSijOjJiduE32QD1iqckQ8lKa4HmNJoe4a1IaiyqEFyD8sZyiqTHI2GK7qHiHoIH32YkP/c60xvE7rZ8uS0fqr7yoq7fcLCiPZk44OCLBjSx+wPwlqfDaq4ogyeamte1mIePPPLjQCDPyLvktAotXNtOkZ2KzYBr7A/GFbYT39OFM2QmE22mVfmEniBhrDRhhFTvsIXuxSRE9UAVFwIDAQAB';

  /// Private Encryption key for `@device1`
  static const String _encryptionPrivateKey =
      'MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCd7edD74Ahp4v8lY0OZmEkVj+JXtkwC6ewdx9M4fsbpxWeXq2yyoq66d7mMdw92irUl3M2PQ7+0/TT4IV6IpE4Q/Bct5VvI11n4BaM7t1QId/2r1NfqsT/pZXNxWm3IPurhEgFKKM6MmJ24TfZAPWKpyRDyUprgeY0mh7hrUhqLKoQXIPyxnKKpMcjYYruoeIeggffZiQ/9zrTG8Tutny5LR+qvvKirt9wsKI9mTjg4IsGNLH7A/CWp8NqriiDJ5qa17WYh4888uNAIM/Iu+S0Ci1c206RnYrNgGvsD8YVthPf04UzZCYTbaZV+YSeIGGsNGGEVO+whe7FJET1QBUXAgMBAAECggEAWtxJxqsfM72aa1p7SgKa9vXsHhOErwC1nHAcgPYuq00owfHEy219/WWaSSP8i1VeeOsdbOIaI4A8hj3RbWA/3ngv7JfukH9vONkTAEhY6cZjfSCHvi2Yo2BX3IgsdyCxyo8ThGxJ5KyiO7T9lYrYucnJsno3p7yXfkIBbGNumy5lzmxnB9tUpteu/742/kebuyKO9zX/ssjjn1Fg4WrxMRtBGt8sRe6m1Gv1NOS0DxhII52ElFSCX66fQeA5JR3bwNpqAhBpUZbbbigqk5VARpGObWZCUh8dJjpsF5BUl1NOrOVYgQ/7uxukDmZ6O/iTN/7u1WvdiB13JbSNNuMqeQKBgQDyTQeADnCBkY8KwV3hZeQo9gXrdTbv5IOmvxjpoT8+bSgTYMq6U8VCdV8PDEhH8m3UF8SA7a7B97IxQRTHLvYhxK3Kn8zKiFyNnPqwQYpmkciUA2KqSqIT4cW1VaYK4o1K8shcqDCDxBa4oI9jz7lx5hr7SvgmKrDkcAevINJ5XQKBgQCm27ZCRAnsCue7H7g9Katz2GnmlrsalCraUI23FqloPhIp+o4aqFaWTOBM9mkgNxnMCnKNlMNn2wUH+mpQnFbIDxtH0MGyqmNdf9+G9/ZPJQHU4ypcLukOZLOhKqc3Y8zjZ2CoDjdiHTW0xyplqa99DAKbopNLRW7uNz1b5fu9AwKBgCHflu7WFfBnMwIj6kX6gp0fV9CFAHslDSqgiJEQ09CcXf/nhi/qSidyVSm7Y9d7EtOVxwjnMYk4YZb1LDx0WkB6SHmNQYoG6jl5+qntX7XbJ5lZp896w5HX/FXPdXkMFwilTFF3yeCB51NETwd7IMfFjXwYDPz49uXYq5pWElaZAoGAeLeAVtTOsNz65iB+tJFPH5K0m0T1vLbxgdzBinJ0wZwWnBRPdu3PJxIbPNMRH2N94Ga2lcPI03xbWXhMLmHNTxPO0tgvKsmm9eAroYQHyR6nApQO835k0ir84l7vd11WwDbscOlIHE2xq0ZkYASxl7B2uo6WLeDf7qw8Uh5DUG0CgYAnSWae63GKBQxUQ5M9ILL9XPzfsOweZ+EaWjz/CgibdGf1EmUXErcKJaRUvGzsIkJlL907tr2FDhNB4eB+5uORrZtTNxP1Gz4EH0ORYNDa2sAlQ+ma8ruMXuOuEgL8W2/k8Buf/tG9TL6FACDuN1Rj1aLFkjk0bGM5oztwOtxzyg==';

  /// AES key for `@device1`
  static const String _aesKey = 'TZHYMVJoAroWr+Yf/gPN9RNC63qvCRKXiBhWDj5un4E=';

  static const String _apkamSymmetricKey =
      '8QHaELcv0QBSBLTc/dpNHenbuZeT95+0GDwq3Lugbt8=';
}

/// All the keys for `@cloudvm1` // same as egbiometric
class Cloudvm1Keys {
  /// CRAM key for `@cloudvm1`
  static const String _cramKey =
      'LsAi8y2qXh6SJwl2C3LIuuZUo3SiZ8fNAH6b7FvUmimShvOu-nSMhYrFEZGeoIf2rNu148AD7QNCD5GJjHWe7FuLW4Q0xvhmw8uvONlipE3VxCVDj8AyQiS6lyn6SPTi-GnNlDTO10d-4aEMKyHXin';

  /// PKAM private key for `@cloudvm1`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDTowSZhDyOBal4RV/BhoskrgEEvGKfVYqYm3K4CNXZgkUmoS2BeqdPKTs+qGrSrp8VDzVgY5nJfsGiF+VQjrsYZXgXC1R00XVXEyduy7ElZH7jbck7h40R2rvX+fnMZxHeicy2yCUgpPnp/yiVLSBEzfGs235VF+mgAY0LEQu7RAACYjWnXc310RwqvJK7xR4O0a8/f4UyVf7kre2AhJmkl9y5t1+v82oJWOVdC30Ef7scL6RPkFFUmqpZkA9XVAyi0Mbr9w5HoQLlPpSkrMzLiP6fbTRqWcAaA4E9ucQNvEOECM55xJYb4kwcr2eXYUMXL2xlLRJrROx15CS1jK8XAgMBAAECggEAQ28D/i5mZRJkx0/DjRRjrZJL/MhR3FcTTEDrsrwN97pMclyU9VaxjMWkfPiI4QyG39zysv3JeKyM4isfBCYWc1WRiDYx+O7spowR2nnIvhNhYvIOVouAZZn+lHiwIXMN/IyH0A3B1r76apbExZOVXpcIVH2zqUVvSW51FHuf81DJIH/JOrU+OyrFd3FwsFpBCurJaZMBEaBDtMtvOzzOB/ySIW2XPzLuRbmJlfIwzwmMS62cMUKQ91Q036kwfc30dqiMiU3jdYHVN2wwzkGQUB6ehqv7y8EQRaf5y598XfSuFVTp9NaqEtIw6Ja6px0u6tcnri/TWafQCMGFzdSyYQKBgQDrTR0omHfqy1eyQ4vcOlTvuOAve0wUaHI1o6GIxgrStcjqTrP1GBm9KHprjZT0A38Uzs3b+7eGhkKDwebwEmhjG0yj5T2s0e9p0KD2USxFjdZAvQWz7y8pAqFo5AsIe0FA1AG4lw2i12xQrU2BGPttdAmJd45NkX3y0KmmcLixKQKBgQDmQP2hnHBVRWIvyoRLrhmKC8B1JTdnnGQmXPxbn60g1VN4Hl8I2hK8oso7V9B8MKmdx3yCcEE29ZvkvJwNQqKFA3ImYxsBQXP5OkJbYnQ2gTYa6siQ1pxVDbhCuT2nCEe3g1ejYt3NH2Kj5MhTCkEtu5efVpD+vuo8peuiWAUmPwKBgDBcsyeK3urVTHsJQw/KtXZoCzv3HZX8Oa0oqqTP/517W4Y9EuPHRlMIpNDCUuEsbsw6DTmvrPLrWXR3QB4LyoTEMaZmEZ0ZsRmQleTKnkzVcDnyH9/xw0GslrxWUqY1nx3R9WCZO2ZC3LJgTFPCbLr8ZJFqj0cGJlrn5FafSHaxAoGBAM9x/FCvZhGdOlH+bmTUzVOvNM0WI62onB5oJkDSQqPTLqmJC2wpNTpYnEUM39wT560sPkQyqL7AV5ykRSA5Sbz3Fs/4+CqQctE3KPO2Zyd4EGv93YeIoz6J5tnOlPo5Hov6vGmKuHSG81Lf24/dLE3stjUrQ+UP0m+juQEBtln3AoGBANdhLgT1kvKkDbQxDy4QRTWLEw2sMbI/Rrc/w65HM0JiA8D2CTDZDrw5pztssYP133pvUqsW9V1ItFAjxcSpqRh/pAmmuv0gWxzV9ZSJ6mnWsyzCtL8N60i8ypsWvuf8mtho3uxfPaQqTOpDKESmoG3eD6uZ9m/gFowFypPQ8fq3';

  /// PKAM public key for `@cloudvm1`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA06MEmYQ8jgWpeEVfwYaLJK4BBLxin1WKmJtyuAjV2YJFJqEtgXqnTyk7Pqhq0q6fFQ81YGOZyX7BohflUI67GGV4FwtUdNF1VxMnbsuxJWR+423JO4eNEdq71/n5zGcR3onMtsglIKT56f8olS0gRM3xrNt+VRfpoAGNCxELu0QAAmI1p13N9dEcKrySu8UeDtGvP3+FMlX+5K3tgISZpJfcubdfr/NqCVjlXQt9BH+7HC+kT5BRVJqqWZAPV1QMotDG6/cOR6EC5T6UpKzMy4j+n200alnAGgOBPbnEDbxDhAjOecSWG+JMHK9nl2FDFy9sZS0Sa0TsdeQktYyvFwIDAQAB';

  /// Public Encryption key for `@cloudvm1`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAk5ZoGT/u2hrIAonTwZZR1K+gkezftNSNKUw+OhHwh2wvnuqlPx1KXDPm1aqDpf+CGDzVOk2qrXZwcljhbficTOGK7A6/jvSOKjc9S/dk/o0Akw1GTjW3yKGkwsxsez56Tgj7s7HKc8NaAP2BGK7+WVCUErkFpp40Yh1rlW9Srl/ka0c1UXqWBaneb0WJ3RTIJ51lDbVxNtuvI/AdofPzvDTeC+tm/+9xkyBhyqLS4DkRnv6SgufLJ0sd2jgsg7V4dWPZzWlPu1WcFI7P6QGeaaCqr/eLMAsKq2kt6nfLBlB1KXMnIzlzdHwF18nQbvh23uBaOY7EmOP5lxwVVatXpQIDAQAB';

  /// Private Encryption key for `@cloudvm1`
  static const String _encryptionPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCTlmgZP+7aGsgCidPBllHUr6CR7N+01I0pTD46EfCHbC+e6qU/HUpcM+bVqoOl/4IYPNU6TaqtdnByWOFt+JxM4YrsDr+O9I4qNz1L92T+jQCTDUZONbfIoaTCzGx7PnpOCPuzscpzw1oA/YEYrv5ZUJQSuQWmnjRiHWuVb1KuX+RrRzVRepYFqd5vRYndFMgnnWUNtXE2268j8B2h8/O8NN4L62b/73GTIGHKotLgORGe/pKC58snSx3aOCyDtXh1Y9nNaU+7VZwUjs/pAZ5poKqv94swCwqraS3qd8sGUHUpcycjOXN0fAXXydBu+Hbe4Fo5jsSY4/mXHBVVq1elAgMBAAECggEBAIuENnoQDvoNMR/9LLmnIUo+kDsCQmOOPrdYhMaeaNOL+ORwiq/EP6QzyDYZ0AOfK1tAPo20F/GMsjXWQZyU1SR0XcBTHNDF7JKJz589ijJ8Fpvsg5axfz/hVoBzgOVspW+ZXF99ZZXTiQTAoEY2PuktnByq3WWpznkluKr2JqIBOhwbUdR7ncr4m0p7cmcqmK1+TBGeCbBrhesIKMxzRCxLJgLw/UCv26oG/pgCgfjjAvL+M08IGpBPcWAHzn8pqOvHfc++Eg7592N5mqwG84lFx+INBlr5xE7pXPIB8ZMFNB7PQdl/WUGFYECDk9lJBhxfQt2DDXEQcspp7j2L4mECgYEA8XxZJWeiKJ3D95CatDgmjFhlQv4Dhn+JMWtPpOQM7+rJLMBjJgOur4gu6I6SIU8SVJ5qKDgWeRg5j7lUgPqFHMh5HsgRpUkV+QOtYYRsZdyoq+8E/AcROvaqytMkowSPs1SHqDS1sUXfigxUR9nadhiF1RBAzEJ+yn76OQOJQZ0CgYEAnHVIByVUiSnOdo6kCaDkuvSue/Po7VaQBZJ0HiER6IkB3dbjtdLbQhc6xo5A6GUitLrKfugbV3hkruk+rtVfeyCvok8/J5WmE3JUV4w1MPJRKIjjBUYbabaQLop0pjHuR9eGlvteeIwk8wIXVt51oucdsZdgpL06j7A1oE6z86kCgYBT7UyqRFdGWHZ4PwiVZAJ5umsPGmstPnv28f3PJ/cbFvVuGTscRiFbHjB3YL2G2A1d3WS1r7CXy4SN3/JvlSHYPBBkU1JWqIz7a3zBrJ1j1YnFn5+S2/3wCTSYo0NTaM1snQ88tX0ELG2hc+GCy0My0hkJUMnEc8PPKsxaLlFwvQKBgDrOllEhReH8Vb8YJC3+TJq8xyyN5Bn5NE7z2jNM6MdHX+07DQHVjFYOFyh0ZY80HFRj9SK4KTa6aNWZk9bxGl9UTM+sC6fcRrz+dxck+wU3vyuGMBZWYI1eclkb73ZcRBy6tLrhJoQW4Ph5673aBctCJVYP+OJSwcUqTS3BB0BpAoGAderD3T+fWac6fDvwqktbLo5oEZY8DC5MLs19kbXzRZ3gWl/6Nu+nunUEiP4u9AfYTG/qTjqD9QplD4oL/cWmO99Mb0PmZP+VpvbJw26EwvRp2Xs1wQeXWuvarTYD+zimg/UEC5C1EY/OrNOYYwBgu+70voZF6gqSUT9LWoXiw/E=';

  /// AES key for `@cloudvm1`
  static const String _aesKey = '6EI4LavFXYHC/layLd+3ouXNyEUG9gyPk/ji7C3iidA=';

  static const String _apkamSymmetricKey =
      '8XwV3ijbI501guymko92UZeEEFuGhZFSkDhucLWr7Zs=';
}

/// All keys class for `@colin` // same as colin with emoji
class EmojilessColinKeys {
  /// CRAM key for `@colin`
  static const String _cramKey =
      '540f1b5fa05b40a58ea7ef82d3cfcde9bb72db8baf4bc863f552f82695837b9fee631f773ab3e34dde05b51e900220e6ae6f7240ec9fc1d967252e1aea4064ba';

  /// PKAM private key for `@colin`
  static const String _pkamPrivateKey =
      'MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDtDpsY3qjwDIgmMc+rU4EWoJqOlfgEJrBhoZM7N/Asp/N/tkcbDjWHTEVwmpstoWNw8JiMFOUuN/U2RFyaU764zABWLzNT4k17qCPPMj8VBEIIj8z9SGR4HXVhZXHCezrtjKvwnp3fK2hU1tEQMeDbmHTLZYAcEOwj/rQw8jzXSnRPEuzfNM02gSBVJ2JJG9J3qksRL3EB1hgPc4BpQQZQsu6/poyYN7G25LIcD3fIWpesfTGAkTNb4SkTlm5QC1CmAyUXvRWGuYpq7HOy2XwZvJOrJzGQ+5kjGA75oWZh0otn+TlVrhRb4ShPPMu11c8CvqvGwV/03LNoomZ4WpsRAgMBAAECggEARyNx8cWn5tmr5eJe0qgtfe/WUeG5Wu2NUs8dEtFXlt8T2IiH0Bu0fpSp5f/Pf6MF53ecH7WJjRQn1xAuxfVJr8UweKyTd6Ha5LfxfxUyDwmHE3Cr8HpQBCe6+O5rdBRs+6qSUpQXBkjNd2A7vuNo+h1HN16PUlzVsHuX8XRQQ761OXBBLMOorFPLgcLM3lrzdPwul9hrkuy7pnCKQeREypLPNdw5d5RrFL195IN/f1mxlOds8Bkw1Qsd5h0/dwP8iRetABquDbHWo8LAw2E+B7EycyFRkALDfD6f8kGdo0JC00ODdlzsaS16LZXUxzHpHEYyZAzZxyBeTEsj+WH/wQKBgQD+J/WTeTxjoM2R2IuKjjCVeHB8AWD1KKL/bQt/9TPg/Wdw3rvnbSKcgGoysVRdhQ6l9Ni1Xapd534QaoqaszCuj4r6/iJWo8jUpVml8C0V6Zg4GYjfmiDTM+pJeEZ5670wj6gOsKt7vYVlqa1A95HAFhTecBEYGefcmawvp19MGQKBgQDuxuOFWwaEUkFw6ySP7YfA/MiK8eGFlJjx1EwBuS0lIdYmEnCH722dMk5CNlIICps3i1i0HU2GEAQJMYZRyx9ksyl6JIrto0A2PTSA9cOW8xcyKImTVHrLXLaP02sXglwI29prJOGnXX9elhjCdFkQNfGHVNmfwe+0eYb7kgUluQKBgD0nLj66yB4Mvgneucyv497DKQWda0/x5C5jdYXnYQE819vfrATGTLKtb2AdLPiHoHusC0ywaeLIZZvbltgcT5Vg8obsCSUhqZwI4SY9QQvptfehpT5wHn/TGQduij6hy1bY6g4G0mwmsOdCSW69YvN+HK1c96/9470/uJ+KvTJZAoGATUA1jgiEFD1UhMbevl335L0j2Kgm8YPA88RejtQtQe0vjoO6upAA47HJ1ewjIAzmaNMBcMxmL3BxDdRjA4V286pvSeAWvolpleK5YNuiWuzs3UJ2OB9F1xN40RFyfVmkkw0mHjIBe5dpRN3ExuzDf9Yj/Ue7XM9u0PHcdPmqBqkCgYBnmRxijc63kSWE1EOOlFQK3TGGII87MOvpI5t7Cs86AMmAVTS3MhJgInxLWRExF5A4Boowbu5ShbaVwIjvJLm+jyJWzEkjifmkEVDvjjNzXyR89Cn40RB2vxOUUJlT+BIT0kRPpn9StZcmXOEJDxdSoig+5XfclVTbyp1M4NNP7g==';

  /// PKAM public key for `@colin`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA7Q6bGN6o8AyIJjHPq1OBFqCajpX4BCawYaGTOzfwLKfzf7ZHGw41h0xFcJqbLaFjcPCYjBTlLjf1NkRcmlO+uMwAVi8zU+JNe6gjzzI/FQRCCI/M/UhkeB11YWVxwns67Yyr8J6d3ytoVNbREDHg25h0y2WAHBDsI/60MPI810p0TxLs3zTNNoEgVSdiSRvSd6pLES9xAdYYD3OAaUEGULLuv6aMmDextuSyHA93yFqXrH0xgJEzW+EpE5ZuUAtQpgMlF70VhrmKauxzstl8GbyTqycxkPuZIxgO+aFmYdKLZ/k5Va4UW+EoTzzLtdXPAr6rxsFf9NyzaKJmeFqbEQIDAQAB';

  /// Public Encryption Key for `@colin`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApLQ+CrLLF4Ndp7PKgZ+oRfzL8zJkiu4VXT7z8e5nsM7cUWOZ1f0Az2ct4FyF981NtN1pkf/4Vk3X5OMF2vmEKWzhxuocTYx+X19lbLnZkvYD+SEwKhf6BRfH0vREeKtijmPF/jCB0bKZ0Vffld4kz5F+PBmc93C6XeIm/T+n1ojKrQpDIwgIoPVa1OiP4Xx1prLsr9W2UbrH/h5F2+lsK5HwM35o64h4BXX3IdATYL8TQPCM47Tt1FiP1eMUim/81wO+18SeQJRqqPpm6FBnhfEGFELzBCsXJAn6eP+jKkpAobqviUD7HdxSYlhCROT+CuVXqbtu53YBXB/puvMNcQIDAQAB';

  /// Private Encryption Key for `@colin`
  static const String _encryptionPrivateKey =
      'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCktD4KsssXg12ns8qBn6hF/MvzMmSK7hVdPvPx7mewztxRY5nV/QDPZy3gXIX3zU203WmR//hWTdfk4wXa+YQpbOHG6hxNjH5fX2VsudmS9gP5ITAqF/oFF8fS9ER4q2KOY8X+MIHRspnRV9+V3iTPkX48GZz3cLpd4ib9P6fWiMqtCkMjCAig9VrU6I/hfHWmsuyv1bZRusf+HkXb6WwrkfAzfmjriHgFdfch0BNgvxNA8IzjtO3UWI/V4xSKb/zXA77XxJ5AlGqo+mboUGeF8QYUQvMEKxckCfp4/6MqSkChuq+JQPsd3FJiWEJE5P4K5Vepu27ndgFcH+m68w1xAgMBAAECggEBAICPXDoXkyUYWfs0AGari7qNd1iuRgKXkj+Fiv6Vu4QsA5bX6tU4NfCuNgYB0mQ5cWUyylu29E3RVyqG9iQVTU7UeWs9g7gYaO/i05VJgAYRV8qXWDQTIQnmpQgJuISEKlrAkGQ30q0u/peEQraFfjAy/djFmVsfN6lehFZ64HQ4c4NgXqDRlwkvmEuLiLCZyy2APlu05kjlyiQEziwFVKhmbI2dglQxTtIbEfP7aUsGxLkiw6lTGRJ2lMYMjTtXqD6PQ5YXurV20z8Z4sRt4JuWUucaUArRkniH74SBj94dPo56WDjInbFRibr8J9cNAg8Kl33jJrsP4sL7l1EE5AECgYEAzcfROCf6jRnX5PYEymr5tS6JSb2Wpbjqcz42HTtL13beiVKR/TER/9noLs5eMmXZ/V/PSdRDyk1dWf9vXEr283tDlS7m/E6HzW0nUXCEEaT/ySS417xSEtyXKWX0qH2Q+SoY4GF+D/pnMGa95ZozXi/GQd8VCPwtdcRAUWQ7xEECgYEAzOYqC3Csycw2cKKnE6p+eBv8CYG0xfjsQqopvEIOD7SPbOx5LgfXtG5X1G5r9lYuBpyJhkyJbuK9GXrI6w7hcgTxGZqOfTE2TWJFzisxUGQ7qn6vKI05wqLJaFXKiSLzvLjFElqOjhtoyWHg4Ty86zeIzi0fkk/g8zrhQpH/PTECgYEAqrBZCeSXflz2aLPsy14qnK/qLuF0ySf2SPtMdbjOsv2ln3B/Ke5/CKNeZRzGo7U6OWI0lf/c7zx294TagUqpRtNy/pa2AIi/OpWU7IeQ9PXROa4dKM3LoluZgzxP0Ua+bv8NPWmA4I4K8+n1EDN08mZcZB0/3IEY0DumQh0LOkECgYAtR9QU0SKuOd3yCE/p7ayjOHP7WdmsQnVbyiUNAIABAoMLrDqfbIZDznrEbF6ZgrQLK/7MWg+pHJxzjAnowFIcE3GAmgJRMlXwxf3tMOhl/rCc3gAxcvxHwhfGYecvZTT+CMssYizMxMvkbSf4Pqb1SEGIZrpqaBKrTeDICGGikQKBgQCWnbibJXLkPfNy0q5aRKqyePBaiO56ZHaObuXBZ0qLjsVleLYx/jGJSz1cCHBinUUwDkOseZqt6JZkd7psadtesW+829iw7YZYokmmjUQ6P9oeVxcVfw5fgCBWoQ4VZpK2h3hF6pFm55xxHAF0KTjRnGLiaZ+NolDap6h43RTNTg==';

  /// AES key for `@colin`
  static const String _aesKey = 'wQjp3HXO5cIsIR7lL74ySwtjJ7VP3OLBJKsLiLuRFcM=';

  static const String _apkamSymmetricKey =
      'xpmA6M/9K5bDEpJPGwH5gk3B+aLeReLJXSuIRq3jL70=';
}

/// All keys class for `@barbara` // same as barbara with emoji
class EmojilessBarbaraKeys {
  /// CRAM key for `@barbara`
  static const String _cramKey =
      'b43edaa255f738c763c2c79df4d49a4173b02c132e164b77650383fffe16f045ef8065c2ec05df8f4ae3475e04e83c7c99e96f52de9c4d1a915b67d24f590c99';

  /// PKAM private key for `@barbara`
  static const String _pkamPrivateKey =
      'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDXV0f0gIjSRl/bxXtBJzhii3TJfFWJIeVetrsnXBWcjMD0l0oCauwsNcMyOyDic0dnHeEdGFLBgubI45y81wLrRoiimylpEJGQVjWxIslqXyU57ht9AIkqpzXcBgfvmt+oIZvqj3/r2h8cbz1gH96D3Nfp5kmhU+BNA8O0VYAeT220zJ0R24cnBCYon/VfLmPmw3Yk/1bVrc+IBwAmVCtRuNh+Z/dlPZ26J38FZXUw9LYQAmW8OHum7gek6ZDu7eYLZu0N7GRBxmRP0hWD2NGAVrGvyg4H51uSFOdfOpHMnQWghyRphnb7pRc+6lZqqSWMvOJkmdvJgoDpa2KAMqBDAgMBAAECggEAdnTB1UL7gMhLpOZ+Rbngb30NUmS93MCznyVf0Gf8T3CyGBo9ERVmM2+jn7cdANSvO48ZLVsa8u4iK/HhX5PbPDdBpEk8P1po6IAz6uwa5hPOs45CusGXssnme9EpfmmwjJloXmBv2vrS0F504bLGQb0zXKxcZo1wPo1Kk6HQ51qBxtLqMKeLcS+5uZ3CAS35oi5I85KNS1DQC9Dv7p/z1KRT9GTMLgLKj0cObBnQv6FhZnL1ZRLZr/jvLVH9O/R9tt+FNCxHni0jxZ2jd+2dmacTb/16SRy4r0cyOe3OBkoSjgsauBTJiPLfQyTtiOf5sp9V5BQ1Ykzy0icfCxCfKQKBgQDtcVNDlIePzTNOE+wgWlSfRZVXcO4reMyJndDWXHLhYxHujjW9yV535xpe2t/xp7f/TO+0wWjIUemAJenPqfny4wb+0bC7FxfT6c7ZeMN3yMzOYVw0Sqd5F/c2N2rcVL1uzJmuMKooy6PkPz6c8xDynzpu9un3yTNKh8YXx2fA9wKBgQDoK8Bo4W7zE/KGZSH1OQA8Xc5TaI0IskiXQMJh49egzWHonpQWcFBkKf/QNQeHLP5b/2Ezn+i2TTWPnFxXdPyEG+AN6Hymr2qdTYZ5v1X80a/e7K8JRs+h+Jf5w0u3AFys4DNb8JbuTcw88nnHKL94dtC1OyB7SudSvDZ/+KeUFQKBgQCkzQY8nqekcIlOhNdb8TZQwawQ38n/FD3qukWLsujtdKSqjbvROSW/VQDhm0rZ4E39/blWHPOMLgZCMo5g2xonsdlWHdZrVHDuXZZ7LK2GwzEbgUnM5Y/tpWupDre1q387mviDhTVlUUo0joz3xGEb9NZK1Ee5+sUF0sz0Div+KwKBgQC0Ybm+QtgW17qoHE8D3WOHg0JYn3Rj+1BW46OitojDkI6vUvWvcVekWtU8CNdueNCu3X3BxE3jxZ0FlPBRqry+T4IGjEi8oLFuwdrnIHdIVAoWY0GjLXcIWsKI9OkQp6FZV1/P4N8DC0LRX3qp98i7aWTCScv0vr93EnAtgR2B+QKBgQCX9Fzau/gYyFzRpsc6q3QwTVIEGCbYatqgp9ygZG6JvsvSXxnTWyydPLE4UJ9enx1wnVnJoNERLT2paeiAPWEw7SdE0wTH4Q2hmiMXgLevYegqMJnii4N4QQ8cc9Up/0CO83dYPAUtsoiEM1xFJOKLYW3/NlPj5zsQW/PjCDTu+g==';

  /// PKAM public key for `@barbara`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA11dH9ICI0kZf28V7QSc4Yot0yXxViSHlXra7J1wVnIzA9JdKAmrsLDXDMjsg4nNHZx3hHRhSwYLmyOOcvNcC60aIopspaRCRkFY1sSLJal8lOe4bfQCJKqc13AYH75rfqCGb6o9/69ofHG89YB/eg9zX6eZJoVPgTQPDtFWAHk9ttMydEduHJwQmKJ/1Xy5j5sN2JP9W1a3PiAcAJlQrUbjYfmf3ZT2duid/BWV1MPS2EAJlvDh7pu4HpOmQ7u3mC2btDexkQcZkT9IVg9jRgFaxr8oOB+dbkhTnXzqRzJ0FoIckaYZ2+6UXPupWaqkljLziZJnbyYKA6WtigDKgQwIDAQAB';

  /// Encryption public key for `@barbara`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyvS3xLWgKuekekE9+D5+MIZ6Xx5Cjn8Xnm9D00xhUNu8/9C5wTgbMPX8XUfMGyOA85ymt9dkDl0BmrN8Rz8MPKpxNB94nRQuMO+0af1Tu2csxdAUZyn14usd0WYaahBhyUw36VKhuyhHoFOEmt2GHCiRiKr4pE3WPX8aod8JiJjzyzvREkQcn8NhxLi9k7ISPDwwp46NkBex10SV+oJ0YEDL1VGJHBdNTKm1q3e3mWorK391oK4gKmJv2zA/pFBdG0NXaPS9DYHRT3486nw6x3jVLybriCQBhfYAZrtUyfsc0tqCDD+YCFcWqhotSz2cA6Oj/Uu4TTHgnaSPc3BNNQIDAQAB';

  /// Encryption private key for `@barbara`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDK9LfEtaAq56R6QT34Pn4whnpfHkKOfxeeb0PTTGFQ27z/0LnBOBsw9fxdR8wbI4DznKa312QOXQGas3xHPww8qnE0H3idFC4w77Rp/VO7ZyzF0BRnKfXi6x3RZhpqEGHJTDfpUqG7KEegU4Sa3YYcKJGIqvikTdY9fxqh3wmImPPLO9ESRByfw2HEuL2TshI8PDCnjo2QF7HXRJX6gnRgQMvVUYkcF01MqbWrd7eZaisrf3WgriAqYm/bMD+kUF0bQ1do9L0NgdFPfjzqfDrHeNUvJuuIJAGF9gBmu1TJ+xzS2oIMP5gIVxaqGi1LPZwDo6P9S7hNMeCdpI9zcE01AgMBAAECggEALVmJRpce9vdTtU2mvzWXlNg3t9FXJegYKvrJuQk0JZE0JiVJnHcg/Eu63E0Sum2wfr7eMe4bGWqG1T6N4o2f+l5LdU4i8VZ1C9JECfrlHtbrFjhslrC1lMLcotGhzVljwEsbozMnmF5jwttmogQl11zpSBSMAoqx+IPSO6FOzAqa5ktoUbfKYblVEpYEMFcW3ayedpGmg1gH5pJ0fPE8zI3uMOrJfazjmGnuEJrUjeA1Ju7x3jQZpOQXN6Fd7DWzNm92GIt0Bb+LA258r5uBTgyL2WN9CWRR7L0SglcZo6nr+Ez4o1E2TZeX8twqpV7i7vqWHVlsD4//o5698ts/AQKBgQD8utdGndfd/s/RtKKiaWes/1w3gwqZSOKdo95aGzGHI+FJW1L+UnJ/GrSKLsQH/SuGT9Hky367IAkrM5aUN7Wm1XXyfNJA+PkkCttM85HcqcRkl70s3YlNVdBeDWR0kyCi4dpwM7kVFlCVpgC6oDfO2d/UUZkokCLj5V9rtNrnxQKBgQDNlQCj9UuEdWRx2ysJFUFji9Ski8tmYWKdNfIIasnwSADIEsQck2jJWPMrKcDzot/XSjrNgjfbwgO/GbWu0rQJEB9EwZer0Z8/69+zgvl0rM+/bzeQtaECWNyTC5+HkcPlhOC58YbVMxf1ZnvOzdGzd7TCCURVQ1DfJc2JzxC2sQKBgQDkR+x+F8NN/YVAObaRlz4TkJF+fvpK3P/9PnBw2ZFSLUGonjoICPbtAnVDP9zIDpGK/3xq+rjdU6GUiUOhW/TT3opsXv0XvQxl1vyhtHzzYdFIv5sb9Hu6BCJzYgt0FRVsqy9BHCc4+fAOTGTqLiBa0ogQYyhB8HfjfGNFiZYVtQKBgEt+03xigTgEcD2LkdNFFf07hXxjxe80BiXbgKVsqfnuRzMyCQjBbXK7kpkgPTZ7cp46KTv8/QxbxEpyY5Du2aSWYhU6zrsPQN8VfNIMYBVjvOr9Kbefq6AUB/SMCSqc8gagdHJ0auJyX/MDjqXUWZUBecTj6E8zaEh6Nm/MNcQRAoGBALcJwlkylocU7gZhmlsgVLVzeM1IjX7SevRUukMpWoD0Vn4gpRT6wLzu0vjgVLGnbTozy2EAi6Ing6FSTum6qmTKVxtMviVlgrQas+A8+7J7tEDmRq8sGl9CTwX/w87Ky185pkNSdBecZBXdji1y3gLuj8de0qYf9VECH4fiubAU';

  /// AES key for `@barbara`
  static const String _aesKey = '5fwTqTnFJ6xyhTf9t70seOlbxe2KvqFO5w3UWkPDGac=';

  static const String _apkamSymmetricKey =
      'zWq0K1DX+wM7AizdUsZfRT5Qe4sAy+u+qOwQYxIVcEU=';
}

/// All keys class for `@gateway1` // same as egcreditbureau
class Gateway1Keys {
  /// CRAM key for `@gateway1`
  static const String _cramKey =
      'NC6gYrJMRM5R4N-FUQs7KTv1jrOlj8x8ai1JFFBBrflcUxihJHtJCArMx5eENuvHn4imKnlbrbyYuJUlsYoVTkid9gAwXco4-3rd0thxzwo9bYHNW4hYkAqISElyxbzO9s20NFbbWSEkhoGN4IY9yJ';

  /// PKAM private key for `@gateway1`
  static const String _pkamPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCUzNLPgeoSRgojlNN3/G1H1hDWfSeQLZFFrVSQ1Muc7gnPzFeeIYr2BWu276r+y3JT6MDA8flKchYesl5RXD4NgkeFgZj7j095qniWGdAthwBGjXNFv+uf3Cpcqo+Npm2+dNrV9ur7EaqiL9PaUt52HzDU9ZXN+FpI+rmVUJEwJ8dwRtFa2mJnmQf3+48rIJvEOYZVhHb98U2NXWnfMe/kkapNVH38EGO2Nk5TlfhCwBRxL2jorg7KD7nl+ht+qGjoExuPTsY71PuN4nDY92R84bQCFal87Dfy06crC6LKRrbh2iS3Y8VI/nmvFN4oNpbbOaIo0apk1JlcIQDGBz7nAgMBAAECggEAO4QVScRXwEldYs/zKUnA1/vKLlBO0782HN1wNqG2cyVOrVu5K9mUwER4yengxhrPtrog5suh/2HUcSC80uQHOdYDD2Y/r1ap3isOIlNezebyeEW5douGDiG8m+XolyqbOJN6uBwT7qopSsfAf9Gngy2ElZlI+uI8EnaeZhecitqxdedaVXcYEibl7ap8ftiwrA5Cq9pBQzL987FXLLnfIHVKCkkxFd7luafi5tdoaMG58VIG1hHyXdO8xsxiwppbClH1vCDglj3WykgofHn0IzAfAwGfY84zoPxL4RqJ68+wpPZ87FV/OgnL+95kCZlTrm6nPutOESGOM6VHaLh5kQKBgQDWurZHpswGBpSg523+Fqk9ixdtaaNXldGKuLXvrbKWHS9yZbRBZwxY3nVvSMgEzIOJK3Tc2ppJo5/EkH5gKG1FlPGS8fHWM6TsigO6jN7LcUI5GihU3eN11S/xvoypkSWQ+A2YQmip1oYPaER8FRpnP1XMCRx9cvuaNhBRT6WkvwKBgQCxZjTrW1iUDanXICy+WkDbrnve1M192cetv6d1hkRk1zXlDY4s6CU4zn+3QfDuUEEvllu53fYnp1l2BGc3qPV6w6MSP4Yfzos0rpUs3yGCIfSjkioSdg84HkjnhS5EDscKisrrODi540xmHpfliW7kifdBMb2LmA02h9HR91qn2QKBgFkfe8J3f1zM5Gl4RNXeD/ZkQZ/+5XXXz/XUvmaxYFsf1+6SOeOfYqeMBY/f1GzxeXK4X7O+46TGzewm0N0WSmxD6pRD6U0veDdY/T0zdNFZu9O5gJ3gzqS8jD65CObkQIRQAEx+27QKPvAsJaielavexLx/15xV2gnigJlPBoA/AoGAFSdx8grfgjAq65tLmptalpe077qCkppQpFhxWKNdLoU3SQwXwyUfoymEs06qs1BgpZMRdxWPz+S110vpHwsH0s7XeEqY7NwNX4feBA7LiSARcxvv5mmroO6DlRAdl0IH3Cr2zZvTr9758kd9p4J+9cO5900+JBJKqREDJT2Q0ukCgYEArOah1b1XxRkk2HomQR2iR1e8qWnPrCGlNqc7Xsx55TJqR8nT8Zpvp9fVn/mYvmix1TZRoE1/xQKMIC20VaGURd9fL26quXe8oiJ+hj9HPBitHgOssuFcwqFcppnXyaLwUN4NEp7IH4mOukSYiMpZwtJDmBmPKm8AHVAAwF7C/Yo=';

  /// PKAM public key for `@gateway1`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAlMzSz4HqEkYKI5TTd/xtR9YQ1n0nkC2RRa1UkNTLnO4Jz8xXniGK9gVrtu+q/styU+jAwPH5SnIWHrJeUVw+DYJHhYGY+49Peap4lhnQLYcARo1zRb/rn9wqXKqPjaZtvnTa1fbq+xGqoi/T2lLedh8w1PWVzfhaSPq5lVCRMCfHcEbRWtpiZ5kH9/uPKyCbxDmGVYR2/fFNjV1p3zHv5JGqTVR9/BBjtjZOU5X4QsAUcS9o6K4Oyg+55fobfqho6BMbj07GO9T7jeJw2PdkfOG0AhWpfOw38tOnKwuiyka24dokt2PFSP55rxTeKDaW2zmiKNGqZNSZXCEAxgc+5wIDAQAB';

  /// Public Encryption Key for `@gateway1`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvBS8pkbG9bhYwGtcPbbkDoGACZblh4ZroB8qLCknrOGnWCsralq9i04E2JywqOVmRPhvayo5NjhpeR6vGqkWUbb2GLz1SjK+RqpkLyiwsNkH1Awi1WZwxToQ428Gib2cMsleJOQNyQlgVjWK4mvRj32UNwkXTdEwfzihBVJaLInJJW9xtjy2ZH3HqKvWJcYXaKsM7zhPj4yXf+AEpW81zf+ThRZtSO9FgCj1k9VUINhM3rS1yrykBJViHVO0/g0G2QH1ypo9REuH351Pfkm6tOn96aGVk6/qP/OSZCZBifGBc82i9+suslZ7FWDkWHS0YrgUJZ9hQMEpZnXheNtjqQIDAQAB';

  /// Private Encryption Key for `@gateway1`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC8FLymRsb1uFjAa1w9tuQOgYAJluWHhmugHyosKSes4adYKytqWr2LTgTYnLCo5WZE+G9rKjk2OGl5Hq8aqRZRtvYYvPVKMr5GqmQvKLCw2QfUDCLVZnDFOhDjbwaJvZwyyV4k5A3JCWBWNYria9GPfZQ3CRdN0TB/OKEFUlosicklb3G2PLZkfceoq9YlxhdoqwzvOE+PjJd/4ASlbzXN/5OFFm1I70WAKPWT1VQg2EzetLXKvKQElWIdU7T+DQbZAfXKmj1ES4ffnU9+Sbq06f3poZWTr+o/85JkJkGJ8YFzzaL36y6yVnsVYORYdLRiuBQln2FAwSlmdeF422OpAgMBAAECggEANMGgVQe/YUdvZbH3srvtZoA+uPHhuk0jPUvgmXiFz4GQXjPlvrRrPHsK8vOovgdy01/YaPf0ClhyhW3s8g6B2zP1/eRq7YAkTVAYP/4q6cBG6NzqnG9arIfoGtOWwuYzvS8swC5UC5McubHVHkPeCWDRRUrAhaxq7RSmXgbGkn0remvT0JMAac4yZN0GXS0Xan+8BzYFI2waxIw4w/5cunC4MpT1O5bWVkQQK99EwI+CG6QPn6rP1vHiiWU4sBoD8/b0odhB06CT3F50r5pGoiOb+htefit188QEFkNSida5e88feR0uYW54AM1tjsyH8J0O/qYSADD874K9vd9UbQKBgQD7RW1fsL5d11dOEQf9fksvi3IF7S282aW9KTkJ4Wttpjgtn4A1yXWzRzG0rftDw7vpV4PhbvepTmY5jc3Xuds8/3zJRb9rNzLx/5tAQt+cRgQ3aiU6zt1epfNdpqkxk+fWnBy4ce1rj3p11FVSCV5riFNgJ0djBVi0qCfR4RX3rwKBgQC/nt9SbFbExbV2o6NpU+P0XIR06Xmu3NJA+i8yzPCDJC4F6k41X6OoA9/r6K/DIgwn4Z+M/fHMvuC4lBgOr1g1lK+KyUY4waA7HuEN6Ict0MeG1SrEqvoCeFCBPsju9+ZxuZa3sMbGn3+aJWkCZTpeyM4SbeAcHQkoxUW6zanYJwKBgQDN8fqSSpfM7FnXV2g4IdJX9rAPIXWyaqVIZEgmzAa0CV/ULP31l9iLh1e7IjpmMUCMITmrhLsinmp008AaB3AlD7ZkdXFN3CE6bej+g5EpUc3U6X/4MmMIV3YflSDpzLNhl/SGTIJu/Vs+xjjkE1+7PTIxBiChjVlGQOjaQeUyawKBgQCpsdJntdXpkIUxOZ1fi5FWOBB9UL4YIyp3rJfbzy43lPTE/Eiib74I7tWAn6H3ltFZCDA5tjJKdceg7lWXu6TMXo5OxAxR+vchJCl+HayI4FmyiFjFrfyV72Kr8qQTLKqBkC9vITgHcfyY0AR8wJS+l+oW3AMaIoSX/IvR8Iw3BQKBgFCakeQfoIIsxp6nYYFGar9f5FAYNvJ415VetD4eqc8xMat4XDYvIYBFDGzZ/nBe1XLdOrOep3r6N3EBKqjTWBKwDrw87sjCp4UmgmBMlumrW7NXJAroDcfoqjwUZtMQ7+WB0Np8AKH9V9o8NReGebH0yL62LCXhHMecQv8yWthK';

  /// AES Key for `@gateway1`
  static const String _aesKey = 'SgGiUL55OIxq+pU51g5Hn90seYS5+w5weQNVevo9Xa4=';

  static const String _apkamSymmetricKey =
      'BtJqw2vBfg2by7TmqTM/mZii7fzkv9G0VP2dwQKn2qE=';
}

/// All keys class for `@gateway2` // same as eggovagency
class Gateway2Keys {
  /// CRAM key for `@gateway2`
  static const String _cramKey =
      'ikpnBQu2SAQsgxNb6mLoGQrVGK4GrUB2wjWLGzHisojHUtm27-tv4knY8KgPeoUZGxXQVofFoLoltqkQbYnzJeLI6864jMxJyjEKc82DYtvQextapZUZVjliZRTaNsbS6Vd8bYqE7iEEDEHcj60hV5';

  /// PKAM private key for `@gateway2`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCbMfnQbE0qdSgxaWaGfMVG86cxtiBbfIeJcsc3ztzTaKSdmdC7Cd9UE0oDlg+5zBKCzTrSoeqtz95vZJLopjQaZKy/Hqd6uDc1fAxyI4TBkKDSdeN02Fzj7wTzIMLyOvvKYSSwlUwu/hd1i0qzgeEXAw2xv7ddeuUZmS/src39DFci9aaMLahFOXiEVp+0NBvwxIF9U6Lyfz0c1BiugZ6S+ZKd9x0yapynGMqdiaJXshsm/gdB/VHzraFgK7GCfeyP8UkJhAiXndRizuvANbi2Eg5YxYKaCRtaV+j396sQmdHBfFLxVuN94fHeWsI9tvkEgHUrYJTrkmytVJU69ywLAgMBAAECggEASBwReiFIPYkQMt1JcQW6WDxQHE4GfNvA0kGNhUXN30EI892LWcy9gwAvbLkl92t10mbvhP0M4NPsA5AUnprTLMxIY8kngmLj7CsGUWZlgdbkksWJ+Tmq95GQmDNJwWlcou0+Mfo82rzfQ5OEEyIu5xVZIJT26y12E83UscEULBX9ddBe/kQ5G0SgKpEbzxXCoZo1IjBZ0nfcDw/UpL2yoAMogq7l5a/NXDHeWWNv7OKVbvFC7OdHAHL2fsBKmIdOPTaGohIXyk9RTVbx4IsTZvWwzhjlMqAQHb8PB2vrKANFpMBXGoTFSaNdgyQ+qWHtpwpdoUBHEbYjwPHFzuGgYQKBgQDOD6Mf16nivPSW5YXyso7p2mbfvQrkeU5zo/YdCQfLhVgTXEYjpTjq5pyQ9iwqWkdeflmpWVi0MPN2AXN5DfVmxy9+IQGRX8Qz/j7+nzTV5QX/tB9SICR6fOQKYAjWkdTqnAdzvgNbeGL/wronhzk/nqIikreOmvru4TNj6hRWmwKBgQDAzonC74ElP+vOWZtY7UmLpL9H4KNwJ+GY9vbAmX48KMunTwNMlyisXPHvSsoiYRXf4SOqfHxl8NkZWzc4rOCjRXwGToWYIMOC2GQdqHtZuWOgPrE1WQlaI5T4NJalDATkHp8vbd+Tb0ZoYYqlpSA0e/yqhPjSG5WNy4uPN1EfUQKBgEtdyMoCtS4q8kKmnEFSMZcyvGGk4PEDtT/yfjfMb79ue/JI05aB/blcs3MJtsmez2+uQtj/xsPRC5rjmPpzsofu3l4BcHNdVYO2wA+c51Q8Od92X+ZHv0/VkgqBaXohSICupMMeglfYRk1JSZDfkn7EZITEqMJNyO3KDGPE3791AoGBAJxPFTpXRyD2yGobFSkr/iLa5kQUZwwHGQsUtIkCJ2gIPsqd8PPH3C6Yj39K58KlaMF+2ZZeo89VSfwXihZFeTyEmX7Xa9EgRsCuQ8QTkiT0ekMwcCPq0f0kuaHbqIGX0+NIvA8MiWQSo0b+RRPzYb+LARURBlP4Du/Mo5Dw7LBxAoGBAItHGbft/lGlaCJ12GK+XOkwEKEzXWlVmW2AvLpXwG2sVJnlVy+xRoQV4JYPpL12//YsPN8uuAPvti4UtCSNjw9ozOb/dV/WTM32H+IV4TcwwIlqTe0JP6alkH4nMkVwA1O1GbmUo3GXnxunK7+TKyxy6JRLAM8JRhqLQtuSyteb';

  /// PKAM public key for `@gateway2`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmzH50GxNKnUoMWlmhnzFRvOnMbYgW3yHiXLHN87c02iknZnQuwnfVBNKA5YPucwSgs060qHqrc/eb2SS6KY0GmSsvx6nerg3NXwMciOEwZCg0nXjdNhc4+8E8yDC8jr7ymEksJVMLv4XdYtKs4HhFwMNsb+3XXrlGZkv7K3N/QxXIvWmjC2oRTl4hFaftDQb8MSBfVOi8n89HNQYroGekvmSnfcdMmqcpxjKnYmiV7IbJv4HQf1R862hYCuxgn3sj/FJCYQIl53UYs7rwDW4thIOWMWCmgkbWlfo9/erEJnRwXxS8VbjfeHx3lrCPbb5BIB1K2CU65JsrVSVOvcsCwIDAQAB';

  /// Public Encryption key for `@gateway2`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtE8TC8034yPYVhy0WXxZKT94T8r3tXMQce7U+xrBuY/RKyAf0Flsa160AerA1mKHGQBR3OMcXU1+Hcdwgj/ITyA3hJbyzwJArx+e4OHWc2WCoxw6wtBDUTlSQZbdtxD8FFBaK7UUCtxYSC1rP571g0WfJK7HQWWbgKXG2s8SmZSXRM6juqHgznAR1Qcs+vUoM0p9PGd0e8kUGrEOlVQsOV2owyVqOT9Kq1Ely2ye8EHKXAotVueJC+OGcaTnOik1Pg3YOa3NcnhuriMcRHcMl3WyGRA28DKK6tc5kyYp3/TY0oBRyFITd/DKypPmPsbTXmSsyFHRB+Woy2wEWrt+9QIDAQAB';

  /// Private Encryption key for `@gateway2`
  static const String _encryptionPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC0TxMLzTfjI9hWHLRZfFkpP3hPyve1cxBx7tT7GsG5j9ErIB/QWWxrXrQB6sDWYocZAFHc4xxdTX4dx3CCP8hPIDeElvLPAkCvH57g4dZzZYKjHDrC0ENROVJBlt23EPwUUFortRQK3FhILWs/nvWDRZ8krsdBZZuApcbazxKZlJdEzqO6oeDOcBHVByz69SgzSn08Z3R7yRQasQ6VVCw5XajDJWo5P0qrUSXLbJ7wQcpcCi1W54kL44ZxpOc6KTU+Ddg5rc1yeG6uIxxEdwyXdbIZEDbwMorq1zmTJinf9NjSgFHIUhN38MrKk+Y+xtNeZKzIUdEH5ajLbARau371AgMBAAECggEAKn+k1phFPvVY7VsQqzLi9RTvr6cAYbVAQApyCsmQtcMPIyIMPZiGNHx64yTI1P8eJqdrpCunqNo2CqDShPCxruzCCS9nBaHbSyuh0BGK8WIQu49QzlA2PbPMDoeXtKl9MPCLgFfK5JBxAnoqGDHIXmuPih7j+icP0u/AAhzinm4BMIx328sTuvwdsTWMWwOKAdKvKnGCY2IC3H4kwBx0bZg9Sn1827ZATpj/OXjJSVxeBuI3k58Uvo1ftdoOxHjufhbmZFsnIDhWDR53SMKaAoGR/dWkloeNqirOp+VzfvRagz9lH9w4pLtwhhue47xNePkjVWXJDF4WmfMm1IM/wQKBgQDd2r+ZJZ5ZeNCmeBE61I9HSGzGK6Njtg9djTjKSWOP3Zgh2G650nJiMzlQxRuL2Cvr+nrDMJg57/mgBtAOu7+vKqpK3rHVgf1SZPmrao08pK+VuPPeTgnjbR+e/jpS7YR6o13cJINIu5TeIi9W+FWTknm6jiba/fz2QdpSlLPLEQKBgQDQD2UH5JjwuEh73T8r9pIT8GgQo6wrmwK+0GhA4OBPjy+YReacoH0PXjOLd4I7xyIPUP/8bIBTRl8IQVZE2sLE0et5agG6VQU5Q5n2o8FcpkwgdlMHijVx+249Lq6QQd/2HRJgtEaBZuRMOVpI2fhhXlQLuU/19AwUsoqJ423NpQKBgQDGQoFs1CBxprUXvz7uixxLwJ5sbn0CU6XhnZ29sN4HqCkXPfqdl0LfHRXAZ5VZYOLHbL2eh2PSivFSoCP4trHzUTaD2AWmXxdKNbClDoCPTEEZlQJijOzrUA6tIFZw24/DpRDw9bRZIEFGTdhuaVjYm1Krc/OnSslwLKN1nywZcQKBgGSTDIOEPWofquo1SRQ3XOXGkId6lv99LxaOJ9c03TmYPameIJwV+F41azU/z/SVjiFZRmT/DgkzOz0CWHFwTjZWQz2twKgR8TR9OS/AePgQazxF9lzusmcm42Mv7bJOJbUS2I9mla53zmQKVVpiA28N6hLAwaZjEnPu2olNJwcBAoGAEwxuhHmcTAMKi2xvhUL1uzPgTVBoCsR1Ghj9OEuQ27ZBUJq59n5c/PKKDjs2EuJdXH3/1jrZ+SnYz+tRn/eecumlGhsaAi0fQFlWhzchNKEHsmRax+AHB37ObZUsC5eExM63QMrAJwYkVOiaCUIbfghSh9mUciaNo7ucWj3Hlqk=';

  /// AES key for `@gateway2`
  static const String _aesKey = 'zk2XLGrWXMIvgQC9vLLRn3bnsdXZ1NfROS7GAQaZbgs=';

  static const String _apkamSymmetricKey =
      'Jk3toSj6uGUgEcUvkOkY4EPMXCR4CnZpeLnMYvnQVs0=';
}

/// All keys class for `@policy1` // same as emoji
class Policy1Keys {
  /// CRAM key for `policy1`
  static const String _cramKey =
      '1fcb2d6d665d3a79e2eafaec38947a4f4ca3db79430a47fb43b510f46ef9a03991a0ba4ec217ff2173b5cf1324737787263c1dd28b2c0979ea06ed79f0b40118';

  /// PKAM private key for `policy1`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCRXKqlapdOA+zTmI9nHGSGO8G1RaaHjdSll4NyGEdvwJwRKk1jSpRR0KaXpC+mTZNyJqrhsddqPWMfN/9hz3XCui3Sbmq3ecAMjdl1e3qyMs3RnQYPp754wd4DAfcA/DQqo01DFzPEqUO80eW5Q190HcRGNqUlAPFQ+mVHK9MiUnAQEiChNPEkALz8YIvFQgF99l5ylVywlMNk88IpqqEdJH6WZFpInj+6X3cjMktfpT90jqOauWOJe6JFwENlCpp+fvGys2859qV1sqKcjS+QHMM+6ERWucnnMhUIXFNQLOJP5EApR2etv0EWDsUDQJPpDRwRDqmAb72VKmBDXB0FAgMBAAECggEACuP0bPw1ZcTpg1jUtZbs+RmVA626MkGwAs/9KxkikP7PMoIG1j+KKS8GrCnC4CTDvTOkbdBTIUSEHpylZ4CRhAtKz48yM5jNiKM//YtIv/0Kan/nKlkY7hcoOPV2uf4rMl6VtUcRu9QqnQTkvyKLDjoEsHX7nXAapER+PfzMjq+dcJV2CtU+bJuG/Yp7XhQTIz8vTF03nzAluJ4v365RttiqFMKigaf3xsRk/Qx2V8H0RF4F/RK6Mo7dGfKZ6gbnFELTh3WGfJLrO7yDiLjGGsNZGEp5qLoOlusGFbOSTxLcKfQlHxAfuelhj9L0cVrpzgQ1v3zGz+e9d9WZcNsEqQKBgQDRjyC6n9VAVaUYnVHvnBWgt9H3bwUlTmIBeE+YXUwXyyR9uB9u2AxNQzBal9oso7udSv8hh/TUCb0uPyilrWxLMyg8I54vUIj4Zziig4FX91tMSBW2sYL05sBttSFR9zU0FRwVJq4ceuNKSLx+xkOYscN0yr5CdkXMAMFVQrkU7wKBgQCxk3URUS7SzuHDY+Geh61o1rSWy9pA9LgvRWLBhzk8na90BSCQtB3qm0FEuFD06FGzWe4RmwVAE8MPJcldCGP2E6jj8oIeHvQZXb2BcO+KP1CKRjMdzDqEcvXTFWmDI4RJJI4HmOa6+1N+Mev2+LhpLgGcPLF4AFVAVL7mlgq1SwKBgE9UGDatlMOi6DmWLFNBSeqqS2CYdWE29+DIk5EBGHIVY333+mYygQ2qdp6Ex4GIhdg4cLZXyjWObkAYhqGZMdqRxhRmA1az7PXj1Uun7onHSJdq3lVng0SEKaoeHDv0Ef7iUtwq5VRArNQNDtYK5cHi4TPQIA/2x9s/GfDVrkyfAoGBAIwE1Z5eASnAb0v+Cf1Sxm2QPr1Y6DOnw0Oi1of69CrTu3EkSdVP8Pb4jLJ/E3bJaQKeupWvQqiP7JKZHPn6j7eNMPLsWaUeiyMlQzQ5tOexnPQq/ktUqh+d9jAHBjedXcW+yS88ZVKysdcjzgfjfqWQ3Twwr08MFCyxpgVz8eWZAoGBAM9TedxR25ngdAKAf/JbO/BKuYAiPr1Wd1SFLIMRxKrTFXNZQ+H4kN3b6pIGypvbwHb6sGq7LQihA1iV/vqnsR0pZZCVfRca/tSdl5cWmcZtTJtQqAgcZjkSCDLiMCVTR4fMjY/LOBTmbw2GCzZkBO3nAWGS7z4YdVOG863g41rX';

  /// PKAM public key for `policy1`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAkVyqpWqXTgPs05iPZxxkhjvBtUWmh43UpZeDchhHb8CcESpNY0qUUdCml6Qvpk2Tciaq4bHXaj1jHzf/Yc91wrot0m5qt3nADI3ZdXt6sjLN0Z0GD6e+eMHeAwH3APw0KqNNQxczxKlDvNHluUNfdB3ERjalJQDxUPplRyvTIlJwEBIgoTTxJAC8/GCLxUIBffZecpVcsJTDZPPCKaqhHSR+lmRaSJ4/ul93IzJLX6U/dI6jmrljiXuiRcBDZQqafn7xsrNvOfaldbKinI0vkBzDPuhEVrnJ5zIVCFxTUCziT+RAKUdnrb9BFg7FA0CT6Q0cEQ6pgG+9lSpgQ1wdBQIDAQAB';

  /// Public Encryption key for `policy1`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiZyTF6EgsWF3spE/Z03lyTMWeQSrXRJJuz8IdX9ceUMbpIoM2neY1bHW2sRZRSwiudgxUp0bU3YLi5lS2MWGPZ0pdyUCJD1ob43+iUHazGRM+aiqAVxAXOB21ElpvcWJua9kYLIs7+K1d0Bb3ck5J/w9T9pyrOo1pFu7jSvXnjNIuGXyjnW2hIsUAkYylm0Xaan51YDJ4+vgIgWTSemEiFypIFs5O1+jzwOMfazP1b0xDAO893eP39v4ISjVEqo90Lv0fyo4J/YghFg9JOwBEOzeqaxT/4lOoXtcjiKb1AyEwtP8KWZTA0VVZqhIrFTx+TF7UvRZZJPtkMwETcDuWwIDAQAB';

  /// Private Encryption key for `policy1`
  static const String _encryptionPrivateKey =
      'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCJnJMXoSCxYXeykT9nTeXJMxZ5BKtdEkm7Pwh1f1x5Qxukigzad5jVsdbaxFlFLCK52DFSnRtTdguLmVLYxYY9nSl3JQIkPWhvjf6JQdrMZEz5qKoBXEBc4HbUSWm9xYm5r2Rgsizv4rV3QFvdyTkn/D1P2nKs6jWkW7uNK9eeM0i4ZfKOdbaEixQCRjKWbRdpqfnVgMnj6+AiBZNJ6YSIXKkgWzk7X6PPA4x9rM/VvTEMA7z3d4/f2/ghKNUSqj3Qu/R/Kjgn9iCEWD0k7AEQ7N6prFP/iU6he1yOIpvUDITC0/wpZlMDRVVmqEisVPH5MXtS9Flkk+2QzARNwO5bAgMBAAECggEAS4fACHEs448uxrkIRugvnm5HAGd6sxvtkjO3rd4Y4Inf60DGa0bHgUsaNXsd0GS4Lq8l60VGEVoyXg3qtgY8dycC8l1Cvqdh4hDay3V05UiMI1/a5+I9hXzCXCRrQHji7iMBgj1pgsU5etm9Uo82qua8tE6fMJ9gj/S1jXep4i9MMUUg+omL+3OhULSRZuUpp2fUp+pmGZAeJYwCVjNhsBxU5TK2YiNh2dEVe8SdqRzQWNhPvfrOhPtqiUhtgoGgIvQkXIUywj72KgOJtaKvTqhl6Hx95M/DWKlLZdjdbGIqlbvyn4y9v6kfiA3QO7ho/iilvLKJ38T5p0Du+AnNkQKBgQDiL0FlkjrIeLTJwz80oPSL7fjv/Ftzv5uYXsAJx9Fd/y9eUIfw0OQHj9qUs8LXBDJeTXNe4DsKee2v5kNHJFMiyl7WkZRQoEfJ45SPKOE1WG3srehH9dDpEHqO8bSXiAIceoE/IiGtySisH5OU0llkqfK2xfPR7Ub52rTrj+9d2QKBgQCbwF4A1BoIONUf4JLJlS0Lo6YxJGJ9zeY6KGL6+HTiQNr8YzX5ojAktfZD8KSi+E+8ZI9EcltInV1F06N/UhMil9KrsrCP531ts3K94eC6gKqU6tT9UXQS7C/Llr+m9TYBX6fRVhlNPRShz5KGu+jNGAG92CHz8iVAULwtaLPpUwKBgQCyXTOEBpGmf1GJ/hc8yGSwaCQ0E9yGZaYsvSNRUyqupkrTZEwfQotfzzg+pZdTefLCXO9K9SZ593bRjJKnamTI/a9WI41DG3IhKf9/+WvHZomg5+9Rt+5brGwJh1+zU0Te8lgz0hWe9w/E1E3MQSjPchl9upKwjB25cJfVXzcS2QKBgQCFEAW/g3VyDMvX3g7J9Y50YS180m7qt9u3WAWoEFgba/kqor/cM7oZwvNP++lL6gSFGQxlF6XxFbA4FaWbAs2iQj8TvSem6ch4zlR68N0DuSUC8NViThJykCINNw8pXljzN3uyFnKrUEGuNB4kyakMfzQNsvbe6ML2fYMm8Eq0TQKBgQC9nZfbvxcyXttxXnbmc5OAUZ1jEGR7nA0MtW8LoY+qvZe0wewU7/Z89NRFnhZCx5T9Au+qSI/GlP2uHAOWqYUeI8LfLTixUM5WT0sQHXSAsEOmrc08YvhH3Zbijds/iEckLNhRcomVlv1r0cWqLcYNKJh46ec/9cf1eqUis3d7Pg==';

  /// AES key for `policy1`
  static const String _aesKey = 'JYKQzePXSDT5eDGw+CCLMx7o3m+MiN3Ykkhc+2Xq1IY=';

  static const String _apkamSymmetricKey =
      'ZeJpFsd/VO138yh4KkJqTF7D16mI/WbL4OJqceNp4KI=';
}

/// All keys class for `@policy2` // same as eve
class Policy2Keys {
  /// CRAM key for `@policy2`
  static const String _cramKey =
      'c292e64ebe852ac39ef39ac5e83392672d66bdfe0e1d496bf777347019271b05012756b7d19d18beefb5f21027ef6e66b5f1637280982ca7bb295c94adf85f23';

  /// PKAM public key for `@policy2`
  static const String _pkamPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCJ+otmdhvfPN0YBKc8EwUAp6Oh+9mKAIILylBNBw4+Q2wsV+4+C7W0C0V5wv5XI0sXCNkt5nGm/ERRGanDVrd0jfeLARB1/Fvamo3vPAsZMKySwGKNOrdqSalu8OH4ezeO2KT0YGZAZ5dLKDpbZItSR+x+nRWJJ//AY+ov99jVa0ljR9abTwycLBYva0S1BEM82tVwKL3ktnnWilNF0RGlHE9yPyknBe8Tt1go72adPBDk9dH22Jl8umy+8eRhdyvBkTa6TrxtrpHDIMi8u7t7SdfPab7IRjpTxo+fgPHv7UiYcIRHD7dY1El78IXhsBY9sHQuGNbXpzDPFHCizgnLAgMBAAECggEAcnWy+lZ0HKZCys/hY0Zr2fU3GwLvnTl6qAk2wA9gU2pe7BItgq74Ftla0v1dPC/89KjUcO0/zsRqb9SYLYFcQoYamedSHm4wTJH1uEXY9xaXsk2B86KH0NY2hd+xtQ2SMx+pB0iIylik+yXt8y7fHGyp1Qa+fL7/vDumZBB4geF4jRGVJjvYgG9FhCK80Wu61Qo8Qm6R79z7hwA0xE5ENzgG/G6GgTxpMAcqj9NQeTqfUCUZ9JJ7LBGUzy3i9ZwrYpZBucdt3oKVLjgFcw55Pa5YhkDmAarKWExyWifKPf9kg4I6Er6IhxfvIXftghFZ1OqkFYvg7L8AN4HZckmlsQKBgQDcMBLDRvIuRYqyLXZTlIjXuGUot7cFdS00yG+sPv/4kwFJx0XpAbcpr1io82YfMLrCsLkDnao4gs8SOnVsPWEDVBNCLYoGgpyOi8XfJpYWOCiIakihuoKzh6sgM53cRCIZPf6czpjHt1r4OFBvrjnFqE0LcwxiBF+YOHPUp6J4HQKBgQCga4sHhUrNT1oGIDlUEWbg/725F5Y7H1THVFxtKYQWXGGk5jtW1+i8/U0qMIbR0Ex9HoJRN7MJe9KoB9cfeeUWV53SuLSqIxWcj2BR2onUQW1umjDsrDFzBka5oTMflr843swPsrz4GVbuuueBbi/Eg3lFrWJCIvZ3xl/i/731BwKBgQCVM/oy2wtWsYbncAkDX95Ol0PtEHhzuVA1uTB6/oHDdhHkZaUI3EG6fHhOnAhyUDntnYTxX1AuVO1uQ7C39OudLsaSDHvAJ5dgvHQL34DKc6l7rtGizditQNyDyJZK4NxeUHUM2q4Kf0Okebx/wQai2oXCoWYdsSr54h8TVbixPQKBgFMd5XcMFOmzh41M/OcV7Rv+5aoVEn2niiGNECZvMET1sJHjyDMCw0/IXkbRxcjICBl7yUGTfmwXf9oX1do1KgEdfGRF1zWf3/6yOtGuTWNwUubPdTHrNePHCLX9U6O2U3V/2nL3xPk3B9fBd1mUYaOMCzWS1Co4O0NrwRq4Lw/ZAoGAZEKP2bCw5IkUh/OGZEfpmSPnh+DbM3iqLzn6JD2SdWZ4SZ59d+4z10s5ErDfAwRxFa/mkF9ALKUpx4J70Xr5/ua+liV8ISCRsdmD7q0evHIyVYo2V+bfzlXkAO0RJXw1bRIGSlzpJwjDXEfi/ZPrsxp618xzpYKPNPvnFhwBt8s=';

  /// PKAM public key for `@policy2`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAifqLZnYb3zzdGASnPBMFAKejofvZigCCC8pQTQcOPkNsLFfuPgu1tAtFecL+VyNLFwjZLeZxpvxEURmpw1a3dI33iwEQdfxb2pqN7zwLGTCsksBijTq3akmpbvDh+Hs3jtik9GBmQGeXSyg6W2SLUkfsfp0ViSf/wGPqL/fY1WtJY0fWm08MnCwWL2tEtQRDPNrVcCi95LZ51opTRdERpRxPcj8pJwXvE7dYKO9mnTwQ5PXR9tiZfLpsvvHkYXcrwZE2uk68ba6RwyDIvLu7e0nXz2m+yEY6U8aPn4Dx7+1ImHCERw+3WNRJe/CF4bAWPbB0LhjW16cwzxRwos4JywIDAQAB';

  /// Public Encryption key for `@policy2`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAr0S/6t1i5ou8f9WOtj0wrcZSsUoju4njhzylnV9lmtnIlcg+gp0F6nxxyDAR8NO0lfJ795YD8wqq5JgLMwCsbncZsWUuOa/fZx9VsNB1TGqDXxyenqWEdk+1+UshpjOnhJtgjHu9fpkiTQxuw8X6LL3CY4D+L9aryY+jsJQT24dfkyuUtCYvB7sgDDY50JmFGoDFY7jwANTSfyIEcadkGMA0ciYW13I0wmca8lbEbNxKVpXRqW87+IZG1WGEkDmnItXlPQ6l6YxCq2XYf4qlvcG3KQEeGasFuTUZTV7o8z+Tqdgg8htAL2XPzjHO0p2za0UnkHvRFKSHDnI3mQs04QIDAQAB';

  /// Private Encryption key for `@policy2`
  static const String _encryptionPrivateKey =
      'MIIEugIBADANBgkqhkiG9w0BAQEFAASCBKQwggSgAgEAAoIBAQCvRL/q3WLmi7x/1Y62PTCtxlKxSiO7ieOHPKWdX2Wa2ciVyD6CnQXqfHHIMBHw07SV8nv3lgPzCqrkmAszAKxudxmxZS45r99nH1Ww0HVMaoNfHJ6epYR2T7X5SyGmM6eEm2CMe71+mSJNDG7DxfosvcJjgP4v1qvJj6OwlBPbh1+TK5S0Ji8HuyAMNjnQmYUagMVjuPAA1NJ/IgRxp2QYwDRyJhbXcjTCZxryVsRs3EpWldGpbzv4hkbVYYSQOaci1eU9DqXpjEKrZdh/iqW9wbcpAR4ZqwW5NRlNXujzP5Op2CDyG0AvZc/OMc7SnbNrRSeQe9EUpIcOcjeZCzThAgMBAAECgf9w9t67gfU8otPbkMlqrAWz+x9RJXfiZ/0+LNiRlerm43dlEqs3g/1MJOkxHcpybgD2pFNCQG5LN5TtwRF2zfhVOm5U5+HjTHew/4E7dSAlIIGLy+ZwWj4GA1pGUyZc+O3/iiWwZhC8h/aTsm+xvuh/7c5cU8eBDdurDely5f3mf0YVtBDzsoXDOfuOEfUWr6SDB4qdacokF9Dsx+QsogQlHHdL0IEF9zu+GRB9mGUXfTdBj9Eelm7LHbhN4Z+2gju6ZuI76koAQiPVDbaj+rn4aFdeSZGjsnl1ywCWrTTTw4G1MHmGXHaP6MhZkB4VNxlA/osHJnF/8AxF9M9RUZUCgYEA9W7w4UIeJ138Y5O6bNuMJCoSRA+BvBri/FXrPSaEJq6XKErDBXo/6u8QAnx3tAQQi8gXrRl3BZReK1JocAk7I3HRbTxY2AqYH4b4Zpk/y6Uq4I83/N23c2+yH7ywdJ2U1wlV4QDdTRXtURMPKH84xxK41UiVXQS7TdrQjmYzSFcCgYEAttB7oVytTlGyuCe5EPpCjBMS4hMfTWoBaxQePUc4ql2M8rKWk/FpvqRH4T6Ldb5PJVoWE/1/45HZvDeRPX8H6CwnNE0L4J5+AN5PHpekRTqDvJKarokdSR80roAc7h9pDiA0ZBIUE8zeXDIQ26B0KCCMouzWNP5Az18RPbgTCYcCgYA47k0N02pvM0vyRTg/PAYb9W5bP0WWvp3cbomsm5yX5HPHst/eC2d8NYv/J6QUq8Syx+1GB9wl/S6C2hDDvEBtjl9H+XGaW4rB9Wr1UaMMt/lkMZSJIV0Gd+hXmEtOIad+4fl7wdmTofx0i/k+KZSgCOW7A6Ux+IECJDmwbmCC7QKBgBvpXNbYJYWtp5HCTtkuvHZSezGVJdRV+P12Rt+oPhiUy+5KIf9YfoKi5m6XdAd4FPFo/bHzpFEEda/s8/nlqTljdGDh2oxi5m4PgxjyohwHwRFLeN5pBNWjNBHocYJRvWJwvE8DC5myT8jXxAckSlfOEGrXqiTRJOgEZcd8kTuFAoGAa37PitN34IrObhpUYue2BfTMvKL2j4VbeqWqB/1RZV+W5toGO7TVhHy2TGUBbSUfS1mmv07kcYoVL1sUL6vMCYG5cPVu2Ldtn4BNBLGXGj+OH9Z1vq+d/nuXuNh+df2IOwaqN6bXKTqxVNR/Tl2Qi4s5/NgK8feEpmzGuU7e9f0=';

  /// AES key for `@policy2`
  static const String _aesKey = 'rc98zzkVUQSB7jLffAtNI71xj0fUKidSXCwM0yknycI=';

  static const String _apkamSymmetricKey =
      'SJKyV6L4rYA2SB8r7PWl0nRnSry3+aazt6MPiRxAzbM=';
}

/// All keys class for `@chris` // same as jagan
class ChrisKeys {
  /// CRAM key for `@chris`
  static const String _cramKey =
      '0f0ecff314fc3183baea1e94f125e268005557b4763dc744ea41c5693161084d8127d768566613313b1dff887c87be6a80a1fc6fc09d5234fcad093cea82d855';

  /// PKAM private key for `@chris`
  static const String _pkamPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCMmUcNl+QffWwgOvvqtVkEZhsF0B+LBMKt/byGZVe54JtXjlgJOe6CMPh1Ruvb1tTErzfr/DEHeXNE7YZ0VkXig6yBXz7K6LoIGE+TOaSXD225gmw0RmYZpb3VHwnMoKPucBTTtOH4iDBuOZItTUEhTRyU1ziknuBwgTu8PumEqGv5rUbfvDvon1dZTBJn5ekzR0LrW/XPH4lMxelkllARw0WziJe/fG7YzOCZhwPcskPeZcIkJoaFmhG6tcshtn86A+EiGJfHfzBhiHYB4rq64uC2ndNoRHUGb4lEp/1w7YNJHfRHAp3qO9Tf2mFCWHDHqo71Dlad2sWW7zgPUMr3AgMBAAECggEAL1C556oxHCPSSnpvIsqKvX87ItaqdtdQSMt2MWhTgHtE6888c0ZqrKecRaNrZl1C1zn8QM9rFI/bqduhfu81r4gOeq8564EsceL0jKA+cpO/oklw7pqua30qiFlcq993q5tOdvyNe10hp0Z6mgJAo9tWfgR7zHKnJ1Vma/BkF78tujbdCBAQEm2N6CvRkIYZ7h8iyFN5arVD1ys+hHccNMvvnoTS+Sk2HZvGo4E1qRyfpr+ElXs4C3gWCqAR7KKzYHa6VHKJ7g/6EbDxmyrdO6O3ILedOaHIU+oFSQsmYdnLC9NuDCF94OnH9rwM800WuZXieaXWjHrDkzU8owSCQQKBgQD5GTu4KIPIAJDOprCwiBmWU9KBAuFW0h99Vm+07dd7NJ5UmWncsEt/T5fa+Ubv9Zql3FJkvuQTG0h4rhihyXWdVXTJJSXPAycGy88B+AHOrXQiTwOjDP8UtKATiNDifALEj9B1PV5w6dSsjZmRLp3ES0P/dL8COyqnHpzou62BoQKBgQCQfn5zTM2j8Y5QuvG4h9po5qnZvobthX6hTB0xe/AwkxZ5ZtzXeWtgHiFwAQi7ZJlj3NNhm+jEMccgvhPLNmwhl437VtBgLYUF9zzSXsTun5q/+nAuvYD99mMLg6HnZZlbAnJZ3UuEznLqy9/xCbA6E3yCY+0hE80CUpCko0M1lwKBgQDfTU2J01f/bPJjLm7qcbduWYo1eN2EtSzhcSEGssgefJcLA9QwsCGd6T4aYKjE6AlQcmeyRKW0sxqOhJM0RaMX/cmJn7F7GDpeD0ptW2RTYI7hSq/Z9QaeCyYNHPMUdVMN3lZjIzaMRjIO1Yk66u0nUMmOMZwhZeTgl8LVp5jswQKBgAHhc5nilQaePUD1vfGt6vzUi79myHDM/QHycKrVNyIat/8qhJNVZD1jBwJjMQ7nV0vCcwnhMp1jHHljn/RUKAIj69gqoBmwXfve5O7EBwIoF6aKBu3Ez6n+i/l5ZCET5HQXyw86XyJCYaKGtsp3WtDWshcsX8i/bjqqgnFyIozPAoGARuKqI4hACdfXJ1pcZqJdUPlg+NZRmzkc1+ycyT9+136rCGVs5XuWcy7VS71E5gMVeRf9OcXG5QjHysUEdvdSipW9R/swJLuyN1PWeIw0tgsCJb0CpgWYpg/2GsJMrKxjb1JWaFE1wVg1s62cEUiNJLLx3z566oqVu9zCPKanf44=';

  /// PKAM public key for `@chris`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjJlHDZfkH31sIDr76rVZBGYbBdAfiwTCrf28hmVXueCbV45YCTnugjD4dUbr29bUxK836/wxB3lzRO2GdFZF4oOsgV8+yui6CBhPkzmklw9tuYJsNEZmGaW91R8JzKCj7nAU07Th+IgwbjmSLU1BIU0clNc4pJ7gcIE7vD7phKhr+a1G37w76J9XWUwSZ+XpM0dC61v1zx+JTMXpZJZQEcNFs4iXv3xu2MzgmYcD3LJD3mXCJCaGhZoRurXLIbZ/OgPhIhiXx38wYYh2AeK6uuLgtp3TaER1Bm+JRKf9cO2DSR30RwKd6jvU39phQlhwx6qO9Q5WndrFlu84D1DK9wIDAQAB';

  /// Public Encryption key for `@chris`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiA2irG/gmj16sOA672R/u116dt6Ol5nVah9HOppsbkRGo6QH/l2nEUbpZFAfZtp//RLF8Xqoa4+upjUEGUZ4aTBHPLvRC81z+BXomAZKPywbNseEpotAqz6hApo2auEMf1Lx47A6Ee2kakp299GX/8FK5F7A3pDQZz4FYa7jY3Z4fcLEi3eoRGTODO2ecT/MdJ/oKoAgWUro8iWgJnlB78xXDCVPTEtiArjrto3ZZYzinMJC39Jci4ixXEhROF088vrsZJUud9231y8t7ypQo6O1y8/gT3qUb07Uek8kbZrnpaEmMs4rsSwRCs4O9Wr6dVz2XwzHPs0Ms4y1Cyx3pQIDAQAB';

  /// Private Encryption key for `@chris`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCIDaKsb+CaPXqw4DrvZH+7XXp23o6XmdVqH0c6mmxuREajpAf+XacRRulkUB9m2n/9EsXxeqhrj66mNQQZRnhpMEc8u9ELzXP4FeiYBko/LBs2x4Smi0CrPqECmjZq4Qx/UvHjsDoR7aRqSnb30Zf/wUrkXsDekNBnPgVhruNjdnh9wsSLd6hEZM4M7Z5xP8x0n+gqgCBZSujyJaAmeUHvzFcMJU9MS2ICuOu2jdlljOKcwkLf0lyLiLFcSFE4XTzy+uxklS533bfXLy3vKlCjo7XLz+BPepRvTtR6TyRtmueloSYyziuxLBEKzg71avp1XPZfDMc+zQyzjLULLHelAgMBAAECggEAYkIOwSCPgnVyPXnDto7LXSL2xhCXxM85/UmXpLBQLRasOZTGnSM//E9NUcA33Y1iMAC16l9ecUg0px7U1fg6ECXo3Oj74d1AquQPtnOcfaE6Ckbv+2PIkaRKnlmHgYsE/pOF1J26YqZRPt6GqxW5A+GyV9pCyrqleFqnglPPL04VH3k6l0WSq5lYPErpbSYuFTxN5EZr14i5SglVq+IfSKgfV32a5hkETzhZIHYoPgfZnNlRO7YsxcvTGdIOz1d53lZPuZGDAJ/NDIpMB8MKWZaSTqiN97t2c1P4Yv55rTQUiQfnDsQH6ikAnCDS0353GZPLZImqVvAUbXHMkticQQKBgQDo9p88JHp0UtXIa5/WqXLGjDG08oh0396GI/mme42SD2RJwWdb3YoWaRJtWNtdco0LPhf8tHEetkJOukjkY3q5I5gIeMGPrrapQI6wx0kqY2qGzWDnVRLnioQEj4X7Q1WGqUrB2WxojWRaILPOZeW7f7Cb23R4mzibxp2kq4+jdQKBgQCVgcV9uQh0Dr55O4m7bTfB6EQf/i83eqzWUhTkdtzkrXyRM6ySEmmYnnoPIwLWcmVTtP56AEPHEvVIOVUy1O0yKqFgfA9DtoltViGphe5pNnovpEVawWDod2o1aBAwmpWXb0U1QHgGud9bdS90YTyMsCfUT6eb7oPuhh+sCGrtcQKBgQDg7DQjkii0pMGJhvfE/sc1EWhwhvXeucKUCqnf5kxyZ+/xEg0j8gp/xqSm9HKfj5jD8Qih0OmiuF/euRblg3Kay9Xe4BAqFIqBcTYTUeW/SkswqZxU3Zup99+ss5GtXX52zH7EGJMFgvYP2qEfttwOoqM2Z7TVOTB3nlTYB1hgfQKBgDXIcVtA7SGTDEJggLPEHoLLI3a+4g17PCH9dTaa6+v33Q//Ht2Nch9NI2u+lI7AqGLsgX8yCS/cShCpT1Tx9EJPw64J8xPQ3q9OhN2PKK0AxAPPfIOhfVMjYjnELc7OTXIkvSjjAEqrIwarqV6cfEPAOxPNc+ZMb3mnFk202YKBAoGBAIQ91Ik+iBbYFM/R28/gI4tOVkz91igNqf1KO+SArNRrz4JVoAuvya736/iQcEhUpNP9YWYsSnZ/2P2+CJd6fnms50s0RbIeXpG0e54rwCGdffmUn7+0pjON2cgRvya9ebT+RGUNg7rrE8krdyul/KUzLN2ahzoATPQNMrd07mVQ';

  /// AES key for `@chris`
  static const String _aesKey = 'u7WlCn0lal6s4I7yR1sRanhfKaRQtqdVNOgI/F2izl8=';

  static const String _apkamSymmetricKey =
      'cOLGDtn7106a/4DFEUpeGP76CLcyUkYhdPC0Jqf8mb0=';
}

/// All keys class for `@gary` // same as kevin
class GaryKeys {
  /// CRAM key for `@gary`
  static const String _cramKey =
      'e0d06915c3f81561fb5f8929caae64a7231db34fdeaff939aacac3cb736be8328c2843b518a2fc7a58fcec8c0aa98c735c0ce5f8ce880e97cd61cf1f2751efc5';

  /// PKAM private key for `@gary`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCIsWdigHXeVNyRVRV89la9el9VHlWHKOoxTJFMPUCsL2wFiBGvHL5T4qZ1GGAfwoy0a5B/6vNVl2Khxt0ImO/b3tjZEbdiDpI6E257Dfn06gHWul7blXgtWMTf2hsaM3dnRNm3ck05P98Y9OBTMHOws4YiF6JnMa/vpNwxqA4MR4Su9QjOrqR4slRBClTb9kEzs3oautMvBaT6NUI8sI1n4ceqr3ozD6RfNiFb1tg9L3vi0yshY3R3HRjRDtECjf37phM3V0AVB7P8sPcSL/+8LHUrFsVDuRgKhIudbEp6R52n25n1oWwcMEzgA/L5AQJtEHVMwFAmKKQSuTZrarZ1AgMBAAECggEAYEJFoqkB2AJ8nN+E1U4IAUCWt7M32YlnejYIL98GlvqCIFcU1PLx2NLIE7eJoXP4b+k7hckneIO10mTfLHm+l2AT5rDCKgxGzxz19TP/bIgJqXPu7sUQLybO5TCLW2UY1aE3jCay2Pjwm3t+KTb6kVmqwIFSPUdRNPoskc9drSj8HEr3Qzf+3q2oJaKx38aL1qZjowdvZPs7lizYjR77HSR2h/AR5xZ5oec4RMfK9TlMc2e4kk5IOSCZgcld+T7krXIFQ+1E/E0r4ibUSZazR/JsOAuo5TZqULuHyb4iSQ1zh7Zbg4qC7DLZnVQ8S4JHWXI8KszwzrgZSB43gVL99QKBgQDFjGUVZzBSVqvQ6nnK1ehpJjm5o6f4Bs29tw4q1nMvJ4emdR2QMzKziRDrkm5SlP2iC9sci9XT5Q/mYCqW/1laLopK7fbG0F0+tfRGO4LV/UzoMkQbueP3QqotbNeEqruvCLeoGVG0AwfPQ8IWJvm2/ALHfWXxIfj2EkoFEI+wqwKBgQCxI2vyl+gDVubzl2HdIcJRaiBCpUNhA+Sg5tvylYT7+tmzns3zQa0cR1D1WkpPGiJo7Sw1x3okqL7PCVRdw+BMSiriB9SW+CNxYWoLH/ruz4KnbE0bdUHHqV9/sTM3oPbby0/WRTSH2hy0TYpenzFJTU+RhoxEx+hM//zh0w51XwKBgQCuqrXtuLE2/D8ql0dcmsnFvvCnPRaU7J8ZMTOrmLV7af48paygBUS9DWISiARXrDieANGZaeKEWjI2xayimeANJr1MBx99JlprykHTn2bNggtv+pHR2gjAZQdG5segG72aw6BvVwOwoEVVc1m2cHu22Rgz/qIWFK2mFQGxfLUvxQKBgH/wzJv4edxHnSHdehLEulwhYdGhGextammItN4efmGdSjZBAhGrowPkwqWjpD5D6wyMGT1yqVbnBoH1BBmBS3TusNB2xWaRLNBMgtIsNAremEiioYKui2dRfyd0bkDEougXjb9+VrW0pLzZsJItOuTt0QWT/6YCGVfcIONelHfTAoGBAL+QwsfMpmBXvh9LE5MYm0JCtwBT8lMleFLyccexJeDcG880UxHicKfp+kCYhaxx+rdXObvVfyg6UWQfWjbr4dyugI7Pk3BzYPBXaQeYWSo+6hFmRRlm9R1BNyZZelxPwzOSUwk9o6MFepAhh3S9L51hDKSH/XaR+nFl9K704aCm';

  /// Private Encryption key for `@gary`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiLFnYoB13lTckVUVfPZWvXpfVR5VhyjqMUyRTD1ArC9sBYgRrxy+U+KmdRhgH8KMtGuQf+rzVZdiocbdCJjv297Y2RG3Yg6SOhNuew359OoB1rpe25V4LVjE39obGjN3Z0TZt3JNOT/fGPTgUzBzsLOGIheiZzGv76TcMagODEeErvUIzq6keLJUQQpU2/ZBM7N6GrrTLwWk+jVCPLCNZ+HHqq96Mw+kXzYhW9bYPS974tMrIWN0dx0Y0Q7RAo39+6YTN1dAFQez/LD3Ei//vCx1KxbFQ7kYCoSLnWxKekedp9uZ9aFsHDBM4APy+QECbRB1TMBQJiikErk2a2q2dQIDAQAB';

  /// Public Encryption key for `@gary`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvH1ErXT/nImTNAhExbgT+10ySxT/3z5A9QRyhKWfCTp39sy1BODYbEqiwX35egXYr9KbNHMg7i6AzaYfiNGIOEVlx8fViePuQCLKqxMwC7uWxHfe77FuGA/P8SqiVB47OfT7BzwatENZLisbB2X9poYThjuQqsmfeSI4BxGVLpb4ivCZ9gi9bFGhI3RrDOVAFJgizm5wCeiEXfgV51WBFzK3HfF1SNgMpJQ7qTyR7902dw2BXNC2+tTnyAXQNx5KchFO+LVDNLQECTOER0CBtx98KshOaoHCXHTwtphVoE1uHqVO1zkuGxW5Lgz2TR13WBR8ziCJb54d3G1vTfxMjQIDAQAB';

  /// Public Encryption key for `@gary`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC8fUStdP+ciZM0CETFuBP7XTJLFP/fPkD1BHKEpZ8JOnf2zLUE4NhsSqLBffl6Bdiv0ps0cyDuLoDNph+I0Yg4RWXHx9WJ4+5AIsqrEzALu5bEd97vsW4YD8/xKqJUHjs59PsHPBq0Q1kuKxsHZf2mhhOGO5CqyZ95IjgHEZUulviK8Jn2CL1sUaEjdGsM5UAUmCLObnAJ6IRd+BXnVYEXMrcd8XVI2AyklDupPJHv3TZ3DYFc0Lb61OfIBdA3HkpyEU74tUM0tAQJM4RHQIG3H3wqyE5qgcJcdPC2mFWgTW4epU7XOS4bFbkuDPZNHXdYFHzOIIlvnh3cbW9N/EyNAgMBAAECggEAUoAN6FIWc2CwAo0/9L6eWF4xXjWhzQfFjLjWmwKW+oYR7f8pmCoF8Fg2prRJ1sPqVQK8lhdyKW5HSDvW/56eneqaIvhvmbwfEwlnZbuvQuNnmTTSal1hz7xUCr3bcTAOQk7c9Qy0r4Pu68tIOFPG0vVKZG1745T+bRmyJj3m6w2/C1kySp5Z4LBL5tvNoVz/s2UKTZ18GeH65Wx1770kLKuCALlocyUBN6RsfUWYCNv15uH21dIAtvAqKMf42WuHzHlucoX667HMXbeE6F4xNk3MfdzfNjHaWKrQvfyyzihaWICakDwbPUAkJa4gZVSwqfEbzSXBqd3sPMTIsYPKwQKBgQDeASVzJqGUDwoiBBAWDWSHCWi18uGO3surE3IvgR3Jx3mimHp6te2WoG9JdDZGvrMyg8RAjcm/rEdd/q3zp1nSsLu+27p4aUCc91MUrQYN10WdG3sBIZr4yKMVntAqQQpMSchxhZ5Q/7XR/lAYfj0iH0gwDSsAtvc3e/NkeoWDPQKBgQDZWklCI4LJmE32KlzgLK6ctreJLZ9EQQ6wAvaIgKkKWxYzmngsUrxM1SjvKFwlGR8aVZ4lUGzjZZH/5y+GqNeL5deoDJclWIqGiHnKFtcwWyAb8ia2KkoxX7nRhMXwrULcJCPHORwtA5HL6issQnBv765zF1o7LfEWq5OP81RDkQKBgQC+TtU/pPoV5d6V0k3H2as3ZwVwE8jvpGWLPZxAxLo4YtsOWw+DablFyjocCZcNhiQvRW1SuTkdKh3zoYKUv/zr87y9m7Z5yiAtboa1zqzF6KgwSYJkMd6bLcM/oWhpEGA3jXhaeGSCovHGFe+rT2wweAh1yJP4hN/fnE3E8JLLMQKBgQCUWY5k6Q3sgNq9aN6pV3X6mq+cnpn1IR5gPjV8p6w42EDICed6ASJqopbk3Tw/Se0zsTpWp5UahAnpiyaiF32/C6ptFeLX553tAxt1Nq+7XocE6/tGHIk1N+wBOElN40QeM0CEStOTWbtaXcMH23UYwZPlFAxPFiVWXtdBykg6MQKBgEqLuBtGCwTzeHqYuOYZkPZJb8+OVWyW7ENkKU7+1+w9CDj4keH2olzf+h/mulL+JeM4OwbCum/LFNRm16oo4M9AxRD1WomJh4KoRXBUcf7aNKueHBOuNCj05kbggtuE3ByiJCqs9mBdAMQP48umq2Uyvh+HEpV+pbLfaQwUYVGU';

  /// AES key for `@gary`
  static const String _aesKey = '/1wmMjcbIMYfdV09lDIysEm8KSWiVEe2UX8G9AteObc=';

  static const String _apkamSymmetricKey =
      'hKKC4wBaHazyOyvUFrtolU3qpjGokJSIAtY3XP1sIfI=';
}

/// All keys class for `@xavier` // same as murali
class XavierKeys {
  /// CRAM key for `@xavier`
  static const String _cramKey =
      '721741f1f9e191ac85f8af185b57627f6b2a66be8f8c40228d15a8b17373ceaf1c17ff575af621d3b231f63b06a8ba3661c551d301b79b04e8ff9063f00c2de8';

  /// PKAM private key for `@xavier`
  static const String _pkamPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC8GOJYSgfKEoUVs/KzHsPZ93tEsowW72OuPjCfo2lFt3SKbeR07Xu1qEk/qBX4asC5LQCXzG+371eLA++cxOzb25XdI5qi/8zWvYYpyUHAKjMz+mzcs+V8Huh8iv0HGjsNVHFFRSqlAvM/RdQPPA/yeRKa879dYDWAUsVwzNGkE6Wb5HQcujBnNQlddnB02EJiv42SOm3Gl2KQO14ptF5cL+3BSzEDia1o/xhHqcJl+1vzkgR8NnHdonwJkuWanNlsQ6wPNHsEG70gaXS6dcsgG6Ke3BQQiny9EpXwQ/UqZGCKpfOyjQk2lz7PO1o6iOHRh1MfwqonH3R75+3f1G4/AgMBAAECggEAOPZ0PXaV6002fn8TZclQWIcJDqHfqOZwUolE4mNzcwh+w5lKEVsGFtpS7HMzzBpQKQQG5PGld5eE9HWJr/k3HdHfDaxFnU1INFQK+EaZod9lyDzzkNbuDWuyzlytCeSYs426C9dJddVx4tx7vu1aivy9dK2Sa23CZg0q++EbL8u6dvXdLWJWs8dEcLkKW1hfhquA89Xd7eQrMmBFfTt9RQatkZ+tKvATCiz0aZtLzwzXyg6W9Q13I/ngqpGxbYQG3Qr4MRyN9toVBnq5ftxrQznzeoVWPACWKfuRYmXrrkeQojZiltdJz96+9KjI6y4b1lvUMmtU7vUO81AkxS0wYQKBgQDc2KvoxDXUuJNZIumJTskw8TxdztqQaVa+F8e7E9nUZrrJmRa7eCZmIjWDWnc9I23QTOOJPR2e29sJ36I98PynErV7IVffuHhujbBxa5Z5etAenWB/tfdekOEQZ8Kb8h4aKDKKh7pz+PjF6hoeFwg4CsvQnSlaBL5FFnrAG/vZbwKBgQDaCbU4nEeugMb2dk3DTFvHOVACbtAmlIxA3CO39jn08lmEev+TyLEsfuJDIPn0Wg8M3w6JpWDFQ6BoAb4/OCZ3jOGkfMGsV57EpzwdiVSKXaCPd3TWLyxGSwZVBZEfYSxMUiI99Cwn5YbbZaE4lD/ixP7VbrpkwWufEXEmhlUwMQKBgQCdb9kdlsLJYsuoP7s8p23F9jOSrGQjjvTHjyxTsVMYmCOQlBIgkwbMyJZdjaBzdU5TsHyE2YzEMvdzknmWrrVuZWf630pFsrwoE9o1AP3EnEjBim/Am3g9cgsAJvgVNAVBoGZnW1sQUe0HKlx0FvdE/G1Pyrov8jGyDtRzH3/rAQKBgE97DnaOcYrpIp4hTgONSD99Yu8gGfyWVfImzVZ4CXSDC6LBe30RwZQoxK4XzUYHtkjI3vHKOVZvan+/cux0uYEG+BIP8EG0xwmEtONHdmvh6W+i6hJRq+AL5UkE+Hvp3k4L+rN+2MHKZ7h+eaC4Wfl+Oi7vaD7mSyb3Iroaad9hAoGAbaozEbBH/kKUi73yRao7rGXCmFiqsvP4V3zaFQZYLzEWz/u6WMl4P+bfJLDnCWN9Gh4Ie9Z/lVl8jST+M6+qRzYTzuJtaZCI7UlGJzv+1Zcxq3a3EWq7uHOSMWM/XuUV8hlc9hCzEaDhG8Wa1+Rrg9tkgaRKblZtL6YzM8SeFtU=';

  /// PKAM public key for `@xavier`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvBjiWEoHyhKFFbPysx7D2fd7RLKMFu9jrj4wn6NpRbd0im3kdO17tahJP6gV+GrAuS0Al8xvt+9XiwPvnMTs29uV3SOaov/M1r2GKclBwCozM/ps3LPlfB7ofIr9Bxo7DVRxRUUqpQLzP0XUDzwP8nkSmvO/XWA1gFLFcMzRpBOlm+R0HLowZzUJXXZwdNhCYr+NkjptxpdikDteKbReXC/twUsxA4mtaP8YR6nCZftb85IEfDZx3aJ8CZLlmpzZbEOsDzR7BBu9IGl0unXLIBuintwUEIp8vRKV8EP1KmRgiqXzso0JNpc+zztaOojh0YdTH8KqJx90e+ft39RuPwIDAQAB';

  /// Public Encryption key for `@xavier`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqxjwrGbRX9cYQC867Z340Za/aekXSjDT3dmeUZDr1LL2biuemkdknO2Jeh6jxYua69V3eEsDV032SIFcaVOEKE8jY8hVFq1h6KNjUNJVF++RwFmCM0H+9Oh35BppgwThqFBFSTy70L/bzzKSKH2WI/Vk4lqPcwU0U/BGzzUxdUSR1kDX4LN8WJF9ehX7rQb0vweU2GVg16cFRcLhodBRdoC9/8Gb6ekKuT151f4ohd5qxeOpF1xNOFgHos7Bdbtpz/DrsHS5EpNCNc5GvNV66Xsv8kXGzhMCvcxuXOl7IKsAiCxISyAb2F/y0WnJZZMQXIuYr2WkgbMeNSbHPh8OvQIDAQAB';

  /// Private Encryption key for `@xavier`
  static const String _encryptionPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCrGPCsZtFf1xhALzrtnfjRlr9p6RdKMNPd2Z5RkOvUsvZuK56aR2Sc7Yl6HqPFi5rr1Xd4SwNXTfZIgVxpU4QoTyNjyFUWrWHoo2NQ0lUX75HAWYIzQf706HfkGmmDBOGoUEVJPLvQv9vPMpIofZYj9WTiWo9zBTRT8EbPNTF1RJHWQNfgs3xYkX16FfutBvS/B5TYZWDXpwVFwuGh0FF2gL3/wZvp6Qq5PXnV/iiF3mrF46kXXE04WAeizsF1u2nP8OuwdLkSk0I1zka81Xrpey/yRcbOEwK9zG5c6XsgqwCILEhLIBvYX/LRacllkxBci5ivZaSBsx41Jsc+Hw69AgMBAAECggEAOO8jpzrPkUTSHQmaYlee5J91MpkN1vJIjhpMRHglAbJLrn11WYFISbABf1GSzbmW48M07iKIChU3Twk85w+TepZbAGk5Z0Jqwi8cbViQWFav+YHPgZ8EaBqzSoQ/eAm3zXpok+ZR2TT+wAPj/vVLcMvHtkrMUUn6D7R0256nxo1u+fdJ5vsBefhSKR23zNfp+ynU54s20Gc4ejqDujbIow+aiJZv9y/asPG5UdSWN6ykhoPlOCv+VqAlGT7OWFKAMTUfIZb1UsqCIYKN+BNbwFBkFcuzr8AM5Xxd1DoNcBVdLOY6j+6k2kd4U0XxvLAhE0FZDVt5J82jGtmDJQyRQQKBgQDjFixG3XnXArYnM8667+LrdIK2UGbxu94pMjRR16g7v+miShASdcxzmBr/oDAHJrSwYg4t6QIyarj0nIfUqUNefQS28qjDBuQRMHwAcYcZZ5QwynJZsyHu5KP/Hqm2V4C7mU84jpKygiDQl9GSXIsIldQ+5ADrAvpFVkyNOwGFpwKBgQDA4dCHpFFmW2BcFIHXn3fpg2JPNSnXBmVl64QRVKUj30As5KMpgULiP5qP9KfogYArm+S+p6uK5s6kqdLDNOMwqCGLD21n8EOzOjtd1bbzxuC/OUu1SCmmqMd64Y+StNj5lxx1FmkbGT96kAM20QnvUdz1U1KeCODprL5z4L9c+wKBgQCztaBklHEPjr3IWF+J4L2byCCJVyegtiQiRfDRs/EXF9E09ZeyhDbAY+c51PMtNZxY2cCO5I8whvTH3/g+e5Us+ZL5lR+o95MVZ2E6mJ1ppWbJFe1Yv0JjY93Ez+dOvgDKdZEUGQBO9Fwzt3HKeiItMSU+gAGZ+klFBf6e5ctWkQKBgFckbpspwOD2vaU8WqE5Weq1QjA4+6s7J4qRijxuOqHnVk4yCglRbg9b3w/U4BtqjqalKwZ8KEN8HbZFR4SMG2y7OVRjZvGDmoKZ94JgcOTYYGfkkfDYJoE2VdGNoNkOPc0d2WyI8HmewZA1Ck60yMFIAgUQXQ4rQrowImemDa8LAoGAYc8Tp8LUNj4fYzTA0zE7YwBga0eTB8F9eHYhimAhBRScG5FYQHlGgNvwfAATclJfX2ikBRHidWUYGM/4+z10ZX+98uwGEwPgUWJCy8mLJ6CJb88a0j7LQjOYd5ZT+Qi96X5Y4RRYj7/2CHaq1KvoywqsGoaVaiTK1opj33c7F64=';

  /// AES key for `@xavier`
  static const String _aesKey = '7l00PvmXMD9i1z0Q72O7RNQc6D9/9k9FrqfvCZcEBqs=';

  static const String _apkamSymmetricKey =
      'S2e/rEr28kzOlirkSBNYCoRMd0Orh8h8M4JE7bnzC74=';
}

/// All keys class for `@jeremy` // same as naresh
class JeremyKeys {
  /// CRAM key for `@jeremy`
  static const String _cramKey =
      '680b1d580b4bdfb5231b6db336fa4713e29726ee5f4f9ea776d1853c8c94043a2e83b97f1d97adb6c971f0536da0574287314bea647cd5096fe8025222180712';

  /// PKAM private key for `@jeremy`
  static const String _pkamPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCItqg+W1CwArqB6CRhKEmXCzdOpgIWn1BvvNDkb7FhWcFEWoIqTsWKE8odXnN7Lf/QHwQDL7MWnT4D20XXOlwcDmRLiSwkSiiMXeb8Q0qvH4U2AFPi9tnGnGVhEe9PylJzhn3iV0GkkBAfkMw0ee4gllbqljt0tYqJ7D2ETOuxU14R+7gQpIzqLAvt53ReGlrD6c3NVR0tF75O/Ul8eTcjR8E9kb7Dhhthe1bZ75aUspG6GD0zoZzbA4l3QMXAvINUKj5E6Rdr3QBdBAct+67att2p9+4oglcnVkpUKlaEAX44wUtZddtELvxaFXG8/thCBkN17F8P9COTyzj4skdtAgMBAAECggEADV6Xe2mgrWXG6XdTP3EaKTw+j2FqqN2xlwvG/d/yX8vQO6gCPLLxXHxs8oxPDMfF0YuG7+zVPavo6aWi4dZiNZgutLhYacAa0QdJ1HecMR4K/+nuSi7Lw0F+JI0Fcy8c+xE29FCGKdqwyPV3Etats+Af5dcFP3eVccF5jpubHP8d4WloPtYV/A/b2Tac7th3AQXt9x6sk3nvTJl2Gui3R8TR3lkE4VxAuOqcPtD+Oqi8dARsHbXHcgeON7I2wN0sIZnb31cm6BoEZlJKpoqx1qPMGTEmR/8LGKzbc0Kj0pisawu15eUB0dhccn2BMDScAdE21vzpKpU4e91KKQTeAQKBgQDh0tgRF0HUmljJnwbs8txg9RVPKNt4ZlUSkSwsO3YAGGKTTv22X+TJWKmtcn3yG8uRgNWSAFuOCX1xB4WAamSTOeXNUq3DbalNnsCrk0w1KjLdhiE0U/0V4DmrCCCifPl0z5UgQ9s5HdzJVuO7iXLIyxsblc70HiyueHRtX+zagQKBgQCa+3aCanQQEABRuTqi7AFOoQ6dCarTn9/rMN1ZUI7Ppgh23NkBtBJbsbAurfmmPmLSf3JbOjpjWOS2Z3xhnUlmBp2Jdrl1+ZyH3rW311iph2NWQmLKPcJx+wVKQH2TtBaTY1Xpbrj2UTaqkf7L0pJStoAUfp86ofS2DVPrGaD+7QKBgBDSdgn/44WE4exTDl8EUGpgl2/IKWE0rk2txs6ct1OWfXFfxwKY7iAZnLow9zTb4TQ7lq1DnY5dIp0S5F0Gj+tvurCq4grW1m/TzaJ6XIjxVcyuuzZ8szO3+lPFTTkNej+7Xu6CX4hHszTEZj6IJKbUinZpmHsS7F0q1/F13d0BAoGAUwMD3CDm37+iXCOpq6BbpuEPcb++1zFX/6KhvPgwNjrJZ9ktBwOLnb+UDbyz7n6V8ge/meubYKE5iBXwAlz79oDumrWT6wPy+reof7sBy3QwGgDe51KjNufsUnQujxGz0egwGSNsQMsJS919K3EzXMhR3ChiY0ZiS6zh2RhWKpUCgYEAhySdCC3vbVwG06ltF9DIVWwyD1/zffMc+NTdI82aeRwRjgc1O0ZcSimf2o4feEXNVCe6WW+ZW9HrykHq0ANVibTMPNvsuhAk92HgMB3vndPCsIs0keyxgIIBEHrVHM/cDf26quz0t2GvCgKANqTu4VTX5c0ECwk4aJQ1C7FXLew=';

  /// PKAM public key for `@jeremy`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiLaoPltQsAK6gegkYShJlws3TqYCFp9Qb7zQ5G+xYVnBRFqCKk7FihPKHV5zey3/0B8EAy+zFp0+A9tF1zpcHA5kS4ksJEoojF3m/ENKrx+FNgBT4vbZxpxlYRHvT8pSc4Z94ldBpJAQH5DMNHnuIJZW6pY7dLWKiew9hEzrsVNeEfu4EKSM6iwL7ed0Xhpaw+nNzVUdLRe+Tv1JfHk3I0fBPZG+w4YbYXtW2e+WlLKRuhg9M6Gc2wOJd0DFwLyDVCo+ROkXa90AXQQHLfuu2rbdqffuKIJXJ1ZKVCpWhAF+OMFLWXXbRC78WhVxvP7YQgZDdexfD/Qjk8s4+LJHbQIDAQAB';

  /// Public Encryption key for `@jeremy`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAh9Ky9vpVPdEueodV7CzJRnaxsgqvQcVhz5VGQFcVN0v3yDxUGEZjILAJ+UiqEoKhOEP3LGMqNpC0kdOfjch2D2TujJu9HtgvrkhxqamfOGykTk4ixC3VDtAwBlqIEi5/T90g2DeyPifdIPFsn3RxIs8rYq6egOpPMkcttf9OONvGxdmlvdMNbsgZQE0AgPKJXT4l5h8BMTrkYSSwBcJLbRKO4FKhOkqbNPF4b/flmcjJ5y7miio0wh0fxAMS5ijdTSocf3HD5ncIA4udiR2tT+J2n/6YbQKlMlWUtqjwq2EnVz+SXKHnNXkaF50CaSXF5LzjuClw4zAdGVVg8v2YywIDAQAB';

  /// Private Encryption key for `@jeremy`
  static const String _encryptionPrivateKey =
      'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCH0rL2+lU90S56h1XsLMlGdrGyCq9BxWHPlUZAVxU3S/fIPFQYRmMgsAn5SKoSgqE4Q/csYyo2kLSR05+NyHYPZO6Mm70e2C+uSHGpqZ84bKROTiLELdUO0DAGWogSLn9P3SDYN7I+J90g8WyfdHEizytirp6A6k8yRy21/04428bF2aW90w1uyBlATQCA8oldPiXmHwExOuRhJLAFwkttEo7gUqE6Sps08Xhv9+WZyMnnLuaKKjTCHR/EAxLmKN1NKhx/ccPmdwgDi52JHa1P4naf/phtAqUyVZS2qPCrYSdXP5Jcoec1eRoXnQJpJcXkvOO4KXDjMB0ZVWDy/ZjLAgMBAAECggEALB1NL1ajdQ6KEBYA3FK3lQFcOb2qqqwXVrrfNGqUY39zHUAq+C90ZtuGgccOJjDzeDjrASm8PjjFzU901TI01k8sA9NZm7kP04WIFVkYc9UlkKFkPV+9gbAwyP+CjpU3mJLz5gZBCFseQWLoqunBDVNIfibFKI3x5xyjRieEGocbzpnf0C+MKH28bKa0nRu9HRmdwP3ugKXlzu90r6es2ShynUcwEQBqx4LzYQc0YMbi5dT5UJwJAbQQKO9hKiysRQDzT+Vv52mBkKRiOImf7Qboww/UmXXjsrExKb9qMr2OAHjs4YN/9eMTyqMpeg5M6F5EU2w6wiNvJd2C0b3E0QKBgQDlWniaQ/unYNBwKHnOj8+F0CAwZGmegX1osPup5q3SBH4lUXPp92mPuxkm9QJrt6tZkORCz6MvbfP2mqzBoiRn1Qu/f+CU4XLiNSkFvP4IuzcjtxS0rMsockKS+xXvlo001fIFTrib3bPhPfm/iYpNRJpPp+5qe5mwcumbzDagbwKBgQCXmmhBf8Qm3atmfBDaSzA3bJy1wgfxVwzzMwT482s0Y65qsR/WEkLrraKYrbRYwxIpZSJP9KwXd9fWhrGfccr9cmEVYZmCL5kGujqhQ2f3PoxSVTgE4YAvy+v+cz0iZLZN+s802Gl7JO7i6TBVNidtGI5gkaGJzcOUx48ABOEDZQKBgD0cLAI+lvD0FNWtkzb8jnjDCbCbMKExM28PqR6N/kZ1N/9NgqsWZyQK4BrHMYvt9lP5DTjYBkz+6QAOGnXFdBnOZED0G6zPnUK0k2eaAb3l1D1J7NRvLfpq514uVJvv61PmpYPQg9PT8LfVQZRNW3JXEx6iSh5JLJwdIi2G7g81AoGAGwhXasaDjYKdW4rn3mTl1hwx3V8Z13j0QDFqw5F0HkVgBnpK+PsMn8W4Zo0iyWkPRf5YnfU88npWLFScO5go4ASTNyLOIp6mJML0TWkdksK+drfnY0dqehtcm2SlFArtTv5YEE4+kMzHJAL8sVUUtqlYSfPt4Aqmw1LKNvCnxtkCgYEAz0DKXKGtscLpd5o3qf3hJHKfOHxe7wJdG6bQcuQMD8Ue1vgTsQjE5YnGT6zPsrkAzq9l38yzxpPoJIAX6JwXbuvHG5ZImEouNA+hPtxn2ROqlhZ1mliQX5VvHWoWZrCyDMLJX+rTt3gH8KFPdCQL0yRddGhl9jgv8EWfaVKk9yQ=';

  /// AES key for `@jeremy`
  static const String _aesKey = 'PZBVVg6AzUdzeuj01tozYB7EoQ6N+pj/ghdu21IhnFQ=';

  static const String _apkamSymmetricKey =
      'KcnMMvXYAnGoFA+T9sBw+IeiI04dsWqneLtZc88i00Y=';
}

/// All keys class for `@curtly` // same as purnima
class CurtlyKeys {
  /// CRAM key for `@curtly`
  static const String _cramKey =
      '91890877b8054eb456e6dbd0a739d5433c200529cbe885754b7d9947b8eaa317459785bec8afb904eec947ddb36e8a22eafe12a54a39373d381f08c468ccea3f';

  /// PKAM private key for `@curtly`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCFtbUMP/tNEH4N6VwB1cfUNIvJQcAyaLLc9kVvco5bNW/vy3PXSekGVVebkDiFHYg1fAjGzjCING7hRfrkC9mI485nCaFzNFoqcQ2mcPmBVBjgPijIkkPXIvXhkyvnZain7fSkV09q4lpL3VrGw32s/5HfNHyHJQ1D+58Yn6FVWWzX0/KKU9T5dxdBjO/ce+KksqkZyZaBPoNhdpywBC6eMNDRke8K94JlfdsB73QriSM8GFDPyh9x7FLiSZ3D9iW6JSuB1ucbXp4DUAsy8OeqY46K7C6QjahM6KRHYhNATV1BFaZhIvKtu78h86YtNEL20ho0QhE/2CFG4fULMDL9AgMBAAECggEAcL2MwZ51Kz6buukn/hgenQwNTY4WG6ryHaO9WkIyTC+biYp3y3BzfjaZXv7U2VDUV5yU3eRfQYlMcMAL0xs2udizYWfabQQYfq7CfrPFfUnGi9V9l9jUQOMmhaQNIdgyxB286JEB0rK2xj8HWo7dOfBoM9bSpTUVoVvZgu6eHxLGxKjxFM8CFX2XOxOTateMHf4TT163WKRy0fAJ7EOl1ar0GIO6CkYK8FL1J8sr7Oa9QFv6doSiiUnUl4uWptlKF9+EhiDfiiGhFZIYfeljpjh7ZOY3e8pYgdVhsucBxGZGyIh/3ojf6/1pAKhRm27rDSAWpgZvkMdsA7aOBKxT9QKBgQC8+UfT2JOj9F/jBM/sLssjC+AklXOklVfNhzs9kUYWxg37jW9iUzUtyvRts9tGDTjs6rg+qnKHBoAZA8SAU/xggJDTF7dfhIQGsjcYzkPIYI9pGmGZWhSDLPpKpIVfbMtCQnizDU465M8DmAZIe0cWXRZRrzOROf4By5podXbsGwKBgQC1InzXpLDPsqS52MKi3vuasKzk0x6rKNYh3z2U/1DsIzz8ZYraXyJ1aTQP5ExW4tcDvx1DW2fZ9F6CU/fVmHwJ1IvL0BZzdvTtWav66a62mYsgf9X10a4B+bKZb9MfnTGjg0K+qGXgs6ZTCukBYAkw00tnULc2S+5wPkl2tnKexwKBgQCJSl35teYFfpxPNYbNo21np9APJBkhIHLq2e2bHDkcgIVWFXovqB4Bh+qu7LVInoCV9y0mMfUEzh8wjUEsrlez0JPnGNrbZU36A23t8qTiJezqwgTYQc6XQo0Qv5g6LLM7D0nbY7ZLKUKQ7Njbvdx2jeiSLcQ8JTK6IS6r53MfswKBgEOQr7zIg+OVoXhpcIDMaFHVYUihr6jsvKM54IC5k/fhVRhY0CiQoAvnyDG9WPR3/Pg6y7GaYOyeCLrYk3OrQ2lvTQ4jepxrXQVEE7Cuhis6rvjadncRVbUK7SHq4nfCbQevKLBxpD7jBEGpqiyHJCaASnopU43/WNupgEG14J91AoGBAIyq4QWYzRuv0VYhfLvd9Ydvj3d4kN4n4d7ZoJp8nfUxU9Aue9TXrGEuN8lBLLKV+9HALeOc0ptwIVFf3tBSoudDXXfksHbeHyZw67+HLnzkPy8hs1flj3jiMNf5aIBNjEp+nWR/RwN5rz1IMzOMYirpz+CCmZ3DWb9wjffAAvXM';

  /// PKAM public key for `@curtly`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAhbW1DD/7TRB+DelcAdXH1DSLyUHAMmiy3PZFb3KOWzVv78tz10npBlVXm5A4hR2INXwIxs4wiDRu4UX65AvZiOPOZwmhczRaKnENpnD5gVQY4D4oyJJD1yL14ZMr52Wop+30pFdPauJaS91axsN9rP+R3zR8hyUNQ/ufGJ+hVVls19PyilPU+XcXQYzv3HvipLKpGcmWgT6DYXacsAQunjDQ0ZHvCveCZX3bAe90K4kjPBhQz8ofcexS4kmdw/YluiUrgdbnG16eA1ALMvDnqmOOiuwukI2oTOikR2ITQE1dQRWmYSLyrbu/IfOmLTRC9tIaNEIRP9ghRuH1CzAy/QIDAQAB';

  /// Public Encryption key for `@curtly`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArLxzqTp+6Sf8k11yheBt0yjhDRZVWsb1LCuWFgmnUE7QCjQgi1hCiR4s10fZl5CAD9nmDCIhj7Y6dpsD/1WyG5vkDCyc7fmYSlrXqzmGzINoIlZ+WyMsbAQ3H0kO92n8kHY0lY5YxHZMjpGW+kpVNzNn5Uin2xN4YNmvQyscp/5r7m4ZhWK8Oh+UVOK7Yqs1BrTxThx//e9rj4DjPm0heLwQCywHHP1SvDOcZoWICTReV92w0UY+RWBns64JFPtt1D6J9iZiUMI+0dnMZ39sETYfT04HM2r5wZeagcBXt5AGj1tBBrrUb/73/7rv/coeWGeEbTIs2RMmarKFJw3nuQIDAQAB';

  /// Private Encryption key for `@curtly`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCsvHOpOn7pJ/yTXXKF4G3TKOENFlVaxvUsK5YWCadQTtAKNCCLWEKJHizXR9mXkIAP2eYMIiGPtjp2mwP/VbIbm+QMLJzt+ZhKWterOYbMg2giVn5bIyxsBDcfSQ73afyQdjSVjljEdkyOkZb6SlU3M2flSKfbE3hg2a9DKxyn/mvubhmFYrw6H5RU4rtiqzUGtPFOHH/972uPgOM+bSF4vBALLAcc/VK8M5xmhYgJNF5X3bDRRj5FYGezrgkU+23UPon2JmJQwj7R2cxnf2wRNh9PTgczavnBl5qBwFe3kAaPW0EGutRv/vf/uu/9yh5YZ4RtMizZEyZqsoUnDee5AgMBAAECggEAKGkeFeUdc6ZrLH6cID3U86WIoOsspMQO73py7kzr25nUic6QHolTZ4irrOGeQhsIGq07aHNDrr9PBhhV4xJFTLg3rbFyNSpDOoHuGpymsIm9fusFPIUKC2shCiypV7Bv6cv9mU9n7O5QErp0u7FQJk3cbIOG4XW4n8/NdMVNOu+is/6jBfyFfRQL+/6smCk5UQaERF7yFml47ClwYmxVBXZaPuq6B1ozqCvOvqLl04MARQFkiGqXpBdK6mlEV+PIgJH58Klk1aB3nOI7/8UUz4bFKfF0tnKlO6sqmPY6rCbt9GTFqwupEmdAn2CgNmQx+WS8RW38s0EiHAqVQA2gEQKBgQD5cGknKQA5fO5+HtmKG1nbSc4O9OTEKR/AUReSvJK0b8+ZCiDoc57JAU21EhZKQqH1+8CbZVyfzJEEv+jKaTGb9vomY/YxTVFMf/4PaJ54sRB1RHOxxNfzsQ3UwTl6W5tjRYGgsC7s5PO4DgSNVPSUZmeWDJR8oS2Lf513Xz/VAwKBgQCxR5B770KYN9s+84l7s0jG5j8oKTXBfFLrVVjgGslndiIZ0CNZIi+JFt/pKLo8qrUTEias7yqaa3hguEJLJCOTrawi4DVPJsAjDYDB+KY75cw5F12HUxF1oSDgdxzPj5+DpF6iaVvQmapKDVeNfL85tLWieDirMECdb8d9rIHdkwKBgQDbpxiB6oIPHauqliH8ku9CwrBYzWByOMCECyTWC4aoq9lEq/2klMQbvzEdpUrJo/mZclL+xHiXI34Ej7ZAH/gWnptTmS0f5zUTR5aDHR6Hq2yRx3CV94AvUReb5Xdm/ypLddabmOoJo+fWiUmK52flEnRfVr6fLRO9Ruh0SQUd3wKBgGqnZ2FofGQflqO02M22+t3Ov8hlopWZOjmiyylodCrug22MLvf8/SQ4wtT/T6wX94BVtzbrXHIyneVydU/Hmi/KmHkS8n+ADLAJ+6C2+yumAMuIJxi2/RYLrj/c6VRmT81fIiALytUg3bZXeIkCt/j7oxrvwQgcq4MMMLSHCEpJAoGBAM+OCx6/hDpsVwK9oNcIdhv2hXx3E9K1X0FDHFq6IUWrT05NIhhJ9DGxic93o4AZpjiCzD0P4N1MQ2WWmcfnDYXnuwT5NTuU44dO5TyvJvy5GDhZMOHp67sE/qFJfbHaAi7xKVg8Xt+tToFNTRBSoFj6WttNagzCQFD2AGSXWAxv';

  /// AES key for `@curtly`
  static const String _aesKey = 'A+PLEY7DkKBUqx7Gy/Dt3P/rnehaN9td2E9sVuepiBQ=';

  static const String _apkamSymmetricKey =
      'm6fOwRXTMdYPLhjjI5Hq3zfF8OXz3byQWIPo/DPgQFM=';
}

/// All keys class for `@gareth` // same as egcovidlab
class GarethKeys {
  /// CRAM key for `@gareth`
  static const String _cramKey =
      'VkBTIoOH8LdgQ3ZZTgwQcCue8r7AkYZIa4iXtkPWQzP2XxZbaok51FkenmTi7VAycS4NhtorLjHyiipenAO6kjaLJ-qyqc-C07rO0QcWIPi5b0jIMo-zyTTFnPQP1nmmSI306ltdKkWu8W6gsmCTqq';

  /// PKAM private key for `@gareth`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC7SETW3urPyVD7QFdK/qNC3jM65mnY55Qu/T1uobbMN7SibDKJwn0TtUMh3tJsDz7JRwhN4L23YspJzfV9bugPtjBiJUc4Ujn1EaLKw7A8cXD8wC4bEMk2lrc0V7NBnlu3KwUNKoZmk32XxBPQ+aCWQgxcQZriBo3i8SUCHWXfwouObmIV1FhAgm6iXyBpHM5IWdfAeCpQqG9GFiyioErbzOp1lrGBXKKo2tZYJIfYzbtEcZLdbYmmUgAfqI06C9SEuXjtN+HykMoPJEntPwGtqO85HamJE7mqdqXC0VdJLUi0JW55Y9I+xAoh2HI0mfVtLEDxtzL5nD6lEfsRzTOFAgMBAAECggEALwaOgoWm4FXkh7I4ORSHWhsBMiD5IwXDJ6le65Cfnde++6m/Zuf3ECPLn42buJZ7ZX74jtWHzax4rt+QbNaUXp2YuIwzveintOmgvtk0P3kcrdpzuUgVvidKCVKcKDXjQbMDqbKr3MXcG2eYsjh8Ij6ja+btRSPwLLPwXv+SvQRlb4HtV2wfxC/mVxFMc5qpr4x9abQk8KQXoDszq9sseEFzhOnuvcmLCrPq1PCRzt62h37mBWnGLg2awExz8kg9xX7HGlxb3GoZ/7xJYhLhDD69LcPAUYvUrq8zjn+rlpROotXsNpAUVchNWSzyv2DsQXSnmuVHLarGZH1peGOmAQKBgQD9olJKPiPO6JwZxuwBG6Oq/sWvFFELnMMTMrxkF+2C2ddrIyKqpiPOx2FefGBY80bfbDcoGq5il/FESkg36pkDLpYq42hYTdAaM32jMGrNyofANj8P6OWWrd10snlbNrgCR8XVel4gad83wAb/cTpPVh/7AVDti79b7OJi/qXS8QKBgQC9B3/UPlcxGe1iz+GU9X+mzMfaqyIJ2DhdoE/kD4H9l/UQtW7eCkLFYM5iMLcCuXZY0srSPRZWmZT904WaZsfRfwMf2Tha1lETw+g4f2hA2A5+V5uMuYEMy4DjcN58aRQ+uHfBn2AggPC4eQ4e0IIwsZrBZ0z5l2ZX111M0J3B1QKBgQDYrrUosj+7Q6QgrX3wUGGZ80CFm5DFn+5UV3L0/DAwKtVLtV+ndHqA7Hr10sIpG+U/eN8CRxEWMAKxudhK1QRV4JXwHAmH7ypLSBQct393QoCJKI7lk62Y9f6M9PCSiYPYhuKvx3Pksy49HbOcxWnwX37A3NX7qvkXmp+pvS2DsQKBgBFtUZGltbAnLcWAWNG82GnuUzaLtHWn43puPy9NZrSUf9lsgK4j0AgWZrCSwSyVIJ4LwPsk+pw9SIkmKRkVBLMBvK4A/rsRKyRhWVVsGZZw1NU9CnAs4gLl+Bn/2+MoZN9rbk8BfIFCoe6/6ldY7cfDd/sApQ4VsS/EASwFx6WJAoGBAMX4otq//s+stoEutpjNI0MCX3aVNGyov5zd2LbDphSNGbPE5q0eQIAYKf6MVRVBFt5GRQVvNOrf1IteGmlDkMgH9mcZa1xpbyS2plcSV4nwe1XxnideHJ1QA6p5TTwtgKpoB0BgfSkxLjfXZwdr+KR97Ieq2Pjl66rVNGgUrRNT';

  /// PKAM public key for `@gareth`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAu0hE1t7qz8lQ+0BXSv6jQt4zOuZp2OeULv09bqG2zDe0omwyicJ9E7VDId7SbA8+yUcITeC9t2LKSc31fW7oD7YwYiVHOFI59RGiysOwPHFw/MAuGxDJNpa3NFezQZ5btysFDSqGZpN9l8QT0PmglkIMXEGa4gaN4vElAh1l38KLjm5iFdRYQIJuol8gaRzOSFnXwHgqUKhvRhYsoqBK28zqdZaxgVyiqNrWWCSH2M27RHGS3W2JplIAH6iNOgvUhLl47Tfh8pDKDyRJ7T8BrajvOR2piRO5qnalwtFXSS1ItCVueWPSPsQKIdhyNJn1bSxA8bcy+Zw+pRH7Ec0zhQIDAQAB';

  /// Public Encryption Key for `@gareth`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA9erwjxVQ+vthdivKZO8mTSvpQuEWj4/ajg+rMQoJznhR97A3fEoepCmgNEFTsIczrN0F44M2usZXo+eDqSq2ir+GaEC2L8jDr3sZSKGrM88PcHDTgEAdGzKvooIrHnZetO+vIbAK2Ju8JicenDdJ4C7BQXDg99vPXfHVfj1FE7YWJjLPjJDOeHAUGZT9JkaTmWh6BEvBDxTZp2vv9xo//78XgLqAAJuEgCuvI4c5PW0Li1Y35xeGJFSHqZykufHS/9Nql+9Ne7GCHaEXlJehYfNpq9aHtR7kiKd8rDKp2erqrZbTlOmjoRtsfbZZFrwssG3DtF8S5E1JwyMKi7OrSQIDAQAB';

  /// Private Encryption Key for `@gareth`
  static const String _encryptionPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQD16vCPFVD6+2F2K8pk7yZNK+lC4RaPj9qOD6sxCgnOeFH3sDd8Sh6kKaA0QVOwhzOs3QXjgza6xlej54OpKraKv4ZoQLYvyMOvexlIoaszzw9wcNOAQB0bMq+igisedl60768hsArYm7wmJx6cN0ngLsFBcOD3289d8dV+PUUTthYmMs+MkM54cBQZlP0mRpOZaHoES8EPFNmna+/3Gj//vxeAuoAAm4SAK68jhzk9bQuLVjfnF4YkVIepnKS58dL/02qX7017sYIdoReUl6Fh82mr1oe1HuSIp3ysMqnZ6uqtltOU6aOhG2x9tlkWvCywbcO0XxLkTUnDIwqLs6tJAgMBAAECggEBANhpuu2QKsXUt35RJzoQI7rCK/MJNtt8Ey/1pgfv95VV2XyJ/SpJ6BE7+JpD6yxsrxMvJuGDNYTEy5eYRAt5ZU9RIS1Z1XrTyTICuMtsSse7LrEa+WXiBjtLLblrqBqUvN+qFosk60aYNsm0n4GGPmMlgjje53v4WtMn4WPI86NVXxKGJlGIg4P3PWmRcM+2tliwGDDOilo/5u7MocLzMf/sudyHGSHgzEEPK53tf24FoCZsOrXmvcSe9Q7M52F9c8P6JTmUqdJFWl2NHoQySFntxhMIOWKvwHi76J8cVIP/tF34O7VfKUKyxyO11uF5ZdM72dKM2UkdX2xFKH7YsCkCgYEA/7X0SyHtQ/9DmnXln5I0SjYJ05bCh47PIV3UXyFin7rP4gpecNCNnzLQMk1h5Zuyj3ZJRV3r9MMFhXW3PoncZc31lgKSh0R9Qg99aMmwoHxuYjlQzjP4pOXT46YCE585LU+KAoNFm9nUCt+ppzSjx6G2ZZrav0Lk21s2pQsVbgMCgYEA9jImUED9qRStYQS/ZYcKmTeXyB0qOLUcKLxF+GbDIsx/zmXnxlEmXIlKtMlSX7dU4ZHExv2+LBBwvpWBEuyVoSzMQavSq3/H/Im3XANZyXSrI96WLn8utCRY7DOhINvNSPDNE+jD06Q/hD8MGzezGxQfxV6iToIjda/j/rgI9cMCgYEArjPgDHs9b3BsNsMQvsfUlaYAxcPUHJN+qoWIk5Jj5NtYme5kbki14nm0ekBbbBfI6pEz02zrvWBK16PdRV6X5kcMgriX6E0RZDq3PfcBPCPo80OGuCORxYzI8DJ9Aa8cPbENHS8e8dDQ8uNyaXWkCfEyGEAJu/ivfnzCWmeVns8CgYBa+Dzf+qPADjviVXbDdRqdcsVK1Dv9qC43fxn7pz0DZrzy7wStat7Z4oEQPDOL2poqn0ounSPf9FM0mNmQvIqte3gd6/d0F0s2LUzrWvGaVtnF70Fe/O+s8KFK5ejr00wPX6rnaGKzmUU/AGzgwbwUjWMP8t/WUo/3tH5yaF4nMQKBgDtpQZL3TjFqmNaBIkeJQpadsl2AqZbCbKm/tMMU8LCaMj440fEKixVyhrsJDRUEjXC3oMtapP2cBRCAT097iT3m2bFx9er+wTtzrNoMFztJBttCjDqghshe8tdqrIbc16uIB9Wtw2AbrxgaIogLGU3oiWaWv9oXRzOiKykFAG8Z';

  /// AES key for `@gareth`
  static const String _aesKey = 'ZIiuBBvtCSRlC9kEZ0K+1vCOKQ/JQvf7Vx82idT7UrA=';

  static const String _apkamSymmetricKey =
      'HJ7YPNZHyQXT3hOx5JaaAWUXnnA/SuEBpGgP/fq3Qk8=';
}

/// All keys class for `@denise` // same as sameeraja
class DeniseKeys {
  /// CRAM key for `@denise`
  static const String _cramKey =
      '67f75d44efbbd30547b9d090cf67134bc591b65ea7e1c4dec42d08e50ec4b89fc7ba5431ab1ae0b1fb4c99878955ca1f90798422526a070ef1bf2ad428c6353a';

  /// PKAM private key for `@denise`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC/PECWWstNQq3kHcyX8eePUaGhliPvnQpKoAC5A9u++HTkFZ82BHxLkkfhFCVi83Qf8QCvyC9O77+6QA0/PhPoiq2ijkIaXRFlHwSWHo7Xr29kzdteA8KA1ckaktB4Ed00R2ntrP503s77DxYEe9eDr3RmULbGMjeiQ8dUpg80jQtQGZ76050P0K8FLPpeNmO6nyQ72nHXId7fqkxsXF5f6QrepiGUTqJcu+2knG2tXMoeVw62eaNiVqxR8Ing01q9gVTEyceOVK3/ainlCXKFf80nx7Nhvt2LIcpnWhLt8iMisLkm8R1EGHux1a94m8iOPS4NY+GOxqBxgX1w6unRAgMBAAECggEAHF5ZznQlmI59sUtiYF/4U+BuM8RMDG2lazCVKt0RqiC9ZmB2v9Kmhadrlk4gxa8L2PkteuYdbn5OWNjLnkgdN+/qliS4VaTcwb16NrLNyd0yjyeilS3FmsscDB8fYdB0mh7F7gYtsTSkS8YPJBci/1v1zn/GvVwRuLaJSVthAhBwc7QgLCsTM2H0S4n6G52iaVuJ0ULp1xG5PjEAfuJ42WnhezHUOpQOvRzD0wgmr9VRP2kgBo5DL4uH5ub28cTSRJ8T7/jo2BUT+Ydi7U6ZccJ/XrHtpCJXsv73VwJ6HAuu3DBMqtHtXQK8Lo4qgD93d6/KNUd4CgDgxof71fVMgQKBgQDvu1XICANO5zRiwvxfAyevxYQVoEUQXb7euXHp8xo2aL3JfqBAGm2LrbzvRRQfKex6PKnnP/QADT/9QYCojr+LDWrch0AzhmDIuJ13jLBsUhSADdtyAGTzE/iSeHWe+cSA6w/3v6OXvZKsvKTFCH2zmWlqwDyDGcCD4+5lLTY8uQKBgQDMNm2vO2eStxbNj+o0TYeQ9l72d2/NYh7l0csWsWztJIvRVI90WG4WmaClzC3WVZ7xpXi3MQzwVRHacq9zIMo9FfUQ4sZiPMbdyEPCEsp+2EJZ+PlBKwCaHhasAWHeiDjuvdaOPLwPAbOKxsjt2ag6KNOAmbxfoS9TtTXsIi552QKBgQDo4HNI+De2ezRRSBZ+eYMg5V8U3vaYGmji1QRKfiQVfJP4W3ByNPn7OM+TIuiUCVa1u55UjLSLJFPnwayokNqSynrnNN9x7fSwp14YFuv+nZFaf5uP18A4vUq3hhrETt7LWQzO3zOcoMQN1sa8vC3XvIxB7fIabHat6EnZsRzByQKBgASXzMu+KEwydf7Vl8zpWX03LVeZxBf4dv1wRIMUJoEG62Yf4sIZIxC7D9PqzbUeY97He/mSztmw8B/bqHqMaEALeGGS2CdpeoeOc4ev6IIF1ygy41hF4VOWDah8t3jL04v7FRJJ52jm/uTGJ8rBtHjqZidkTcpQ08GsN7RB6I2xAoGBANEn4oq1ThKQY7J3q60oFOWOBRK3iOlTy3Pdk1eTj40vTbMPdJ7en4JYd7nZFW5037QVX+nPEd00iDIqEaZxIo3PrIYhzc0fdsWNjvGUpLSMhigxGzy7NmchMEP/1CslE1sk45BOkHB86fjOQI+mtiuYochTo4mh9uXwK7UuQ9iV';

  /// PKAM public key for `@denise`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvzxAllrLTUKt5B3Ml/Hnj1GhoZYj750KSqAAuQPbvvh05BWfNgR8S5JH4RQlYvN0H/EAr8gvTu+/ukANPz4T6Iqtoo5CGl0RZR8Elh6O169vZM3bXgPCgNXJGpLQeBHdNEdp7az+dN7O+w8WBHvXg690ZlC2xjI3okPHVKYPNI0LUBme+tOdD9CvBSz6XjZjup8kO9px1yHe36pMbFxeX+kK3qYhlE6iXLvtpJxtrVzKHlcOtnmjYlasUfCJ4NNavYFUxMnHjlSt/2op5QlyhX/NJ8ezYb7diyHKZ1oS7fIjIrC5JvEdRBh7sdWveJvIjj0uDWPhjsagcYF9cOrp0QIDAQAB';

  /// Public Encryption key for `@denise`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAhxeCDBQPE8YJ+0ymCl3sOT/7WTjuIk9jkd0yvSd1IHcmQi4UgivIdppJKGwHVX3LLulfXahZuuqCtUbRkSLklyL2QhFU8Rtnhfyukl3Oo/0QTkUzIEbkezruSBq5zwyALxSzih+2+8PiM8s+AvRDo7ZwdQdKscrvrKGBxITOqf8BqSxuLGcp5LKK3iFh1VV/6pQYDjTXi09T1N/p+xMeMwJdhx1VY9BCsmnDXp7RKYq2wQxh3PnpuX2S1cgmZK5RfPKyz2FdzVNjptNoHTfAHuh/MHNEto6cFNYNLxjdXAykQy8qYFgECXT5CnbZklrplJZOMaYgqSyil4ywhIM1OQIDAQAB';

  /// Private Encryption key for `@denise`
  static const String _encryptionPrivateKey =
      'MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCHF4IMFA8Txgn7TKYKXew5P/tZOO4iT2OR3TK9J3UgdyZCLhSCK8h2mkkobAdVfcsu6V9dqFm66oK1RtGRIuSXIvZCEVTxG2eF/K6SXc6j/RBORTMgRuR7Ou5IGrnPDIAvFLOKH7b7w+Izyz4C9EOjtnB1B0qxyu+soYHEhM6p/wGpLG4sZynksoreIWHVVX/qlBgONNeLT1PU3+n7Ex4zAl2HHVVj0EKyacNentEpirbBDGHc+em5fZLVyCZkrlF88rLPYV3NU2Om02gdN8Ae6H8wc0S2jpwU1g0vGN1cDKRDLypgWAQJdPkKdtmSWumUlk4xpiCpLKKXjLCEgzU5AgMBAAECggEAB+e1QXWvCC4viVgL41FpsFPxJmBxduqEXhW+kVkMvpCaWYcOxis/uMkAfPANYdBRonYfkYB3d7ufWHJDcyXCkKGIHYecG9vJrAqEQKZioC//00SzYDElz5w8M1X1B4uouJiShQOkFol45CUBhPS8PIlBfWem1E6WxdhRmqlW2pWuN/SvHCfHBwX5drrGzwFxHiodDeHv+mhwxzqbOM13kS8aM6YzzdZFh4YJ5UBOGkLB+YCv8Ittit/BZDLeIq4D11smUZQchL2kP/zRECmqa1Gxdr96Q595mkeO7IuL4Nro3zPV2L78giU+mhOPICsXLqPX7KDyOyrb/gjXmnIdvQKBgQDory1njff9FWUE9sAEOI1VmRY6OZzJL0+K3UK4dhCme4zd2f0dbA+6HwIkaUxmiPLeAlKyVVSCM12ZtK6JfuK9zPByt7TgF2Q7GatOYl8dYTK4vda529krwipDIAq1hnrEer0tcjR7VpyCOqhK8auTWRJljpq1ss1NCNN0+OarBwKBgQCUoOL8Jjf1Joy0yNufT/+hGWc48wi+1TIa1EaVfThhPnTwX3bmud3QWX3SZ+ypEiZ7vWmvcpgdVy1fdzHjjZqLhNHgL4r5ajmW2mLXHHVEfGrkY/8R498T882vwEExnsd+2WuTjeQq98BzHm6NT5CbVyZIVHv5RgDeAkj6LKPNvwKBgE8+2gfaogrfrnfyUZMeb4QnjxplZLBgHIb+tCp+i00n5uHny/ypQPHyfZhJBGwnWA+kWuXBifaN5+LhVlAdlrttgLaROljXnptCMsWPWzV2VP/2J5tE9MGibyJNV1hbZJRl+OfxbU5UQRlZQNfFVtnoDAvqdWZMbv89ckb0PhshAoGARcCf5mB1YIsf+/RMBh+AQ/XtGLAOiaj6o9a97Yhf/ltWfD0BS1UtgYuOXkHBsrM+9lG1mM56D0MLm0MQWc/qGNJTwRfu7BDrSB3jxzqm2mZdsCQx4A6GchG4lWPv9L6kt6aIMy6jR3sQibZdgdo2boDfCZEEwb8Vxxthbm+mzHcCgYAVWrk3Y2z6voVHtgb2uSk4q+MrzZQh2xCsCXuyvK+1dtlppTD44P9Tp8TGiGL4VU8XkwIeyURXaC5xGZGaPBryRAhzMhMWvoao5yE3s+E0jPXHBj3yYz/Cpnouv565C0qtyA3DMpPutqYq0kcZSFn/DEaTDdoHLjVpeSczy45XTw==';

  /// AES key for `@denise`
  static const String _aesKey = 'GAnfgPgtcuHywoiZAzQTKwTPMP2T2YkPk1MjNjWvWQ0=';

  static const String _apkamSymmetricKey =
      'MvT6ySjAvsqFS/zJHmnkXojr8tpNokKXVqs1IR9Rr98=';
}

/// All keys class for `@don` // same as sitaram
class DonKeys {
  /// CRAM key for `@don`
  static const String _cramKey =
      '15cdce8f92bcf7e742d5b75dc51ec06d798952f8bf7e8ff4c2b6448e5f7c2c12b570fe945f04011455fdc49cacdf9393d9c1ac4609ec71c1a0b0c213578e7ec7';

  /// PKAM private key for `@don`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCTauOYbRGwtdJUdIhUyRCXZggjPw2T2y8l6oo+DRb7qaeWqTruvcqmCj9lL+yCauu7VHYdzN9Gn6wQogMutl7LaNcBaDrfmyclpRGFJBuvJHazM4DAA1WZntQYkFVErihAdB+tzui+MzE7Io5av8OsfPH/mKBz7AQi8pAEOW1IoRIOKAcdX0wzuL8lXbn6dYZPejyQhT3344xElWmr6jzuxZC4sVnjIBOGiUY3Y3Nj6g4byJ1LYbyOuaYTll3lD4id0YgAoNS4M9SG8Hnyu7BH9QLLJKJTLmko2vLg/FywbHBRJhhfiwaVi4gp+G4UNHAdEhswciJHmqrQY9xoEaj5AgMBAAECggEAerzDE/SzhuJLZV/E5nqlYrhjzBzCTDlwruvw/6rcWNovG2R5Ga9RWx8rGy9khk1JSaYP1c3ulBl7JDoP1kOm90qpwJUsd2HxnQkrZiPjHNaKMbeO2c+s5IN16aG6LL2n68oDWi3sX/e1ZJvn1CzXWPSKdBl6dimqZAJ639mEYLPfEbfo2jqZpJktmpdaVvI8cgi+TSnOdLdSF+uAZzEOuG1SK7hg05SjOb4WuWT7ZmE/jipL/u7LLI77bOHkSWU8Eg2hxkAjy0x+TkYc/Gimf2SqDVsdutA3egpAX/sVHNJT8pE0u9WtFiiKlTx84ebtBmAV8K4/Kx5dBCO5G7vdtQKBgQDFa9LH9WSJJGiPJ/ngGZ4fM4FF1GbGpfvaHl2DB32LFTbNECjs/9+QQWkijJPSSUhdbNBIzm0qR8XM65vtGEUn8bIxX8OtFuRDVlTYPBjFJN0eLtPQyfguBsimQdnRdghJBdBENuwVJJHh9Hac0uiKRd+yN6i3p2XfeGcmjOBXswKBgQC/KMW7J+gzzwUJHtxJP1CEFDYtzRtirc0vK9rdLQxLtwlLGfhEXuv5jKrFUNrNFPYHEaVDeaARzdKeC/Lo5A3Sl/y7y4aF8vQei7aR56DayCKw7C5PnXYVQGF+ENvCrd6WgqiUJUTkVWdy/viTnnbWDnWZA/O4yq1g5t4x2FXmowKBgCo337CRQrmtRoruspoBAHaNriR/wqbSkiRYAAloTamzlK+PuCDOq0GPK2uPAoGi2E3aWkRnmKLFDIDBFexDF27uWfwDDbZzQcdArA4989IdCwhMXVG2D1PQcZJUXL9VbXooOxyLXjs7QdM/UypAVChVvvu+uV7k9n0uo2h0EfnPAoGBAIPiPmE8TDCKUIAVYYfLfeJSC3sX+h/fpyM3T32u2b/XHTtKRIXvM0DtcthFS1+YaZFA9FMUM4J1DS1rMwDIblzv7TcnWL1LfG8ilygctVacI4sKt3zINzK8Q0b1nJi42kvfAy2KdPhPj9q/3IIEHxrZyPpzxo+kjW/AeGXNSp6fAoGBAIs0AWG/LR1VsSw4D9/Zareo0lUr72A4awoPVRqzD70RvwT1+hC3jOxjt6tSi9fY2oSYUPx++mBd+G+CYIqBESRBLhvJLoSTKGZuQyWnJfslkZDg6ojWCXxKAv90J3QRikh/1XRtTqVqIOBBVvF72faC3Dn/jPOB/N0ggvUL1URJ';

  /// PKAM public key for `@don`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAk2rjmG0RsLXSVHSIVMkQl2YIIz8Nk9svJeqKPg0W+6mnlqk67r3Kpgo/ZS/sgmrru1R2HczfRp+sEKIDLrZey2jXAWg635snJaURhSQbryR2szOAwANVmZ7UGJBVRK4oQHQfrc7ovjMxOyKOWr/DrHzx/5igc+wEIvKQBDltSKESDigHHV9MM7i/JV25+nWGT3o8kIU99+OMRJVpq+o87sWQuLFZ4yATholGN2NzY+oOG8idS2G8jrmmE5Zd5Q+IndGIAKDUuDPUhvB58ruwR/UCyySiUy5pKNry4PxcsGxwUSYYX4sGlYuIKfhuFDRwHRIbMHIiR5qq0GPcaBGo+QIDAQAB';

  /// Public encryption key for `@don`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqZzijT3bJuSYOOC+Hs41BqZHQrn5h02aWZAR/gDvJAi+8X7RZYI0O164Tg5tN53X06hDp0E20OG39bAchL9pQ6TYVVIPZ262brQxH2opoXeFaOTnvq310CTcstn+1fdrkjyW5LhcBDQEFrmMhc5v51n+CcjfeQDnFBAaBhtsSXozqw/XW4NwNK25eAqSEUALHD7Ic4Wr7np4dLotAycxghkBpIe6J3QMGzStEhTtN6QsXfNRr/y55X3o+4MgTYJHQK3KrgaoivK76GVGgY1EofWHZR12T7yZO6A3yBzLBnU14AuyFl8CYZHI0UL3SHRkhZYATLjbuMlratHihRkdnwIDAQAB';

  /// Private encryption key for `@don`
  static const String _encryptionPrivateKey =
      'MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCpnOKNPdsm5Jg44L4ezjUGpkdCufmHTZpZkBH+AO8kCL7xftFlgjQ7XrhODm03ndfTqEOnQTbQ4bf1sByEv2lDpNhVUg9nbrZutDEfaimhd4Vo5Oe+rfXQJNyy2f7V92uSPJbkuFwENAQWuYyFzm/nWf4JyN95AOcUEBoGG2xJejOrD9dbg3A0rbl4CpIRQAscPshzhavuenh0ui0DJzGCGQGkh7ondAwbNK0SFO03pCxd81Gv/Lnlfej7gyBNgkdArcquBqiK8rvoZUaBjUSh9YdlHXZPvJk7oDfIHMsGdTXgC7IWXwJhkcjRQvdIdGSFlgBMuNu4yWtq0eKFGR2fAgMBAAECggEAY2QvzhylQ5FJMmtgfaTQpejicVORyZvMCxfFs1bQzAjj+5gZFKbL/M5wqi0CC0lPpBRCMMyiVp0us6ZTz+ZqxNzgeH7xz+asuQqWjpYjdx8W6nTY6IAAP8yaF6RvFOs7+iHPOpBeO4hPrRFmKzLhmGy/1PQFIF9LChK1bUa8mgEwlZOTg2XhYcvABLScYG4eOK8GOOVkDX6KWeKC+5sGZuUA474jZLO/hExtGihpxGGvADyvWrwtkDtuyns4YxPbwIEAgxdKxmlf/cxebetyNBeChJY4H5UNndhN8bm+CqPDT+q7HjusavT7oRedyXvr0SZqqSj6W11JbtrYw8JtwQKBgQDnt+ZiWd94wcNAxS7n9ZGpK0Dapa48hmNPCJafEFqWo615JhiuYoPVh1E7cjWHnUOTj1iphTUmI4jAYopAIdpvRwIvgu/7XzNdCZI85WgMAa3u0nBaLOINBi3wwYoe5rKBnTbkX+L84koe7Jt50QRASz/H40xVWt+VwLkXJLOPRwKBgQC7Yu+W0rPoChDhzf9p3i14vzqR5OiMDRHABGkdYtPYGl1LzUkOQbsmjWjVfX4neItlhQOOLHZpChOrKGkVuRRLIlq6T6VlU7c42mwj285nGrV14fFrBcg/jrRMc5qKLarGDEo83j+VW6XL7du7bRTBdStK8i93wLSbsjo7xi2a6QKBgHx2mTcG0zRHz5sAzzsk+oKFiyZmi/pSrREMqerym9YCQPGr9uHkZK/TKVzm8b3QSTX/bz5PIMdFmvTLeTsNdAkFeTUP/dtlvW8h7vzqtEKOvGBlhJfLN/iK8y44pvoGLKfWTF/K6V+wJOQLb0+1Z7UpNi8l9iB62VHU3RaDTjeNAoGAPknn7JHDvdlCvVy1j2KMaPvgI0kdSBi8EsEkk+EbHFW/N4hYxYVyCaGt/HGHsuUuKSPrB6KeBdKUsStwqwjnxwX3dMEu8JzAZgStN8pENR+6vCHMF1BHvWDZbCRtdYsynjzNnKggKKzbUwuRJB9ha+Ff77zLrJoBL1QyaVY6KKkCgYBrp6fjLQK7G4fP9H7Ruak+vhrLug2luymFiHzJI89FLeXV6JTxsutjFAWvw6iFDFmo+se6S54n1/yUV3o1zYDraS5ZevqN9TRefi2ddmKjDdLPeXT+bRF/bv0jh9YAL33u0v5PorOJDT7bnLLb1t6lWHJGPXYP77COs2RMvk7tYA==';

  /// AES key for `@don`
  static const String _aesKey = 'REqkIcl9HPekt0T7+rZhkrBvpysaPOeC2QL1PVuWlus=';

  static const String _apkamSymmetricKey =
      'KsmGhxHU+2f1DITP4QQqvziX5UuQ8G/YgIpwoMqUZpo=';
}
