part of 'at_demo_credentials.dart';

class SrieKeys {
  /// CRAM key for `@srie`
  static const String _cramKey =
      '5feafc244bfb18c36ecd04a2ebd12457cf5f7a5c54ec3225cbbb6ba9e31ddadb668251aa777166e3a66f1cdd31e2db68f33de8e2d696d3c95aeb0b8cb980cb06';

  /// PKAM private key for `@srie`
  static const String _pkamPrivateKey =
      'MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCPArFf5ZstAKchOOChsNlwKRqSHeoMa7/qbR9nlZf52VOeL2qLQqBk4SKTg91Vn0gWKlyigYIZ2wIJGO0vhXB5IcfNDVHnlZmGuGwwPculpLf90EdVn4YCKrQZkWjxS6u44iaY5mfoygwRUshBbxigJxR3RvMQsxnjow4kNBspxmSW1JEznOXkjyyI3u6soi8apFl2i9WecLlYwWuSbsPKRUeBXyDOTScsyAvHrks93B/AFlgPq8uUgK3u0xlTO5X0ZVVQkoOH4xbb21DFahim92VD+R8AabXMiMyUJ88JcoJPwTpT21ThDNJfhMa2WaNSQuj9Tb7aPPs2vXIz+nirAgMBAAECggEAIOVKrbdgCWsEBrVRnn/SlGUwEnpFExRZ8e+l8KrNaZBfFpzrkhsCUBIlZO9JI1/fMhIOeub1aUMiZbtRG8RDCeoGTpmIxI954C5d3H7qcDDCjeSx8/Uc2zS9dsAm9pIkbwO+Qx+EuVx4iCeVns+SR4yVvZYZZTb9dopUP2mo8eOzFwf06ODn7EJYMNDPVk7iw3z47ZfIDnnGjugcaxe5tebqyJ2xUhpJbeCwuv0Br8DtHawMH7+YQyD1KvdnPH0UKqFW19bLL/fhQYLNY4Sa+iUq5m0+OvIudytTIEuL6/wo6+z8j/95wr3UpMQg3EV/O0KGsb/ErO9Nq30Vi5JGCQKBgQDZGMobPzoKHLIJkZz9G0kgqX8UjClw0G+rmQWfcQ6lArovBaYhv4znpMdc2iE/lSe7BuaJ21ZLVzHnpC3DNQHMZrRZBx3rp0c/FbZ65hR322LxWBfVx+N4aVD8dD+BEqYze75tZu8bSSkKCbNgh+CwPczM+SXgZkvn5MrUGP0FfwKBgQCoozrpJQrCsiO9NVwgfIHpzlQ3eTBav0RNB0QweNzwgrBKgKOmvS1hgkt17PYIREf3lqSgX8cxkVRoUNn59bxiBUkIONp7vh4fg+n+z1rQ7P9eg6kZZZ71T5/n+TYph3bbeDnhiqYPeZE6SifGU1EaDqQHZUzu1A8OE4bm2Boa1QKBgBbsTyrhWjeHICVygqkXIHmabBi3VAjdeW0dE0LqpSk3SIF+jzQxDafH9mUPg0M7dJ6C9ATKbCo4YsSayVo7Vp1GmvRrk/U2DIfUuxfvA2pEeAYTzzB7ksE8HZkKjUoLthDpmAnlPIodB4BP1ejzb/4sCFv8UsuHAazSs7gBi3XxAoGAE15D+tkFRl09W5LQVO7X4OmQpJpnolSLXKlz/Hk1Lu5jnvrtUM4zcxqK3i1sCIEHHvmPSNgXQasmXaDDmEDP9RYUUDxvY3zvasE0084u6QX/QnSurDsOqbAOdo8Z2GU1knlZdHz/G5HjyyUPMmkJTIvX7P2Ge3uhiwVVHhg9z00CgYAOjxfNqdKY1T76CgJeT+kN8iLyogRE48q1i4syuo9W55UOg2N+TJpuCvXukJx8torPCbrgCWSpGnV37pi9MY9IwtMCseFpsMG8fv+Tkm47qrZdQ03MNetBmBi6YUXYOgFuf+FoWgmvFSKA0Dm18Jql857OeufxxMSHbYUnIZ+dDg==';

  /// PKAM public key for `@srie`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjwKxX+WbLQCnITjgobDZcCkakh3qDGu/6m0fZ5WX+dlTni9qi0KgZOEik4PdVZ9IFipcooGCGdsCCRjtL4VweSHHzQ1R55WZhrhsMD3LpaS3/dBHVZ+GAiq0GZFo8UuruOImmOZn6MoMEVLIQW8YoCcUd0bzELMZ46MOJDQbKcZkltSRM5zl5I8siN7urKIvGqRZdovVnnC5WMFrkm7DykVHgV8gzk0nLMgLx65LPdwfwBZYD6vLlICt7tMZUzuV9GVVUJKDh+MW29tQxWoYpvdlQ/kfAGm1zIjMlCfPCXKCT8E6U9tU4QzSX4TGtlmjUkLo/U2+2jz7Nr1yM/p4qwIDAQAB';

  /// Private encryption key for `@srie`
  static const String _encryptionPrivateKey =
      'MIIEwAIBADANBgkqhkiG9w0BAQEFAASCBKowggSmAgEAAoIBAQDjAbHt2i6B92I5AIOw6/8EN3Zu8Y6nzU1kbJa8gscMKhawnonRN1JlsI3Y3pts9h+RA3FI/qkcRSX/fLS58sxrF5P3Qp8wDsunDE1dUM6Ip83i1tNaQVs3FEaTKVZR41eCzlkVv5934AnSHcn69b5Fe/LeGPNeYQ7YsB/3JkZsJLAOhLcLDAlbgweZ8XJaoj4G2NajqPmDvVppXY7sZfEiAdJgLXOspVCwsDQHpw/siD/5D7OVC8JbqjMtx0feYFuEiV+yF7HvfhbjrCy44Lv2DZ6+YEy1qeqoyyejFujkfIFj4MxAc2+BeYi09HSUJMoCy6+Kgq4zVhgvO49WzlDzAgMBAAECggEBAOFQFWKXZAHroLojIJLCKmPtCMglSgqTY3WBsjt5MkeInuy+7tuRpV75VlEi4fHMeJhealqhKQi+OXDUPi0yKGNDC8InhgkVJl2vgDpWsihBJcE4qJ60r+yDW2lFZj/w/jL+zL0hbQ52eEjs+ET3FNuyouR+r0/F1g6NAa01eEBsavmLpd/T/qnn55+ql3Zc1LifYw12r6gd3YQOwUHjihGkkDIQCtpb2JN1oTSh8J858QqFRlR+K/C85IB7ER8NSEvJSq/Gioz0ga1ZXtloFjp0XzSS5WyHhV510FW55NE90ehK3IhE+wZp43Zu1hnKsx/UjQidYhkqJVsRijkBUEECgYEA97Z41cfLL7Y4QceTRh7H4F6Ez2UXKqCAQLUes/K1LxlyODs7DXy6NmhwmPxni+kLq/8lhJr6Ab4WNj+BPwCFJu5zH7pGOxeqzB7bpnwHriOf+6RtP6l2jvUtwu/9qhaOAmV7pbBFbylXFOgR9vxPHCfyvPIaQF7hXyQ8L7jup4UCgYEA6pniw3b5k0lEyOCfIO1YatwKf2bEssbZdiKEyvqNmxEZPq/7MgocVTE9inFW+34Ts8oYttNDRpYMzf9vLbHxFvSIs6tOYqXU70SI8Za1akAUDq4TUI10zpCXcpH/6/ztcdc1r0Geu/JbhrihlVR0b5GVnWDMAO5Rx+oh1AExdBcCgYEA7uUHvASnLChsMOQsYF+nG/eL1ggEQ5PunHkQVzMnEXlU8m4NEYDMhVRL4v7pTcE/BG1Y3X4oxi1wdnjgSMZTo6wrUtnuiWbVzW2lH/ZV4ddxntqAkfj44f4KWAnjdXmzExSUHsLU89PGq970FGJYWSsdqqNCNfpLF9p2QP/1CZECgYEA2k9dX7uFP/Q8mBm+uutjDf25nxjJDfxRPMeefyxtPdHJhjZJMSWLfBOYSw5xfRKzzujP2sH5puPXApMiqIkf6tafp2JQTSg4YHeMYBR4uWjrwUVoH9uiyN5wsGMAnl/9raQxBueviQJc/Z8ubkHrIC9/5LXA4VTksX5FAH4jwP0CgYEAgVOCHgKOgcxosaXkyVireNDZofrMn+mk32urLGpRbWOhAGwdKLQdI0kU1WNn6HyYbaHAkKcYYsUeaH0mpnSGx+sb2U2Ux82IX2MMOEG7TuLTl0O4tk9yEXczjX7gh3/y6xdguatM9QAkDeZHs+AqpsmvzRYq4/k+bxhdfHfdTp0=';

  /// Public encryption key for `@srie`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4wGx7dougfdiOQCDsOv/BDd2bvGOp81NZGyWvILHDCoWsJ6J0TdSZbCN2N6bbPYfkQNxSP6pHEUl/3y0ufLMaxeT90KfMA7LpwxNXVDOiKfN4tbTWkFbNxRGkylWUeNXgs5ZFb+fd+AJ0h3J+vW+RXvy3hjzXmEO2LAf9yZGbCSwDoS3CwwJW4MHmfFyWqI+BtjWo6j5g71aaV2O7GXxIgHSYC1zrKVQsLA0B6cP7Ig/+Q+zlQvCW6ozLcdH3mBbhIlfshex734W46wsuOC79g2evmBMtanqqMsnoxbo5HyBY+DMQHNvgXmItPR0lCTKAsuvioKuM1YYLzuPVs5Q8wIDAQAB';

  /// AES key for `@srie`
  static const String _aesKey = 'xI7ZreiofLCNPAqZ7lu04WcgElZD6qCbrJrSOGTe6lI=';

  static const String _apkamSymmetricKey =
      'NL+xI1oT153CqZ8yrySurssjwvSdQvw/NAVKcH96RyI=';
}

class SachinKeys {
  /// CRAM key for `@sachin`
  static const String _cramKey =
      'c883aecc627ebe54af505254a531afa19bcbaecdbe4e666fea73f34bf68c6ead2a28704cc6f7c67f6e6ff624095610af100219f51e9554ea47bb5b4ba2853c2e';

  /// PKAM private key for `@sachin`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCsK/3wn4o3p8Zrk/aovg+6ufS8pHpSKyUm71Sa+68EL0eHIsRtm8zPa15ac4qCLs4iogRtbK/44ZZZchd8O8pepD+yAG+3uP3vPQT1NTtX2ix6i3Bi1Xj6Ao+BSVvPt8pWLMZASFGtDLu8lRgrUdgGkxOBXCpawgQHcaQPNj9VV2x5qPyGUyjgiaOklMljEvBi1IB5p2klCIkwiZet73XN1fULtUj3uPtVI/DFgxA/vocXZQQNjBqgQgqmOrs69MwCEYwzngjazl/znY7ql2PpYWMP3xI228yEYkNdjNopyUy8f6KAr4eOahUrI/BKOzAAf6MsxgKBYchvNa/vh43rAgMBAAECggEBAJiucoXelW4BpN5l2smNstk+ayCXI7qWdF3ww7ClHXGyk9XtKRCip6ARcRz5dY05AKiJ0S9QwUUOmIw9t0H+q9n+AlZSOMBOlzJ/hFQHntarreIGoeWjtaLQfn6ClZ7BN/fvwOfkujmiHyJ/fW19KPu7lgKTvyO5BmWri3fJ/aQpbIn8F0rezhDAyERHC6qsw8dhaEXeORWPoopuO168R9cA2azBiZFvU4HRCAXwbWzsnAyAF40EvlOGaCpNk0whixNJs3n2CZMrse+jhE0qYf553nlN/5E9cxNp/iXIpAMMYZSBsT3CL9ADdywxj7of7hqb7F4l1qNv5BhO+mTT4yECgYEA2IC/fK9wuVu0khhh6yOF55BAWYJWD8l25g65klD/hIjX1tbGi0qRU8yvaqima2akGXkd8IyKWiwrMKrctfYdZPd1mlUFDBJhltydGZOvJVu40Na1B5Lrc4z7MddSd0qg/d5ImDM2p20EaLe2fzbT7Hkc6dO3tWnBj+76RWaA4KMCgYEAy5Td5nV8BOgB/AnhYQdnsDSdwZr0f/QqraIGZ2SIYeC1jwHm1BM4P2gWCnuCzAcJYtJQ0cdpkVaVHOoi/2KmTQpb6+7sjtU/CDSIwL9H9MuJxLcR4bJJCrTVA9XI3+ZabGlm7kFMu2/0w4ZftTGIr8eU34UTq+w1onix8nObyhkCgYEAoAQYg1lP4U/sWAZ5aMdqksnFJeL1JNnsbQD5GzGOiTBzBrDbMdw9KUihZh2cUskcBE/GVyIop5j5mxDN7BcphpR3cUfhYRi81DneSyciTmRKZuAqEJ0ANPlAN4hDxTN9ZeVClmtTu88RcSxHUCL/40lom1IF96lgjLc+dsjZ/C0CgYAMkknNpG2fI/CTbszDICDwCZ/AR+BXUm2cQUgh9FxTpvuvNA/cAr/TcosB5LSkAr86ogAppCXJus4EdhTpLl9UnJImlJ95BoQY7p2PQYChBjygsCljhY3rIlWRIg+AfAoTbcLUbaXeYUB9HnwkhUWKjUmNL/uR/0kkmk1qymbRaQKBgEBsBdxwhi7bHaKpLNFEF3ax3X5PvJxUN0hMJJW/aI+X4PtXtpcnyOoSxflNvaRv9V0e8lshjLV+t33L55+kO1Zie8Q6b9G0ybIJKdQgFuyhTeXW8oAE2AwqRSMSGJVMHCOSJdfRWYXprajKbNWNtop+QlONqZxJmy0Eus87tAZn';

  /// PKAM public key for `@sachin`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArCv98J+KN6fGa5P2qL4Purn0vKR6UislJu9UmvuvBC9HhyLEbZvMz2teWnOKgi7OIqIEbWyv+OGWWXIXfDvKXqQ/sgBvt7j97z0E9TU7V9oseotwYtV4+gKPgUlbz7fKVizGQEhRrQy7vJUYK1HYBpMTgVwqWsIEB3GkDzY/VVdseaj8hlMo4ImjpJTJYxLwYtSAeadpJQiJMImXre91zdX1C7VI97j7VSPwxYMQP76HF2UEDYwaoEIKpjq7OvTMAhGMM54I2s5f852O6pdj6WFjD98SNtvMhGJDXYzaKclMvH+igK+HjmoVKyPwSjswAH+jLMYCgWHIbzWv74eN6wIDAQAB';

  /// Private encryption key for `@sachin`
  static const String _encryptionPrivateKey =
      'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDIkExPO7xt//VN4p2G2od3JjWwDKAwTZxzLOhOUVdX9qMU324x2YfSCv1tXnDRjwD7IgnP9/o0x3EdSEOQPtqWXt9+HsqQZiQGP/9SyswiApHFom+xErElQJrPI3BBzPgkLPWkaKZBb6mnnOdsXhjGwvYKW9lFP82hcrtxWbCsLLnL2Y+u5rg8jw9KAX95qJ3UfLSXD2xcCUIiWb+SsSjP17j88laaa2Vm1d+9oVLP8eR0OHn6QpVOpMbOdH9xIxMYUIqQBmAQWjOuWQtv1uwCcdPAChdQFCm+y66TYiDoDFKvcePK8xgi9T9UHxpsRWzriZzQaueTKSOqQHi9sTihAgMBAAECggEACDLV27tOZZS7+1YTKGsQdI9sTGkHt1HE3nRsfp8WmfLsEbNcds80nSJz35+nrvlQifOHQSga40Nv3UmR8XiQSOtR6X7quuJiAJtnHYRKue0u9kxAkpV4BlTQvzzsntP5JMlttS3N9gjRf5eLYkOqcZ2QnzXH+Ou1xS7CeMy4yyDqV4rIyPEqZ8C+JIKqMX7XrlNubpKbiiDgqqZS4uHcs14h4yTBXk3VkJm0uh4W4sjX7g8mS/oX9sFuVz/jAfhUrUjHEaUR8lJeS1+fdUctvGXvWXrgRCYviRrhpxNaXXkZqkyEoFY+C2BY/FqUxRzGSeL9VoJQg44q3atBbvkdXQKBgQD0P3t8rVNk7aj4Ezm+/t+ltPQm46xAUW9f146E9U05AOhjtdbg13z/oOnaC7b3vS3yOr450bHqmc0aYdMF8tlsnk/Ku7xMg0/+Mp4NxnYzTejbpwlbwThLLi46f2hfjW4Zx/VbxuWdC2sJS9vhe/HFHUQlwggTVLjfeBOoUIjtlwKBgQDSNrxDYnnfsNTmdId4OPEuq7TR7cUDQ2sUgVvBz0u0ceCXwoHA9b+upHNljnsgOLpSdfVLnQNXldgL6tdYQLdKA1849NyCpcJizXDCI3CtqTHwmr/HBckTGBOWGc3aHsEWdxe5h1ypeVqWq4RhlIn9XNE+uZBQAQZxgZJ6Zv1ChwKBgQDmiWzjFy4Zm4Da9jqRHjy2SYARnN+erb6z9d+de3NyFHtEcgPpoTtohNd1aY0/dJ6DfhLCvDx0NMs01ZS6jqfOL/ccYeqvRVohkmFAm0xBzI23lYftxQh/XY1gxZUca3+6cdQS1j8v5fEXizR1NenTpXYHNYctx8/fjZTwT2OO7QKBgQDCyeV5q26zUPB2+9PsGxeh34oWXPUKKRa4UYXs+WF1O3CaL6p8WzvbYJdtq7F8EhTVBGjgQAYwyrD/mgUhyhYNh0JdTMhoZ6DQXP33Z0+qG/YitcKvcTT5dH3xwMd3LrhNUN2zFTNP9xtyMkzg/vs+wxtBvEF1YP3Pf/lzYqubUQKBgQDTvcMRQaEZ6/l0LPwfOaRbLYvEr/hY0Ve1fD9NjfnGmUEbB4zqdabA7H25sVwOlwtvTtRVdf6r2zh0DyV9T6hXwpAkAp8ijC4MJhk1gw4ccZqJOVGyncopSIK0Q6z1DPGxM6ai6Q0B9TeeV/5Bd0ESFWXvUiamZ89IWFTlef8Olg==';

  /// Public encryption key for `@sachin`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyJBMTzu8bf/1TeKdhtqHdyY1sAygME2ccyzoTlFXV/ajFN9uMdmH0gr9bV5w0Y8A+yIJz/f6NMdxHUhDkD7all7ffh7KkGYkBj//UsrMIgKRxaJvsRKxJUCazyNwQcz4JCz1pGimQW+pp5znbF4YxsL2ClvZRT/NoXK7cVmwrCy5y9mPrua4PI8PSgF/eaid1Hy0lw9sXAlCIlm/krEoz9e4/PJWmmtlZtXfvaFSz/HkdDh5+kKVTqTGznR/cSMTGFCKkAZgEFozrlkLb9bsAnHTwAoXUBQpvsuuk2Ig6AxSr3HjyvMYIvU/VB8abEVs64mc0GrnkykjqkB4vbE4oQIDAQAB';

  /// AES key for `@sachin`
  static const String _aesKey = 'ZLKGHsqDBGWKltDddH7654tkeqSkqyn3cGltefSJwiY=';

  static const String _apkamSymmetricKey =
      'J5EzKenByJVhM91omz7Lz/wdaq68HjK9SpEccQIcYYk=';
}

class Cloudvm2Keys {
  // same as srie
  /// CRAM key for `@cloudvm2`
  static const String _cramKey =
      '5feafc244bfb18c36ecd04a2ebd12457cf5f7a5c54ec3225cbbb6ba9e31ddadb668251aa777166e3a66f1cdd31e2db68f33de8e2d696d3c95aeb0b8cb980cb06';

  /// PKAM private key for `@cloudvm2`
  static const String _pkamPrivateKey =
      'MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCPArFf5ZstAKchOOChsNlwKRqSHeoMa7/qbR9nlZf52VOeL2qLQqBk4SKTg91Vn0gWKlyigYIZ2wIJGO0vhXB5IcfNDVHnlZmGuGwwPculpLf90EdVn4YCKrQZkWjxS6u44iaY5mfoygwRUshBbxigJxR3RvMQsxnjow4kNBspxmSW1JEznOXkjyyI3u6soi8apFl2i9WecLlYwWuSbsPKRUeBXyDOTScsyAvHrks93B/AFlgPq8uUgK3u0xlTO5X0ZVVQkoOH4xbb21DFahim92VD+R8AabXMiMyUJ88JcoJPwTpT21ThDNJfhMa2WaNSQuj9Tb7aPPs2vXIz+nirAgMBAAECggEAIOVKrbdgCWsEBrVRnn/SlGUwEnpFExRZ8e+l8KrNaZBfFpzrkhsCUBIlZO9JI1/fMhIOeub1aUMiZbtRG8RDCeoGTpmIxI954C5d3H7qcDDCjeSx8/Uc2zS9dsAm9pIkbwO+Qx+EuVx4iCeVns+SR4yVvZYZZTb9dopUP2mo8eOzFwf06ODn7EJYMNDPVk7iw3z47ZfIDnnGjugcaxe5tebqyJ2xUhpJbeCwuv0Br8DtHawMH7+YQyD1KvdnPH0UKqFW19bLL/fhQYLNY4Sa+iUq5m0+OvIudytTIEuL6/wo6+z8j/95wr3UpMQg3EV/O0KGsb/ErO9Nq30Vi5JGCQKBgQDZGMobPzoKHLIJkZz9G0kgqX8UjClw0G+rmQWfcQ6lArovBaYhv4znpMdc2iE/lSe7BuaJ21ZLVzHnpC3DNQHMZrRZBx3rp0c/FbZ65hR322LxWBfVx+N4aVD8dD+BEqYze75tZu8bSSkKCbNgh+CwPczM+SXgZkvn5MrUGP0FfwKBgQCoozrpJQrCsiO9NVwgfIHpzlQ3eTBav0RNB0QweNzwgrBKgKOmvS1hgkt17PYIREf3lqSgX8cxkVRoUNn59bxiBUkIONp7vh4fg+n+z1rQ7P9eg6kZZZ71T5/n+TYph3bbeDnhiqYPeZE6SifGU1EaDqQHZUzu1A8OE4bm2Boa1QKBgBbsTyrhWjeHICVygqkXIHmabBi3VAjdeW0dE0LqpSk3SIF+jzQxDafH9mUPg0M7dJ6C9ATKbCo4YsSayVo7Vp1GmvRrk/U2DIfUuxfvA2pEeAYTzzB7ksE8HZkKjUoLthDpmAnlPIodB4BP1ejzb/4sCFv8UsuHAazSs7gBi3XxAoGAE15D+tkFRl09W5LQVO7X4OmQpJpnolSLXKlz/Hk1Lu5jnvrtUM4zcxqK3i1sCIEHHvmPSNgXQasmXaDDmEDP9RYUUDxvY3zvasE0084u6QX/QnSurDsOqbAOdo8Z2GU1knlZdHz/G5HjyyUPMmkJTIvX7P2Ge3uhiwVVHhg9z00CgYAOjxfNqdKY1T76CgJeT+kN8iLyogRE48q1i4syuo9W55UOg2N+TJpuCvXukJx8torPCbrgCWSpGnV37pi9MY9IwtMCseFpsMG8fv+Tkm47qrZdQ03MNetBmBi6YUXYOgFuf+FoWgmvFSKA0Dm18Jql857OeufxxMSHbYUnIZ+dDg==';

  /// PKAM public key for `@cloudvm2`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjwKxX+WbLQCnITjgobDZcCkakh3qDGu/6m0fZ5WX+dlTni9qi0KgZOEik4PdVZ9IFipcooGCGdsCCRjtL4VweSHHzQ1R55WZhrhsMD3LpaS3/dBHVZ+GAiq0GZFo8UuruOImmOZn6MoMEVLIQW8YoCcUd0bzELMZ46MOJDQbKcZkltSRM5zl5I8siN7urKIvGqRZdovVnnC5WMFrkm7DykVHgV8gzk0nLMgLx65LPdwfwBZYD6vLlICt7tMZUzuV9GVVUJKDh+MW29tQxWoYpvdlQ/kfAGm1zIjMlCfPCXKCT8E6U9tU4QzSX4TGtlmjUkLo/U2+2jz7Nr1yM/p4qwIDAQAB';

  /// Private encryption key for `@cloudvm2`
  static const String _encryptionPrivateKey =
      'MIIEwAIBADANBgkqhkiG9w0BAQEFAASCBKowggSmAgEAAoIBAQDjAbHt2i6B92I5AIOw6/8EN3Zu8Y6nzU1kbJa8gscMKhawnonRN1JlsI3Y3pts9h+RA3FI/qkcRSX/fLS58sxrF5P3Qp8wDsunDE1dUM6Ip83i1tNaQVs3FEaTKVZR41eCzlkVv5934AnSHcn69b5Fe/LeGPNeYQ7YsB/3JkZsJLAOhLcLDAlbgweZ8XJaoj4G2NajqPmDvVppXY7sZfEiAdJgLXOspVCwsDQHpw/siD/5D7OVC8JbqjMtx0feYFuEiV+yF7HvfhbjrCy44Lv2DZ6+YEy1qeqoyyejFujkfIFj4MxAc2+BeYi09HSUJMoCy6+Kgq4zVhgvO49WzlDzAgMBAAECggEBAOFQFWKXZAHroLojIJLCKmPtCMglSgqTY3WBsjt5MkeInuy+7tuRpV75VlEi4fHMeJhealqhKQi+OXDUPi0yKGNDC8InhgkVJl2vgDpWsihBJcE4qJ60r+yDW2lFZj/w/jL+zL0hbQ52eEjs+ET3FNuyouR+r0/F1g6NAa01eEBsavmLpd/T/qnn55+ql3Zc1LifYw12r6gd3YQOwUHjihGkkDIQCtpb2JN1oTSh8J858QqFRlR+K/C85IB7ER8NSEvJSq/Gioz0ga1ZXtloFjp0XzSS5WyHhV510FW55NE90ehK3IhE+wZp43Zu1hnKsx/UjQidYhkqJVsRijkBUEECgYEA97Z41cfLL7Y4QceTRh7H4F6Ez2UXKqCAQLUes/K1LxlyODs7DXy6NmhwmPxni+kLq/8lhJr6Ab4WNj+BPwCFJu5zH7pGOxeqzB7bpnwHriOf+6RtP6l2jvUtwu/9qhaOAmV7pbBFbylXFOgR9vxPHCfyvPIaQF7hXyQ8L7jup4UCgYEA6pniw3b5k0lEyOCfIO1YatwKf2bEssbZdiKEyvqNmxEZPq/7MgocVTE9inFW+34Ts8oYttNDRpYMzf9vLbHxFvSIs6tOYqXU70SI8Za1akAUDq4TUI10zpCXcpH/6/ztcdc1r0Geu/JbhrihlVR0b5GVnWDMAO5Rx+oh1AExdBcCgYEA7uUHvASnLChsMOQsYF+nG/eL1ggEQ5PunHkQVzMnEXlU8m4NEYDMhVRL4v7pTcE/BG1Y3X4oxi1wdnjgSMZTo6wrUtnuiWbVzW2lH/ZV4ddxntqAkfj44f4KWAnjdXmzExSUHsLU89PGq970FGJYWSsdqqNCNfpLF9p2QP/1CZECgYEA2k9dX7uFP/Q8mBm+uutjDf25nxjJDfxRPMeefyxtPdHJhjZJMSWLfBOYSw5xfRKzzujP2sH5puPXApMiqIkf6tafp2JQTSg4YHeMYBR4uWjrwUVoH9uiyN5wsGMAnl/9raQxBueviQJc/Z8ubkHrIC9/5LXA4VTksX5FAH4jwP0CgYEAgVOCHgKOgcxosaXkyVireNDZofrMn+mk32urLGpRbWOhAGwdKLQdI0kU1WNn6HyYbaHAkKcYYsUeaH0mpnSGx+sb2U2Ux82IX2MMOEG7TuLTl0O4tk9yEXczjX7gh3/y6xdguatM9QAkDeZHs+AqpsmvzRYq4/k+bxhdfHfdTp0=';

  /// Public encryption key for `@cloudvm2`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4wGx7dougfdiOQCDsOv/BDd2bvGOp81NZGyWvILHDCoWsJ6J0TdSZbCN2N6bbPYfkQNxSP6pHEUl/3y0ufLMaxeT90KfMA7LpwxNXVDOiKfN4tbTWkFbNxRGkylWUeNXgs5ZFb+fd+AJ0h3J+vW+RXvy3hjzXmEO2LAf9yZGbCSwDoS3CwwJW4MHmfFyWqI+BtjWo6j5g71aaV2O7GXxIgHSYC1zrKVQsLA0B6cP7Ig/+Q+zlQvCW6ozLcdH3mBbhIlfshex734W46wsuOC79g2evmBMtanqqMsnoxbo5HyBY+DMQHNvgXmItPR0lCTKAsuvioKuM1YYLzuPVs5Q8wIDAQAB';

  /// AES key for `@cloudvm2`
  static const String _aesKey = 'xI7ZreiofLCNPAqZ7lu04WcgElZD6qCbrJrSOGTe6lI=';

  static const String _apkamSymmetricKey =
      'NL+xI1oT153CqZ8yrySurssjwvSdQvw/NAVKcH96RyI=';
}

class Device2Keys {
  // same as sachin
  /// CRAM key for `@device2`
  static const String _cramKey =
      'c883aecc627ebe54af505254a531afa19bcbaecdbe4e666fea73f34bf68c6ead2a28704cc6f7c67f6e6ff624095610af100219f51e9554ea47bb5b4ba2853c2e';

  /// PKAM private key for `@device2`
  static const String _pkamPrivateKey =
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCsK/3wn4o3p8Zrk/aovg+6ufS8pHpSKyUm71Sa+68EL0eHIsRtm8zPa15ac4qCLs4iogRtbK/44ZZZchd8O8pepD+yAG+3uP3vPQT1NTtX2ix6i3Bi1Xj6Ao+BSVvPt8pWLMZASFGtDLu8lRgrUdgGkxOBXCpawgQHcaQPNj9VV2x5qPyGUyjgiaOklMljEvBi1IB5p2klCIkwiZet73XN1fULtUj3uPtVI/DFgxA/vocXZQQNjBqgQgqmOrs69MwCEYwzngjazl/znY7ql2PpYWMP3xI228yEYkNdjNopyUy8f6KAr4eOahUrI/BKOzAAf6MsxgKBYchvNa/vh43rAgMBAAECggEBAJiucoXelW4BpN5l2smNstk+ayCXI7qWdF3ww7ClHXGyk9XtKRCip6ARcRz5dY05AKiJ0S9QwUUOmIw9t0H+q9n+AlZSOMBOlzJ/hFQHntarreIGoeWjtaLQfn6ClZ7BN/fvwOfkujmiHyJ/fW19KPu7lgKTvyO5BmWri3fJ/aQpbIn8F0rezhDAyERHC6qsw8dhaEXeORWPoopuO168R9cA2azBiZFvU4HRCAXwbWzsnAyAF40EvlOGaCpNk0whixNJs3n2CZMrse+jhE0qYf553nlN/5E9cxNp/iXIpAMMYZSBsT3CL9ADdywxj7of7hqb7F4l1qNv5BhO+mTT4yECgYEA2IC/fK9wuVu0khhh6yOF55BAWYJWD8l25g65klD/hIjX1tbGi0qRU8yvaqima2akGXkd8IyKWiwrMKrctfYdZPd1mlUFDBJhltydGZOvJVu40Na1B5Lrc4z7MddSd0qg/d5ImDM2p20EaLe2fzbT7Hkc6dO3tWnBj+76RWaA4KMCgYEAy5Td5nV8BOgB/AnhYQdnsDSdwZr0f/QqraIGZ2SIYeC1jwHm1BM4P2gWCnuCzAcJYtJQ0cdpkVaVHOoi/2KmTQpb6+7sjtU/CDSIwL9H9MuJxLcR4bJJCrTVA9XI3+ZabGlm7kFMu2/0w4ZftTGIr8eU34UTq+w1onix8nObyhkCgYEAoAQYg1lP4U/sWAZ5aMdqksnFJeL1JNnsbQD5GzGOiTBzBrDbMdw9KUihZh2cUskcBE/GVyIop5j5mxDN7BcphpR3cUfhYRi81DneSyciTmRKZuAqEJ0ANPlAN4hDxTN9ZeVClmtTu88RcSxHUCL/40lom1IF96lgjLc+dsjZ/C0CgYAMkknNpG2fI/CTbszDICDwCZ/AR+BXUm2cQUgh9FxTpvuvNA/cAr/TcosB5LSkAr86ogAppCXJus4EdhTpLl9UnJImlJ95BoQY7p2PQYChBjygsCljhY3rIlWRIg+AfAoTbcLUbaXeYUB9HnwkhUWKjUmNL/uR/0kkmk1qymbRaQKBgEBsBdxwhi7bHaKpLNFEF3ax3X5PvJxUN0hMJJW/aI+X4PtXtpcnyOoSxflNvaRv9V0e8lshjLV+t33L55+kO1Zie8Q6b9G0ybIJKdQgFuyhTeXW8oAE2AwqRSMSGJVMHCOSJdfRWYXprajKbNWNtop+QlONqZxJmy0Eus87tAZn';

  /// PKAM public key for `@device2`
  static const String _pkamPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArCv98J+KN6fGa5P2qL4Purn0vKR6UislJu9UmvuvBC9HhyLEbZvMz2teWnOKgi7OIqIEbWyv+OGWWXIXfDvKXqQ/sgBvt7j97z0E9TU7V9oseotwYtV4+gKPgUlbz7fKVizGQEhRrQy7vJUYK1HYBpMTgVwqWsIEB3GkDzY/VVdseaj8hlMo4ImjpJTJYxLwYtSAeadpJQiJMImXre91zdX1C7VI97j7VSPwxYMQP76HF2UEDYwaoEIKpjq7OvTMAhGMM54I2s5f852O6pdj6WFjD98SNtvMhGJDXYzaKclMvH+igK+HjmoVKyPwSjswAH+jLMYCgWHIbzWv74eN6wIDAQAB';

  /// Private encryption key for `@device2`
  static const String _encryptionPrivateKey =
      'MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDIkExPO7xt//VN4p2G2od3JjWwDKAwTZxzLOhOUVdX9qMU324x2YfSCv1tXnDRjwD7IgnP9/o0x3EdSEOQPtqWXt9+HsqQZiQGP/9SyswiApHFom+xErElQJrPI3BBzPgkLPWkaKZBb6mnnOdsXhjGwvYKW9lFP82hcrtxWbCsLLnL2Y+u5rg8jw9KAX95qJ3UfLSXD2xcCUIiWb+SsSjP17j88laaa2Vm1d+9oVLP8eR0OHn6QpVOpMbOdH9xIxMYUIqQBmAQWjOuWQtv1uwCcdPAChdQFCm+y66TYiDoDFKvcePK8xgi9T9UHxpsRWzriZzQaueTKSOqQHi9sTihAgMBAAECggEACDLV27tOZZS7+1YTKGsQdI9sTGkHt1HE3nRsfp8WmfLsEbNcds80nSJz35+nrvlQifOHQSga40Nv3UmR8XiQSOtR6X7quuJiAJtnHYRKue0u9kxAkpV4BlTQvzzsntP5JMlttS3N9gjRf5eLYkOqcZ2QnzXH+Ou1xS7CeMy4yyDqV4rIyPEqZ8C+JIKqMX7XrlNubpKbiiDgqqZS4uHcs14h4yTBXk3VkJm0uh4W4sjX7g8mS/oX9sFuVz/jAfhUrUjHEaUR8lJeS1+fdUctvGXvWXrgRCYviRrhpxNaXXkZqkyEoFY+C2BY/FqUxRzGSeL9VoJQg44q3atBbvkdXQKBgQD0P3t8rVNk7aj4Ezm+/t+ltPQm46xAUW9f146E9U05AOhjtdbg13z/oOnaC7b3vS3yOr450bHqmc0aYdMF8tlsnk/Ku7xMg0/+Mp4NxnYzTejbpwlbwThLLi46f2hfjW4Zx/VbxuWdC2sJS9vhe/HFHUQlwggTVLjfeBOoUIjtlwKBgQDSNrxDYnnfsNTmdId4OPEuq7TR7cUDQ2sUgVvBz0u0ceCXwoHA9b+upHNljnsgOLpSdfVLnQNXldgL6tdYQLdKA1849NyCpcJizXDCI3CtqTHwmr/HBckTGBOWGc3aHsEWdxe5h1ypeVqWq4RhlIn9XNE+uZBQAQZxgZJ6Zv1ChwKBgQDmiWzjFy4Zm4Da9jqRHjy2SYARnN+erb6z9d+de3NyFHtEcgPpoTtohNd1aY0/dJ6DfhLCvDx0NMs01ZS6jqfOL/ccYeqvRVohkmFAm0xBzI23lYftxQh/XY1gxZUca3+6cdQS1j8v5fEXizR1NenTpXYHNYctx8/fjZTwT2OO7QKBgQDCyeV5q26zUPB2+9PsGxeh34oWXPUKKRa4UYXs+WF1O3CaL6p8WzvbYJdtq7F8EhTVBGjgQAYwyrD/mgUhyhYNh0JdTMhoZ6DQXP33Z0+qG/YitcKvcTT5dH3xwMd3LrhNUN2zFTNP9xtyMkzg/vs+wxtBvEF1YP3Pf/lzYqubUQKBgQDTvcMRQaEZ6/l0LPwfOaRbLYvEr/hY0Ve1fD9NjfnGmUEbB4zqdabA7H25sVwOlwtvTtRVdf6r2zh0DyV9T6hXwpAkAp8ijC4MJhk1gw4ccZqJOVGyncopSIK0Q6z1DPGxM6ai6Q0B9TeeV/5Bd0ESFWXvUiamZ89IWFTlef8Olg==';

  /// Public encryption key for `@device2`
  static const String _encryptionPublicKey =
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyJBMTzu8bf/1TeKdhtqHdyY1sAygME2ccyzoTlFXV/ajFN9uMdmH0gr9bV5w0Y8A+yIJz/f6NMdxHUhDkD7all7ffh7KkGYkBj//UsrMIgKRxaJvsRKxJUCazyNwQcz4JCz1pGimQW+pp5znbF4YxsL2ClvZRT/NoXK7cVmwrCy5y9mPrua4PI8PSgF/eaid1Hy0lw9sXAlCIlm/krEoz9e4/PJWmmtlZtXfvaFSz/HkdDh5+kKVTqTGznR/cSMTGFCKkAZgEFozrlkLb9bsAnHTwAoXUBQpvsuuk2Ig6AxSr3HjyvMYIvU/VB8abEVs64mc0GrnkykjqkB4vbE4oQIDAQAB';

  /// AES key for `@device2`
  static const String _aesKey = 'ZLKGHsqDBGWKltDddH7654tkeqSkqyn3cGltefSJwiY=';

  static const String _apkamSymmetricKey =
      'J5EzKenByJVhM91omz7Lz/wdaq68HjK9SpEccQIcYYk=';
}
