<?php

namespace atoum\atoum\tests\units\test\engines;

require_once __DIR__ . '/../../../runner.php';

use atoum\atoum;
use atoum\atoum\test\engines;

class inline extends atoum\test
{
    public function testClass()
    {
        $this->testedClass->extends(atoum\test\engine::class);
    }

    public function testIsAsynchronous()
    {
        $this
            ->if($engine = new engines\inline())
            ->then
                ->boolean($engine->isAsynchronous())->isFalse()
        ;
    }

    public function testRun()
    {
        $this
            ->if($engine = new engines\inline())
            ->then
                ->object($engine->run($test = new \mock\atoum\atoum\test()))->isIdenticalTo($engine)
            ->if($test->getMockController()->getCurrentMethod = $method = uniqid())
            ->and($test->getMockController()->runTestMethod = $test)
            ->then
                ->object($engine->run($test))->isIdenticalTo($engine)
                ->mock($test)
                    ->call('getScore')
                        ->before($this->mock($test)->call('runTestMethod'))
                            ->once()
                    ->call('setScore')
                        ->withIdenticalArguments($engine->getScore())
                            ->before($this->mock($test)->call('runTestMethod'))
                                ->once()
                    ->call('runTestMethod')
                        ->withArguments($method)->once()
                    ->call('setScore')
                        ->withIdenticalArguments($test->getScore())
                            ->after($this->mock($test)->call('runTestMethod'))
                                ->once()
        ;
    }

    public function testGetScore()
    {
        $this
            ->if($engine = new engines\inline())
            ->then
                ->object($engine->getScore())->isInstanceof(atoum\score::class)
            ->if($test = new \mock\atoum\atoum\test())
            ->and($test->getMockController()->getCurrentMethod = $method = uniqid())
            ->and($test->getMockController()->runTestMethod = $test)
            ->and($engine->run($test))
            ->then
                ->object($engine->getScore())->isInstanceOf(atoum\test\score::class)
        ;
    }
}
