%
% This file is part of AtomVM.
%
% Copyright 2024 Paul Guyot <pguyot@kallisys.net>
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%    http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
%
% SPDX-License-Identifier: Apache-2.0 OR LGPL-2.1-or-later
%

-module(literal_test2).
-export([start/0, f/1, g/1]).

start() ->
    Result = f(<<"duh">>),
    <<"1234567890abcdef01234567890abcdef01234567890abcdef01234567890abcdef0duh">> = Result,
    0.

% This is large enough to have to decode literal index with last encoding.
g(X) ->
    <<
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0"
        "1234567890ABCDEF01234567890ABCDEF01234567890ABCDEF01234567890ABCDEF0",
        X/binary
    >>.

f(X) ->
    <<"1234567890abcdef01234567890abcdef01234567890abcdef01234567890abcdef0", X/binary>>.
