---
title: What is Assemble?
description: >
  Get a high level overview of Assemble, and answers to questions like, "What is Assemble?", "What does Assemble do?", "Is Assemble a good fit for me?".
category: subjects
---

Assemble makes it easy to create, customize, generate and maintain a complete static web project. This includes:

- Transforming content from markdown or any other plain text format to HTML
- Keeping pages, layouts and design consistent and in sync
- Ability to use any data source for rendering templates, which makes it easy to begin a project using mock data and switch to a "live" data source later on.

**For those who prefer a more technical description:**

- Assemble is a node.js/JavaScript build system that that automatically builds projects and libraries from source code.
- Besides building projects, Assemble can be used to update any project that contains files that must be updated automatically whenever other files change (using `.watch`)
- Development with Assemble takes place on a local machine, and the generated site can be deployed to any web server.
- Assemble can be used by command line or API.

### CLI

When run via command line, Assemble looks for a user-defined file named `assemblefile.js`, which provides Assemble with the necessary information for generating the expected result.

### API

Assemble also offers an approachable API, with a powerful set of features for building web projects of any size.

## FAQ

**What are the prerequisites?**

To get started, only a basic understanding of JavaScript is necessary.

**What kinds of projects can Assemble by used for?**

Assemble loves designers and developers, and is often used for:

- Rapid prototyping
- Styleguides
- Static web sites
- Product showcases
- Marketing sites
- A/B, multivariate testing
- Company or personal blog
- Books

**What are the advantages of using Assemble?**

- Assemble makes it easy to mock out web designs or application prototypes
- Easy to get started. It only takes a couple of minutes to generate your first web project.
- Built to scale. Starts out easy, keeps code debt to a minimum as the project grows.
- Configuration conventions that make it easy for a team to stay on the same page
- Highly customizable. Hack to your heart's content!

**Who uses Assemble?**

Assemble is used on thousands of projects of every size, with users in every country.

- Large projects: [zurb foundation][zurb] | [less.js](http://lesscss.org/) | [Web Experience Toolkit][WET]
- Large sites: Target, Airbus
- Small sites:
- Marketing sites:
- Design sites:

**Who should use Assemble?**

If you're a designer, web designer, web developer, node.js developer, blogger, book author or marketer with a cursory knowledge of programming, then you!

**Get in touch!**

Have [questions][issue]? [Suggestions][issue]? Join the conversation on [gitter](gitter.im/assemble/assemble) or give us a shout on [twitter](https://twitter.com/assemblejs). The assemble team and community are always happy to help!

[issue]: https://github.com/assemble/assemble/issues/new?title=%5Byour%20topic%5D&body=assemble%20version%3A%20%5Breplace%20this%20with%20the%20version%20of%20assemble%20used%20on%20your%20project%5D%0Aoperating%20system%3A%20%5Breplace%20this%20with%20your%20os%5D%0A%0Adescription%3A%20%5Bplease%20provide%20as%20much%20detail%20as%20possible%20so%20we%20can%20do%20our%20best%20to%20help%20you%5D
[WET]: https://wet-boew.github.io/v4.0-ci/index-en.html
[zurb]: http://foundation.zurb.com/docs/
[senheiser]: http://sennheiser-d1.com/
