<p align="center">
  <a href="https://github.com/assemble/assemble">
    <img height="250" width="250" src="https://raw.githubusercontent.com/assemble/assemble/master/docs/logo.png">
  </a>
</p>

# {%= name %}

{%= badge("fury") %} {%= badge('downloads') %} {%= ifExists(["test", "test.js"], badge('travis')) %} {%= badge('gitter') %} 

Looking for the grunt plugin? Please visit [grunt-assemble][]. 

_(Note that the current website assemble.io, is for [grunt-assemble][]. Thanks for your patience while we work on updating the site with documentation for the latest assemble)_.

## Overview

_(Click the following sections to expand them)_

<details>
<summary>Table of contents</summary>

<!-- toc -->
</details>


<details>
<summary>What is Assemble?</summary>

Assemble is a command line tool and developer framework for rapid prototyping, static site generation, and [much more](#what-can-i-do-with-assemble). 
</details>


<details>
<summary>Who uses assemble?</summary>

Assemble is used by thousands of developers and teams in more than 170 countries! Here are a few examples of sites built with assemble:

- [Airbus Group](http://www.airbusgroup.com/int/en.html)
- [Diebold](http://www.diebold.com/)
- [Transformicons](http://www.transformicons.com/)
- [Barrel](https://www.barrelny.com/)
- [yesware](https://www.yesware.com/)
- [Amaze](https://www.amaze.com/)
- [sennheiser](http://sennheiser-d1.com/)
- [perf.rocks](http://perf.rocks/)
- [Milano JS](http://milanojs.com/)
- [AKQA](http://www.akqa.com/)
- [huxtaburger](http://www.huxtaburger.com.au/)
- [Typeplate](http://typeplate.com/)
- [Angular Basics](http://www.angularjsbook.com/)

Is your website, blog or project built with assemble? Please [let us know about it](../../issues/300)!
</details>


<details>
<summary>Why should I use assemble?</summary>

* Expressive, functional API (the API is also stable)
* You can use assemble with any web framework or CSS/HTML toolkit
* Assemble can build static sites or hybrid static/dynamic sites 
* Streams support, you can run any [gulp][] plugin
* [Powerful features](#features) for rapid web development, including a robust API for rendering templates with any node.js template engine.
* Assemble can use any [base][] plugin
* Assemble can do anything Jekyll does, but with more flexibility and control
* Like gulp, assemble can also run **any** other static site generator as a plugin, which means you can do anything and everything all other node.js static site generators can do, and much more.
</details>

<details>
<summary>What can I do with Assemble?</summary>

* Rapid prototyping
* Static site generation (more powerful alternative to jekyll)
* Landing pages
* A/B testing
* [blogs](examples/blog)
* Styleguides
* Themes 
* UI components
* [Project scaffolder](examples/generator) ([generate][] is also built on assemble)
* [build tool](examples/build-tool)
* Documentation ([verb][] is built on assemble)
* Generate [boilerplates](examples/boilerplates), [scaffolds](examples/scaffold), and [targets](examples/targets)
* E-books ([Angular Basics](http://www.angularjsbook.com/) was built with assemble)
* Much more!

</details>


<details>
<summary>Rapid development toolkit</summary>

Assemble can be used standalone, but it's even more powerful when used alongside the following libraries: 

- [generate][]: scaffold out new projects from the command line
- [assemble][]: <= you are here
- [verb][]: generate documention for your projects
- [update][]: keep your projects up-to-date

</details>


<details>
<summary>Features</summary>

Here are just a few of the features assemble offers:

* Intuitive CLI
* Full support for [gulp][] and [base][] plugins
* Assemble templates are [vinyl][] files
* Render templates with any [template engine](#engine), including [nunjucks][assemble-nunjucks], [handlebars][engine-handlebars], [lodash][engine-lodash] and any consolidate engine!
* Use multiple engines, assemble can detect the one to use based on file extension
* [helpers](#helpers): support for sync and async
* [Templates collections](#collections) 
* Pages
* Partials/includes
* [Layouts][]
* Pagination
* [permalinks][assemble-permalinks]
* [middleware](#middleware) can be used to tranform files at any stage in the render cycle
* Generate pages from JSON
* Much more!

</details>


## Quickstart

### Installing assemble 

Add assemble your project's `devDependencies` using [npm](https://npmjs.org):

```sh
$ npm install -D assemble
```

You should now be able to run assemble directly (using `node assemblefile.js` etc) or using `npm` scripts. For example, add the following to package.json:

```json
{
  "scripts": {
    "build": "assemble"
  }
}
```

Then run

```sh
$ npm run build
```


### Installing assemble's CLI

You can also assemble's CLI globally, which adds the `assemble` command to your system path, allowing it to be run from any directory.

```sh
$ npm install --global assemble
```

_Note that even if assemble is installed globally, it's good practice to install it locally in every project to ensure that your projects are protected against any potentially breaking changes that might occur in assemble between development cycles._


### assemblefile.js

To use assemble's CLI, you'll need to add an `assemblefile.js` to your project. The fastest way to do this is to run the following command:

```sh
$ assemble
```

If no `assemblefile.js` exists in the current project, assemble will ask if you want to add one. If you answer yes, assemble will then generate a basic `assembfile.js` for you.


## CLI

Run assemble from the command line.

```sh
$ assemble <tasks> [options]
```

### Running tasks

Specify one or more space-separated tasks to run.

**Examples**

Run task `foo`

```sh
$ assemble foo
```

Run tasks `foo` and `bar`

```sh
$ assemble foo bar
```

### Specifying options

Non-task options are prefixed with `--`.

**Examples**

Set the `--cwd` to run an assemblefile.js in a different directory:

```sh
$ assemble --cwd=docs
```

Emit views as they're loaded and log them to `stderr`:

```sh
$ assemble --emit=view
```

See more [command line options]()

### Object expansion

Object-paths may be specified using dot-notation for **either the key or value** in a command line argument.

Additionally, assemble uses [expand-object][] (and some custom parsing) to make it easier to pass non-trivial options and commands via command line. So all of the following formats are possible.

**Examples**

Boolean values:

```sh
$ assemble --foo 
# { foo: true }
```

Key-value pairs:

```sh
$ assemble --foo=bar
# { foo: 'bar' }
```

Nested booleans:

```sh
$ assemble --option=foo 
# {options: { foo: true }}
```

Nested key-value pairs:

```sh
$ assemble --option=foo:bar
# {options: { foo: 'bar' }}
```

Deeply nested key-value pairs:

```sh
$ assemble --option=foo.bar.baz:qux
# {options: foo: { bar: { baz: 'qux' }}}}
```

Or on the left-side of the `=`:

```sh
$ assemble --option.foo.bar.baz=qux
# {options: foo: { bar: { baz: 'qux' }}}}
```

## Command line options

### cwd

Change the `cwd` for the `assemblefile.js` to run, optionally specifying any tasks to run:

```sh
$ assemble <tasks> --cwd [directory]
```

**Example**

To run the `scaffolds` example in the `examples/` directory, you would enter:

```sh
$ assemble --cwd examples/scaffolds
```

If successful, in the command line, you should see something like this:

<img width="527" alt="screen shot 2016-01-09 at 1 35 52 pm" src="https://cloud.githubusercontent.com/assets/383994/12217685/0a14294e-b6d6-11e5-9e06-dc4738f0e53a.png">

### file

Specify the name of the config file for assemble's CLI to run, the default is `assemblefile.js`.

**Example**

```sh
$ assemble --file assemblefile.dev.js
```

## API
{%= apidocs("index.js") %}

### Templates API

Assemble exposes the entire API from the [templates][] library for working with templates and template collections. The API is much more extensive than what is documented here, see [templates][] for more documentation.

**Templates and Views**

In the following documentation, the terms "template" and "view" both refer to _aspects_ of the same thing. Here's what they mean:

- `template`: an actual template string
- `view`: a object with a `content` property that contains the template string. Since views are instances of [vinyl][], you can think of a view as a "vinyl file for templates".


#### .create

Create a template collection for caching [views][]:

```js
app.create('includes', {viewType: 'partial'});
```

**Options**

* `cwd` **{String}**: the base directory to use when loading templates onto the collection from a glob
- `viewType`: **{String|Array}**: One or more [view types](#view-types) to associate with the collection


**Add views**

Add a view to the collection:

```js
app.include('foo.md', {contents: new Buffer('this is contents')});
```

Add multiple views:

```js
app.includes({
  path: 'foo.md', contents: new Buffer('this is contents'),
  path: 'bar.md', contents: new Buffer('this is contents'),
  path: 'baz.md', contents: new Buffer('this is contents')
});

// or pass a glob (optionally override `cwd` defined on `.create`)
app.includes('*.{md,hbs}', {cwd: 'templates/includes'});
```

#### View types

View types are defined on a collection to determine how a templates in the collection will be handled throughout the [render cycle][].

**Available types**

Assemble supports three view types:

- `partial`: Views with this type are can be used as "partials" (or "partial views"), which can be injected into other views. Useful for components, document fragments, or other snippets of reusable code or content. These views are passed to rendering engines to be used as partials, or variables on the context if partials are not directly supported.
- `layout`: allows views to "wrap" other views (of any type, including other layouts or partials) with common code or content.
- `renderable`: Views that have a one-to-one relationship with rendered files that will eventually be visible to a user or visitor to a website. For example: pages or blog posts. The `renderable` view type is automatically set if no other view types are set.


**Defining view types**

You can define view types when a collection is created:

```js
app.create('snippet', {viewType: 'partial'});
```

Or directly on the collection options:

```js
app.create('snippet');
app.snippets.option('viewType', ['partial']); // string or array
```


#### .engine

Register template engine for rendering views with the given `ext`:

```js
app.engine(ext, fn);
```

**Params**

* `ext` **{String}**: The file extension of files to render with the engine 
* `fn` **{Function}**: Async function that follows [consolidate][] engine conventions, and takes three arguments: `str`, `locals` and ` callback`. 

**Example**

```js
// this engine is already registered in assemble
app.engine('hbs', require('engine-handlebars'));

// create a custom engine
app.engine('txt', function(str, locals, cb) {
  // render `str` with `locals`
  cb(null, str);
});
```


You can tell assemble to use the same engine for all file extensions by setting a value on `options.engine`.

**Example**

```js
// use engine `hbs` for rendering all files
app.option('engine', 'hbs');
```

Or, if you're using [.renderFile](#renderFile), you can force a specific engine to be used by passing the engine name.

**Example**

Use the `hbs` engine to render all templates:

```js
app.src('templates/*.*')
  .pipe(app.renderFile('hbs'))
```

#### .render

Render a view with the given `locals` and `callback`.

```js
app.render(view, {title: 'Foo'}, function(err, view) {
  // `view` is an object with a rendered `content` property
});
```

**Params**

* `view` **{Object|String}**: The view to render
* `locals` **{Object}**: Locals to pass to template engine for rendering templates in `view`
* `callback` **{Function}**

***


### File System API

Assemble offers the following low-level methods for working with the file system:

- [src](#src)
- [symlink](#symlink)
- [dest](#dest)
- [copy](#copy)

Assemble has first-class support for [vinyl-fs][], so any [gulp][] plugin can be used in your assemble pipeline.

#### .src

Create a [vinyl][] stream. Takes glob patterns or filepaths to the source files to read.

**Params**

* `glob` **{String|Array}**: Glob patterns or file paths to source files.
* `options` **{Object}**: Options or locals to merge into the context and/or pass to `src` plugins

**Example**

```js
app.src('src/*.hbs');

// define `src` options
app.src('src/*.hbs', { layout: 'default' });
```

#### .dest

Specify a destination for processed files.

**Params**

* `dest` **{String|Function}**: File path or rename function.
* `options` **{Object}**: Options and locals to pass to `dest` plugins

**Example**

```js
app.dest('dist/');
```

#### .copy

Copy files with the given glob `patterns` to the specified `dest`.

**Params**

* `patterns` **{String|Array}**: Glob patterns of files to copy.
* `dest` **{String|Function}**: Desination directory.
* `returns` **{Stream}**: Stream, to continue processing if necessary.

**Example**

```js
app.task('assets', function() {
  // return, to let assemble know when the task has completed
  return app.copy('assets/**', 'dist/');
});
```

#### .renderFile

Renders files as they are pushed through the stream.

```js
app.src('*.hbs')
  .pipe(app.renderfile())
  .pipe(app.dest('foo'));
```

Force a specific engine to be used for rendering files:

```js
app.engine('txt', function(str, locals, cb) {
  cb(null, str);
});

app.src('*.hbs')
  .pipe(app.renderfile('txt')) //<= use engine `txt`
  .pipe(app.dest('foo'));
```

***

### Task API

Assemble has the following methods for running tasks and controlling workflows:

- [task](#task)  
- [build](#build)  
- [watch](#watch)  

#### .task

Define a task to be run when the task is called.

**Params**

* `name` **{String}**: Task name
* `fn` **{Function}**: function that is called when the task is run.

**Example**

```js
app.task('default', function() {
  app.src('templates/*.hbs')
    .pipe(app.dest('site/'));
});
```

#### .build

Run one or more tasks.

**Params**

* `tasks` **{Array|String}**: Task name or array of task names.
* `cb` **{Function}**: callback function that exposes `err`

**Example**

```js
app.build(['foo', 'bar'], function(err) {
  if (err) throw err;
  console.log('done!');
});
```

#### .watch

Watch files, run one or more tasks when a watched file changes.

**Params**

* `glob` **{String|Array}**: Filepaths or glob patterns.
* `tasks` **{Array}**: Task(s) to watch.

**Example**

```js
app.task('watch', function() {
  app.watch('docs/*.md', ['docs']);
});
```

## Plugins

### Discovering plugins

Plugins from any applications built on [base][] should work with Assemble and can be used in your `assemblefile.js`:

* [base][base-plugin]: find base plugins on npm using the `baseplugin` keyword
* [assemble][assemble-plugin]: find assemble plugins on npm using the `assembleplugin` keyword
* [generate][generate-plugin]: find generate plugins on npm using the `generateplugin` keyword
* [templates][templates-plugin]: find templates plugins on npm using the `templatesplugin` keyword
* [update][update-plugin]: find update plugins on npm using the `updateplugin` keyword
* [verb][verb-plugin]: find verb plugins on npm using the `verbplugin` keyword

### Authoring plugins

Visit the [plugin documentation](docs/plugins.md) guide to learn how to use, author and publish plugins.

## Learning

### Help

**Get in touch!**

Have questions, suggestions, or want to discuss assemble? Join the conversation on [gitter](http://gitter.im/assemble/assemble) or give us a shout on [twitter](https://twitter.com/assemblejs). The assemble team and community are always happy to help! 

### More information

* ~~[Documentation](docs)~~ (Temporarily, while we work on the new website, docs can be found in [support/docs/src](support/docs/src))
* [API documentation](docs/api)
* [Generators maintained by the core team](https://github.com/generate)

### FAQ

**Website is outdated and being refactored!**

Assemble's website, assemble.io, only has information related to [gulp-assemble][]. We're working hard to update the site with information about the latest release. 

In the meantime, you might find the [WIP docs](docs/src/content) useful. The [unit tests](test/) are also great examples! 

**Is the assemble website up-to-date?**

No, as mentioned above, it's completely out-of-date. If you're using [grunt-assemble][], some of the documentation at assemble.io might still be useful. If you're using assemble v0.6.0 and higher, the documentation is probably wrong in almost every way. 

We're actively (daily) working on a refactor and it's a very high priority. 

**What's the difference between [assemble-core][] and assemble?**

Assemble adds a CLI, a few built-in view collections: `pages`, `layouts`, and `partials`, middleware for parsing front-matter, and a few other basic defaults that we've found many users expect. If you'd prefer different defaults, [assemble-core][] is a great starting point. 

If you want something that handles templates, rendering, engines, helpers, collections, etc. but you don't need to run tasks or work with the file system, then consider using [templates][] instead of assemble-core.

**I use gulp, why is it recommended to use assemble directly, instead of running assemble with gulp?**

You can run gulp plugins with assemble, but it won't always work the other way around. This is because, as a build system, assemble does things that gulp doesn't do, like handle middleware. 

For example, assemble's `.src` and `.dest` methods have built-in `.onStream`, `.preWrite`, and `.postWrite` middleware handlers. If you still wish to use gulp and your build cycle includes middleware that requires these handlers, you can use the [assemble-handle][] plugin with gulp to ensure that the handlers are still called as needed.

This is a long way of saying, you can find ways to make gulp work, but you would just be adding an extra dependency to your project to do things that assemble already does.

**What is the relationship between gulp and assemble?**

Please read our [gulp FAQ](docs/src/subjects/gulp-faq.md) for more information.

## About

### Community

Get updates on Assemble's development and chat with the project maintainers and community members.

- Follow [@assemblejs on Twitter](https://twitter.com/assemblejs).
* If you like Assemble and want to tweet about it, please feel free to mention `@assemblejs` or use the `#assemble` hashtag
- Read and subscribe to [The Official Assemble Blog]({%= homepage %}/blog).
- Join [the official Slack room](https://assemble.github.io/slack).
- Join the [conversation on Gitter](https://gitter.im/assemble/assemble?utm_source=share-link&utm_medium=link&utm_campaign=share-link)
* Tell us about [your assemble project](https://github.com/assemble/assemble/issues/300)
* Show your love by starring Assemble!
* Get implementation help on [StackOverflow](http://stackoverflow.com/questions/tagged/assemble) (please use the [`assemble`](https://stackoverflow.com/questions/tagged/assemble) tag in questions)
* **Gitter** Discuss Assemble with us on [Gitter](https://gitter.im/assemble/assemble)
- For maximum discoverability, plugin developers should use the keyword `assembleplugin` on packages which modify or add to the functionality of Assemble when distributing through [npm](https://www.npmjs.com/browse/keyword/assemble) or similar delivery mechanisms.

**Contributing**

Please read our [contributing guide](.github/contributing.md) if you'd like to learn more about contributing to this project.

[docs]: https://github.com/assemble/assemble/blob/master/docs/

### Related projects

You might also be interested in these projects from [@doowb](https://github.com/doowb) and [@jonschlinkert](https://github.com/jonschlinkert):

{%= related(verb.related.list) %}

### Similar projects

If assemble doesn't do what you need, there are some other great open source projects you might be interested in, created by our friends on GitHub (in alphabetical order):

**Static site generators**

- [docpad](https://github.com/docpad)
- [metalsmith](https://github.com/metalsmith)
- [punch](https://github.com/laktek/punch)
- [wintersmith](https://github.com/jnordberg/wintersmith)

**Blog frameworks**

- [hexojs](https://github.com/hexojs)
- [ghost](https://github.com/TryGhost/Ghost)


### Release history
{%= increaseHeadings(increaseHeadings(changelog('changelog.md', {
  changelogFooter: true,
  stripHeading: true, 
  repo: repo
}))) %}

### Contributing
{%= include("contributing") %}

If Assemble doesn't do what you need, [please let us know]({%= issue({
  title: "request: <title here>",
  repo: "assemble",
  owner: "assemble"
}) %})

### Contributors
{%= gh.contributors() %}

### Authors

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

**Brian Woodward**

* [github/doowb](https://github.com/doowb)
* [twitter/doowb](http://twitter.com/doowb)

### License
{%= copyright() %}
{%= license %}

***

{%= include("footer") %}


[layouts]: [github]doowb/layouts
[grunt-assemble]: [assemble]grunt-assemble
[assemble-nunjucks]: [assemble]assemble-nunjucks
[engine-handlebars]: [jon]engine-handlebars
[engine-lodash]: [jon]engine-lodash
[engine-base]: [jon]engine-base
[doowb]: [github]doowb/
[jon]: [github]jonschlinkert/
[assemble]: [github]assemble/
[github]: https://github.com/

[assemble-plugin]: https://www.npmjs.com/browse/keyword/assembleplugin
[base-plugin]: https://www.npmjs.com/browse/keyword/baseplugin
[generate-plugin]: https://www.npmjs.com/browse/keyword/generateplugin
[generate-generator]: https://www.npmjs.com/browse/keyword/generate-generator
[getting-started]: https://github.com/generate/getting-started
[templates-plugin]: https://www.npmjs.com/browse/keyword/templatesplugin
[update-plugin]: https://www.npmjs.com/browse/keyword/updateplugin
[verb-plugin]: https://www.npmjs.com/browse/keyword/verbplugin
[hc]: https://medium.com/git-out-the-vote/fear-and-page-loading-on-the-campaign-trail-7163ed42e6d0#.mzg6dkvhb
