;; Licensed under the Apache License, Version 2.0 (the "License");
;; you may not use this file except in compliance with the License.
;; You may obtain a copy of the License at
;;
;;      http://www.apache.org/licenses/LICENSE-2.0
;;
;; Unless required by applicable law or agreed to in writing, software
;; distributed under the License is distributed on an "AS IS" BASIS,
;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;; See the License for the specific language governing permissions and
;; limitations under the License.
;;
;; Copyright 2008-2012, University of Illinois at Urbana-Champaign
;;
;; Originally this table was developed by Richard Sproat and Kyoung-young Kim
;; at UIUC
;; A python version of their original code is available here
;;  https://github.com/nltk/nltk_contrib/tree/master/nltk_contrib/scripttranscriber/Unitran
;;
;; Modified and converted to be used into the FestVox voice building tools
;; by Gopala Anumanchipalli (gopalakr@cs.cmu.edu) September 2012
;; 
;; See http://www.lfsag.unito.it/ipa/index_en.html for an IPA/SAMPA mapping
;;
;; Post Wilderness first_pass update 24th Dec 2018
;;
( set! unicode_sampa_mapping '(
( let_a    (( A )))
( let_hyphen (( )) )
( u0621p   (( HAMZA)))
( u0622p   (( QM @:)))
( u0623p   (( QM )))
( u0624p   (( QM )))
( u0625p   (( QM )))
( u0626p   (( QM )))
( u0627p   (( @:)))
( u0628p   (( b )))
( u0629p   (( t )))
( u062Ap   (( t )))
( u062Cp   (( dZ )))
( u062Dp   (( H )))
( u062Ep   (( x )))
( u062Fp   (( d )))
( u0630p   (( D )))
( u0631p   (( r )))
( u0632p   (( z )))
( u0633p   (( s )))
( u0634p   (( S )))
( u0635p   (( s~ )))
( u0636p   (( d~ )))
( u0637p   (( t~ )))
( u0638p   (( z~ )))
( u0639p   (( hv  )))
( u063Ap   (( G )))
( u0641p   (( f )))
( u0642p   (( q )))
( u0643p   (( k )))
( u0644p   (( l )))
( u0645p   (( m )))
( u0646p   (( n )))
( u0647p   (( h )))
( u0648p   (( u:)))
( u0649p   (( a: )))
( u064Ap   (( i:)))
( u064Bp   (( FATHATAN)))
( u064Cp   (( DAMMATAN)))
( u064Dp   (( KASRATAN)))
( u064Ep   (( E)))
( u064Fp   (( U)))
( u0650p   (( I)))
( u0651p   (( SHADDA)))
( u0652p   (( a~)))
))
