;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                     ;;;
;;;                     Carnegie Mellon University                      ;;;
;;;                  and Alan W Black and Kevin Lenzo                   ;;;
;;;                      Copyright (c) 1998-2000                        ;;;
;;;                        All Rights Reserved.                         ;;;
;;;                                                                     ;;;
;;; Permission is hereby granted, free of charge, to use and distribute ;;;
;;; this software and its documentation without restriction, including  ;;;
;;; without limitation the rights to use, copy, modify, merge, publish, ;;;
;;; distribute, sublicense, and/or sell copies of this work, and to     ;;;
;;; permit persons to whom this work is furnished to do so, subject to  ;;;
;;; the following conditions:                                           ;;;
;;;  1. The code must retain the above copyright notice, this list of   ;;;
;;;     conditions and the following disclaimer.                        ;;;
;;;  2. Any modifications must be clearly marked as such.               ;;;
;;;  3. Original authors' names are not deleted.                        ;;;
;;;  4. The authors' names are not used to endorse or promote products  ;;;
;;;     derived from this software without specific prior written       ;;;
;;;     permission.                                                     ;;;
;;;                                                                     ;;;
;;; CARNEGIE MELLON UNIVERSITY AND THE CONTRIBUTORS TO THIS WORK        ;;;
;;; DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     ;;;
;;; ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  ;;;
;;; SHALL CARNEGIE MELLON UNIVERSITY NOR THE CONTRIBUTORS BE LIABLE     ;;;
;;; FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   ;;;
;;; WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  ;;;
;;; AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         ;;;
;;; ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      ;;;
;;; THIS SOFTWARE.                                                      ;;;
;;;                                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Tokenizer for ar
;;;
;;;  To share this among voices you need to promote this file to
;;;  to say festival/lib/kacst_ar/ so others can use it.
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Load any other required files

;; Punctuation for the particular language
(set! kacst_ar_asc::token.punctuation "\"'`.,:;!?(){}[]")
(set! kacst_ar_asc::token.prepunctuation "\"'`({[")
(set! kacst_ar_asc::token.whitespace " \t\n\r")
(set! kacst_ar_asc::token.singlecharsymbols "")

;;; Voice/ar token_to_word rules 
(define (kacst_ar_asc::token_to_words token name)
  "(kacst_ar_asc::token_to_words token name)
Specific token to word rules for the voice kacst_ar_asc.  Returns a list
of words that expand given token with name."
  (cond
   ((string-matches name "[1-9][0-9]+")
    (kacst_ar::number token name))
   (t ;; when no specific rules apply do the general ones
    (list name))))

(define (kacst_ar::number token name)
  "(kacst_ar::number token name)
Return list of words that pronounce this number in ar."

  (error "kacst_ar::number to be written\n")

)

(define (kacst_ar_asc::select_tokenizer)
  "(kacst_ar_asc::select_tokenizer)
Set up tokenizer for ar."
  (Parameter.set 'Language 'kacst_ar)
  (set! token.punctuation kacst_ar_asc::token.punctuation)
  (set! token.prepunctuation kacst_ar_asc::token.prepunctuation)
  (set! token.whitespace kacst_ar_asc::token.whitespace)
  (set! token.singlecharsymbols kacst_ar_asc::token.singlecharsymbols)

  (set! token_to_words kacst_ar_asc::token_to_words)
)

(define (kacst_ar_asc::reset_tokenizer)
  "(kacst_ar_asc::reset_tokenizer)
Reset any globals modified for this voice.  Called by 
(kacst_ar_asc::voice_reset)."
  ;; None

  t
)

(provide 'kacst_ar_asc_tokenizer)
