;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                     ;;;
;;;                     Carnegie Mellon University                      ;;;
;;;                  and Alan W Black and Kevin Lenzo                   ;;;
;;;                      Copyright (c) 1998-2012                        ;;;
;;;                        All Rights Reserved.                         ;;;
;;;                                                                     ;;;
;;; Permission is hereby granted, free of charge, to use and distribute ;;;
;;; this software and its documentation without restriction, including  ;;;
;;; without limitation the rights to use, copy, modify, merge, publish, ;;;
;;; distribute, sublicense, and/or sell copies of this work, and to     ;;;
;;; permit persons to whom this work is furnished to do so, subject to  ;;;
;;; the following conditions:                                           ;;;
;;;  1. The code must retain the above copyright notice, this list of   ;;;
;;;     conditions and the following disclaimer.                        ;;;
;;;  2. Any modifications must be clearly marked as such.               ;;;
;;;  3. Original authors' names are not deleted.                        ;;;
;;;  4. The authors' names are not used to endorse or promote products  ;;;
;;;     derived from this software without specific prior written       ;;;
;;;     permission.                                                     ;;;
;;;                                                                     ;;;
;;; CARNEGIE MELLON UNIVERSITY AND THE CONTRIBUTORS TO THIS WORK        ;;;
;;; DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     ;;;
;;; ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  ;;;
;;; SHALL CARNEGIE MELLON UNIVERSITY NOR THE CONTRIBUTORS BE LIABLE     ;;;
;;; FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   ;;;
;;; WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  ;;;
;;; AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         ;;;
;;; ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      ;;;
;;; THIS SOFTWARE.                                                      ;;;
;;;                                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Phonset for kacst_ar
;;;

;;; To give a "sampa" phoneset definition (though there are so many
;;; different sampas these may not be exactly the sampas you're looking for

(defPhoneSet
  kacst_ar
  ;;;  Phone Features
  (;; vowel or consonant
   (clst + - 0)
   (vc + - 0)
   ;; vowel length: short long dipthong schwa
   (vlng s l d a 0)
   ;; vowel height: high mid low
   (vheight 1 2 3 0 -)
   ;; vowel frontness: front mid back
   (vfront 1 2 3 0 -)
   ;; lip rounding
   (vrnd + - 0)
   ;; consonant type: stop fricative affricative nasal liquid approximant
   (ctype s f a n l r 0)
   ;; place of articulation: labial alveolar palatal labio-dental
   ;;                         dental velar glottal
   (cplace l a p b d v g 0)
   ;; consonant voicing
   (cvox + - 0)
   (asp  + - 0)
   (nuk + - 0)
   )
 (

   (pau    - -       0    0    0    0    0    0    -    -    -)  ;; slience ...
( @:     - +       l    2    1    -    0    0    0    -    0)
( D     - -       0    0    0    0    s    d    +    -    -)
   ( DAMMATAN - - 0 0 0 0  0 0  0 0 0 )
( E     - +       s    2    1    -    0    0    0    -    -) ; ??
   ( FATHATAN - - 0 0 0 0  0 0  0 0 0 )
( G      - -       0    0    0    0    s    v    +    -    -)
( H     - -       0    0    0    0    l    p    +    -    -)
   ( HAMZA - - 0 0 0 0  0 0  0 0 0 )
   ( I - - 0 0 0 0  0 0  0 0 0 )
   ( KASRATAN - - 0 0 0 0  0 0  0 0 0 )
( QM      - -       0    0    0    0    s    v    -    -    -)  ;; question mark
( S     - -       0    0    0    0    f    p    +    +    -)
   ( SHADDA - - 0 0 0 0  0 0  0 0 0 )
   ( U - - 0 0 0 0  0 0  0 0 0 )
( a:     - +       l    2    2    -    0    0    0    -    0)
( a~     - +       s    2    2    -    n    0    0    -    0)
( b     - -       0    0    0    0    s    l    +    -    -)
( d     - -       0    0    0    0    s    d    +    -    -)
( dZ     - -      0    0    0    0    a    p    +    -    -)
( d~    - -       0    0    0    0    s    d    +    -    -) ;; nasal?
( f     - -       0    0    0    0    s    l    -    +    -)
( h     - -       0    0    0    0    f    v    -    +    -)
( hv    - -       0    0    0    0    f    v    -    +    -)
( i:     - +       l    1    1    -    0    0    0    -    0)
( k      - -       0    0    0    0    s    v    -    -    -)
( l     - -       0    0    0    0    l    d    +    -    -)
( m     - -       0    0    0    0    n    l    +    -    -)
( n     - -       0    0    0    0    n    d    +    -    -)
( q      - -       0    0    0    0    s    v    -    -    -)
( r      - -       0    0    0    +    l    a    +    -    -)
( s     - -       0    0    0    0    f    d    -    -    -)
( s~     - -       0    0    0    0    f    d    -    -    -)
( t     - -       0    0    0    0    s    a    -    -    -)
( t~     - -       0    0    0    0    s    a    -    -    -)
( u:     - +       l    1    3    +    0    0    0    -    0)
( x      - -       0    0    0    0    s    v    +    +    -)
   ( x031p - - 0 0 0 0  0 0  0 0 0 )
( z      - -       0    0    0    0    a    p    +    -    -)
( z~      - -       0    0    0    0    a    p    +    -    -)
  )
)

 (PhoneSet.silences '(pau))
 
 (define (kacst_ar_asc::select_phoneset)
   "(kacst_ar_asc::select_phoneset)
 Set up phone set for kacst_ar."
   (Parameter.set 'PhoneSet 'kacst_ar)
   (PhoneSet.select 'kacst_ar)
 )
 
 (define (kacst_ar_asc::reset_phoneset)
   "(kacst_ar_asc::reset_phoneset)
 Reset phone set for kacst_ar."
   t
 )
 
 (provide 'kacst_ar_asc_phoneset)
