# coding: utf-8
"""
<copyright company="Aspose" file="WriteProtectionpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class WriteProtection(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'author' : 'str',
        'recommend_read_only' : 'bool',
        'is_write_protected' : 'bool',
        'password' : 'str'
    }

    attribute_map = {
        'author' : 'Author' ,
        'recommend_read_only' : 'RecommendReadOnly' ,
        'is_write_protected' : 'IsWriteProtected' ,
        'password' : 'Password' 
    }

    @staticmethod
    def get_swagger_types():
        return WriteProtection.swagger_types

    @staticmethod
    def get_attribute_map():
        return WriteProtection.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,author=None ,recommend_read_only=None ,is_write_protected=None ,password=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        WriteProtection - a model defined in Swagger
        """
        self.container['author'] = None 
        self.container['recommend_read_only'] = None 
        self.container['is_write_protected'] = None 
        self.container['password'] = None 
        params = locals()
        self.author = author
        if 'author' in params:
            self.author = params["author"]


             
        self.recommend_read_only = recommend_read_only
        if 'recommend_read_only' in params:
            self.recommend_read_only = params["recommend_read_only"]


             
        self.is_write_protected = is_write_protected
        if 'is_write_protected' in params:
            self.is_write_protected = params["is_write_protected"]


             
        self.password = password
        if 'password' in params:
            self.password = params["password"]


             

    @property
    def author(self):
        return self.container['author']

    @author.setter
    def author(self, author):
        self.container['author'] = author 
    @property
    def recommend_read_only(self):
        return self.container['recommend_read_only']

    @recommend_read_only.setter
    def recommend_read_only(self, recommend_read_only):
        self.container['recommend_read_only'] = recommend_read_only 
    @property
    def is_write_protected(self):
        return self.container['is_write_protected']

    @is_write_protected.setter
    def is_write_protected(self, is_write_protected):
        self.container['is_write_protected'] = is_write_protected 
    @property
    def password(self):
        return self.container['password']

    @password.setter
    def password(self, password):
        self.container['password'] = password 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, WriteProtection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    