# coding: utf-8
"""
<copyright company="Aspose" file="WorksheetDataStatisticspy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class WorksheetDataStatistics(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'name' : 'str',
        'charts_count' : 'int',
        'tables_count' : 'int',
        'pivot_tables_count' : 'int',
        'shapes_count' : 'int',
        'hyperlinks_count' : 'int',
        'query_tables_count' : 'int',
        'cells_count' : 'int',
        'cells_count_in_table' : 'int',
        'cells_count_is_formula' : 'int'
    }

    attribute_map = {
        'name' : 'Name' ,
        'charts_count' : 'ChartsCount' ,
        'tables_count' : 'TablesCount' ,
        'pivot_tables_count' : 'PivotTablesCount' ,
        'shapes_count' : 'ShapesCount' ,
        'hyperlinks_count' : 'HyperlinksCount' ,
        'query_tables_count' : 'QueryTablesCount' ,
        'cells_count' : 'CellsCount' ,
        'cells_count_in_table' : 'CellsCountInTable' ,
        'cells_count_is_formula' : 'CellsCountIsFormula' 
    }

    @staticmethod
    def get_swagger_types():
        return WorksheetDataStatistics.swagger_types

    @staticmethod
    def get_attribute_map():
        return WorksheetDataStatistics.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,name=None ,charts_count=None ,tables_count=None ,pivot_tables_count=None ,shapes_count=None ,hyperlinks_count=None ,query_tables_count=None ,cells_count=None ,cells_count_in_table=None ,cells_count_is_formula=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        WorksheetDataStatistics - a model defined in Swagger
        """
        self.container['name'] = None 
        self.container['charts_count'] = None 
        self.container['tables_count'] = None 
        self.container['pivot_tables_count'] = None 
        self.container['shapes_count'] = None 
        self.container['hyperlinks_count'] = None 
        self.container['query_tables_count'] = None 
        self.container['cells_count'] = None 
        self.container['cells_count_in_table'] = None 
        self.container['cells_count_is_formula'] = None 
        params = locals()
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.charts_count = charts_count
        if 'charts_count' in params:
            self.charts_count = params["charts_count"]


             
        self.tables_count = tables_count
        if 'tables_count' in params:
            self.tables_count = params["tables_count"]


             
        self.pivot_tables_count = pivot_tables_count
        if 'pivot_tables_count' in params:
            self.pivot_tables_count = params["pivot_tables_count"]


             
        self.shapes_count = shapes_count
        if 'shapes_count' in params:
            self.shapes_count = params["shapes_count"]


             
        self.hyperlinks_count = hyperlinks_count
        if 'hyperlinks_count' in params:
            self.hyperlinks_count = params["hyperlinks_count"]


             
        self.query_tables_count = query_tables_count
        if 'query_tables_count' in params:
            self.query_tables_count = params["query_tables_count"]


             
        self.cells_count = cells_count
        if 'cells_count' in params:
            self.cells_count = params["cells_count"]


             
        self.cells_count_in_table = cells_count_in_table
        if 'cells_count_in_table' in params:
            self.cells_count_in_table = params["cells_count_in_table"]


             
        self.cells_count_is_formula = cells_count_is_formula
        if 'cells_count_is_formula' in params:
            self.cells_count_is_formula = params["cells_count_is_formula"]


             

    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def charts_count(self):
        return self.container['charts_count']

    @charts_count.setter
    def charts_count(self, charts_count):
        self.container['charts_count'] = charts_count 
    @property
    def tables_count(self):
        return self.container['tables_count']

    @tables_count.setter
    def tables_count(self, tables_count):
        self.container['tables_count'] = tables_count 
    @property
    def pivot_tables_count(self):
        return self.container['pivot_tables_count']

    @pivot_tables_count.setter
    def pivot_tables_count(self, pivot_tables_count):
        self.container['pivot_tables_count'] = pivot_tables_count 
    @property
    def shapes_count(self):
        return self.container['shapes_count']

    @shapes_count.setter
    def shapes_count(self, shapes_count):
        self.container['shapes_count'] = shapes_count 
    @property
    def hyperlinks_count(self):
        return self.container['hyperlinks_count']

    @hyperlinks_count.setter
    def hyperlinks_count(self, hyperlinks_count):
        self.container['hyperlinks_count'] = hyperlinks_count 
    @property
    def query_tables_count(self):
        return self.container['query_tables_count']

    @query_tables_count.setter
    def query_tables_count(self, query_tables_count):
        self.container['query_tables_count'] = query_tables_count 
    @property
    def cells_count(self):
        return self.container['cells_count']

    @cells_count.setter
    def cells_count(self, cells_count):
        self.container['cells_count'] = cells_count 
    @property
    def cells_count_in_table(self):
        return self.container['cells_count_in_table']

    @cells_count_in_table.setter
    def cells_count_in_table(self, cells_count_in_table):
        self.container['cells_count_in_table'] = cells_count_in_table 
    @property
    def cells_count_is_formula(self):
        return self.container['cells_count_is_formula']

    @cells_count_is_formula.setter
    def cells_count_is_formula(self, cells_count_is_formula):
        self.container['cells_count_is_formula'] = cells_count_is_formula 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, WorksheetDataStatistics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    