# coding: utf-8
"""
<copyright company="Aspose" file="Worksheetpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Worksheet(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'links' : 'list[Link]',
        'display_right_to_left' : 'bool',
        'display_zeros' : 'bool',
        'first_visible_column' : 'int',
        'first_visible_row' : 'int',
        'name' : 'str',
        'index' : 'int',
        'is_gridlines_visible' : 'bool',
        'is_outline_shown' : 'bool',
        'is_page_break_preview' : 'bool',
        'is_visible' : 'bool',
        'is_protected' : 'bool',
        'is_row_column_headers_visible' : 'bool',
        'is_ruler_visible' : 'bool',
        'is_selected' : 'bool',
        'tab_color' : 'Color',
        'transition_entry' : 'bool',
        'transition_evaluation' : 'bool',
        'type' : 'str',
        'view_type' : 'str',
        'visibility_type' : 'str',
        'zoom' : 'int',
        'cells' : 'LinkElement',
        'charts' : 'LinkElement',
        'auto_shapes' : 'LinkElement',
        'ole_objects' : 'LinkElement',
        'comments' : 'LinkElement',
        'pictures' : 'LinkElement',
        'merged_cells' : 'LinkElement',
        'validations' : 'LinkElement',
        'conditional_formattings' : 'LinkElement',
        'hyperlinks' : 'LinkElement'
    }

    attribute_map = {
        'links' : 'Links' ,
        'display_right_to_left' : 'DisplayRightToLeft' ,
        'display_zeros' : 'DisplayZeros' ,
        'first_visible_column' : 'FirstVisibleColumn' ,
        'first_visible_row' : 'FirstVisibleRow' ,
        'name' : 'Name' ,
        'index' : 'Index' ,
        'is_gridlines_visible' : 'IsGridlinesVisible' ,
        'is_outline_shown' : 'IsOutlineShown' ,
        'is_page_break_preview' : 'IsPageBreakPreview' ,
        'is_visible' : 'IsVisible' ,
        'is_protected' : 'IsProtected' ,
        'is_row_column_headers_visible' : 'IsRowColumnHeadersVisible' ,
        'is_ruler_visible' : 'IsRulerVisible' ,
        'is_selected' : 'IsSelected' ,
        'tab_color' : 'TabColor' ,
        'transition_entry' : 'TransitionEntry' ,
        'transition_evaluation' : 'TransitionEvaluation' ,
        'type' : 'Type' ,
        'view_type' : 'ViewType' ,
        'visibility_type' : 'VisibilityType' ,
        'zoom' : 'Zoom' ,
        'cells' : 'Cells' ,
        'charts' : 'Charts' ,
        'auto_shapes' : 'AutoShapes' ,
        'ole_objects' : 'OleObjects' ,
        'comments' : 'Comments' ,
        'pictures' : 'Pictures' ,
        'merged_cells' : 'MergedCells' ,
        'validations' : 'Validations' ,
        'conditional_formattings' : 'ConditionalFormattings' ,
        'hyperlinks' : 'Hyperlinks' 
    }

    @staticmethod
    def get_swagger_types():
        return Worksheet.swagger_types

    @staticmethod
    def get_attribute_map():
        return Worksheet.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,links=None ,display_right_to_left=None ,display_zeros=None ,first_visible_column=None ,first_visible_row=None ,name=None ,index=None ,is_gridlines_visible=None ,is_outline_shown=None ,is_page_break_preview=None ,is_visible=None ,is_protected=None ,is_row_column_headers_visible=None ,is_ruler_visible=None ,is_selected=None ,tab_color=None ,transition_entry=None ,transition_evaluation=None ,type=None ,view_type=None ,visibility_type=None ,zoom=None ,cells=None ,charts=None ,auto_shapes=None ,ole_objects=None ,comments=None ,pictures=None ,merged_cells=None ,validations=None ,conditional_formattings=None ,hyperlinks=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Worksheet - a model defined in Swagger
        """
        self.container['links'] = None 
        self.container['display_right_to_left'] = None 
        self.container['display_zeros'] = None 
        self.container['first_visible_column'] = None 
        self.container['first_visible_row'] = None 
        self.container['name'] = None 
        self.container['index'] = None 
        self.container['is_gridlines_visible'] = None 
        self.container['is_outline_shown'] = None 
        self.container['is_page_break_preview'] = None 
        self.container['is_visible'] = None 
        self.container['is_protected'] = None 
        self.container['is_row_column_headers_visible'] = None 
        self.container['is_ruler_visible'] = None 
        self.container['is_selected'] = None 
        self.container['tab_color'] = None 
        self.container['transition_entry'] = None 
        self.container['transition_evaluation'] = None 
        self.container['type'] = None 
        self.container['view_type'] = None 
        self.container['visibility_type'] = None 
        self.container['zoom'] = None 
        self.container['cells'] = None 
        self.container['charts'] = None 
        self.container['auto_shapes'] = None 
        self.container['ole_objects'] = None 
        self.container['comments'] = None 
        self.container['pictures'] = None 
        self.container['merged_cells'] = None 
        self.container['validations'] = None 
        self.container['conditional_formattings'] = None 
        self.container['hyperlinks'] = None 
        params = locals()
        self.links = links
        if 'links' in params:
            self.links = params["links"]


             
        self.display_right_to_left = display_right_to_left
        if 'display_right_to_left' in params:
            self.display_right_to_left = params["display_right_to_left"]


             
        self.display_zeros = display_zeros
        if 'display_zeros' in params:
            self.display_zeros = params["display_zeros"]


             
        self.first_visible_column = first_visible_column
        if 'first_visible_column' in params:
            self.first_visible_column = params["first_visible_column"]


             
        self.first_visible_row = first_visible_row
        if 'first_visible_row' in params:
            self.first_visible_row = params["first_visible_row"]


             
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.index = index
        if 'index' in params:
            self.index = params["index"]


             
        self.is_gridlines_visible = is_gridlines_visible
        if 'is_gridlines_visible' in params:
            self.is_gridlines_visible = params["is_gridlines_visible"]


             
        self.is_outline_shown = is_outline_shown
        if 'is_outline_shown' in params:
            self.is_outline_shown = params["is_outline_shown"]


             
        self.is_page_break_preview = is_page_break_preview
        if 'is_page_break_preview' in params:
            self.is_page_break_preview = params["is_page_break_preview"]


             
        self.is_visible = is_visible
        if 'is_visible' in params:
            self.is_visible = params["is_visible"]


             
        self.is_protected = is_protected
        if 'is_protected' in params:
            self.is_protected = params["is_protected"]


             
        self.is_row_column_headers_visible = is_row_column_headers_visible
        if 'is_row_column_headers_visible' in params:
            self.is_row_column_headers_visible = params["is_row_column_headers_visible"]


             
        self.is_ruler_visible = is_ruler_visible
        if 'is_ruler_visible' in params:
            self.is_ruler_visible = params["is_ruler_visible"]


             
        self.is_selected = is_selected
        if 'is_selected' in params:
            self.is_selected = params["is_selected"]


             
        self.tab_color = tab_color
        if 'tab_color' in params:
            self.tab_color = params["tab_color"]


             
        self.transition_entry = transition_entry
        if 'transition_entry' in params:
            self.transition_entry = params["transition_entry"]


             
        self.transition_evaluation = transition_evaluation
        if 'transition_evaluation' in params:
            self.transition_evaluation = params["transition_evaluation"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.view_type = view_type
        if 'view_type' in params:
            self.view_type = params["view_type"]


             
        self.visibility_type = visibility_type
        if 'visibility_type' in params:
            self.visibility_type = params["visibility_type"]


             
        self.zoom = zoom
        if 'zoom' in params:
            self.zoom = params["zoom"]


             
        self.cells = cells
        if 'cells' in params:
            self.cells = params["cells"]


             
        self.charts = charts
        if 'charts' in params:
            self.charts = params["charts"]


             
        self.auto_shapes = auto_shapes
        if 'auto_shapes' in params:
            self.auto_shapes = params["auto_shapes"]


             
        self.ole_objects = ole_objects
        if 'ole_objects' in params:
            self.ole_objects = params["ole_objects"]


             
        self.comments = comments
        if 'comments' in params:
            self.comments = params["comments"]


             
        self.pictures = pictures
        if 'pictures' in params:
            self.pictures = params["pictures"]


             
        self.merged_cells = merged_cells
        if 'merged_cells' in params:
            self.merged_cells = params["merged_cells"]


             
        self.validations = validations
        if 'validations' in params:
            self.validations = params["validations"]


             
        self.conditional_formattings = conditional_formattings
        if 'conditional_formattings' in params:
            self.conditional_formattings = params["conditional_formattings"]


             
        self.hyperlinks = hyperlinks
        if 'hyperlinks' in params:
            self.hyperlinks = params["hyperlinks"]


             

    @property
    def links(self):
        return self.container['links']

    @links.setter
    def links(self, links):
        self.container['links'] = links 
    @property
    def display_right_to_left(self):
        return self.container['display_right_to_left']

    @display_right_to_left.setter
    def display_right_to_left(self, display_right_to_left):
        self.container['display_right_to_left'] = display_right_to_left 
    @property
    def display_zeros(self):
        return self.container['display_zeros']

    @display_zeros.setter
    def display_zeros(self, display_zeros):
        self.container['display_zeros'] = display_zeros 
    @property
    def first_visible_column(self):
        return self.container['first_visible_column']

    @first_visible_column.setter
    def first_visible_column(self, first_visible_column):
        self.container['first_visible_column'] = first_visible_column 
    @property
    def first_visible_row(self):
        return self.container['first_visible_row']

    @first_visible_row.setter
    def first_visible_row(self, first_visible_row):
        self.container['first_visible_row'] = first_visible_row 
    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def index(self):
        return self.container['index']

    @index.setter
    def index(self, index):
        self.container['index'] = index 
    @property
    def is_gridlines_visible(self):
        return self.container['is_gridlines_visible']

    @is_gridlines_visible.setter
    def is_gridlines_visible(self, is_gridlines_visible):
        self.container['is_gridlines_visible'] = is_gridlines_visible 
    @property
    def is_outline_shown(self):
        return self.container['is_outline_shown']

    @is_outline_shown.setter
    def is_outline_shown(self, is_outline_shown):
        self.container['is_outline_shown'] = is_outline_shown 
    @property
    def is_page_break_preview(self):
        return self.container['is_page_break_preview']

    @is_page_break_preview.setter
    def is_page_break_preview(self, is_page_break_preview):
        self.container['is_page_break_preview'] = is_page_break_preview 
    @property
    def is_visible(self):
        return self.container['is_visible']

    @is_visible.setter
    def is_visible(self, is_visible):
        self.container['is_visible'] = is_visible 
    @property
    def is_protected(self):
        return self.container['is_protected']

    @is_protected.setter
    def is_protected(self, is_protected):
        self.container['is_protected'] = is_protected 
    @property
    def is_row_column_headers_visible(self):
        return self.container['is_row_column_headers_visible']

    @is_row_column_headers_visible.setter
    def is_row_column_headers_visible(self, is_row_column_headers_visible):
        self.container['is_row_column_headers_visible'] = is_row_column_headers_visible 
    @property
    def is_ruler_visible(self):
        return self.container['is_ruler_visible']

    @is_ruler_visible.setter
    def is_ruler_visible(self, is_ruler_visible):
        self.container['is_ruler_visible'] = is_ruler_visible 
    @property
    def is_selected(self):
        return self.container['is_selected']

    @is_selected.setter
    def is_selected(self, is_selected):
        self.container['is_selected'] = is_selected 
    @property
    def tab_color(self):
        return self.container['tab_color']

    @tab_color.setter
    def tab_color(self, tab_color):
        self.container['tab_color'] = tab_color 
    @property
    def transition_entry(self):
        return self.container['transition_entry']

    @transition_entry.setter
    def transition_entry(self, transition_entry):
        self.container['transition_entry'] = transition_entry 
    @property
    def transition_evaluation(self):
        return self.container['transition_evaluation']

    @transition_evaluation.setter
    def transition_evaluation(self, transition_evaluation):
        self.container['transition_evaluation'] = transition_evaluation 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def view_type(self):
        return self.container['view_type']

    @view_type.setter
    def view_type(self, view_type):
        self.container['view_type'] = view_type 
    @property
    def visibility_type(self):
        return self.container['visibility_type']

    @visibility_type.setter
    def visibility_type(self, visibility_type):
        self.container['visibility_type'] = visibility_type 
    @property
    def zoom(self):
        return self.container['zoom']

    @zoom.setter
    def zoom(self, zoom):
        self.container['zoom'] = zoom 
    @property
    def cells(self):
        return self.container['cells']

    @cells.setter
    def cells(self, cells):
        self.container['cells'] = cells 
    @property
    def charts(self):
        return self.container['charts']

    @charts.setter
    def charts(self, charts):
        self.container['charts'] = charts 
    @property
    def auto_shapes(self):
        return self.container['auto_shapes']

    @auto_shapes.setter
    def auto_shapes(self, auto_shapes):
        self.container['auto_shapes'] = auto_shapes 
    @property
    def ole_objects(self):
        return self.container['ole_objects']

    @ole_objects.setter
    def ole_objects(self, ole_objects):
        self.container['ole_objects'] = ole_objects 
    @property
    def comments(self):
        return self.container['comments']

    @comments.setter
    def comments(self, comments):
        self.container['comments'] = comments 
    @property
    def pictures(self):
        return self.container['pictures']

    @pictures.setter
    def pictures(self, pictures):
        self.container['pictures'] = pictures 
    @property
    def merged_cells(self):
        return self.container['merged_cells']

    @merged_cells.setter
    def merged_cells(self, merged_cells):
        self.container['merged_cells'] = merged_cells 
    @property
    def validations(self):
        return self.container['validations']

    @validations.setter
    def validations(self, validations):
        self.container['validations'] = validations 
    @property
    def conditional_formattings(self):
        return self.container['conditional_formattings']

    @conditional_formattings.setter
    def conditional_formattings(self, conditional_formattings):
        self.container['conditional_formattings'] = conditional_formattings 
    @property
    def hyperlinks(self):
        return self.container['hyperlinks']

    @hyperlinks.setter
    def hyperlinks(self, hyperlinks):
        self.container['hyperlinks'] = hyperlinks 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Worksheet):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    