# coding: utf-8
"""
<copyright company="Aspose" file="WorkbookSettingspy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class WorkbookSettings(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'auto_compress_pictures' : 'bool',
        'auto_recover' : 'bool',
        'build_version' : 'str',
        'calc_mode' : 'str',
        'calculation_id' : 'str',
        'check_comptiliblity' : 'bool',
        'check_excel_restriction' : 'bool',
        'crash_save' : 'bool',
        'create_calc_chain' : 'bool',
        'data_extract_load' : 'bool',
        'date1904' : 'bool',
        'display_drawing_objects' : 'str',
        'enable_macros' : 'bool',
        'first_visible_tab' : 'int',
        'hide_pivot_field_list' : 'bool',
        'is_default_encrypted' : 'bool',
        'is_hidden' : 'bool',
        'is_h_scroll_bar_visible' : 'bool',
        'is_minimized' : 'bool',
        'is_v_scroll_bar_visible' : 'bool',
        'iteration' : 'bool',
        'language_code' : 'str',
        'max_change' : 'float',
        'max_iteration' : 'int',
        'memory_setting' : 'str',
        'number_decimal_separator' : 'str',
        'number_group_separator' : 'str',
        'parsing_formula_on_open' : 'bool',
        'precision_as_displayed' : 'bool',
        'recalculate_before_save' : 'bool',
        're_calculate_on_open' : 'bool',
        'recommend_read_only' : 'bool',
        'region' : 'str',
        'remove_personal_information' : 'bool',
        'repair_load' : 'bool',
        'shared' : 'bool',
        'sheet_tab_bar_width' : 'int',
        'show_tabs' : 'bool',
        'update_adjacent_cells_border' : 'bool',
        'update_links_type' : 'str',
        'window_height' : 'float',
        'window_left' : 'float',
        'window_top' : 'float',
        'window_width' : 'float',
        'author' : 'str',
        'check_custom_number_format' : 'bool',
        'protection_type' : 'str',
        'globalization_settings' : 'GlobalizationSettings',
        'password' : 'str',
        'write_protection' : 'WriteProtection',
        'is_encrypted' : 'bool',
        'is_protected' : 'bool',
        'max_row' : 'int',
        'max_column' : 'int',
        'significant_digits' : 'int',
        'check_compatibility' : 'bool',
        'paper_size' : 'str',
        'max_rows_of_shared_formula' : 'int',
        'compliance' : 'str',
        'quote_prefix_to_style' : 'bool',
        'formula_settings' : 'FormulaSettings',
        'force_full_calculate' : 'bool'
    }

    attribute_map = {
        'auto_compress_pictures' : 'AutoCompressPictures' ,
        'auto_recover' : 'AutoRecover' ,
        'build_version' : 'BuildVersion' ,
        'calc_mode' : 'CalcMode' ,
        'calculation_id' : 'CalculationId' ,
        'check_comptiliblity' : 'CheckComptiliblity' ,
        'check_excel_restriction' : 'CheckExcelRestriction' ,
        'crash_save' : 'CrashSave' ,
        'create_calc_chain' : 'CreateCalcChain' ,
        'data_extract_load' : 'DataExtractLoad' ,
        'date1904' : 'Date1904' ,
        'display_drawing_objects' : 'DisplayDrawingObjects' ,
        'enable_macros' : 'EnableMacros' ,
        'first_visible_tab' : 'FirstVisibleTab' ,
        'hide_pivot_field_list' : 'HidePivotFieldList' ,
        'is_default_encrypted' : 'IsDefaultEncrypted' ,
        'is_hidden' : 'IsHidden' ,
        'is_h_scroll_bar_visible' : 'IsHScrollBarVisible' ,
        'is_minimized' : 'IsMinimized' ,
        'is_v_scroll_bar_visible' : 'IsVScrollBarVisible' ,
        'iteration' : 'Iteration' ,
        'language_code' : 'LanguageCode' ,
        'max_change' : 'MaxChange' ,
        'max_iteration' : 'MaxIteration' ,
        'memory_setting' : 'MemorySetting' ,
        'number_decimal_separator' : 'NumberDecimalSeparator' ,
        'number_group_separator' : 'NumberGroupSeparator' ,
        'parsing_formula_on_open' : 'ParsingFormulaOnOpen' ,
        'precision_as_displayed' : 'PrecisionAsDisplayed' ,
        'recalculate_before_save' : 'RecalculateBeforeSave' ,
        're_calculate_on_open' : 'ReCalculateOnOpen' ,
        'recommend_read_only' : 'RecommendReadOnly' ,
        'region' : 'Region' ,
        'remove_personal_information' : 'RemovePersonalInformation' ,
        'repair_load' : 'RepairLoad' ,
        'shared' : 'Shared' ,
        'sheet_tab_bar_width' : 'SheetTabBarWidth' ,
        'show_tabs' : 'ShowTabs' ,
        'update_adjacent_cells_border' : 'UpdateAdjacentCellsBorder' ,
        'update_links_type' : 'UpdateLinksType' ,
        'window_height' : 'WindowHeight' ,
        'window_left' : 'WindowLeft' ,
        'window_top' : 'WindowTop' ,
        'window_width' : 'WindowWidth' ,
        'author' : 'Author' ,
        'check_custom_number_format' : 'CheckCustomNumberFormat' ,
        'protection_type' : 'ProtectionType' ,
        'globalization_settings' : 'GlobalizationSettings' ,
        'password' : 'Password' ,
        'write_protection' : 'WriteProtection' ,
        'is_encrypted' : 'IsEncrypted' ,
        'is_protected' : 'IsProtected' ,
        'max_row' : 'MaxRow' ,
        'max_column' : 'MaxColumn' ,
        'significant_digits' : 'SignificantDigits' ,
        'check_compatibility' : 'CheckCompatibility' ,
        'paper_size' : 'PaperSize' ,
        'max_rows_of_shared_formula' : 'MaxRowsOfSharedFormula' ,
        'compliance' : 'Compliance' ,
        'quote_prefix_to_style' : 'QuotePrefixToStyle' ,
        'formula_settings' : 'FormulaSettings' ,
        'force_full_calculate' : 'ForceFullCalculate' 
    }

    @staticmethod
    def get_swagger_types():
        return WorkbookSettings.swagger_types

    @staticmethod
    def get_attribute_map():
        return WorkbookSettings.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,auto_compress_pictures=None ,auto_recover=None ,build_version=None ,calc_mode=None ,calculation_id=None ,check_comptiliblity=None ,check_excel_restriction=None ,crash_save=None ,create_calc_chain=None ,data_extract_load=None ,date1904=None ,display_drawing_objects=None ,enable_macros=None ,first_visible_tab=None ,hide_pivot_field_list=None ,is_default_encrypted=None ,is_hidden=None ,is_h_scroll_bar_visible=None ,is_minimized=None ,is_v_scroll_bar_visible=None ,iteration=None ,language_code=None ,max_change=None ,max_iteration=None ,memory_setting=None ,number_decimal_separator=None ,number_group_separator=None ,parsing_formula_on_open=None ,precision_as_displayed=None ,recalculate_before_save=None ,re_calculate_on_open=None ,recommend_read_only=None ,region=None ,remove_personal_information=None ,repair_load=None ,shared=None ,sheet_tab_bar_width=None ,show_tabs=None ,update_adjacent_cells_border=None ,update_links_type=None ,window_height=None ,window_left=None ,window_top=None ,window_width=None ,author=None ,check_custom_number_format=None ,protection_type=None ,globalization_settings=None ,password=None ,write_protection=None ,is_encrypted=None ,is_protected=None ,max_row=None ,max_column=None ,significant_digits=None ,check_compatibility=None ,paper_size=None ,max_rows_of_shared_formula=None ,compliance=None ,quote_prefix_to_style=None ,formula_settings=None ,force_full_calculate=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        WorkbookSettings - a model defined in Swagger
        """
        self.container['auto_compress_pictures'] = None 
        self.container['auto_recover'] = None 
        self.container['build_version'] = None 
        self.container['calc_mode'] = None 
        self.container['calculation_id'] = None 
        self.container['check_comptiliblity'] = None 
        self.container['check_excel_restriction'] = None 
        self.container['crash_save'] = None 
        self.container['create_calc_chain'] = None 
        self.container['data_extract_load'] = None 
        self.container['date1904'] = None 
        self.container['display_drawing_objects'] = None 
        self.container['enable_macros'] = None 
        self.container['first_visible_tab'] = None 
        self.container['hide_pivot_field_list'] = None 
        self.container['is_default_encrypted'] = None 
        self.container['is_hidden'] = None 
        self.container['is_h_scroll_bar_visible'] = None 
        self.container['is_minimized'] = None 
        self.container['is_v_scroll_bar_visible'] = None 
        self.container['iteration'] = None 
        self.container['language_code'] = None 
        self.container['max_change'] = None 
        self.container['max_iteration'] = None 
        self.container['memory_setting'] = None 
        self.container['number_decimal_separator'] = None 
        self.container['number_group_separator'] = None 
        self.container['parsing_formula_on_open'] = None 
        self.container['precision_as_displayed'] = None 
        self.container['recalculate_before_save'] = None 
        self.container['re_calculate_on_open'] = None 
        self.container['recommend_read_only'] = None 
        self.container['region'] = None 
        self.container['remove_personal_information'] = None 
        self.container['repair_load'] = None 
        self.container['shared'] = None 
        self.container['sheet_tab_bar_width'] = None 
        self.container['show_tabs'] = None 
        self.container['update_adjacent_cells_border'] = None 
        self.container['update_links_type'] = None 
        self.container['window_height'] = None 
        self.container['window_left'] = None 
        self.container['window_top'] = None 
        self.container['window_width'] = None 
        self.container['author'] = None 
        self.container['check_custom_number_format'] = None 
        self.container['protection_type'] = None 
        self.container['globalization_settings'] = None 
        self.container['password'] = None 
        self.container['write_protection'] = None 
        self.container['is_encrypted'] = None 
        self.container['is_protected'] = None 
        self.container['max_row'] = None 
        self.container['max_column'] = None 
        self.container['significant_digits'] = None 
        self.container['check_compatibility'] = None 
        self.container['paper_size'] = None 
        self.container['max_rows_of_shared_formula'] = None 
        self.container['compliance'] = None 
        self.container['quote_prefix_to_style'] = None 
        self.container['formula_settings'] = None 
        self.container['force_full_calculate'] = None 
        params = locals()
        self.auto_compress_pictures = auto_compress_pictures
        if 'auto_compress_pictures' in params:
            self.auto_compress_pictures = params["auto_compress_pictures"]


             
        self.auto_recover = auto_recover
        if 'auto_recover' in params:
            self.auto_recover = params["auto_recover"]


             
        self.build_version = build_version
        if 'build_version' in params:
            self.build_version = params["build_version"]


             
        self.calc_mode = calc_mode
        if 'calc_mode' in params:
            self.calc_mode = params["calc_mode"]


             
        self.calculation_id = calculation_id
        if 'calculation_id' in params:
            self.calculation_id = params["calculation_id"]


             
        self.check_comptiliblity = check_comptiliblity
        if 'check_comptiliblity' in params:
            self.check_comptiliblity = params["check_comptiliblity"]


             
        self.check_excel_restriction = check_excel_restriction
        if 'check_excel_restriction' in params:
            self.check_excel_restriction = params["check_excel_restriction"]


             
        self.crash_save = crash_save
        if 'crash_save' in params:
            self.crash_save = params["crash_save"]


             
        self.create_calc_chain = create_calc_chain
        if 'create_calc_chain' in params:
            self.create_calc_chain = params["create_calc_chain"]


             
        self.data_extract_load = data_extract_load
        if 'data_extract_load' in params:
            self.data_extract_load = params["data_extract_load"]


             
        self.date1904 = date1904
        if 'date1904' in params:
            self.date1904 = params["date1904"]


             
        self.display_drawing_objects = display_drawing_objects
        if 'display_drawing_objects' in params:
            self.display_drawing_objects = params["display_drawing_objects"]


             
        self.enable_macros = enable_macros
        if 'enable_macros' in params:
            self.enable_macros = params["enable_macros"]


             
        self.first_visible_tab = first_visible_tab
        if 'first_visible_tab' in params:
            self.first_visible_tab = params["first_visible_tab"]


             
        self.hide_pivot_field_list = hide_pivot_field_list
        if 'hide_pivot_field_list' in params:
            self.hide_pivot_field_list = params["hide_pivot_field_list"]


             
        self.is_default_encrypted = is_default_encrypted
        if 'is_default_encrypted' in params:
            self.is_default_encrypted = params["is_default_encrypted"]


             
        self.is_hidden = is_hidden
        if 'is_hidden' in params:
            self.is_hidden = params["is_hidden"]


             
        self.is_h_scroll_bar_visible = is_h_scroll_bar_visible
        if 'is_h_scroll_bar_visible' in params:
            self.is_h_scroll_bar_visible = params["is_h_scroll_bar_visible"]


             
        self.is_minimized = is_minimized
        if 'is_minimized' in params:
            self.is_minimized = params["is_minimized"]


             
        self.is_v_scroll_bar_visible = is_v_scroll_bar_visible
        if 'is_v_scroll_bar_visible' in params:
            self.is_v_scroll_bar_visible = params["is_v_scroll_bar_visible"]


             
        self.iteration = iteration
        if 'iteration' in params:
            self.iteration = params["iteration"]


             
        self.language_code = language_code
        if 'language_code' in params:
            self.language_code = params["language_code"]


             
        self.max_change = max_change
        if 'max_change' in params:
            self.max_change = params["max_change"]


             
        self.max_iteration = max_iteration
        if 'max_iteration' in params:
            self.max_iteration = params["max_iteration"]


             
        self.memory_setting = memory_setting
        if 'memory_setting' in params:
            self.memory_setting = params["memory_setting"]


             
        self.number_decimal_separator = number_decimal_separator
        if 'number_decimal_separator' in params:
            self.number_decimal_separator = params["number_decimal_separator"]


             
        self.number_group_separator = number_group_separator
        if 'number_group_separator' in params:
            self.number_group_separator = params["number_group_separator"]


             
        self.parsing_formula_on_open = parsing_formula_on_open
        if 'parsing_formula_on_open' in params:
            self.parsing_formula_on_open = params["parsing_formula_on_open"]


             
        self.precision_as_displayed = precision_as_displayed
        if 'precision_as_displayed' in params:
            self.precision_as_displayed = params["precision_as_displayed"]


             
        self.recalculate_before_save = recalculate_before_save
        if 'recalculate_before_save' in params:
            self.recalculate_before_save = params["recalculate_before_save"]


             
        self.re_calculate_on_open = re_calculate_on_open
        if 're_calculate_on_open' in params:
            self.re_calculate_on_open = params["re_calculate_on_open"]


             
        self.recommend_read_only = recommend_read_only
        if 'recommend_read_only' in params:
            self.recommend_read_only = params["recommend_read_only"]


             
        self.region = region
        if 'region' in params:
            self.region = params["region"]


             
        self.remove_personal_information = remove_personal_information
        if 'remove_personal_information' in params:
            self.remove_personal_information = params["remove_personal_information"]


             
        self.repair_load = repair_load
        if 'repair_load' in params:
            self.repair_load = params["repair_load"]


             
        self.shared = shared
        if 'shared' in params:
            self.shared = params["shared"]


             
        self.sheet_tab_bar_width = sheet_tab_bar_width
        if 'sheet_tab_bar_width' in params:
            self.sheet_tab_bar_width = params["sheet_tab_bar_width"]


             
        self.show_tabs = show_tabs
        if 'show_tabs' in params:
            self.show_tabs = params["show_tabs"]


             
        self.update_adjacent_cells_border = update_adjacent_cells_border
        if 'update_adjacent_cells_border' in params:
            self.update_adjacent_cells_border = params["update_adjacent_cells_border"]


             
        self.update_links_type = update_links_type
        if 'update_links_type' in params:
            self.update_links_type = params["update_links_type"]


             
        self.window_height = window_height
        if 'window_height' in params:
            self.window_height = params["window_height"]


             
        self.window_left = window_left
        if 'window_left' in params:
            self.window_left = params["window_left"]


             
        self.window_top = window_top
        if 'window_top' in params:
            self.window_top = params["window_top"]


             
        self.window_width = window_width
        if 'window_width' in params:
            self.window_width = params["window_width"]


             
        self.author = author
        if 'author' in params:
            self.author = params["author"]


             
        self.check_custom_number_format = check_custom_number_format
        if 'check_custom_number_format' in params:
            self.check_custom_number_format = params["check_custom_number_format"]


             
        self.protection_type = protection_type
        if 'protection_type' in params:
            self.protection_type = params["protection_type"]


             
        self.globalization_settings = globalization_settings
        if 'globalization_settings' in params:
            self.globalization_settings = params["globalization_settings"]


             
        self.password = password
        if 'password' in params:
            self.password = params["password"]


             
        self.write_protection = write_protection
        if 'write_protection' in params:
            self.write_protection = params["write_protection"]


             
        self.is_encrypted = is_encrypted
        if 'is_encrypted' in params:
            self.is_encrypted = params["is_encrypted"]


             
        self.is_protected = is_protected
        if 'is_protected' in params:
            self.is_protected = params["is_protected"]


             
        self.max_row = max_row
        if 'max_row' in params:
            self.max_row = params["max_row"]


             
        self.max_column = max_column
        if 'max_column' in params:
            self.max_column = params["max_column"]


             
        self.significant_digits = significant_digits
        if 'significant_digits' in params:
            self.significant_digits = params["significant_digits"]


             
        self.check_compatibility = check_compatibility
        if 'check_compatibility' in params:
            self.check_compatibility = params["check_compatibility"]


             
        self.paper_size = paper_size
        if 'paper_size' in params:
            self.paper_size = params["paper_size"]


             
        self.max_rows_of_shared_formula = max_rows_of_shared_formula
        if 'max_rows_of_shared_formula' in params:
            self.max_rows_of_shared_formula = params["max_rows_of_shared_formula"]


             
        self.compliance = compliance
        if 'compliance' in params:
            self.compliance = params["compliance"]


             
        self.quote_prefix_to_style = quote_prefix_to_style
        if 'quote_prefix_to_style' in params:
            self.quote_prefix_to_style = params["quote_prefix_to_style"]


             
        self.formula_settings = formula_settings
        if 'formula_settings' in params:
            self.formula_settings = params["formula_settings"]


             
        self.force_full_calculate = force_full_calculate
        if 'force_full_calculate' in params:
            self.force_full_calculate = params["force_full_calculate"]


             

    @property
    def auto_compress_pictures(self):
        return self.container['auto_compress_pictures']

    @auto_compress_pictures.setter
    def auto_compress_pictures(self, auto_compress_pictures):
        self.container['auto_compress_pictures'] = auto_compress_pictures 
    @property
    def auto_recover(self):
        return self.container['auto_recover']

    @auto_recover.setter
    def auto_recover(self, auto_recover):
        self.container['auto_recover'] = auto_recover 
    @property
    def build_version(self):
        return self.container['build_version']

    @build_version.setter
    def build_version(self, build_version):
        self.container['build_version'] = build_version 
    @property
    def calc_mode(self):
        return self.container['calc_mode']

    @calc_mode.setter
    def calc_mode(self, calc_mode):
        self.container['calc_mode'] = calc_mode 
    @property
    def calculation_id(self):
        return self.container['calculation_id']

    @calculation_id.setter
    def calculation_id(self, calculation_id):
        self.container['calculation_id'] = calculation_id 
    @property
    def check_comptiliblity(self):
        return self.container['check_comptiliblity']

    @check_comptiliblity.setter
    def check_comptiliblity(self, check_comptiliblity):
        self.container['check_comptiliblity'] = check_comptiliblity 
    @property
    def check_excel_restriction(self):
        return self.container['check_excel_restriction']

    @check_excel_restriction.setter
    def check_excel_restriction(self, check_excel_restriction):
        self.container['check_excel_restriction'] = check_excel_restriction 
    @property
    def crash_save(self):
        return self.container['crash_save']

    @crash_save.setter
    def crash_save(self, crash_save):
        self.container['crash_save'] = crash_save 
    @property
    def create_calc_chain(self):
        return self.container['create_calc_chain']

    @create_calc_chain.setter
    def create_calc_chain(self, create_calc_chain):
        self.container['create_calc_chain'] = create_calc_chain 
    @property
    def data_extract_load(self):
        return self.container['data_extract_load']

    @data_extract_load.setter
    def data_extract_load(self, data_extract_load):
        self.container['data_extract_load'] = data_extract_load 
    @property
    def date1904(self):
        return self.container['date1904']

    @date1904.setter
    def date1904(self, date1904):
        self.container['date1904'] = date1904 
    @property
    def display_drawing_objects(self):
        return self.container['display_drawing_objects']

    @display_drawing_objects.setter
    def display_drawing_objects(self, display_drawing_objects):
        self.container['display_drawing_objects'] = display_drawing_objects 
    @property
    def enable_macros(self):
        return self.container['enable_macros']

    @enable_macros.setter
    def enable_macros(self, enable_macros):
        self.container['enable_macros'] = enable_macros 
    @property
    def first_visible_tab(self):
        return self.container['first_visible_tab']

    @first_visible_tab.setter
    def first_visible_tab(self, first_visible_tab):
        self.container['first_visible_tab'] = first_visible_tab 
    @property
    def hide_pivot_field_list(self):
        return self.container['hide_pivot_field_list']

    @hide_pivot_field_list.setter
    def hide_pivot_field_list(self, hide_pivot_field_list):
        self.container['hide_pivot_field_list'] = hide_pivot_field_list 
    @property
    def is_default_encrypted(self):
        return self.container['is_default_encrypted']

    @is_default_encrypted.setter
    def is_default_encrypted(self, is_default_encrypted):
        self.container['is_default_encrypted'] = is_default_encrypted 
    @property
    def is_hidden(self):
        return self.container['is_hidden']

    @is_hidden.setter
    def is_hidden(self, is_hidden):
        self.container['is_hidden'] = is_hidden 
    @property
    def is_h_scroll_bar_visible(self):
        return self.container['is_h_scroll_bar_visible']

    @is_h_scroll_bar_visible.setter
    def is_h_scroll_bar_visible(self, is_h_scroll_bar_visible):
        self.container['is_h_scroll_bar_visible'] = is_h_scroll_bar_visible 
    @property
    def is_minimized(self):
        return self.container['is_minimized']

    @is_minimized.setter
    def is_minimized(self, is_minimized):
        self.container['is_minimized'] = is_minimized 
    @property
    def is_v_scroll_bar_visible(self):
        return self.container['is_v_scroll_bar_visible']

    @is_v_scroll_bar_visible.setter
    def is_v_scroll_bar_visible(self, is_v_scroll_bar_visible):
        self.container['is_v_scroll_bar_visible'] = is_v_scroll_bar_visible 
    @property
    def iteration(self):
        return self.container['iteration']

    @iteration.setter
    def iteration(self, iteration):
        self.container['iteration'] = iteration 
    @property
    def language_code(self):
        return self.container['language_code']

    @language_code.setter
    def language_code(self, language_code):
        self.container['language_code'] = language_code 
    @property
    def max_change(self):
        return self.container['max_change']

    @max_change.setter
    def max_change(self, max_change):
        self.container['max_change'] = max_change 
    @property
    def max_iteration(self):
        return self.container['max_iteration']

    @max_iteration.setter
    def max_iteration(self, max_iteration):
        self.container['max_iteration'] = max_iteration 
    @property
    def memory_setting(self):
        return self.container['memory_setting']

    @memory_setting.setter
    def memory_setting(self, memory_setting):
        self.container['memory_setting'] = memory_setting 
    @property
    def number_decimal_separator(self):
        return self.container['number_decimal_separator']

    @number_decimal_separator.setter
    def number_decimal_separator(self, number_decimal_separator):
        self.container['number_decimal_separator'] = number_decimal_separator 
    @property
    def number_group_separator(self):
        return self.container['number_group_separator']

    @number_group_separator.setter
    def number_group_separator(self, number_group_separator):
        self.container['number_group_separator'] = number_group_separator 
    @property
    def parsing_formula_on_open(self):
        return self.container['parsing_formula_on_open']

    @parsing_formula_on_open.setter
    def parsing_formula_on_open(self, parsing_formula_on_open):
        self.container['parsing_formula_on_open'] = parsing_formula_on_open 
    @property
    def precision_as_displayed(self):
        return self.container['precision_as_displayed']

    @precision_as_displayed.setter
    def precision_as_displayed(self, precision_as_displayed):
        self.container['precision_as_displayed'] = precision_as_displayed 
    @property
    def recalculate_before_save(self):
        return self.container['recalculate_before_save']

    @recalculate_before_save.setter
    def recalculate_before_save(self, recalculate_before_save):
        self.container['recalculate_before_save'] = recalculate_before_save 
    @property
    def re_calculate_on_open(self):
        return self.container['re_calculate_on_open']

    @re_calculate_on_open.setter
    def re_calculate_on_open(self, re_calculate_on_open):
        self.container['re_calculate_on_open'] = re_calculate_on_open 
    @property
    def recommend_read_only(self):
        return self.container['recommend_read_only']

    @recommend_read_only.setter
    def recommend_read_only(self, recommend_read_only):
        self.container['recommend_read_only'] = recommend_read_only 
    @property
    def region(self):
        return self.container['region']

    @region.setter
    def region(self, region):
        self.container['region'] = region 
    @property
    def remove_personal_information(self):
        return self.container['remove_personal_information']

    @remove_personal_information.setter
    def remove_personal_information(self, remove_personal_information):
        self.container['remove_personal_information'] = remove_personal_information 
    @property
    def repair_load(self):
        return self.container['repair_load']

    @repair_load.setter
    def repair_load(self, repair_load):
        self.container['repair_load'] = repair_load 
    @property
    def shared(self):
        return self.container['shared']

    @shared.setter
    def shared(self, shared):
        self.container['shared'] = shared 
    @property
    def sheet_tab_bar_width(self):
        return self.container['sheet_tab_bar_width']

    @sheet_tab_bar_width.setter
    def sheet_tab_bar_width(self, sheet_tab_bar_width):
        self.container['sheet_tab_bar_width'] = sheet_tab_bar_width 
    @property
    def show_tabs(self):
        return self.container['show_tabs']

    @show_tabs.setter
    def show_tabs(self, show_tabs):
        self.container['show_tabs'] = show_tabs 
    @property
    def update_adjacent_cells_border(self):
        return self.container['update_adjacent_cells_border']

    @update_adjacent_cells_border.setter
    def update_adjacent_cells_border(self, update_adjacent_cells_border):
        self.container['update_adjacent_cells_border'] = update_adjacent_cells_border 
    @property
    def update_links_type(self):
        return self.container['update_links_type']

    @update_links_type.setter
    def update_links_type(self, update_links_type):
        self.container['update_links_type'] = update_links_type 
    @property
    def window_height(self):
        return self.container['window_height']

    @window_height.setter
    def window_height(self, window_height):
        self.container['window_height'] = window_height 
    @property
    def window_left(self):
        return self.container['window_left']

    @window_left.setter
    def window_left(self, window_left):
        self.container['window_left'] = window_left 
    @property
    def window_top(self):
        return self.container['window_top']

    @window_top.setter
    def window_top(self, window_top):
        self.container['window_top'] = window_top 
    @property
    def window_width(self):
        return self.container['window_width']

    @window_width.setter
    def window_width(self, window_width):
        self.container['window_width'] = window_width 
    @property
    def author(self):
        return self.container['author']

    @author.setter
    def author(self, author):
        self.container['author'] = author 
    @property
    def check_custom_number_format(self):
        return self.container['check_custom_number_format']

    @check_custom_number_format.setter
    def check_custom_number_format(self, check_custom_number_format):
        self.container['check_custom_number_format'] = check_custom_number_format 
    @property
    def protection_type(self):
        return self.container['protection_type']

    @protection_type.setter
    def protection_type(self, protection_type):
        self.container['protection_type'] = protection_type 
    @property
    def globalization_settings(self):
        return self.container['globalization_settings']

    @globalization_settings.setter
    def globalization_settings(self, globalization_settings):
        self.container['globalization_settings'] = globalization_settings 
    @property
    def password(self):
        return self.container['password']

    @password.setter
    def password(self, password):
        self.container['password'] = password 
    @property
    def write_protection(self):
        return self.container['write_protection']

    @write_protection.setter
    def write_protection(self, write_protection):
        self.container['write_protection'] = write_protection 
    @property
    def is_encrypted(self):
        return self.container['is_encrypted']

    @is_encrypted.setter
    def is_encrypted(self, is_encrypted):
        self.container['is_encrypted'] = is_encrypted 
    @property
    def is_protected(self):
        return self.container['is_protected']

    @is_protected.setter
    def is_protected(self, is_protected):
        self.container['is_protected'] = is_protected 
    @property
    def max_row(self):
        return self.container['max_row']

    @max_row.setter
    def max_row(self, max_row):
        self.container['max_row'] = max_row 
    @property
    def max_column(self):
        return self.container['max_column']

    @max_column.setter
    def max_column(self, max_column):
        self.container['max_column'] = max_column 
    @property
    def significant_digits(self):
        return self.container['significant_digits']

    @significant_digits.setter
    def significant_digits(self, significant_digits):
        self.container['significant_digits'] = significant_digits 
    @property
    def check_compatibility(self):
        return self.container['check_compatibility']

    @check_compatibility.setter
    def check_compatibility(self, check_compatibility):
        self.container['check_compatibility'] = check_compatibility 
    @property
    def paper_size(self):
        return self.container['paper_size']

    @paper_size.setter
    def paper_size(self, paper_size):
        self.container['paper_size'] = paper_size 
    @property
    def max_rows_of_shared_formula(self):
        return self.container['max_rows_of_shared_formula']

    @max_rows_of_shared_formula.setter
    def max_rows_of_shared_formula(self, max_rows_of_shared_formula):
        self.container['max_rows_of_shared_formula'] = max_rows_of_shared_formula 
    @property
    def compliance(self):
        return self.container['compliance']

    @compliance.setter
    def compliance(self, compliance):
        self.container['compliance'] = compliance 
    @property
    def quote_prefix_to_style(self):
        return self.container['quote_prefix_to_style']

    @quote_prefix_to_style.setter
    def quote_prefix_to_style(self, quote_prefix_to_style):
        self.container['quote_prefix_to_style'] = quote_prefix_to_style 
    @property
    def formula_settings(self):
        return self.container['formula_settings']

    @formula_settings.setter
    def formula_settings(self, formula_settings):
        self.container['formula_settings'] = formula_settings 
    @property
    def force_full_calculate(self):
        return self.container['force_full_calculate']

    @force_full_calculate.setter
    def force_full_calculate(self, force_full_calculate):
        self.container['force_full_calculate'] = force_full_calculate 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, WorkbookSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    