# coding: utf-8
"""
<copyright company="Aspose" file="Validationpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Validation(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'alert_style' : 'str',
        'area_list' : 'list[CellArea]',
        'error_message' : 'str',
        'error_title' : 'str',
        'formula1' : 'str',
        'formula2' : 'str',
        'ignore_blank' : 'bool',
        'in_cell_drop_down' : 'bool',
        'input_message' : 'str',
        'input_title' : 'str',
        'operator' : 'str',
        'show_error' : 'bool',
        'show_input' : 'bool',
        'type' : 'str',
        'value1' : 'str',
        'value2' : 'str',
        'link' : 'Link'
    }

    attribute_map = {
        'alert_style' : 'AlertStyle' ,
        'area_list' : 'AreaList' ,
        'error_message' : 'ErrorMessage' ,
        'error_title' : 'ErrorTitle' ,
        'formula1' : 'Formula1' ,
        'formula2' : 'Formula2' ,
        'ignore_blank' : 'IgnoreBlank' ,
        'in_cell_drop_down' : 'InCellDropDown' ,
        'input_message' : 'InputMessage' ,
        'input_title' : 'InputTitle' ,
        'operator' : 'Operator' ,
        'show_error' : 'ShowError' ,
        'show_input' : 'ShowInput' ,
        'type' : 'Type' ,
        'value1' : 'Value1' ,
        'value2' : 'Value2' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return Validation.swagger_types

    @staticmethod
    def get_attribute_map():
        return Validation.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,alert_style=None ,area_list=None ,error_message=None ,error_title=None ,formula1=None ,formula2=None ,ignore_blank=None ,in_cell_drop_down=None ,input_message=None ,input_title=None ,operator=None ,show_error=None ,show_input=None ,type=None ,value1=None ,value2=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Validation - a model defined in Swagger
        """
        self.container['alert_style'] = None 
        self.container['area_list'] = None 
        self.container['error_message'] = None 
        self.container['error_title'] = None 
        self.container['formula1'] = None 
        self.container['formula2'] = None 
        self.container['ignore_blank'] = None 
        self.container['in_cell_drop_down'] = None 
        self.container['input_message'] = None 
        self.container['input_title'] = None 
        self.container['operator'] = None 
        self.container['show_error'] = None 
        self.container['show_input'] = None 
        self.container['type'] = None 
        self.container['value1'] = None 
        self.container['value2'] = None 
        self.container['link'] = None 
        params = locals()
        self.alert_style = alert_style
        if 'alert_style' in params:
            self.alert_style = params["alert_style"]


             
        self.area_list = area_list
        if 'area_list' in params:
            self.area_list = params["area_list"]


             
        self.error_message = error_message
        if 'error_message' in params:
            self.error_message = params["error_message"]


             
        self.error_title = error_title
        if 'error_title' in params:
            self.error_title = params["error_title"]


             
        self.formula1 = formula1
        if 'formula1' in params:
            self.formula1 = params["formula1"]


             
        self.formula2 = formula2
        if 'formula2' in params:
            self.formula2 = params["formula2"]


             
        self.ignore_blank = ignore_blank
        if 'ignore_blank' in params:
            self.ignore_blank = params["ignore_blank"]


             
        self.in_cell_drop_down = in_cell_drop_down
        if 'in_cell_drop_down' in params:
            self.in_cell_drop_down = params["in_cell_drop_down"]


             
        self.input_message = input_message
        if 'input_message' in params:
            self.input_message = params["input_message"]


             
        self.input_title = input_title
        if 'input_title' in params:
            self.input_title = params["input_title"]


             
        self.operator = operator
        if 'operator' in params:
            self.operator = params["operator"]


             
        self.show_error = show_error
        if 'show_error' in params:
            self.show_error = params["show_error"]


             
        self.show_input = show_input
        if 'show_input' in params:
            self.show_input = params["show_input"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.value1 = value1
        if 'value1' in params:
            self.value1 = params["value1"]


             
        self.value2 = value2
        if 'value2' in params:
            self.value2 = params["value2"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def alert_style(self):
        return self.container['alert_style']

    @alert_style.setter
    def alert_style(self, alert_style):
        self.container['alert_style'] = alert_style 
    @property
    def area_list(self):
        return self.container['area_list']

    @area_list.setter
    def area_list(self, area_list):
        self.container['area_list'] = area_list 
    @property
    def error_message(self):
        return self.container['error_message']

    @error_message.setter
    def error_message(self, error_message):
        self.container['error_message'] = error_message 
    @property
    def error_title(self):
        return self.container['error_title']

    @error_title.setter
    def error_title(self, error_title):
        self.container['error_title'] = error_title 
    @property
    def formula1(self):
        return self.container['formula1']

    @formula1.setter
    def formula1(self, formula1):
        self.container['formula1'] = formula1 
    @property
    def formula2(self):
        return self.container['formula2']

    @formula2.setter
    def formula2(self, formula2):
        self.container['formula2'] = formula2 
    @property
    def ignore_blank(self):
        return self.container['ignore_blank']

    @ignore_blank.setter
    def ignore_blank(self, ignore_blank):
        self.container['ignore_blank'] = ignore_blank 
    @property
    def in_cell_drop_down(self):
        return self.container['in_cell_drop_down']

    @in_cell_drop_down.setter
    def in_cell_drop_down(self, in_cell_drop_down):
        self.container['in_cell_drop_down'] = in_cell_drop_down 
    @property
    def input_message(self):
        return self.container['input_message']

    @input_message.setter
    def input_message(self, input_message):
        self.container['input_message'] = input_message 
    @property
    def input_title(self):
        return self.container['input_title']

    @input_title.setter
    def input_title(self, input_title):
        self.container['input_title'] = input_title 
    @property
    def operator(self):
        return self.container['operator']

    @operator.setter
    def operator(self, operator):
        self.container['operator'] = operator 
    @property
    def show_error(self):
        return self.container['show_error']

    @show_error.setter
    def show_error(self, show_error):
        self.container['show_error'] = show_error 
    @property
    def show_input(self):
        return self.container['show_input']

    @show_input.setter
    def show_input(self, show_input):
        self.container['show_input'] = show_input 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def value1(self):
        return self.container['value1']

    @value1.setter
    def value1(self, value1):
        self.container['value1'] = value1 
    @property
    def value2(self):
        return self.container['value2']

    @value2.setter
    def value2(self, value2):
        self.container['value2'] = value2 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Validation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    