# coding: utf-8
"""
<copyright company="Aspose" file="UnpivotColumnpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class UnpivotColumn(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'unpivot_column_names' : 'list[str]',
        'column_map_name' : 'str',
        'value_map_name' : 'str',
        'applied_operate_type' : 'str'
    }

    attribute_map = {
        'unpivot_column_names' : 'UnpivotColumnNames' ,
        'column_map_name' : 'ColumnMapName' ,
        'value_map_name' : 'ValueMapName' ,
        'applied_operate_type' : 'AppliedOperateType' 
    }

    @staticmethod
    def get_swagger_types():
        return UnpivotColumn.swagger_types

    @staticmethod
    def get_attribute_map():
        return UnpivotColumn.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,unpivot_column_names=None ,column_map_name=None ,value_map_name=None ,applied_operate_type=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        UnpivotColumn - a model defined in Swagger
        """
        self.container['unpivot_column_names'] = None 
        self.container['column_map_name'] = None 
        self.container['value_map_name'] = None 
        self.container['applied_operate_type'] = None 
        params = locals()
        self.unpivot_column_names = unpivot_column_names
        if 'unpivot_column_names' in params:
            self.unpivot_column_names = params["unpivot_column_names"]


             
        self.column_map_name = column_map_name
        if 'column_map_name' in params:
            self.column_map_name = params["column_map_name"]


             
        self.value_map_name = value_map_name
        if 'value_map_name' in params:
            self.value_map_name = params["value_map_name"]


             
        self.applied_operate_type = applied_operate_type
        if 'applied_operate_type' in params:
            self.applied_operate_type = params["applied_operate_type"]


             

    @property
    def unpivot_column_names(self):
        return self.container['unpivot_column_names']

    @unpivot_column_names.setter
    def unpivot_column_names(self, unpivot_column_names):
        self.container['unpivot_column_names'] = unpivot_column_names 
    @property
    def column_map_name(self):
        return self.container['column_map_name']

    @column_map_name.setter
    def column_map_name(self, column_map_name):
        self.container['column_map_name'] = column_map_name 
    @property
    def value_map_name(self):
        return self.container['value_map_name']

    @value_map_name.setter
    def value_map_name(self, value_map_name):
        self.container['value_map_name'] = value_map_name 
    @property
    def applied_operate_type(self):
        return self.container['applied_operate_type']

    @applied_operate_type.setter
    def applied_operate_type(self, applied_operate_type):
        self.container['applied_operate_type'] = applied_operate_type 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, UnpivotColumn):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    