# coding: utf-8
"""
<copyright company="Aspose" file="TickLabelspy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class TickLabels(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'auto_scale_font' : 'bool',
        'background_mode' : 'str',
        'font' : 'Font',
        'number' : 'int',
        'number_format' : 'str',
        'number_format_linked' : 'bool',
        'offset' : 'int',
        'rotation_angle' : 'int',
        'text_direction' : 'str',
        'reading_order' : 'str',
        'direction_type' : 'str',
        'link' : 'Link'
    }

    attribute_map = {
        'auto_scale_font' : 'AutoScaleFont' ,
        'background_mode' : 'BackgroundMode' ,
        'font' : 'Font' ,
        'number' : 'Number' ,
        'number_format' : 'NumberFormat' ,
        'number_format_linked' : 'NumberFormatLinked' ,
        'offset' : 'Offset' ,
        'rotation_angle' : 'RotationAngle' ,
        'text_direction' : 'TextDirection' ,
        'reading_order' : 'ReadingOrder' ,
        'direction_type' : 'DirectionType' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return TickLabels.swagger_types

    @staticmethod
    def get_attribute_map():
        return TickLabels.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,auto_scale_font=None ,background_mode=None ,font=None ,number=None ,number_format=None ,number_format_linked=None ,offset=None ,rotation_angle=None ,text_direction=None ,reading_order=None ,direction_type=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        TickLabels - a model defined in Swagger
        """
        self.container['auto_scale_font'] = None 
        self.container['background_mode'] = None 
        self.container['font'] = None 
        self.container['number'] = None 
        self.container['number_format'] = None 
        self.container['number_format_linked'] = None 
        self.container['offset'] = None 
        self.container['rotation_angle'] = None 
        self.container['text_direction'] = None 
        self.container['reading_order'] = None 
        self.container['direction_type'] = None 
        self.container['link'] = None 
        params = locals()
        self.auto_scale_font = auto_scale_font
        if 'auto_scale_font' in params:
            self.auto_scale_font = params["auto_scale_font"]


             
        self.background_mode = background_mode
        if 'background_mode' in params:
            self.background_mode = params["background_mode"]


             
        self.font = font
        if 'font' in params:
            self.font = params["font"]


             
        self.number = number
        if 'number' in params:
            self.number = params["number"]


             
        self.number_format = number_format
        if 'number_format' in params:
            self.number_format = params["number_format"]


             
        self.number_format_linked = number_format_linked
        if 'number_format_linked' in params:
            self.number_format_linked = params["number_format_linked"]


             
        self.offset = offset
        if 'offset' in params:
            self.offset = params["offset"]


             
        self.rotation_angle = rotation_angle
        if 'rotation_angle' in params:
            self.rotation_angle = params["rotation_angle"]


             
        self.text_direction = text_direction
        if 'text_direction' in params:
            self.text_direction = params["text_direction"]


             
        self.reading_order = reading_order
        if 'reading_order' in params:
            self.reading_order = params["reading_order"]


             
        self.direction_type = direction_type
        if 'direction_type' in params:
            self.direction_type = params["direction_type"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def auto_scale_font(self):
        return self.container['auto_scale_font']

    @auto_scale_font.setter
    def auto_scale_font(self, auto_scale_font):
        self.container['auto_scale_font'] = auto_scale_font 
    @property
    def background_mode(self):
        return self.container['background_mode']

    @background_mode.setter
    def background_mode(self, background_mode):
        self.container['background_mode'] = background_mode 
    @property
    def font(self):
        return self.container['font']

    @font.setter
    def font(self, font):
        self.container['font'] = font 
    @property
    def number(self):
        return self.container['number']

    @number.setter
    def number(self, number):
        self.container['number'] = number 
    @property
    def number_format(self):
        return self.container['number_format']

    @number_format.setter
    def number_format(self, number_format):
        self.container['number_format'] = number_format 
    @property
    def number_format_linked(self):
        return self.container['number_format_linked']

    @number_format_linked.setter
    def number_format_linked(self, number_format_linked):
        self.container['number_format_linked'] = number_format_linked 
    @property
    def offset(self):
        return self.container['offset']

    @offset.setter
    def offset(self, offset):
        self.container['offset'] = offset 
    @property
    def rotation_angle(self):
        return self.container['rotation_angle']

    @rotation_angle.setter
    def rotation_angle(self, rotation_angle):
        self.container['rotation_angle'] = rotation_angle 
    @property
    def text_direction(self):
        return self.container['text_direction']

    @text_direction.setter
    def text_direction(self, text_direction):
        self.container['text_direction'] = text_direction 
    @property
    def reading_order(self):
        return self.container['reading_order']

    @reading_order.setter
    def reading_order(self, reading_order):
        self.container['reading_order'] = reading_order 
    @property
    def direction_type(self):
        return self.container['direction_type']

    @direction_type.setter
    def direction_type(self, direction_type):
        self.container['direction_type'] = direction_type 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TickLabels):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    