# coding: utf-8
"""
<copyright company="Aspose" file="TextureFillpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class TextureFill(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'type' : 'str',
        'transparency' : 'float',
        'scale' : 'float',
        'tile_pic_option' : 'TilePicOption',
        'pic_format_option' : 'PicFormatOption',
        'image' : 'LinkElement'
    }

    attribute_map = {
        'type' : 'Type' ,
        'transparency' : 'Transparency' ,
        'scale' : 'Scale' ,
        'tile_pic_option' : 'TilePicOption' ,
        'pic_format_option' : 'PicFormatOption' ,
        'image' : 'Image' 
    }

    @staticmethod
    def get_swagger_types():
        return TextureFill.swagger_types

    @staticmethod
    def get_attribute_map():
        return TextureFill.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,type=None ,transparency=None ,scale=None ,tile_pic_option=None ,pic_format_option=None ,image=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        TextureFill - a model defined in Swagger
        """
        self.container['type'] = None 
        self.container['transparency'] = None 
        self.container['scale'] = None 
        self.container['tile_pic_option'] = None 
        self.container['pic_format_option'] = None 
        self.container['image'] = None 
        params = locals()
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.transparency = transparency
        if 'transparency' in params:
            self.transparency = params["transparency"]


             
        self.scale = scale
        if 'scale' in params:
            self.scale = params["scale"]


             
        self.tile_pic_option = tile_pic_option
        if 'tile_pic_option' in params:
            self.tile_pic_option = params["tile_pic_option"]


             
        self.pic_format_option = pic_format_option
        if 'pic_format_option' in params:
            self.pic_format_option = params["pic_format_option"]


             
        self.image = image
        if 'image' in params:
            self.image = params["image"]


             

    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def transparency(self):
        return self.container['transparency']

    @transparency.setter
    def transparency(self, transparency):
        self.container['transparency'] = transparency 
    @property
    def scale(self):
        return self.container['scale']

    @scale.setter
    def scale(self, scale):
        self.container['scale'] = scale 
    @property
    def tile_pic_option(self):
        return self.container['tile_pic_option']

    @tile_pic_option.setter
    def tile_pic_option(self, tile_pic_option):
        self.container['tile_pic_option'] = tile_pic_option 
    @property
    def pic_format_option(self):
        return self.container['pic_format_option']

    @pic_format_option.setter
    def pic_format_option(self, pic_format_option):
        self.container['pic_format_option'] = pic_format_option 
    @property
    def image(self):
        return self.container['image']

    @image.setter
    def image(self, image):
        self.container['image'] = image 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TextureFill):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    