# coding: utf-8
"""
<copyright company="Aspose" file="TextWaterMarkerRequestpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class TextWaterMarkerRequest(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'text' : 'str',
        'font_name' : 'str',
        'font_size' : 'int',
        'height' : 'int',
        'width' : 'int',
        'image_adapt_option' : 'str'
    }

    attribute_map = {
        'text' : 'Text' ,
        'font_name' : 'FontName' ,
        'font_size' : 'FontSize' ,
        'height' : 'Height' ,
        'width' : 'Width' ,
        'image_adapt_option' : 'ImageAdaptOption' 
    }

    @staticmethod
    def get_swagger_types():
        return TextWaterMarkerRequest.swagger_types

    @staticmethod
    def get_attribute_map():
        return TextWaterMarkerRequest.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,text=None ,font_name=None ,font_size=None ,height=None ,width=None ,image_adapt_option=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        TextWaterMarkerRequest - a model defined in Swagger
        """
        self.container['text'] = None 
        self.container['font_name'] = None 
        self.container['font_size'] = None 
        self.container['height'] = None 
        self.container['width'] = None 
        self.container['image_adapt_option'] = None 
        params = locals()
        self.text = text
        if 'text' in params:
            self.text = params["text"]


             
        self.font_name = font_name
        if 'font_name' in params:
            self.font_name = params["font_name"]


             
        self.font_size = font_size
        if 'font_size' in params:
            self.font_size = params["font_size"]


             
        self.height = height
        if 'height' in params:
            self.height = params["height"]


             
        self.width = width
        if 'width' in params:
            self.width = params["width"]


             
        self.image_adapt_option = image_adapt_option
        if 'image_adapt_option' in params:
            self.image_adapt_option = params["image_adapt_option"]


             

    @property
    def text(self):
        return self.container['text']

    @text.setter
    def text(self, text):
        self.container['text'] = text 
    @property
    def font_name(self):
        return self.container['font_name']

    @font_name.setter
    def font_name(self, font_name):
        self.container['font_name'] = font_name 
    @property
    def font_size(self):
        return self.container['font_size']

    @font_size.setter
    def font_size(self, font_size):
        self.container['font_size'] = font_size 
    @property
    def height(self):
        return self.container['height']

    @height.setter
    def height(self, height):
        self.container['height'] = height 
    @property
    def width(self):
        return self.container['width']

    @width.setter
    def width(self, width):
        self.container['width'] = width 
    @property
    def image_adapt_option(self):
        return self.container['image_adapt_option']

    @image_adapt_option.setter
    def image_adapt_option(self, image_adapt_option):
        self.container['image_adapt_option'] = image_adapt_option 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TextWaterMarkerRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    