# coding: utf-8
"""
<copyright company="Aspose" file="StyleFormatConditionpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class StyleFormatCondition(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'priority' : 'int',
        'type' : 'str',
        'stop_if_true' : 'bool',
        'above_average' : 'AboveAverage',
        'color_scale' : 'ColorScale',
        'data_bar' : 'DataBar',
        'formula1' : 'str',
        'formula2' : 'str',
        'icon_set' : 'IconSet',
        'operator' : 'str',
        'style' : 'Style',
        'text' : 'str',
        'time_period' : 'str',
        'top10' : 'Top10',
        'link' : 'Link'
    }

    attribute_map = {
        'priority' : 'Priority' ,
        'type' : 'Type' ,
        'stop_if_true' : 'StopIfTrue' ,
        'above_average' : 'AboveAverage' ,
        'color_scale' : 'ColorScale' ,
        'data_bar' : 'DataBar' ,
        'formula1' : 'Formula1' ,
        'formula2' : 'Formula2' ,
        'icon_set' : 'IconSet' ,
        'operator' : 'Operator' ,
        'style' : 'Style' ,
        'text' : 'Text' ,
        'time_period' : 'TimePeriod' ,
        'top10' : 'Top10' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return StyleFormatCondition.swagger_types

    @staticmethod
    def get_attribute_map():
        return StyleFormatCondition.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,priority=None ,type=None ,stop_if_true=None ,above_average=None ,color_scale=None ,data_bar=None ,formula1=None ,formula2=None ,icon_set=None ,operator=None ,style=None ,text=None ,time_period=None ,top10=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        StyleFormatCondition - a model defined in Swagger
        """
        self.container['priority'] = None 
        self.container['type'] = None 
        self.container['stop_if_true'] = None 
        self.container['above_average'] = None 
        self.container['color_scale'] = None 
        self.container['data_bar'] = None 
        self.container['formula1'] = None 
        self.container['formula2'] = None 
        self.container['icon_set'] = None 
        self.container['operator'] = None 
        self.container['style'] = None 
        self.container['text'] = None 
        self.container['time_period'] = None 
        self.container['top10'] = None 
        self.container['link'] = None 
        params = locals()
        self.priority = priority
        if 'priority' in params:
            self.priority = params["priority"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.stop_if_true = stop_if_true
        if 'stop_if_true' in params:
            self.stop_if_true = params["stop_if_true"]


             
        self.above_average = above_average
        if 'above_average' in params:
            self.above_average = params["above_average"]


             
        self.color_scale = color_scale
        if 'color_scale' in params:
            self.color_scale = params["color_scale"]


             
        self.data_bar = data_bar
        if 'data_bar' in params:
            self.data_bar = params["data_bar"]


             
        self.formula1 = formula1
        if 'formula1' in params:
            self.formula1 = params["formula1"]


             
        self.formula2 = formula2
        if 'formula2' in params:
            self.formula2 = params["formula2"]


             
        self.icon_set = icon_set
        if 'icon_set' in params:
            self.icon_set = params["icon_set"]


             
        self.operator = operator
        if 'operator' in params:
            self.operator = params["operator"]


             
        self.style = style
        if 'style' in params:
            self.style = params["style"]


             
        self.text = text
        if 'text' in params:
            self.text = params["text"]


             
        self.time_period = time_period
        if 'time_period' in params:
            self.time_period = params["time_period"]


             
        self.top10 = top10
        if 'top10' in params:
            self.top10 = params["top10"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def priority(self):
        return self.container['priority']

    @priority.setter
    def priority(self, priority):
        self.container['priority'] = priority 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def stop_if_true(self):
        return self.container['stop_if_true']

    @stop_if_true.setter
    def stop_if_true(self, stop_if_true):
        self.container['stop_if_true'] = stop_if_true 
    @property
    def above_average(self):
        return self.container['above_average']

    @above_average.setter
    def above_average(self, above_average):
        self.container['above_average'] = above_average 
    @property
    def color_scale(self):
        return self.container['color_scale']

    @color_scale.setter
    def color_scale(self, color_scale):
        self.container['color_scale'] = color_scale 
    @property
    def data_bar(self):
        return self.container['data_bar']

    @data_bar.setter
    def data_bar(self, data_bar):
        self.container['data_bar'] = data_bar 
    @property
    def formula1(self):
        return self.container['formula1']

    @formula1.setter
    def formula1(self, formula1):
        self.container['formula1'] = formula1 
    @property
    def formula2(self):
        return self.container['formula2']

    @formula2.setter
    def formula2(self, formula2):
        self.container['formula2'] = formula2 
    @property
    def icon_set(self):
        return self.container['icon_set']

    @icon_set.setter
    def icon_set(self, icon_set):
        self.container['icon_set'] = icon_set 
    @property
    def operator(self):
        return self.container['operator']

    @operator.setter
    def operator(self, operator):
        self.container['operator'] = operator 
    @property
    def style(self):
        return self.container['style']

    @style.setter
    def style(self, style):
        self.container['style'] = style 
    @property
    def text(self):
        return self.container['text']

    @text.setter
    def text(self, text):
        self.container['text'] = text 
    @property
    def time_period(self):
        return self.container['time_period']

    @time_period.setter
    def time_period(self, time_period):
        self.container['time_period'] = time_period 
    @property
    def top10(self):
        return self.container['top10']

    @top10.setter
    def top10(self, top10):
        self.container['top10'] = top10 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, StyleFormatCondition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    