# coding: utf-8
"""
<copyright company="Aspose" file="Stylepy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Style(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'font' : 'Font',
        'name' : 'str',
        'culture_custom' : 'str',
        'custom' : 'str',
        'background_color' : 'Color',
        'foreground_color' : 'Color',
        'is_formula_hidden' : 'bool',
        'is_date_time' : 'bool',
        'is_text_wrapped' : 'bool',
        'is_gradient' : 'bool',
        'is_locked' : 'bool',
        'is_percent' : 'bool',
        'shrink_to_fit' : 'bool',
        'indent_level' : 'int',
        'number' : 'int',
        'rotation_angle' : 'int',
        'pattern' : 'str',
        'text_direction' : 'str',
        'vertical_alignment' : 'str',
        'horizontal_alignment' : 'str',
        'border_collection' : 'list[Border]',
        'background_theme_color' : 'ThemeColor',
        'foreground_theme_color' : 'ThemeColor'
    }

    attribute_map = {
        'font' : 'Font' ,
        'name' : 'Name' ,
        'culture_custom' : 'CultureCustom' ,
        'custom' : 'Custom' ,
        'background_color' : 'BackgroundColor' ,
        'foreground_color' : 'ForegroundColor' ,
        'is_formula_hidden' : 'IsFormulaHidden' ,
        'is_date_time' : 'IsDateTime' ,
        'is_text_wrapped' : 'IsTextWrapped' ,
        'is_gradient' : 'IsGradient' ,
        'is_locked' : 'IsLocked' ,
        'is_percent' : 'IsPercent' ,
        'shrink_to_fit' : 'ShrinkToFit' ,
        'indent_level' : 'IndentLevel' ,
        'number' : 'Number' ,
        'rotation_angle' : 'RotationAngle' ,
        'pattern' : 'Pattern' ,
        'text_direction' : 'TextDirection' ,
        'vertical_alignment' : 'VerticalAlignment' ,
        'horizontal_alignment' : 'HorizontalAlignment' ,
        'border_collection' : 'BorderCollection' ,
        'background_theme_color' : 'BackgroundThemeColor' ,
        'foreground_theme_color' : 'ForegroundThemeColor' 
    }

    @staticmethod
    def get_swagger_types():
        return Style.swagger_types

    @staticmethod
    def get_attribute_map():
        return Style.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,font=None ,name=None ,culture_custom=None ,custom=None ,background_color=None ,foreground_color=None ,is_formula_hidden=None ,is_date_time=None ,is_text_wrapped=None ,is_gradient=None ,is_locked=None ,is_percent=None ,shrink_to_fit=None ,indent_level=None ,number=None ,rotation_angle=None ,pattern=None ,text_direction=None ,vertical_alignment=None ,horizontal_alignment=None ,border_collection=None ,background_theme_color=None ,foreground_theme_color=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Style - a model defined in Swagger
        """
        self.container['font'] = None 
        self.container['name'] = None 
        self.container['culture_custom'] = None 
        self.container['custom'] = None 
        self.container['background_color'] = None 
        self.container['foreground_color'] = None 
        self.container['is_formula_hidden'] = None 
        self.container['is_date_time'] = None 
        self.container['is_text_wrapped'] = None 
        self.container['is_gradient'] = None 
        self.container['is_locked'] = None 
        self.container['is_percent'] = None 
        self.container['shrink_to_fit'] = None 
        self.container['indent_level'] = None 
        self.container['number'] = None 
        self.container['rotation_angle'] = None 
        self.container['pattern'] = None 
        self.container['text_direction'] = None 
        self.container['vertical_alignment'] = None 
        self.container['horizontal_alignment'] = None 
        self.container['border_collection'] = None 
        self.container['background_theme_color'] = None 
        self.container['foreground_theme_color'] = None 
        params = locals()
        self.font = font
        if 'font' in params:
            self.font = params["font"]


             
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.culture_custom = culture_custom
        if 'culture_custom' in params:
            self.culture_custom = params["culture_custom"]


             
        self.custom = custom
        if 'custom' in params:
            self.custom = params["custom"]


             
        self.background_color = background_color
        if 'background_color' in params:
            self.background_color = params["background_color"]


             
        self.foreground_color = foreground_color
        if 'foreground_color' in params:
            self.foreground_color = params["foreground_color"]


             
        self.is_formula_hidden = is_formula_hidden
        if 'is_formula_hidden' in params:
            self.is_formula_hidden = params["is_formula_hidden"]


             
        self.is_date_time = is_date_time
        if 'is_date_time' in params:
            self.is_date_time = params["is_date_time"]


             
        self.is_text_wrapped = is_text_wrapped
        if 'is_text_wrapped' in params:
            self.is_text_wrapped = params["is_text_wrapped"]


             
        self.is_gradient = is_gradient
        if 'is_gradient' in params:
            self.is_gradient = params["is_gradient"]


             
        self.is_locked = is_locked
        if 'is_locked' in params:
            self.is_locked = params["is_locked"]


             
        self.is_percent = is_percent
        if 'is_percent' in params:
            self.is_percent = params["is_percent"]


             
        self.shrink_to_fit = shrink_to_fit
        if 'shrink_to_fit' in params:
            self.shrink_to_fit = params["shrink_to_fit"]


             
        self.indent_level = indent_level
        if 'indent_level' in params:
            self.indent_level = params["indent_level"]


             
        self.number = number
        if 'number' in params:
            self.number = params["number"]


             
        self.rotation_angle = rotation_angle
        if 'rotation_angle' in params:
            self.rotation_angle = params["rotation_angle"]


             
        self.pattern = pattern
        if 'pattern' in params:
            self.pattern = params["pattern"]


             
        self.text_direction = text_direction
        if 'text_direction' in params:
            self.text_direction = params["text_direction"]


             
        self.vertical_alignment = vertical_alignment
        if 'vertical_alignment' in params:
            self.vertical_alignment = params["vertical_alignment"]


             
        self.horizontal_alignment = horizontal_alignment
        if 'horizontal_alignment' in params:
            self.horizontal_alignment = params["horizontal_alignment"]


             
        self.border_collection = border_collection
        if 'border_collection' in params:
            self.border_collection = params["border_collection"]


             
        self.background_theme_color = background_theme_color
        if 'background_theme_color' in params:
            self.background_theme_color = params["background_theme_color"]


             
        self.foreground_theme_color = foreground_theme_color
        if 'foreground_theme_color' in params:
            self.foreground_theme_color = params["foreground_theme_color"]


             

    @property
    def font(self):
        return self.container['font']

    @font.setter
    def font(self, font):
        self.container['font'] = font 
    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def culture_custom(self):
        return self.container['culture_custom']

    @culture_custom.setter
    def culture_custom(self, culture_custom):
        self.container['culture_custom'] = culture_custom 
    @property
    def custom(self):
        return self.container['custom']

    @custom.setter
    def custom(self, custom):
        self.container['custom'] = custom 
    @property
    def background_color(self):
        return self.container['background_color']

    @background_color.setter
    def background_color(self, background_color):
        self.container['background_color'] = background_color 
    @property
    def foreground_color(self):
        return self.container['foreground_color']

    @foreground_color.setter
    def foreground_color(self, foreground_color):
        self.container['foreground_color'] = foreground_color 
    @property
    def is_formula_hidden(self):
        return self.container['is_formula_hidden']

    @is_formula_hidden.setter
    def is_formula_hidden(self, is_formula_hidden):
        self.container['is_formula_hidden'] = is_formula_hidden 
    @property
    def is_date_time(self):
        return self.container['is_date_time']

    @is_date_time.setter
    def is_date_time(self, is_date_time):
        self.container['is_date_time'] = is_date_time 
    @property
    def is_text_wrapped(self):
        return self.container['is_text_wrapped']

    @is_text_wrapped.setter
    def is_text_wrapped(self, is_text_wrapped):
        self.container['is_text_wrapped'] = is_text_wrapped 
    @property
    def is_gradient(self):
        return self.container['is_gradient']

    @is_gradient.setter
    def is_gradient(self, is_gradient):
        self.container['is_gradient'] = is_gradient 
    @property
    def is_locked(self):
        return self.container['is_locked']

    @is_locked.setter
    def is_locked(self, is_locked):
        self.container['is_locked'] = is_locked 
    @property
    def is_percent(self):
        return self.container['is_percent']

    @is_percent.setter
    def is_percent(self, is_percent):
        self.container['is_percent'] = is_percent 
    @property
    def shrink_to_fit(self):
        return self.container['shrink_to_fit']

    @shrink_to_fit.setter
    def shrink_to_fit(self, shrink_to_fit):
        self.container['shrink_to_fit'] = shrink_to_fit 
    @property
    def indent_level(self):
        return self.container['indent_level']

    @indent_level.setter
    def indent_level(self, indent_level):
        self.container['indent_level'] = indent_level 
    @property
    def number(self):
        return self.container['number']

    @number.setter
    def number(self, number):
        self.container['number'] = number 
    @property
    def rotation_angle(self):
        return self.container['rotation_angle']

    @rotation_angle.setter
    def rotation_angle(self, rotation_angle):
        self.container['rotation_angle'] = rotation_angle 
    @property
    def pattern(self):
        return self.container['pattern']

    @pattern.setter
    def pattern(self, pattern):
        self.container['pattern'] = pattern 
    @property
    def text_direction(self):
        return self.container['text_direction']

    @text_direction.setter
    def text_direction(self, text_direction):
        self.container['text_direction'] = text_direction 
    @property
    def vertical_alignment(self):
        return self.container['vertical_alignment']

    @vertical_alignment.setter
    def vertical_alignment(self, vertical_alignment):
        self.container['vertical_alignment'] = vertical_alignment 
    @property
    def horizontal_alignment(self):
        return self.container['horizontal_alignment']

    @horizontal_alignment.setter
    def horizontal_alignment(self, horizontal_alignment):
        self.container['horizontal_alignment'] = horizontal_alignment 
    @property
    def border_collection(self):
        return self.container['border_collection']

    @border_collection.setter
    def border_collection(self, border_collection):
        self.container['border_collection'] = border_collection 
    @property
    def background_theme_color(self):
        return self.container['background_theme_color']

    @background_theme_color.setter
    def background_theme_color(self, background_theme_color):
        self.container['background_theme_color'] = background_theme_color 
    @property
    def foreground_theme_color(self):
        return self.container['foreground_theme_color']

    @foreground_theme_color.setter
    def foreground_theme_color(self, foreground_theme_color):
        self.container['foreground_theme_color'] = foreground_theme_color 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Style):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    