# coding: utf-8
"""
<copyright company="Aspose" file="SparklineGrouppy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class SparklineGroup(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'display_hidden' : 'bool',
        'first_point_color' : 'CellsColor',
        'high_point_color' : 'CellsColor',
        'horizontal_axis_color' : 'CellsColor',
        'horizontal_axis_date_range' : 'str',
        'last_point_color' : 'CellsColor',
        'line_weight' : 'float',
        'low_point_color' : 'CellsColor',
        'markers_color' : 'CellsColor',
        'negative_points_color' : 'CellsColor',
        'plot_empty_cells_type' : 'str',
        'plot_right_to_left' : 'bool',
        'preset_style' : 'str',
        'series_color' : 'CellsColor',
        'show_first_point' : 'bool',
        'show_high_point' : 'bool',
        'show_horizontal_axis' : 'bool',
        'show_last_point' : 'bool',
        'show_low_point' : 'bool',
        'show_markers' : 'bool',
        'show_negative_points' : 'bool',
        'sparkline_collection' : 'list[Sparkline]',
        'type' : 'str',
        'vertical_axis_max_value' : 'float',
        'vertical_axis_max_value_type' : 'str',
        'vertical_axis_min_value' : 'float',
        'vertical_axis_min_value_type' : 'str'
    }

    attribute_map = {
        'display_hidden' : 'DisplayHidden' ,
        'first_point_color' : 'FirstPointColor' ,
        'high_point_color' : 'HighPointColor' ,
        'horizontal_axis_color' : 'HorizontalAxisColor' ,
        'horizontal_axis_date_range' : 'HorizontalAxisDateRange' ,
        'last_point_color' : 'LastPointColor' ,
        'line_weight' : 'LineWeight' ,
        'low_point_color' : 'LowPointColor' ,
        'markers_color' : 'MarkersColor' ,
        'negative_points_color' : 'NegativePointsColor' ,
        'plot_empty_cells_type' : 'PlotEmptyCellsType' ,
        'plot_right_to_left' : 'PlotRightToLeft' ,
        'preset_style' : 'PresetStyle' ,
        'series_color' : 'SeriesColor' ,
        'show_first_point' : 'ShowFirstPoint' ,
        'show_high_point' : 'ShowHighPoint' ,
        'show_horizontal_axis' : 'ShowHorizontalAxis' ,
        'show_last_point' : 'ShowLastPoint' ,
        'show_low_point' : 'ShowLowPoint' ,
        'show_markers' : 'ShowMarkers' ,
        'show_negative_points' : 'ShowNegativePoints' ,
        'sparkline_collection' : 'SparklineCollection' ,
        'type' : 'Type' ,
        'vertical_axis_max_value' : 'VerticalAxisMaxValue' ,
        'vertical_axis_max_value_type' : 'VerticalAxisMaxValueType' ,
        'vertical_axis_min_value' : 'VerticalAxisMinValue' ,
        'vertical_axis_min_value_type' : 'VerticalAxisMinValueType' 
    }

    @staticmethod
    def get_swagger_types():
        return SparklineGroup.swagger_types

    @staticmethod
    def get_attribute_map():
        return SparklineGroup.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,display_hidden=None ,first_point_color=None ,high_point_color=None ,horizontal_axis_color=None ,horizontal_axis_date_range=None ,last_point_color=None ,line_weight=None ,low_point_color=None ,markers_color=None ,negative_points_color=None ,plot_empty_cells_type=None ,plot_right_to_left=None ,preset_style=None ,series_color=None ,show_first_point=None ,show_high_point=None ,show_horizontal_axis=None ,show_last_point=None ,show_low_point=None ,show_markers=None ,show_negative_points=None ,sparkline_collection=None ,type=None ,vertical_axis_max_value=None ,vertical_axis_max_value_type=None ,vertical_axis_min_value=None ,vertical_axis_min_value_type=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        SparklineGroup - a model defined in Swagger
        """
        self.container['display_hidden'] = None 
        self.container['first_point_color'] = None 
        self.container['high_point_color'] = None 
        self.container['horizontal_axis_color'] = None 
        self.container['horizontal_axis_date_range'] = None 
        self.container['last_point_color'] = None 
        self.container['line_weight'] = None 
        self.container['low_point_color'] = None 
        self.container['markers_color'] = None 
        self.container['negative_points_color'] = None 
        self.container['plot_empty_cells_type'] = None 
        self.container['plot_right_to_left'] = None 
        self.container['preset_style'] = None 
        self.container['series_color'] = None 
        self.container['show_first_point'] = None 
        self.container['show_high_point'] = None 
        self.container['show_horizontal_axis'] = None 
        self.container['show_last_point'] = None 
        self.container['show_low_point'] = None 
        self.container['show_markers'] = None 
        self.container['show_negative_points'] = None 
        self.container['sparkline_collection'] = None 
        self.container['type'] = None 
        self.container['vertical_axis_max_value'] = None 
        self.container['vertical_axis_max_value_type'] = None 
        self.container['vertical_axis_min_value'] = None 
        self.container['vertical_axis_min_value_type'] = None 
        params = locals()
        self.display_hidden = display_hidden
        if 'display_hidden' in params:
            self.display_hidden = params["display_hidden"]


             
        self.first_point_color = first_point_color
        if 'first_point_color' in params:
            self.first_point_color = params["first_point_color"]


             
        self.high_point_color = high_point_color
        if 'high_point_color' in params:
            self.high_point_color = params["high_point_color"]


             
        self.horizontal_axis_color = horizontal_axis_color
        if 'horizontal_axis_color' in params:
            self.horizontal_axis_color = params["horizontal_axis_color"]


             
        self.horizontal_axis_date_range = horizontal_axis_date_range
        if 'horizontal_axis_date_range' in params:
            self.horizontal_axis_date_range = params["horizontal_axis_date_range"]


             
        self.last_point_color = last_point_color
        if 'last_point_color' in params:
            self.last_point_color = params["last_point_color"]


             
        self.line_weight = line_weight
        if 'line_weight' in params:
            self.line_weight = params["line_weight"]


             
        self.low_point_color = low_point_color
        if 'low_point_color' in params:
            self.low_point_color = params["low_point_color"]


             
        self.markers_color = markers_color
        if 'markers_color' in params:
            self.markers_color = params["markers_color"]


             
        self.negative_points_color = negative_points_color
        if 'negative_points_color' in params:
            self.negative_points_color = params["negative_points_color"]


             
        self.plot_empty_cells_type = plot_empty_cells_type
        if 'plot_empty_cells_type' in params:
            self.plot_empty_cells_type = params["plot_empty_cells_type"]


             
        self.plot_right_to_left = plot_right_to_left
        if 'plot_right_to_left' in params:
            self.plot_right_to_left = params["plot_right_to_left"]


             
        self.preset_style = preset_style
        if 'preset_style' in params:
            self.preset_style = params["preset_style"]


             
        self.series_color = series_color
        if 'series_color' in params:
            self.series_color = params["series_color"]


             
        self.show_first_point = show_first_point
        if 'show_first_point' in params:
            self.show_first_point = params["show_first_point"]


             
        self.show_high_point = show_high_point
        if 'show_high_point' in params:
            self.show_high_point = params["show_high_point"]


             
        self.show_horizontal_axis = show_horizontal_axis
        if 'show_horizontal_axis' in params:
            self.show_horizontal_axis = params["show_horizontal_axis"]


             
        self.show_last_point = show_last_point
        if 'show_last_point' in params:
            self.show_last_point = params["show_last_point"]


             
        self.show_low_point = show_low_point
        if 'show_low_point' in params:
            self.show_low_point = params["show_low_point"]


             
        self.show_markers = show_markers
        if 'show_markers' in params:
            self.show_markers = params["show_markers"]


             
        self.show_negative_points = show_negative_points
        if 'show_negative_points' in params:
            self.show_negative_points = params["show_negative_points"]


             
        self.sparkline_collection = sparkline_collection
        if 'sparkline_collection' in params:
            self.sparkline_collection = params["sparkline_collection"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.vertical_axis_max_value = vertical_axis_max_value
        if 'vertical_axis_max_value' in params:
            self.vertical_axis_max_value = params["vertical_axis_max_value"]


             
        self.vertical_axis_max_value_type = vertical_axis_max_value_type
        if 'vertical_axis_max_value_type' in params:
            self.vertical_axis_max_value_type = params["vertical_axis_max_value_type"]


             
        self.vertical_axis_min_value = vertical_axis_min_value
        if 'vertical_axis_min_value' in params:
            self.vertical_axis_min_value = params["vertical_axis_min_value"]


             
        self.vertical_axis_min_value_type = vertical_axis_min_value_type
        if 'vertical_axis_min_value_type' in params:
            self.vertical_axis_min_value_type = params["vertical_axis_min_value_type"]


             

    @property
    def display_hidden(self):
        return self.container['display_hidden']

    @display_hidden.setter
    def display_hidden(self, display_hidden):
        self.container['display_hidden'] = display_hidden 
    @property
    def first_point_color(self):
        return self.container['first_point_color']

    @first_point_color.setter
    def first_point_color(self, first_point_color):
        self.container['first_point_color'] = first_point_color 
    @property
    def high_point_color(self):
        return self.container['high_point_color']

    @high_point_color.setter
    def high_point_color(self, high_point_color):
        self.container['high_point_color'] = high_point_color 
    @property
    def horizontal_axis_color(self):
        return self.container['horizontal_axis_color']

    @horizontal_axis_color.setter
    def horizontal_axis_color(self, horizontal_axis_color):
        self.container['horizontal_axis_color'] = horizontal_axis_color 
    @property
    def horizontal_axis_date_range(self):
        return self.container['horizontal_axis_date_range']

    @horizontal_axis_date_range.setter
    def horizontal_axis_date_range(self, horizontal_axis_date_range):
        self.container['horizontal_axis_date_range'] = horizontal_axis_date_range 
    @property
    def last_point_color(self):
        return self.container['last_point_color']

    @last_point_color.setter
    def last_point_color(self, last_point_color):
        self.container['last_point_color'] = last_point_color 
    @property
    def line_weight(self):
        return self.container['line_weight']

    @line_weight.setter
    def line_weight(self, line_weight):
        self.container['line_weight'] = line_weight 
    @property
    def low_point_color(self):
        return self.container['low_point_color']

    @low_point_color.setter
    def low_point_color(self, low_point_color):
        self.container['low_point_color'] = low_point_color 
    @property
    def markers_color(self):
        return self.container['markers_color']

    @markers_color.setter
    def markers_color(self, markers_color):
        self.container['markers_color'] = markers_color 
    @property
    def negative_points_color(self):
        return self.container['negative_points_color']

    @negative_points_color.setter
    def negative_points_color(self, negative_points_color):
        self.container['negative_points_color'] = negative_points_color 
    @property
    def plot_empty_cells_type(self):
        return self.container['plot_empty_cells_type']

    @plot_empty_cells_type.setter
    def plot_empty_cells_type(self, plot_empty_cells_type):
        self.container['plot_empty_cells_type'] = plot_empty_cells_type 
    @property
    def plot_right_to_left(self):
        return self.container['plot_right_to_left']

    @plot_right_to_left.setter
    def plot_right_to_left(self, plot_right_to_left):
        self.container['plot_right_to_left'] = plot_right_to_left 
    @property
    def preset_style(self):
        return self.container['preset_style']

    @preset_style.setter
    def preset_style(self, preset_style):
        self.container['preset_style'] = preset_style 
    @property
    def series_color(self):
        return self.container['series_color']

    @series_color.setter
    def series_color(self, series_color):
        self.container['series_color'] = series_color 
    @property
    def show_first_point(self):
        return self.container['show_first_point']

    @show_first_point.setter
    def show_first_point(self, show_first_point):
        self.container['show_first_point'] = show_first_point 
    @property
    def show_high_point(self):
        return self.container['show_high_point']

    @show_high_point.setter
    def show_high_point(self, show_high_point):
        self.container['show_high_point'] = show_high_point 
    @property
    def show_horizontal_axis(self):
        return self.container['show_horizontal_axis']

    @show_horizontal_axis.setter
    def show_horizontal_axis(self, show_horizontal_axis):
        self.container['show_horizontal_axis'] = show_horizontal_axis 
    @property
    def show_last_point(self):
        return self.container['show_last_point']

    @show_last_point.setter
    def show_last_point(self, show_last_point):
        self.container['show_last_point'] = show_last_point 
    @property
    def show_low_point(self):
        return self.container['show_low_point']

    @show_low_point.setter
    def show_low_point(self, show_low_point):
        self.container['show_low_point'] = show_low_point 
    @property
    def show_markers(self):
        return self.container['show_markers']

    @show_markers.setter
    def show_markers(self, show_markers):
        self.container['show_markers'] = show_markers 
    @property
    def show_negative_points(self):
        return self.container['show_negative_points']

    @show_negative_points.setter
    def show_negative_points(self, show_negative_points):
        self.container['show_negative_points'] = show_negative_points 
    @property
    def sparkline_collection(self):
        return self.container['sparkline_collection']

    @sparkline_collection.setter
    def sparkline_collection(self, sparkline_collection):
        self.container['sparkline_collection'] = sparkline_collection 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def vertical_axis_max_value(self):
        return self.container['vertical_axis_max_value']

    @vertical_axis_max_value.setter
    def vertical_axis_max_value(self, vertical_axis_max_value):
        self.container['vertical_axis_max_value'] = vertical_axis_max_value 
    @property
    def vertical_axis_max_value_type(self):
        return self.container['vertical_axis_max_value_type']

    @vertical_axis_max_value_type.setter
    def vertical_axis_max_value_type(self, vertical_axis_max_value_type):
        self.container['vertical_axis_max_value_type'] = vertical_axis_max_value_type 
    @property
    def vertical_axis_min_value(self):
        return self.container['vertical_axis_min_value']

    @vertical_axis_min_value.setter
    def vertical_axis_min_value(self, vertical_axis_min_value):
        self.container['vertical_axis_min_value'] = vertical_axis_min_value 
    @property
    def vertical_axis_min_value_type(self):
        return self.container['vertical_axis_min_value_type']

    @vertical_axis_min_value_type.setter
    def vertical_axis_min_value_type(self, vertical_axis_min_value_type):
        self.container['vertical_axis_min_value_type'] = vertical_axis_min_value_type 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SparklineGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    