# coding: utf-8
"""
<copyright company="Aspose" file="ShadowEffectpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ShadowEffect(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'angle' : 'float',
        'blur' : 'float',
        'color' : 'CellsColor',
        'distance' : 'float',
        'preset_type' : 'str',
        'size' : 'float',
        'transparency' : 'float'
    }

    attribute_map = {
        'angle' : 'Angle' ,
        'blur' : 'Blur' ,
        'color' : 'Color' ,
        'distance' : 'Distance' ,
        'preset_type' : 'PresetType' ,
        'size' : 'Size' ,
        'transparency' : 'Transparency' 
    }

    @staticmethod
    def get_swagger_types():
        return ShadowEffect.swagger_types

    @staticmethod
    def get_attribute_map():
        return ShadowEffect.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,angle=None ,blur=None ,color=None ,distance=None ,preset_type=None ,size=None ,transparency=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ShadowEffect - a model defined in Swagger
        """
        self.container['angle'] = None 
        self.container['blur'] = None 
        self.container['color'] = None 
        self.container['distance'] = None 
        self.container['preset_type'] = None 
        self.container['size'] = None 
        self.container['transparency'] = None 
        params = locals()
        self.angle = angle
        if 'angle' in params:
            self.angle = params["angle"]


             
        self.blur = blur
        if 'blur' in params:
            self.blur = params["blur"]


             
        self.color = color
        if 'color' in params:
            self.color = params["color"]


             
        self.distance = distance
        if 'distance' in params:
            self.distance = params["distance"]


             
        self.preset_type = preset_type
        if 'preset_type' in params:
            self.preset_type = params["preset_type"]


             
        self.size = size
        if 'size' in params:
            self.size = params["size"]


             
        self.transparency = transparency
        if 'transparency' in params:
            self.transparency = params["transparency"]


             

    @property
    def angle(self):
        return self.container['angle']

    @angle.setter
    def angle(self, angle):
        self.container['angle'] = angle 
    @property
    def blur(self):
        return self.container['blur']

    @blur.setter
    def blur(self, blur):
        self.container['blur'] = blur 
    @property
    def color(self):
        return self.container['color']

    @color.setter
    def color(self, color):
        self.container['color'] = color 
    @property
    def distance(self):
        return self.container['distance']

    @distance.setter
    def distance(self, distance):
        self.container['distance'] = distance 
    @property
    def preset_type(self):
        return self.container['preset_type']

    @preset_type.setter
    def preset_type(self, preset_type):
        self.container['preset_type'] = preset_type 
    @property
    def size(self):
        return self.container['size']

    @size.setter
    def size(self, size):
        self.container['size'] = size 
    @property
    def transparency(self):
        return self.container['transparency']

    @transparency.setter
    def transparency(self, transparency):
        self.container['transparency'] = transparency 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ShadowEffect):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    