# coding: utf-8
"""
<copyright company="Aspose" file="SeriesItemspy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class SeriesItems(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'category_data' : 'str',
        'is_color_varied' : 'bool',
        'second_catergory_data' : 'str',
        'series_list' : 'list[Series]',
        'link' : 'Link'
    }

    attribute_map = {
        'category_data' : 'CategoryData' ,
        'is_color_varied' : 'IsColorVaried' ,
        'second_catergory_data' : 'SecondCatergoryData' ,
        'series_list' : 'SeriesList' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return SeriesItems.swagger_types

    @staticmethod
    def get_attribute_map():
        return SeriesItems.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,category_data=None ,is_color_varied=None ,second_catergory_data=None ,series_list=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        SeriesItems - a model defined in Swagger
        """
        self.container['category_data'] = None 
        self.container['is_color_varied'] = None 
        self.container['second_catergory_data'] = None 
        self.container['series_list'] = None 
        self.container['link'] = None 
        params = locals()
        self.category_data = category_data
        if 'category_data' in params:
            self.category_data = params["category_data"]


             
        self.is_color_varied = is_color_varied
        if 'is_color_varied' in params:
            self.is_color_varied = params["is_color_varied"]


             
        self.second_catergory_data = second_catergory_data
        if 'second_catergory_data' in params:
            self.second_catergory_data = params["second_catergory_data"]


             
        self.series_list = series_list
        if 'series_list' in params:
            self.series_list = params["series_list"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def category_data(self):
        return self.container['category_data']

    @category_data.setter
    def category_data(self, category_data):
        self.container['category_data'] = category_data 
    @property
    def is_color_varied(self):
        return self.container['is_color_varied']

    @is_color_varied.setter
    def is_color_varied(self, is_color_varied):
        self.container['is_color_varied'] = is_color_varied 
    @property
    def second_catergory_data(self):
        return self.container['second_catergory_data']

    @second_catergory_data.setter
    def second_catergory_data(self, second_catergory_data):
        self.container['second_catergory_data'] = second_catergory_data 
    @property
    def series_list(self):
        return self.container['series_list']

    @series_list.setter
    def series_list(self, series_list):
        self.container['series_list'] = series_list 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SeriesItems):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    