# coding: utf-8
"""
<copyright company="Aspose" file="Rowpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Row(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'group_level' : 'int',
        'height' : 'float',
        'index' : 'int',
        'is_blank' : 'bool',
        'is_height_matched' : 'bool',
        'is_hidden' : 'bool',
        'style' : 'LinkElement',
        'link' : 'Link'
    }

    attribute_map = {
        'group_level' : 'GroupLevel' ,
        'height' : 'Height' ,
        'index' : 'Index' ,
        'is_blank' : 'IsBlank' ,
        'is_height_matched' : 'IsHeightMatched' ,
        'is_hidden' : 'IsHidden' ,
        'style' : 'Style' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return Row.swagger_types

    @staticmethod
    def get_attribute_map():
        return Row.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,group_level=None ,height=None ,index=None ,is_blank=None ,is_height_matched=None ,is_hidden=None ,style=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Row - a model defined in Swagger
        """
        self.container['group_level'] = None 
        self.container['height'] = None 
        self.container['index'] = None 
        self.container['is_blank'] = None 
        self.container['is_height_matched'] = None 
        self.container['is_hidden'] = None 
        self.container['style'] = None 
        self.container['link'] = None 
        params = locals()
        self.group_level = group_level
        if 'group_level' in params:
            self.group_level = params["group_level"]


             
        self.height = height
        if 'height' in params:
            self.height = params["height"]


             
        self.index = index
        if 'index' in params:
            self.index = params["index"]


             
        self.is_blank = is_blank
        if 'is_blank' in params:
            self.is_blank = params["is_blank"]


             
        self.is_height_matched = is_height_matched
        if 'is_height_matched' in params:
            self.is_height_matched = params["is_height_matched"]


             
        self.is_hidden = is_hidden
        if 'is_hidden' in params:
            self.is_hidden = params["is_hidden"]


             
        self.style = style
        if 'style' in params:
            self.style = params["style"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def group_level(self):
        return self.container['group_level']

    @group_level.setter
    def group_level(self, group_level):
        self.container['group_level'] = group_level 
    @property
    def height(self):
        return self.container['height']

    @height.setter
    def height(self, height):
        self.container['height'] = height 
    @property
    def index(self):
        return self.container['index']

    @index.setter
    def index(self, index):
        self.container['index'] = index 
    @property
    def is_blank(self):
        return self.container['is_blank']

    @is_blank.setter
    def is_blank(self, is_blank):
        self.container['is_blank'] = is_blank 
    @property
    def is_height_matched(self):
        return self.container['is_height_matched']

    @is_height_matched.setter
    def is_height_matched(self, is_height_matched):
        self.container['is_height_matched'] = is_height_matched 
    @property
    def is_hidden(self):
        return self.container['is_hidden']

    @is_hidden.setter
    def is_hidden(self, is_hidden):
        self.container['is_hidden'] = is_hidden 
    @property
    def style(self):
        return self.container['style']

    @style.setter
    def style(self, style):
        self.container['style'] = style 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Row):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    