# coding: utf-8
"""
<copyright company="Aspose" file="RenderingWatermarkpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class RenderingWatermark(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'rotation' : 'float',
        'scale_to_page_percent' : 'int',
        'opacity' : 'float',
        'is_background' : 'bool',
        'text' : 'str',
        'font' : 'RenderingFont',
        'image' : 'list[int]',
        'h_alignment' : 'str',
        'v_alignment' : 'str',
        'offset_x' : 'float',
        'offset_y' : 'float'
    }

    attribute_map = {
        'rotation' : 'Rotation' ,
        'scale_to_page_percent' : 'ScaleToPagePercent' ,
        'opacity' : 'Opacity' ,
        'is_background' : 'IsBackground' ,
        'text' : 'Text' ,
        'font' : 'Font' ,
        'image' : 'Image' ,
        'h_alignment' : 'HAlignment' ,
        'v_alignment' : 'VAlignment' ,
        'offset_x' : 'OffsetX' ,
        'offset_y' : 'OffsetY' 
    }

    @staticmethod
    def get_swagger_types():
        return RenderingWatermark.swagger_types

    @staticmethod
    def get_attribute_map():
        return RenderingWatermark.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,rotation=None ,scale_to_page_percent=None ,opacity=None ,is_background=None ,text=None ,font=None ,image=None ,h_alignment=None ,v_alignment=None ,offset_x=None ,offset_y=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        RenderingWatermark - a model defined in Swagger
        """
        self.container['rotation'] = None 
        self.container['scale_to_page_percent'] = None 
        self.container['opacity'] = None 
        self.container['is_background'] = None 
        self.container['text'] = None 
        self.container['font'] = None 
        self.container['image'] = None 
        self.container['h_alignment'] = None 
        self.container['v_alignment'] = None 
        self.container['offset_x'] = None 
        self.container['offset_y'] = None 
        params = locals()
        self.rotation = rotation
        if 'rotation' in params:
            self.rotation = params["rotation"]


             
        self.scale_to_page_percent = scale_to_page_percent
        if 'scale_to_page_percent' in params:
            self.scale_to_page_percent = params["scale_to_page_percent"]


             
        self.opacity = opacity
        if 'opacity' in params:
            self.opacity = params["opacity"]


             
        self.is_background = is_background
        if 'is_background' in params:
            self.is_background = params["is_background"]


             
        self.text = text
        if 'text' in params:
            self.text = params["text"]


             
        self.font = font
        if 'font' in params:
            self.font = params["font"]


             
        self.image = image
        if 'image' in params:
            self.image = params["image"]


             
        self.h_alignment = h_alignment
        if 'h_alignment' in params:
            self.h_alignment = params["h_alignment"]


             
        self.v_alignment = v_alignment
        if 'v_alignment' in params:
            self.v_alignment = params["v_alignment"]


             
        self.offset_x = offset_x
        if 'offset_x' in params:
            self.offset_x = params["offset_x"]


             
        self.offset_y = offset_y
        if 'offset_y' in params:
            self.offset_y = params["offset_y"]


             

    @property
    def rotation(self):
        return self.container['rotation']

    @rotation.setter
    def rotation(self, rotation):
        self.container['rotation'] = rotation 
    @property
    def scale_to_page_percent(self):
        return self.container['scale_to_page_percent']

    @scale_to_page_percent.setter
    def scale_to_page_percent(self, scale_to_page_percent):
        self.container['scale_to_page_percent'] = scale_to_page_percent 
    @property
    def opacity(self):
        return self.container['opacity']

    @opacity.setter
    def opacity(self, opacity):
        self.container['opacity'] = opacity 
    @property
    def is_background(self):
        return self.container['is_background']

    @is_background.setter
    def is_background(self, is_background):
        self.container['is_background'] = is_background 
    @property
    def text(self):
        return self.container['text']

    @text.setter
    def text(self, text):
        self.container['text'] = text 
    @property
    def font(self):
        return self.container['font']

    @font.setter
    def font(self, font):
        self.container['font'] = font 
    @property
    def image(self):
        return self.container['image']

    @image.setter
    def image(self, image):
        self.container['image'] = image 
    @property
    def h_alignment(self):
        return self.container['h_alignment']

    @h_alignment.setter
    def h_alignment(self, h_alignment):
        self.container['h_alignment'] = h_alignment 
    @property
    def v_alignment(self):
        return self.container['v_alignment']

    @v_alignment.setter
    def v_alignment(self, v_alignment):
        self.container['v_alignment'] = v_alignment 
    @property
    def offset_x(self):
        return self.container['offset_x']

    @offset_x.setter
    def offset_x(self, offset_x):
        self.container['offset_x'] = offset_x 
    @property
    def offset_y(self):
        return self.container['offset_y']

    @offset_y.setter
    def offset_y(self, offset_y):
        self.container['offset_y'] = offset_y 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, RenderingWatermark):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    