# coding: utf-8
"""
<copyright company="Aspose" file="RemoveCharactersByPositionpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class RemoveCharactersByPosition(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'the_first_n_characters' : 'int',
        'the_last_n_characters' : 'int',
        'all_characters_before_text' : 'str',
        'all_characters_after_text' : 'str'
    }

    attribute_map = {
        'the_first_n_characters' : 'TheFirstNCharacters' ,
        'the_last_n_characters' : 'TheLastNCharacters' ,
        'all_characters_before_text' : 'AllCharactersBeforeText' ,
        'all_characters_after_text' : 'AllCharactersAfterText' 
    }

    @staticmethod
    def get_swagger_types():
        return RemoveCharactersByPosition.swagger_types

    @staticmethod
    def get_attribute_map():
        return RemoveCharactersByPosition.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,the_first_n_characters=None ,the_last_n_characters=None ,all_characters_before_text=None ,all_characters_after_text=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        RemoveCharactersByPosition - a model defined in Swagger
        """
        self.container['the_first_n_characters'] = None 
        self.container['the_last_n_characters'] = None 
        self.container['all_characters_before_text'] = None 
        self.container['all_characters_after_text'] = None 
        params = locals()
        self.the_first_n_characters = the_first_n_characters
        if 'the_first_n_characters' in params:
            self.the_first_n_characters = params["the_first_n_characters"]


             
        self.the_last_n_characters = the_last_n_characters
        if 'the_last_n_characters' in params:
            self.the_last_n_characters = params["the_last_n_characters"]


             
        self.all_characters_before_text = all_characters_before_text
        if 'all_characters_before_text' in params:
            self.all_characters_before_text = params["all_characters_before_text"]


             
        self.all_characters_after_text = all_characters_after_text
        if 'all_characters_after_text' in params:
            self.all_characters_after_text = params["all_characters_after_text"]


             

    @property
    def the_first_n_characters(self):
        return self.container['the_first_n_characters']

    @the_first_n_characters.setter
    def the_first_n_characters(self, the_first_n_characters):
        self.container['the_first_n_characters'] = the_first_n_characters 
    @property
    def the_last_n_characters(self):
        return self.container['the_last_n_characters']

    @the_last_n_characters.setter
    def the_last_n_characters(self, the_last_n_characters):
        self.container['the_last_n_characters'] = the_last_n_characters 
    @property
    def all_characters_before_text(self):
        return self.container['all_characters_before_text']

    @all_characters_before_text.setter
    def all_characters_before_text(self, all_characters_before_text):
        self.container['all_characters_before_text'] = all_characters_before_text 
    @property
    def all_characters_after_text(self):
        return self.container['all_characters_after_text']

    @all_characters_after_text.setter
    def all_characters_after_text(self, all_characters_after_text):
        self.container['all_characters_after_text'] = all_characters_after_text 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, RemoveCharactersByPosition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    