# coding: utf-8
"""
<copyright company="Aspose" file="RangeCopyRequestpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class RangeCopyRequest(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'operate' : 'str',
        'source' : 'Range',
        'target' : 'Range',
        'paste_options' : 'PasteOptions'
    }

    attribute_map = {
        'operate' : 'Operate' ,
        'source' : 'Source' ,
        'target' : 'Target' ,
        'paste_options' : 'PasteOptions' 
    }

    @staticmethod
    def get_swagger_types():
        return RangeCopyRequest.swagger_types

    @staticmethod
    def get_attribute_map():
        return RangeCopyRequest.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,operate=None ,source=None ,target=None ,paste_options=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        RangeCopyRequest - a model defined in Swagger
        """
        self.container['operate'] = None 
        self.container['source'] = None 
        self.container['target'] = None 
        self.container['paste_options'] = None 
        params = locals()
        self.operate = operate
        if 'operate' in params:
            self.operate = params["operate"]


             
        self.source = source
        if 'source' in params:
            self.source = params["source"]


             
        self.target = target
        if 'target' in params:
            self.target = params["target"]


             
        self.paste_options = paste_options
        if 'paste_options' in params:
            self.paste_options = params["paste_options"]


             

    @property
    def operate(self):
        return self.container['operate']

    @operate.setter
    def operate(self, operate):
        self.container['operate'] = operate 
    @property
    def source(self):
        return self.container['source']

    @source.setter
    def source(self, source):
        self.container['source'] = source 
    @property
    def target(self):
        return self.container['target']

    @target.setter
    def target(self, target):
        self.container['target'] = target 
    @property
    def paste_options(self):
        return self.container['paste_options']

    @paste_options.setter
    def paste_options(self, paste_options):
        self.container['paste_options'] = paste_options 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, RangeCopyRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    